/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor;

import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ProfileEditorInput
implements IEditorInput,
IDebugProfileEditorConstants {
    private DebugProfile fProfile;
    private IDebugProfileEditorConstants.PROFILE_TYPE fProfileType;

    public ProfileEditorInput(IDebugProfileEditorConstants.PROFILE_TYPE profileType) {
        this.fProfileType = profileType;
    }

    public ProfileEditorInput(DebugProfile profile) {
        this.fProfile = profile;
        if (this.fProfile instanceof DebugProfileDTCN) {
            this.fProfileType = IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS;
        } else if (this.fProfile instanceof DebugProfileIMS) {
            this.fProfileType = IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS;
        } else if (this.fProfile instanceof DebugProfileDTSP) {
            this.fProfileType = IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_NON_CICS;
        }
    }

    public DebugProfile getDebugProfile() {
        return this.fProfile;
    }

    public void setDebugProfile(DebugProfile profile) {
        this.fProfile = profile;
    }

    public IDebugProfileEditorConstants.PROFILE_TYPE getProfileType() {
        return this.fProfileType;
    }

    public <T> T getAdapter(Class<T> arg0) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        String iconKey = null;
        switch (this.fProfileType) {
            case PROFILE_IMS: {
                iconKey = "PROFILE_ICON_CREATE_IMS";
                break;
            }
            case PROFILE_NON_CICS: {
                iconKey = "PROFILE_ICON_CREATE_DTSP";
                break;
            }
            default: {
                iconKey = "PROFILE_ICON_CREATE_DTCN";
            }
        }
        return Activator.getDefault().getImageRegistry().getDescriptor(iconKey);
    }

    public String getName() {
        if (this.fProfile != null) {
            switch (this.fProfileType) {
                case PROFILE_IMS: {
                    return NLS.bind((String)ProfileLabels.editor_ims_profile, (Object)this.fProfile.getName());
                }
                case PROFILE_NON_CICS: {
                    return NLS.bind((String)ProfileLabels.editor_dtsp_profile, (Object)this.fProfile.getName());
                }
            }
            return NLS.bind((String)ProfileLabels.editor_dtcn_profile, (Object)this.fProfile.getName());
        }
        switch (this.fProfileType) {
            case PROFILE_IMS: {
                return ProfileLabels.editor_ims_profile_new;
            }
            case PROFILE_NON_CICS: {
                return ProfileLabels.editor_dtsp_profile_new;
            }
        }
        return ProfileLabels.editor_dtcn_profile_new;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }
}

