/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor;

import com.ibm.debug.pdt.profile.IAdditionalCICSFilters;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionEventListener;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionEventManager;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DTCNForceSettings;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.APIServerException;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.IDebugProfileViewConstants;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditor;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditorHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.FormToolkitHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.IRegionHandler;
import com.ibm.debug.pdt.ui.profile.internal.editor.MessageManagerHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import com.ibm.debug.pdt.ui.profile.internal.editor.Validator;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IIMSIsolationComposite;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IIMSIsolationUIProvider;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IMSIsolationProfileUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileRSEUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlinePage;
import com.ibm.ftt.debug.ui.composites.DebugOptionsComposite;
import com.ibm.ftt.debug.ui.composites.dlydbg.DebugItem;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugComposite;
import com.ibm.ftt.debug.ui.composites.dlydbg.IDelayDebugEventListener;
import com.ibm.ftt.debug.ui.tabs.HostFilter;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.ui.rse.utils.RSESelectRemoteFolderDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.menus.IMenuService;

public class DebugProfileEditorPage
extends FormPage
implements IDebugProfileConstants,
IDebugProfileViewConstants,
IDebugProfileEditorConstants,
IDelayDebugEventListener,
IRegionHandler {
    private static final String STEPLIB = "STEPLIB";
    private ScrolledForm form;
    private FormToolkit fToolkit = null;
    private DebugProfileEditor fProfileEditor = null;
    private FormToolkitHelper fToolkitHelper;
    private MessageManagerHelper fMessageHelper;
    private DebugProfileEditorHelper fEditorHelper;
    private Validator fValidator;
    private REGION_STATE fRegionState = REGION_STATE.REGION;
    private boolean ignoreEvent;
    private Section fAddtionSubSysfilterSection;
    private Section fFilterSection;
    private Section fAdditionalFilterSection;
    private Section fAdvancedFilterSection;
    private Section fAdvConnOptionSection;
    private Section fDebugOptionSection;
    private Section fIMSISolationSection;
    private Section profileSection;
    private Label fRegionLabel;
    private Text fProfileNameText;
    private Text fDescriptionText;
    private CCombo fConnectionCombo;
    private CCombo fRegionCombo;
    private Link fHideHintLink;
    private Button fConnectionButton;
    private Text fTransactionNameText;
    private Text fUserIdText;
    private DelayDebugComposite fLoadModuleComposite;
    private DebugProfile fDebugProfile = null;
    private ProfileEditorInput fEditorInput;
    private IDebugProfileEditorConstants.PROFILE_TYPE fType;
    private Text fNetNameText;
    private Text fIpText;
    private Text fSYSIDText;
    private Text fTermIDText;
    private Button fURMCheck;
    private Group fGroupContainer;
    private Text fContainerNameText;
    private Text fContainerOffsetText;
    private Text fContainerDatasetText;
    private Group fGroupCOMMAREA;
    private Text fComAreaOffsetText;
    private Text fComAreaDataText;
    private Text fPlatfromNameText;
    private Text fAppNameText;
    private Text fOperationNameText;
    private Text fAppVersionText;
    private Group fGroupApplication;
    private Text fJobNameText;
    private Text fStepNameText;
    private Text fSubsystemIDText;
    private Text fTransactionIDText;
    private CCombo fTestLevelCombo;
    private CCombo fErrorLevelCombo;
    private CCombo fPromptLevelCombo;
    private Text fCommandDataSetText;
    private Button fCommandsDataSetBrowseButton;
    private Text fPreferenceDataSetText;
    private Button fPreferenceDataSetBrowseButton;
    private Text fEqaOptsText;
    private Button fEqaoptsDataSetBrowseButton;
    private Text fEnvOptionsText;
    private Button fConnectWithClientInfoButton;
    private Label fConnectIPLabel;
    private Text fConnectIPText;
    private Label fConnectPortLabel;
    private Text fConnectPortText;
    private Label fConnectUserIDLabel;
    private Text fConnectUserIDText;
    private Label fCertificateLabel;
    private Text fCertificateText;
    private Button fCertificateBrowseButton;
    private Object fOutlineInput;
    private IIMSIsolationComposite fIMSIsolationComposite;
    private IIMSIsolationComposite fIMSStepLibComposite;
    private Section fIMSStepLibSection;
    private Image fImage;
    private DTCNForceSettings fDTCNForceSettings = new DTCNForceSettings();
    private ModifyListener fModifylistener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (DebugProfileEditorPage.this.ignoreEvent) {
                Connection c = ConnectionUtilities.getConnection((String)DebugProfileEditorPage.this.fConnectionCombo.getText(), (boolean)false);
                DebugProfileEditorPage.this.fValidator.validateRegionCombo(DebugProfileEditorPage.this.fRegionCombo, DebugProfileEditorPage.this.fRegionState, c);
                DebugProfileEditorPage.this.fMessageHelper.updateSessionState(DebugProfileEditorPage.this.getFormMessageType());
                return;
            }
            if (event.getSource() == DebugProfileEditorPage.this.fProfileNameText) {
                DebugProfileEditorPage.this.fProfileEditor.setEditorPartName(DebugProfileEditorPage.this.fProfileNameText.getText());
                boolean isExistingProfileName = DebugProfileEditorPage.this.fValidator.checkIfEqualExistingProfileName(DebugProfileEditorPage.this.fDebugProfile, DebugProfileEditorPage.this.fProfileNameText);
                DebugProfileEditorPage.this.fValidator.validateProfileName(DebugProfileEditorPage.this.fProfileNameText, isExistingProfileName);
            } else if (event.getSource() == DebugProfileEditorPage.this.fRegionCombo) {
                Connection c = ConnectionUtilities.getConnection((String)DebugProfileEditorPage.this.fConnectionCombo.getText(), (boolean)false);
                DebugProfileEditorPage.this.fValidator.validateRegionCombo(DebugProfileEditorPage.this.fRegionCombo, DebugProfileEditorPage.this.fRegionState, c);
                if (DebugProfileEditorPage.this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
                    DebugProfileEditorPage.this.fIMSIsolationComposite.setLocation(DebugProfileEditorPage.this.fRegionCombo.getText());
                }
            } else if (event.getSource() == DebugProfileEditorPage.this.fTransactionNameText || event.getSource() == DebugProfileEditorPage.this.fUserIdText || event.getSource() == DebugProfileEditorPage.this.fNetNameText || event.getSource() == DebugProfileEditorPage.this.fIpText || event.getSource() == DebugProfileEditorPage.this.fSYSIDText || event.getSource() == DebugProfileEditorPage.this.fTermIDText || event.getSource() == DebugProfileEditorPage.this.fLoadModuleComposite) {
                if (DebugProfileEditorPage.this.fValidator.validateCICSDebugConjunctionFields(DebugProfileEditorPage.this.fTransactionNameText, DebugProfileEditorPage.this.fUserIdText, DebugProfileEditorPage.this.fNetNameText, DebugProfileEditorPage.this.fIpText, DebugProfileEditorPage.this.fTermIDText, DebugProfileEditorPage.this.fLoadModuleComposite, DebugProfileEditorPage.this.fDTCNForceSettings)) {
                    DebugProfileEditorPage.this.fValidator.validateGenericCICSFields(DebugProfileEditorPage.this.fTransactionNameText, DebugProfileEditorPage.this.fUserIdText, DebugProfileEditorPage.this.fNetNameText, DebugProfileEditorPage.this.fIpText, DebugProfileEditorPage.this.fTermIDText, DebugProfileEditorPage.this.fLoadModuleComposite, DebugProfileEditorPage.this.fDTCNForceSettings);
                }
            } else if (event.getSource() == DebugProfileEditorPage.this.fConnectUserIDText || event.getSource() == DebugProfileEditorPage.this.fConnectIPText || event.getSource() == DebugProfileEditorPage.this.fConnectPortText) {
                if (event.getSource() == DebugProfileEditorPage.this.fConnectIPText) {
                    DebugProfileEditorPage.this.fMessageHelper.clearMessages((Control)DebugProfileEditorPage.this.fConnectIPText);
                } else if (event.getSource() == DebugProfileEditorPage.this.fConnectPortText) {
                    DebugProfileEditorPage.this.fMessageHelper.clearMessages((Control)DebugProfileEditorPage.this.fConnectPortText);
                } else if (event.getSource() == DebugProfileEditorPage.this.fConnectUserIDText) {
                    DebugProfileEditorPage.this.fMessageHelper.clearMessages((Control)DebugProfileEditorPage.this.fConnectIPText);
                    DebugProfileEditorPage.this.fMessageHelper.clearMessages((Control)DebugProfileEditorPage.this.fConnectPortText);
                    DebugProfileEditorPage.this.fMessageHelper.clearMessages((Control)DebugProfileEditorPage.this.fCertificateText);
                }
                DebugProfileEditorPage.this.fEditorHelper.updateAdvancedConnectionFieldsEnablement(DebugProfileEditorPage.this.fConnectionCombo.getText(), DebugProfileEditorPage.this.fConnectWithClientInfoButton, DebugProfileEditorPage.this.fCertificateBrowseButton, DebugProfileEditorPage.this.fConnectUserIDText, DebugProfileEditorPage.this.fConnectIPText, DebugProfileEditorPage.this.fConnectPortText, DebugProfileEditorPage.this.fCertificateText, DebugProfileEditorPage.this.fConnectUserIDLabel, DebugProfileEditorPage.this.fConnectIPLabel, DebugProfileEditorPage.this.fConnectPortLabel, DebugProfileEditorPage.this.fCertificateLabel);
                if (DebugProfileEditorPage.this.fConnectWithClientInfoButton.getSelection()) {
                    DebugProfileEditorPage.this.fValidator.validateAdvanceConnectionOptions(DebugProfileEditorPage.this.fConnectWithClientInfoButton, DebugProfileEditorPage.this.fConnectIPText, DebugProfileEditorPage.this.fConnectPortText, DebugProfileEditorPage.this.fConnectUserIDText);
                }
            } else if (event.getSource() == DebugProfileEditorPage.this.fCertificateText) {
                DebugProfileEditorPage.this.fValidator.validateAuthCertificate(DebugProfileEditorPage.this.fConnectionCombo.getText(), DebugProfileEditorPage.this.fCertificateText);
                DebugProfileEditorPage.this.fEditorHelper.updateAdvancedConnectionFieldsEnablement(DebugProfileEditorPage.this.fConnectionCombo.getText(), DebugProfileEditorPage.this.fConnectWithClientInfoButton, DebugProfileEditorPage.this.fCertificateBrowseButton, DebugProfileEditorPage.this.fConnectUserIDText, DebugProfileEditorPage.this.fConnectIPText, DebugProfileEditorPage.this.fConnectPortText, DebugProfileEditorPage.this.fCertificateText, DebugProfileEditorPage.this.fConnectUserIDLabel, DebugProfileEditorPage.this.fConnectIPLabel, DebugProfileEditorPage.this.fConnectPortLabel, DebugProfileEditorPage.this.fCertificateLabel);
            } else if (event.getSource() == DebugProfileEditorPage.this.fContainerNameText || event.getSource() == DebugProfileEditorPage.this.fContainerOffsetText || event.getSource() == DebugProfileEditorPage.this.fContainerDatasetText) {
                DebugProfileEditorPage.this.fEditorHelper.disableCOMMAREAGroup(DebugProfileEditorPage.this.fGroupCOMMAREA, DebugProfileEditorPage.this.fContainerNameText, DebugProfileEditorPage.this.fContainerOffsetText, DebugProfileEditorPage.this.fContainerDatasetText);
            } else if (event.getSource() == DebugProfileEditorPage.this.fComAreaOffsetText || event.getSource() == DebugProfileEditorPage.this.fComAreaDataText) {
                DebugProfileEditorPage.this.fEditorHelper.disableContainerGroup(DebugProfileEditorPage.this.fGroupContainer, DebugProfileEditorPage.this.fComAreaOffsetText, DebugProfileEditorPage.this.fComAreaDataText);
            } else if (event.getSource() == DebugProfileEditorPage.this.fAppVersionText) {
                DebugProfileEditorPage.this.fValidator.validateApplicationVersion(DebugProfileEditorPage.this.fAppVersionText);
            } else if (event.widget == DebugProfileEditorPage.this.fCommandDataSetText) {
                DebugProfileEditorPage.this.fValidator.validateCommandEntry(DebugProfileEditorPage.this.fConnectionCombo.getText(), (Text)event.widget);
            } else if (event.widget == DebugProfileEditorPage.this.fEqaOptsText || event.widget == DebugProfileEditorPage.this.fPreferenceDataSetText) {
                DebugProfileEditorPage.this.fValidator.validateDataset(DebugProfileEditorPage.this.fConnectionCombo.getText(), (Text)event.widget);
            } else if (event.widget == DebugProfileEditorPage.this.fJobNameText || event.widget == DebugProfileEditorPage.this.fStepNameText || event.widget == DebugProfileEditorPage.this.fSubsystemIDText || event.widget == DebugProfileEditorPage.this.fTransactionIDText) {
                DebugProfileEditorPage.this.fValidator.validateGenericNonCICSFields(DebugProfileEditorPage.this.fLoadModuleComposite, DebugProfileEditorPage.this.fJobNameText, DebugProfileEditorPage.this.fStepNameText, DebugProfileEditorPage.this.fSubsystemIDText, DebugProfileEditorPage.this.fTransactionIDText);
            }
            if (event.getSource() instanceof Text || event.getSource() instanceof CCombo) {
                DebugProfileEditorPage.this.fProfileEditor.setDirty(true);
                DebugProfileEditorPage.this.fMessageHelper.updateSessionState(DebugProfileEditorPage.this.getFormMessageType());
            }
            DebugProfileEditorPage.this.updateContentOutline();
        }
    };
    private RSEEventListener fRSEEventListener = new RSEEventListener(){

        @Override
        public void handleEvent(final Connection source, final int eventType, final String oldName) {
            DebugProfileEditorPage.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        switch (eventType) {
                            case 0: {
                                if (source == null) break;
                                String host = source.getConnectionName();
                                (this).DebugProfileEditorPage.this.fConnectionCombo.add(host);
                                if (!(this).DebugProfileEditorPage.this.fConnectionCombo.getText().isEmpty()) break;
                                (this).DebugProfileEditorPage.this.fConnectionCombo.setText(host);
                                DebugProfileEditorPage.this.handleConnectionComboUpdate(true, true);
                                break;
                            }
                            case 3: 
                            case 4: {
                                if (source == null) break;
                                String host = source.getConnectionName();
                                if (!(this).DebugProfileEditorPage.this.fConnectionCombo.getText().equalsIgnoreCase(host)) break;
                                (this).DebugProfileEditorPage.this.fConnectionCombo.setText(host);
                                DebugProfileEditorPage.this.handleConnectionComboUpdate(eventType == 3, false);
                                break;
                            }
                            case 1: {
                                if (source == null) break;
                                String host = source.getConnectionName();
                                (this).DebugProfileEditorPage.this.fEditorHelper.updateDeleteConnection(host, (this).DebugProfileEditorPage.this.fConnectionCombo, (this).DebugProfileEditorPage.this.fRegionCombo, (this).DebugProfileEditorPage.this.fRegionLabel, (this).DebugProfileEditorPage.this.fType);
                                DebugProfileEditorPage.this.handleConnectionComboUpdate(false, false);
                                break;
                            }
                            case 2: {
                                DebugProfileEditorPage.this.handleRename(source, oldName);
                                break;
                            }
                        }
                        DebugProfileEditorPage.this.updateContentOutline();
                    }
                    catch (SWTError sWTError) {
                        // empty catch block
                    }
                }
            });
        }
    };
    private ConnectionEventListener fConnectionEventListener = new ConnectionEventListener(){

        public void handleEvent(final Connection source, ConnectionEventListener.ConnectionEventType eventType) {
            if (eventType == ConnectionEventListener.ConnectionEventType.AUTH_INVALID_CICS_REGION_ADDED && DebugProfileEditorPage.this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (source.getConnectionName().equalsIgnoreCase((this).DebugProfileEditorPage.this.fConnectionCombo.getText())) {
                            (this).DebugProfileEditorPage.this.fValidator.validateRegionCombo((this).DebugProfileEditorPage.this.fRegionCombo, REGION_STATE.REGION, source);
                        }
                    }
                });
            }
        }
    };

    public DebugProfileEditorPage(DebugProfileEditor editor, String id, String tabBottomName) {
        super((FormEditor)editor, id, tabBottomName);
        this.fProfileEditor = editor;
        this.fEditorInput = editor.getProfileEditorInput();
        this.fDebugProfile = this.fEditorInput.getDebugProfile();
        this.fType = this.fEditorInput.getProfileType();
    }

    protected void createFormContent(final IManagedForm managedForm) {
        int height;
        this.fToolkit = managedForm.getToolkit();
        this.fToolkitHelper = new FormToolkitHelper(this.fToolkit);
        this.form = managedForm.getForm();
        this.fMessageHelper = new MessageManagerHelper(managedForm.getMessageManager());
        final IMessagePrefixProvider defaultProvider = managedForm.getMessageManager().getMessagePrefixProvider();
        managedForm.getMessageManager().setMessagePrefixProvider(new IMessagePrefixProvider(){

            public String getPrefix(Control control) {
                if (control == DebugProfileEditorPage.this.fRegionCombo) {
                    switch (DebugProfileEditorPage.this.fRegionState) {
                        case LOCATION: {
                            return ProfileLabels.editor_connect_location + " ";
                        }
                        case REGION: 
                        case PORT: {
                            return "";
                        }
                    }
                }
                return defaultProvider.getPrefix(control);
            }
        });
        this.fValidator = new Validator(this.fMessageHelper);
        this.fEditorHelper = new DebugProfileEditorHelper(this.fDebugProfile, this.fType, this.fToolkitHelper, this.fValidator);
        this.form.setText(this.fEditorInput.getName());
        this.fToolkit.decorateFormHeading(this.form.getForm());
        String icon = null;
        switch (this.fType) {
            case PROFILE_IMS: {
                icon = "PROFILE_ICON_IMS_BIG";
                break;
            }
            case PROFILE_NON_CICS: {
                icon = "PROFILE_ICON_DTSP_BIG";
                break;
            }
            default: {
                icon = "PROFILE_ICON_DTCN_BIG";
            }
        }
        ImageDescriptor imgDescriptor = Activator.getDefault().getImageRegistry().getDescriptor(icon);
        this.fImage = imgDescriptor.createImage();
        this.form.setImage(this.fImage);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        Composite parent = this.form.getBody();
        parent.setLayout((Layout)layout);
        parent.setBackgroundMode(1);
        layout = new TableWrapLayout();
        layout.numColumns = 1;
        final ScrolledForm formParent = this.fToolkit.createScrolledForm(parent);
        formParent.getBody().setLayout((Layout)layout);
        formParent.setBackgroundMode(1);
        final Composite oldParent = parent;
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                int height;
                TableWrapData data = (TableWrapData)formParent.getLayoutData();
                data.heightHint = -1;
                formParent.reflow(true);
                data.heightHint = height = DebugProfileEditorPage.this.form.getVerticalBar().getThumb() - DebugProfileEditorPage.this.form.getForm().getHead().computeSize((int)-1, (int)-1).y - formParent.getHorizontalBar().getSize().y;
                data.grabVertical = true;
                formParent.reflow(true);
                DebugProfileEditorPage.this.form.reflow(true);
                oldParent.layout(true);
            }
        });
        this.form.getParent().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                if (!formParent.isDisposed()) {
                    formParent.reflow(true);
                }
            }
        });
        parent = formParent.getBody();
        TableWrapData data = new TableWrapData(256, 256);
        formParent.setLayoutData((Object)data);
        this.createEditorToolbar();
        this.createProfileSection(parent);
        this.createSettingSection(parent);
        this.createDebugOptionSection(parent, ProfileLabels.editor_debugger_options);
        this.createAdvConnOptionSection(parent, ProfileLabels.editor_advanced_connection_options);
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
            this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fIMSISolationSection);
        }
        this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fFilterSection);
        this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fDebugOptionSection);
        this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fAdvConnOptionSection);
        this.initializeControls(this.form);
        this.fOutlineInput = this.getOutlineInput();
        data.heightHint = -1;
        formParent.reflow(true);
        data.heightHint = height = this.form.getVerticalBar().getThumb() - this.form.getForm().getHead().computeSize((int)-1, (int)-1).y - formParent.getHorizontalBar().getSize().y;
        data.maxWidth = 0;
        data.grabVertical = true;
        formParent.reflow(true);
        this.form.reflow(true);
        data.maxHeight = -1;
        oldParent.layout(true);
        this.fEditorHelper.addModifyListenerForControls(formParent.getBody(), this.fModifylistener);
        DebugProfileRSEUtils.getInstance().addRSEEventListener(this.fRSEEventListener);
        ConnectionEventManager.getInstance().addConnectionEventListener(this.fConnectionEventListener);
        this.form.setContent((Control)formParent);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                managedForm.getMessageManager().update();
                DebugProfileEditorPage.this.fMessageHelper.updateSessionState(DebugProfileEditorPage.this.getFormMessageType());
                DebugProfileEditorPage.this.updateContentOutline();
            }
        });
    }

    private void createSettingSection(Composite parent) {
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
            Composite filterComposite = this.createFilterSection(parent, ProfileLabels.editor_cics_settings);
            this.createCICSAdditionalFilterSection(filterComposite);
            this.createCICSAdvancedFilterSection(filterComposite, ProfileLabels.editor_cics_interruption_criteria);
            this.setOutlineParentChildRel((Widget)this.fAdditionalFilterSection, (Widget)this.fNetNameText);
            this.setOutlineParentChildRel((Widget)this.fAdditionalFilterSection, (Widget)this.fIpText);
            this.setOutlineParentChildRel((Widget)this.fAdditionalFilterSection, (Widget)this.fTermIDText);
            this.setOutlineParentChildRel((Widget)this.fGroupContainer, (Widget)this.fContainerNameText);
            this.setOutlineParentChildRel((Widget)this.fGroupContainer, (Widget)this.fContainerDatasetText);
            this.setOutlineParentChildRel((Widget)this.fGroupContainer, (Widget)this.fContainerOffsetText);
            this.setOutlineParentChildRel((Widget)this.fAdvancedFilterSection, (Widget)this.fGroupContainer);
            this.setOutlineParentChildRel((Widget)this.fGroupCOMMAREA, (Widget)this.fComAreaOffsetText);
            this.setOutlineParentChildRel((Widget)this.fGroupCOMMAREA, (Widget)this.fComAreaDataText);
            this.setOutlineParentChildRel((Widget)this.fAdvancedFilterSection, (Widget)this.fGroupCOMMAREA);
            this.setOutlineParentChildRel((Widget)this.fGroupApplication, (Widget)this.fPlatfromNameText);
            this.setOutlineParentChildRel((Widget)this.fGroupApplication, (Widget)this.fAppNameText);
            this.setOutlineParentChildRel((Widget)this.fGroupApplication, (Widget)this.fOperationNameText);
            this.setOutlineParentChildRel((Widget)this.fGroupApplication, (Widget)this.fAppVersionText);
            this.setOutlineParentChildRel((Widget)this.fAdvancedFilterSection, (Widget)this.fGroupApplication);
            this.setOutlineParentChildRel((Widget)this.fAdvancedFilterSection, (Widget)this.fURMCheck);
            this.setOutlineParentChildRel((Widget)this.fFilterSection, (Widget)this.fAdditionalFilterSection);
            this.setOutlineParentChildRel((Widget)this.fFilterSection, (Widget)this.fAdvancedFilterSection);
        } else {
            if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
                this.createIMSISolationSection(parent, ProfileLabels.ims_isolation_section_title);
            }
            Composite filterComposite = this.createFilterSection(parent, ProfileLabels.editor_non_cics_settings);
            if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_NON_CICS) {
                this.createNonCICSAdditionalSubSysFilterSection(filterComposite, ProfileLabels.editor_non_cics_additional_filters);
                this.setOutlineParentChildRel((Widget)this.fFilterSection, (Widget)this.fAddtionSubSysfilterSection);
            }
        }
    }

    private void createCICSAdditionalFilterSection(Composite parent) {
        this.fAdditionalFilterSection = this.fToolkitHelper.createAddtionalCICSFiltersSection(parent, true);
        Composite client = (Composite)this.fAdditionalFilterSection.getClient();
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
            this.fNetNameText = this.fToolkitHelper.createNetNameText(client);
            this.fIpText = this.fToolkitHelper.createCICSIPText(client);
            this.fTermIDText = this.fToolkitHelper.createTerminalIDText(client);
        }
    }

    private void createNonCICSAdditionalSubSysFilterSection(Composite parent, String title) {
        int colspan = 2;
        this.fAddtionSubSysfilterSection = this.fToolkitHelper.createSection(parent, 8450, colspan);
        this.fAddtionSubSysfilterSection.setLayoutData((Object)this.fToolkitHelper.getGridData(colspan));
        this.fAddtionSubSysfilterSection.setText(title);
        this.fAddtionSubSysfilterSection.setData("outlineWidget", (Object)this.fAddtionSubSysfilterSection);
        Composite client = this.fToolkit.createComposite((Composite)this.fAddtionSubSysfilterSection);
        client.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan));
        client.setLayoutData((Object)this.fToolkitHelper.getGridData(colspan));
        this.fToolkitHelper.createSectionDescription(this.fAddtionSubSysfilterSection, client, colspan);
        Group groupContainer1 = this.fToolkitHelper.createGroup(client, ProfileLabels.editor_job_information, 768, colspan);
        groupContainer1.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan));
        groupContainer1.setData("outlineWidget", (Object)groupContainer1);
        Label jobNameLabel = this.fToolkitHelper.createLabel((Composite)groupContainer1, ProfileLabels.editor_job_name);
        this.fJobNameText = this.fToolkitHelper.createText((Composite)groupContainer1, ProfileLabels.editor_job_name_tooltip);
        this.fJobNameText.setTextLimit(8);
        this.fJobNameText.setData("outlineWidget", (Object)jobNameLabel);
        Label stepNameLabel = this.fToolkitHelper.createLabel((Composite)groupContainer1, ProfileLabels.editor_step_name);
        this.fStepNameText = this.fToolkitHelper.createText((Composite)groupContainer1, ProfileLabels.editor_step_name_tooltip);
        this.fStepNameText.setTextLimit(8);
        this.fStepNameText.setData("outlineWidget", (Object)stepNameLabel);
        Group groupContainer2 = this.fToolkitHelper.createGroup(client, ProfileLabels.editor_ims_options, 768, colspan);
        groupContainer2.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan));
        groupContainer2.setData("outlineWidget", (Object)groupContainer2);
        Label imsSubsystemId = this.fToolkitHelper.createLabel((Composite)groupContainer2, ProfileLabels.editor_subsystem_id);
        this.fSubsystemIDText = this.fToolkitHelper.createText((Composite)groupContainer2, ProfileLabels.editor_subsystem_id_tooltip);
        this.fSubsystemIDText.setData("outlineWidget", (Object)imsSubsystemId);
        Label imsTrans = this.fToolkitHelper.createLabel((Composite)groupContainer2, ProfileLabels.editor_transaction_id);
        this.fTransactionIDText = this.fToolkitHelper.createText((Composite)groupContainer2, ProfileLabels.editor_transaction_id_tooltip);
        this.fTransactionIDText.setData("outlineWidget", (Object)imsTrans);
        this.fAddtionSubSysfilterSection.setClient((Control)client);
        this.setOutlineParentChildRel((Widget)groupContainer1, (Widget)this.fJobNameText);
        this.setOutlineParentChildRel((Widget)groupContainer1, (Widget)this.fStepNameText);
        this.setOutlineParentChildRel((Widget)this.fAddtionSubSysfilterSection, (Widget)groupContainer1);
        this.setOutlineParentChildRel((Widget)groupContainer2, (Widget)this.fSubsystemIDText);
        this.setOutlineParentChildRel((Widget)groupContainer2, (Widget)this.fTransactionIDText);
        this.setOutlineParentChildRel((Widget)this.fAddtionSubSysfilterSection, (Widget)groupContainer2);
    }

    private void createProfileSection(Composite parent) {
        this.profileSection = this.fToolkitHelper.createProfileSection(parent);
        int colspan = 2;
        Composite client = this.fToolkitHelper.createProfileComposite(this.profileSection);
        this.fToolkitHelper.createSectionDescription(this.profileSection, client, 3);
        this.fHideHintLink = this.fToolkitHelper.createLink(client, "<a>" + ProfileLabels.editor_profile_info_hint_link_hide + "</a>", ProfileLabels.editor_profile_info_hint_link_tooltip, 3, 136);
        this.fHideHintLink.addSelectionListener((SelectionListener)this);
        Label profileNameLabel = this.fToolkitHelper.createLabel(client, ProfileLabels.editor_profile_name);
        this.fProfileNameText = this.fToolkitHelper.createText(client, ProfileLabels.editor_profile_name_tooltip, colspan);
        this.fProfileNameText.setText(this.fProfileEditor.getPartName());
        this.fProfileNameText.setTextLimit(25);
        this.fProfileNameText.setData("outlineWidget", (Object)profileNameLabel);
        Label desc = this.fToolkitHelper.createLabel(client, ProfileLabels.editor_description);
        GridDataFactory.fillDefaults().span(1, 2).applyTo((Control)desc);
        this.fDescriptionText = this.fToolkit.createText(client, "", 2114);
        this.fToolkitHelper.setTooltip((Control)this.fDescriptionText, ProfileLabels.editor_description_tooltip);
        this.fDescriptionText.setText(this.fDebugProfile != null && this.fDebugProfile.getDescription() != null ? this.fDebugProfile.getDescription() : "");
        this.fDescriptionText.setTextLimit(100);
        GridData data = this.fToolkitHelper.getStyleGridData(true, false, 4, 4);
        data.horizontalSpan = colspan;
        data.verticalSpan = 2;
        data.horizontalIndent = 4;
        data.heightHint = this.fDescriptionText.computeSize((int)-1, (int)-1).y * 2;
        data.minimumWidth = this.fDescriptionText.computeSize((int)-1, (int)data.heightHint).x;
        this.fDescriptionText.setLayoutData((Object)data);
        this.fDescriptionText.setData("outlineWidget", (Object)desc);
        this.fConnectionCombo = this.fToolkitHelper.createConnectionCombo(client, (SelectionListener)this);
        this.fConnectionButton = this.fToolkitHelper.createConnectionButton(client, (SelectionListener)this);
        this.fRegionLabel = this.fToolkitHelper.createLabel(client, ProfileLabels.editor_cics_region);
        this.fRegionCombo = this.fToolkitHelper.createRegionCombo(client, colspan, new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                Connection c = ConnectionUtilities.getConnection((String)DebugProfileEditorPage.this.fConnectionCombo.getText(), (boolean)false);
                if (c != null && !c.isConnected()) {
                    DebugProfileEditorPage.this.getConnectionUpdateRegion(true, c.getConnectionName(), true);
                    DebugProfileEditorPage.this.updateContentOutline();
                }
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        this.fRegionCombo.addSelectionListener((SelectionListener)this);
        this.profileSection.setClient((Control)client);
        this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fProfileNameText);
        this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fDescriptionText);
        this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fConnectionCombo);
        this.setOutlineParentChildRel((Widget)this.form, (Widget)this.fRegionCombo);
    }

    private void createCICSAdvancedFilterSection(Composite parent, String title) {
        int colspan = 2;
        this.fAdvancedFilterSection = this.fToolkitHelper.createSection(parent, 258, colspan);
        GridLayout layout = this.fToolkitHelper.getGridLayout(colspan);
        layout.makeColumnsEqualWidth = true;
        this.fAdvancedFilterSection.setLayoutData((Object)this.fToolkitHelper.getGridData(colspan));
        this.fAdvancedFilterSection.setText(title);
        this.fAdvancedFilterSection.setData("outlineWidget", (Object)this.fAdvancedFilterSection);
        Composite client = this.fToolkit.createComposite((Composite)this.fAdvancedFilterSection);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)this.fToolkitHelper.getGridData(colspan));
        this.fToolkitHelper.createSectionDescription(this.fAdvancedFilterSection, client, colspan);
        this.fGroupContainer = this.fToolkitHelper.createGroup(client, ProfileLabels.editor_cics_container, 256);
        this.fGroupContainer.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan));
        this.fGroupContainer.setData("outlineWidget", (Object)this.fGroupContainer);
        Label containerNameLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupContainer, ProfileLabels.editor_cics_container_name);
        this.fContainerNameText = this.fToolkitHelper.createText((Composite)this.fGroupContainer, ProfileLabels.editor_cics_container_name_tooltip);
        this.fContainerNameText.setTextLimit(16);
        this.fContainerNameText.setData("outlineWidget", (Object)containerNameLabel);
        Label containerOffsetLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupContainer, ProfileLabels.editor_cics_container_offset);
        this.fContainerOffsetText = this.fToolkitHelper.createText((Composite)this.fGroupContainer, ProfileLabels.editor_cics_container_offset_tooltip);
        this.fContainerOffsetText.setTextLimit(7);
        this.fContainerOffsetText.setData("outlineWidget", (Object)containerOffsetLabel);
        Label containerDataLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupContainer, ProfileLabels.editor_cics_container_data);
        this.fContainerDatasetText = this.fToolkitHelper.createText((Composite)this.fGroupContainer, ProfileLabels.editor_cics_container_data_tooltip);
        this.fContainerDatasetText.setTextLimit(56);
        this.fContainerDatasetText.setData("outlineWidget", (Object)containerDataLabel);
        this.fGroupCOMMAREA = this.fToolkitHelper.createGroup(client, ProfileLabels.editor_cics_communication_area, 258);
        this.fGroupCOMMAREA.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan));
        this.fGroupCOMMAREA.setData("outlineWidget", (Object)this.fGroupCOMMAREA);
        Label commAreaOffsetLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupCOMMAREA, ProfileLabels.editor_cics_container_offset);
        this.fComAreaOffsetText = this.fToolkitHelper.createText((Composite)this.fGroupCOMMAREA, ProfileLabels.editor_cics_communication_area_offset_tooltip);
        this.fComAreaOffsetText.setTextLimit(7);
        this.fComAreaOffsetText.setData("outlineWidget", (Object)commAreaOffsetLabel);
        Label commAreaDataLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupCOMMAREA, ProfileLabels.editor_cics_container_data);
        this.fComAreaDataText = this.fToolkitHelper.createText((Composite)this.fGroupCOMMAREA, ProfileLabels.editor_cics_communication_area_data_tooltip);
        this.fComAreaDataText.setTextLimit(56);
        this.fComAreaDataText.setData("outlineWidget", (Object)commAreaDataLabel);
        this.fGroupApplication = this.fToolkitHelper.createGroup(client, ProfileLabels.editor_cics_application, 256, colspan);
        this.fGroupApplication.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan));
        this.fGroupApplication.setData("outlineWidget", (Object)this.fGroupApplication);
        Label cicsPlatformNameLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupApplication, ProfileLabels.editor_cics_platform_name);
        this.fPlatfromNameText = this.fToolkitHelper.createText((Composite)this.fGroupApplication, ProfileLabels.editor_cics_platform_name_tooltip);
        this.fPlatfromNameText.setData("outlineWidget", (Object)cicsPlatformNameLabel);
        Label cicsApplnNameLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupApplication, ProfileLabels.editor_cics_application_name);
        this.fAppNameText = this.fToolkitHelper.createText((Composite)this.fGroupApplication, ProfileLabels.editor_cics_application_name_tooltip);
        this.fAppNameText.setData("outlineWidget", (Object)cicsApplnNameLabel);
        Label cicsOperationNameLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupApplication, ProfileLabels.editor_cics_operation_name);
        this.fOperationNameText = this.fToolkitHelper.createText((Composite)this.fGroupApplication, ProfileLabels.editor_cics_operation_name_tooltip);
        this.fOperationNameText.setData("outlineWidget", (Object)cicsOperationNameLabel);
        Label cicsApplnNoLabel = this.fToolkitHelper.createLabel((Composite)this.fGroupApplication, ProfileLabels.editor_cics_application_version);
        this.fAppVersionText = this.fToolkitHelper.createText((Composite)this.fGroupApplication, ProfileLabels.editor_cics_application_version_tooltip);
        this.fAppVersionText.setData("outlineWidget", (Object)cicsApplnNoLabel);
        this.fURMCheck = this.fToolkitHelper.createCheckBox(client, ProfileLabels.editor_cics_urm, ProfileLabels.editor_cics_urm_tooltip, colspan);
        this.fURMCheck.addSelectionListener((SelectionListener)this);
        this.fURMCheck.setData("outlineWidget", (Object)this.fURMCheck);
        this.fAdvancedFilterSection.setClient((Control)client);
    }

    private Composite createFilterSection(Composite parent, String title) {
        this.fFilterSection = this.fToolkitHelper.createFilterSection(parent, title, true);
        Composite client = (Composite)this.fFilterSection.getClient();
        int colspan = 2;
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
            this.fTransactionNameText = this.fToolkitHelper.createTransactionText(client);
            this.setOutlineParentChildRel((Widget)this.fFilterSection, (Widget)this.fTransactionNameText);
            this.fUserIdText = this.fToolkitHelper.createCICSUserIDText(client);
            this.setOutlineParentChildRel((Widget)this.fFilterSection, (Widget)this.fUserIdText);
            this.fSYSIDText = this.fToolkitHelper.createCICSSYSIDText(client);
            this.setOutlineParentChildRel((Widget)this.fFilterSection, (Widget)this.fSYSIDText);
        }
        this.fToolkitHelper.createLabel(client, ProfileLabels.editor_cics_load_module, colspan);
        this.createLoadModuleTable(client, colspan);
        this.fLoadModuleComposite.setData("outlineWidget", (Object)this.fLoadModuleComposite);
        this.setOutlineParentChildRel((Widget)this.fFilterSection, (Widget)this.fLoadModuleComposite);
        return client;
    }

    private void createLoadModuleTable(Composite parent, int colspan) {
        this.fLoadModuleComposite = new DelayDebugComposite(parent, 0, (IDelayDebugEventListener)this, null, false, this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS, 3);
        this.fLoadModuleComposite.setToolTipText(ProfileLabels.editor_cics_load_module_tooltip);
        GridDataFactory.fillDefaults().grab(true, true).span(colspan, 1).applyTo((Control)this.fLoadModuleComposite);
        this.fLoadModuleComposite.addDelayDebugListener((IDelayDebugEventListener)this);
        if (this.fDebugProfile != null) {
            this.fLoadModuleComposite.init(this.fDebugProfile.getLoadModulePairs());
        } else if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
            this.fLoadModuleComposite.init(DelayDebugComposite.GENERIC);
        }
        this.fLoadModuleComposite.getTableControl().setData("profile_editor_message_prefix", (Object)ProfileLabels.profile_table_column_loadmod_cu);
    }

    private void createEditorToolbar() {
        if (this.form.getToolBarManager() instanceof ToolBarManager) {
            ToolBarManager manager = (ToolBarManager)this.form.getToolBarManager();
            IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
            String menuLocation = "toolbar:com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor.internal";
            menuService.populateContributionManager((ContributionManager)manager, menuLocation);
        }
    }

    private void createAdvConnOptionSection(Composite parent, String title) {
        this.fAdvConnOptionSection = this.fToolkitHelper.createSection(parent, 258);
        TableWrapData td = new TableWrapData(256);
        this.fAdvConnOptionSection.setLayoutData((Object)td);
        this.fAdvConnOptionSection.setText(title);
        this.fAdvConnOptionSection.setData("outlineWidget", (Object)this.fAdvConnOptionSection);
        int colspan = 2;
        int indent = 20;
        Composite client = this.fToolkit.createComposite((Composite)this.fAdvConnOptionSection);
        client.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan));
        client.setLayoutData((Object)this.fToolkitHelper.getGridData());
        this.fToolkitHelper.createSectionDescription(this.fAdvConnOptionSection, client, colspan);
        this.fConnectWithClientInfoButton = this.fToolkitHelper.createCheckBox(client, ProfileLabels.editor_connect_with_specific_client_check, ProfileLabels.editor_connect_with_specific_client_check_tooltip, colspan);
        this.fConnectWithClientInfoButton.addSelectionListener((SelectionListener)this);
        this.fConnectWithClientInfoButton.setData("outlineWidget", (Object)this.fConnectWithClientInfoButton);
        this.fConnectIPLabel = this.fToolkitHelper.createLabel(client, ProfileLabels.editor_connect_ip);
        this.fConnectIPText = this.fToolkitHelper.createText(client, ProfileLabels.editor_connect_ip_tooltip);
        GridDataFactory.fillDefaults().indent(indent, 0).applyTo((Control)this.fConnectIPLabel);
        this.fConnectIPText.setData("outlineWidget", (Object)this.fConnectIPLabel);
        this.fConnectPortLabel = this.fToolkitHelper.createLabel(client, ProfileLabels.editor_connect_port);
        this.fConnectPortText = this.fToolkitHelper.createText(client, ProfileLabels.editor_connect_port_tooltip);
        GridDataFactory.fillDefaults().indent(indent, 0).applyTo((Control)this.fConnectPortLabel);
        this.fConnectPortText.setData("outlineWidget", (Object)this.fConnectPortLabel);
        this.fConnectUserIDLabel = this.fToolkitHelper.createLabel(client, ProfileLabels.editor_connect_user_id);
        this.fConnectUserIDText = this.fToolkitHelper.createText(client, ProfileLabels.editor_connect_user_id_tooltip);
        GridDataFactory.fillDefaults().indent(indent, 0).applyTo((Control)this.fConnectUserIDLabel);
        this.fConnectUserIDText.setData("outlineWidget", (Object)this.fConnectUserIDLabel);
        Composite dsComposite = this.fToolkit.createComposite(client);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(dsComposite);
        dsComposite.setLayoutData((Object)this.fToolkitHelper.getGridData(2));
        this.fCertificateLabel = this.fToolkitHelper.createLabel(dsComposite, ProfileLabels.editor_certificate);
        this.fCertificateText = this.fToolkitHelper.createText(dsComposite, ProfileLabels.editor_certificate_tooltip);
        this.fCertificateText.setTextLimit(254);
        this.fCertificateText.setText("X".repeat(50));
        Point size = this.fCertificateText.computeSize(-1, -1);
        GridData data = (GridData)this.fCertificateText.getLayoutData();
        data.widthHint = size.x;
        this.fCertificateText.setText("");
        this.fCertificateBrowseButton = this.fToolkitHelper.createButton(dsComposite, ProfileLabels.editor_browse_button_label, "");
        this.fCertificateBrowseButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fCertificateBrowseButton);
        this.fCertificateText.setData("outlineWidget", (Object)this.fCertificateLabel);
        this.fAdvConnOptionSection.setClient((Control)client);
        this.setOutlineParentChildRel((Widget)this.fAdvConnOptionSection, (Widget)this.fConnectWithClientInfoButton);
        this.setOutlineParentChildRel((Widget)this.fConnectWithClientInfoButton, (Widget)this.fConnectIPText);
        this.setOutlineParentChildRel((Widget)this.fConnectWithClientInfoButton, (Widget)this.fConnectPortText);
        this.setOutlineParentChildRel((Widget)this.fConnectWithClientInfoButton, (Widget)this.fConnectUserIDText);
        this.setOutlineParentChildRel((Widget)this.fAdvConnOptionSection, (Widget)this.fCertificateText);
    }

    private void createDebugOptionSection(Composite parent, String title) {
        this.fDebugOptionSection = this.fToolkitHelper.createSection(parent, 258);
        TableWrapData td = new TableWrapData(256);
        this.fDebugOptionSection.setLayoutData((Object)td);
        this.fDebugOptionSection.setText(title);
        this.fDebugOptionSection.setData("outlineWidget", (Object)this.fDebugOptionSection);
        int colspan2 = 2;
        int colspan3 = 3;
        Composite client = this.fToolkit.createComposite((Composite)this.fDebugOptionSection);
        GridLayoutFactory.fillDefaults().numColumns(colspan3).equalWidth(true).applyTo(client);
        client.setLayoutData((Object)this.fToolkitHelper.getGridData(3));
        this.fToolkitHelper.createSectionDescription(this.fDebugOptionSection, client, colspan3);
        Composite levelComposite1 = this.fToolkit.createComposite(client);
        levelComposite1.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan2));
        levelComposite1.setLayoutData((Object)this.fToolkitHelper.getGridData());
        Label testLevelLabel = this.fToolkitHelper.createLabel(levelComposite1, ProfileLabels.editor_test_level);
        this.fTestLevelCombo = this.fToolkitHelper.createCombo(levelComposite1, ProfileLabels.editor_test_level_tooltip);
        this.fTestLevelCombo.setData("outlineWidget", (Object)testLevelLabel);
        Composite levelComposite2 = this.fToolkit.createComposite(client);
        levelComposite2.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan2));
        levelComposite2.setLayoutData((Object)this.fToolkitHelper.getGridData());
        Label errLevelLabel = this.fToolkitHelper.createLabel(levelComposite2, ProfileLabels.editor_error_level);
        this.fErrorLevelCombo = this.fToolkitHelper.createCombo(levelComposite2, ProfileLabels.editor_error_level_tooltip);
        this.fErrorLevelCombo.setData("outlineWidget", (Object)errLevelLabel);
        Composite levelComposite3 = this.fToolkit.createComposite(client);
        levelComposite3.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan2));
        levelComposite3.setLayoutData((Object)this.fToolkitHelper.getGridData());
        Label promptLevelLabel = this.fToolkitHelper.createLabel(levelComposite3, ProfileLabels.editor_prompt_level);
        this.fPromptLevelCombo = this.fToolkitHelper.createCombo(levelComposite3, ProfileLabels.editor_prompt_level_tooltip);
        this.fPromptLevelCombo.setData("outlineWidget", (Object)promptLevelLabel);
        Composite dsComposite = this.fToolkit.createComposite(client);
        dsComposite.setLayout((Layout)this.fToolkitHelper.getGridLayout(colspan3));
        dsComposite.setLayoutData((Object)this.fToolkitHelper.getGridData(colspan3));
        Label commandDataSetLabel = this.fToolkitHelper.createLabel(dsComposite, ProfileLabels.editor_command_dataset);
        this.fCommandDataSetText = this.fToolkitHelper.createText(dsComposite, ProfileLabels.editor_command_dataset_tooltip);
        this.fCommandDataSetText.setTextLimit(58);
        this.fCommandsDataSetBrowseButton = this.fToolkitHelper.createButton(dsComposite, ProfileLabels.editor_browse_button_label, "");
        this.fCommandsDataSetBrowseButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fCommandsDataSetBrowseButton);
        this.fCommandDataSetText.setData("outlineWidget", (Object)commandDataSetLabel);
        Label prefDatasetLabel = this.fToolkitHelper.createLabel(dsComposite, ProfileLabels.editor_preference_dataset);
        this.fPreferenceDataSetText = this.fToolkitHelper.createText(dsComposite, ProfileLabels.editor_preference_dataset_tooltip);
        this.fPreferenceDataSetText.setTextLimit(57);
        this.fPreferenceDataSetBrowseButton = this.fToolkitHelper.createButton(dsComposite, ProfileLabels.editor_browse_button_label, "");
        this.fPreferenceDataSetBrowseButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fPreferenceDataSetBrowseButton);
        this.fPreferenceDataSetText.setData("outlineWidget", (Object)prefDatasetLabel);
        Label eqaoptDataseLabel = this.fToolkitHelper.createLabel(dsComposite, ProfileLabels.editor_eqaopts_file);
        this.fEqaOptsText = this.fToolkitHelper.createText(dsComposite, ProfileLabels.editor_eqaopts_file_tooltip);
        this.fEqaOptsText.setTextLimit(54);
        this.fEqaoptsDataSetBrowseButton = this.fToolkitHelper.createButton(dsComposite, ProfileLabels.editor_browse_button_label, "");
        this.fEqaoptsDataSetBrowseButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fEqaoptsDataSetBrowseButton);
        this.fEqaOptsText.setData("outlineWidget", (Object)eqaoptDataseLabel);
        Label leOptLabel = this.fToolkitHelper.createLabel(dsComposite, ProfileLabels.editor_language_environment_options, this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS);
        this.fEnvOptionsText = this.fToolkitHelper.createText(dsComposite, ProfileLabels.editor_language_environment_options_tooltip, colspan2);
        this.fEnvOptionsText.setTextLimit(73);
        this.fEnvOptionsText.setEnabled(this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS);
        this.fEnvOptionsText.setData("outlineWidget", (Object)leOptLabel);
        this.fDebugOptionSection.setClient((Control)client);
        this.setOutlineParentChildRel((Widget)this.fDebugOptionSection, (Widget)this.fTestLevelCombo);
        this.setOutlineParentChildRel((Widget)this.fDebugOptionSection, (Widget)this.fErrorLevelCombo);
        this.setOutlineParentChildRel((Widget)this.fDebugOptionSection, (Widget)this.fPromptLevelCombo);
        this.setOutlineParentChildRel((Widget)this.fDebugOptionSection, (Widget)this.fCommandDataSetText);
        this.setOutlineParentChildRel((Widget)this.fDebugOptionSection, (Widget)this.fPreferenceDataSetText);
        this.setOutlineParentChildRel((Widget)this.fDebugOptionSection, (Widget)this.fEqaOptsText);
        this.setOutlineParentChildRel((Widget)this.fDebugOptionSection, (Widget)this.fEnvOptionsText);
    }

    public int getFormMessageType() {
        return this.form.getMessageType();
    }

    protected DebugProfile saveProfile() {
        boolean isRenamed;
        if (this.getFormMessageType() == 3) {
            return null;
        }
        DebugProfile profile = this.fDebugProfile;
        if (profile != null && profile.getMode() != 0) {
            try {
                profile.deactivate();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
        String profileName = this.fProfileNameText.getText().trim();
        boolean bl = isRenamed = profile != null && !profileName.equalsIgnoreCase(profile.getName());
        if (isRenamed) {
            DebugProfileRoot.getInstance().removeDebugProfile(profile);
        }
        if (profile == null || isRenamed) {
            switch (this.fType) {
                case PROFILE_NON_CICS: {
                    profile = new DebugProfileDTSP(profileName);
                    break;
                }
                case PROFILE_IMS: {
                    profile = new DebugProfileIMS(profileName);
                    break;
                }
                default: {
                    profile = new DebugProfileDTCN(profileName);
                }
            }
        }
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
            this.saveCICSProfile(profile);
            this.fEditorHelper.saveCICSSectionExpandState(this.fFilterSection, this.fAdditionalFilterSection, this.fAdvancedFilterSection);
        } else if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
            this.saveIMSProfile((DebugProfileIMS)profile);
            this.fEditorHelper.saveIMSIsolationSectionExpandState(this.fIMSStepLibSection);
        } else {
            this.saveNonCICSProfile(profile);
            this.fEditorHelper.saveNonCICSSectionExpandState(this.fAddtionSubSysfilterSection);
        }
        this.fEditorHelper.saveCommonSectionsExpandState(this.fFilterSection, this.fDebugOptionSection, this.fAdvConnOptionSection);
        profile.setConnectionName(this.fConnectionCombo.getText());
        profile.setDescription(this.fDescriptionText.getText());
        profile.clearLoadModules();
        List debugItems = this.fLoadModuleComposite.getDebugItems();
        for (DebugItem item : debugItems) {
            if (DebugItem.isDefaultAddItem((DebugItem)item)) continue;
            profile.addLoadModulePair(item.getModule(), item.getProgram());
        }
        DebugProfile.DebuggerOptions dbgOptions = new DebugProfile.DebuggerOptions(this.fTestLevelCombo.getText(), this.fErrorLevelCombo.getText(), this.fPromptLevelCombo.getText());
        dbgOptions.setCommandDataSet(this.fCommandDataSetText.getText());
        dbgOptions.setPreferenceDataSet(this.fPreferenceDataSetText.getText());
        dbgOptions.setLanguageEnvironmentOptions(this.fEnvOptionsText.getText());
        dbgOptions.setEqaOptsFile(this.fEqaOptsText.getText());
        profile.setDebuggerOptions(dbgOptions);
        DebugProfile.AdvancedConnectionOptions advConnectionOptions = null;
        advConnectionOptions = this.fConnectWithClientInfoButton.getSelection() ? new DebugProfile.AdvancedConnectionOptions(this.fConnectUserIDText.getText(), this.fConnectIPText.getText(), this.fConnectPortText.getText(), this.fCertificateText.getText(), Boolean.valueOf(this.fCertificateText.getEnabled())) : new DebugProfile.AdvancedConnectionOptions(null, null, null, this.fCertificateText.getText(), Boolean.valueOf(this.fCertificateText.getEnabled()));
        profile.setAdvancedConnectionOptions(advConnectionOptions);
        profile.save();
        if (this.fEditorInput != null) {
            this.fEditorInput.setDebugProfile(profile);
        }
        this.fDebugProfile = profile;
        return this.fDebugProfile;
    }

    private void saveNonCICSProfile(DebugProfile profile) {
        DebugProfileDTSP p = (DebugProfileDTSP)profile;
        Connection c = ConnectionUtilities.getConnection((String)this.fConnectionCombo.getText(), (boolean)false);
        if (DebugProfile.isBackLevelRequired((Connection)c, (boolean)false)) {
            p.setLocation(this.fRegionCombo.getText());
        }
        this.fEditorHelper.updateArrayList(this.fRegionCombo.getText(), "NON_CICS_LOCATIONS");
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_NON_CICS) {
            DebugProfileDTSP.JobInfo jobInfo = new DebugProfileDTSP.JobInfo(this.fJobNameText.getText(), this.fStepNameText.getText());
            p.setJobInfo(jobInfo);
            DebugProfileDTSP.IMSOptions imsOptions = new DebugProfileDTSP.IMSOptions(this.fSubsystemIDText.getText(), this.fTransactionIDText.getText());
            p.setIMSOptions(imsOptions);
        }
    }

    private void saveIMSProfile(DebugProfileIMS profile) {
        this.saveNonCICSProfile((DebugProfile)profile);
        this.fIMSIsolationComposite.updateProfile(profile);
        this.fIMSStepLibComposite.updateProfile(profile);
    }

    private void saveCICSProfile(DebugProfile profile) {
        DebugProfileDTCN p = (DebugProfileDTCN)profile;
        if (this.fRegionState == REGION_STATE.REGION) {
            p.setRegion(this.fRegionCombo.getText());
        } else if (this.fRegionState == REGION_STATE.PORT) {
            p.setPort(Integer.parseInt(this.fRegionCombo.getText()));
            this.fEditorHelper.updateArrayList(this.fRegionCombo.getText(), "CICS_PORTS");
        }
        p.setTransaction(this.fTransactionNameText.getText());
        DebugProfileDTCN.AdditionalCICSFilters filters = new DebugProfileDTCN.AdditionalCICSFilters(this.fUserIdText.getText(), this.fNetNameText.getText(), this.fIpText.getText(), this.fSYSIDText.getText(), this.fTermIDText.getText());
        p.setAdditionalCICSFilters((IAdditionalCICSFilters)filters);
        DebugProfileDTCN.ContainerInfo containerInfo = new DebugProfileDTCN.ContainerInfo(this.fContainerNameText.getText(), this.fContainerOffsetText.getText(), this.fContainerDatasetText.getText());
        DebugProfileDTCN.ApplicationInfo appInfo = new DebugProfileDTCN.ApplicationInfo(this.fPlatfromNameText.getText(), this.fAppNameText.getText(), this.fOperationNameText.getText(), this.fAppVersionText.getText());
        DebugProfileDTCN.CommAreaInfo commAreaInfo = new DebugProfileDTCN.CommAreaInfo(this.fComAreaOffsetText.getText(), this.fComAreaDataText.getText());
        DebugProfileDTCN.AdvancedProgramInterruptionCriteria advCriteria = new DebugProfileDTCN.AdvancedProgramInterruptionCriteria(containerInfo, appInfo, commAreaInfo, this.fURMCheck.getSelection());
        p.setAdvancedProgramInterruptionCriteria(advCriteria);
    }

    private void populateNonCICSLocation(Connection c) {
        this.fRegionState = REGION_STATE.LOCATION;
        this.fRegionCombo.removeAll();
        this.fRegionLabel.setText(ProfileLabels.editor_connect_location);
        this.fToolkitHelper.setTooltip((Control)this.fRegionCombo, ProfileLabels.editor_connect_location_nonAPI_tooltip);
        DebugProfileDTSP p = (DebugProfileDTSP)this.fDebugProfile;
        if (c != null) {
            if (c.getErrorState() == Connection.ERROR_STATE.NONE) {
                String location = c.getNonCICSLocation();
                this.fRegionCombo.setText(location == null ? "" : location);
                this.fToolkitHelper.updateTooltip((Control)this.fRegionCombo, ProfileLabels.editor_connect_location_API_tooltip);
                this.fRegionCombo.setEditable(false);
                this.fValidator.clearMessages(this.fConnectionCombo);
                if (c.getErrorState() != Connection.ERROR_STATE.NONE) {
                    this.fValidator.updateMessage(this.fConnectionCombo, c.getErrorMessage(), "error");
                }
                if (location == null || location.trim().isEmpty()) {
                    this.setRegionComboException(c.getNonCICSException());
                }
            } else if (DebugProfile.isBackLevelRequired((Connection)c, (boolean)false)) {
                this.fEditorHelper.getBackLevelLocation(this.fRegionCombo, p);
                this.fValidator.updateMessage(this.fConnectionCombo, c.getErrorMessage(), "warn");
            } else {
                this.fToolkitHelper.determineConnectionError(c, this.fConnectionCombo, this.fValidator);
            }
            this.fMessageHelper.updateCCSessionState(c.getErrorState() == Connection.ERROR_STATE.NONE);
        } else {
            this.fValidator.updateMessage(this.fConnectionCombo, ProfileMessages.CRRDG9113, "error");
            this.fMessageHelper.updateCCSessionState(false);
        }
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
            this.fIMSIsolationComposite.setLocation(this.fRegionCombo.getText());
        }
        this.fRegionLabel.getParent().layout();
    }

    private void populateCICSRegion(Connection c, String[] regions) {
        this.fRegionState = REGION_STATE.REGION;
        this.fRegionLabel.setText(ProfileLabels.editor_cics_region);
        this.fToolkitHelper.updateTooltip((Control)this.fRegionCombo, ProfileLabels.editor_cics_region_tooltip);
        this.fRegionCombo.setEditable(false);
        this.fValidator.clearMessages(this.fConnectionCombo);
        if (this.fRegionCombo.getItemCount() > 0) {
            this.fRegionCombo.removeAll();
        }
        DebugProfileDTCN p = (DebugProfileDTCN)this.fDebugProfile;
        if (c != null) {
            if (c.getErrorState() == Connection.ERROR_STATE.NONE || c.getErrorState() == Connection.ERROR_STATE.CICS_ONLY) {
                this.fToolkitHelper.getRegionList(c, p != null ? p.getRegion() : "", regions, this.fRegionCombo);
                this.fValidator.clearMessages(this.fConnectionCombo);
            } else if (DebugProfile.isBackLevelRequired((Connection)c, (boolean)true)) {
                this.fRegionState = REGION_STATE.PORT;
                this.fRegionLabel.setText(ProfileLabels.editor_connect_port);
                this.fToolkitHelper.updateTooltip((Control)this.fRegionCombo, ProfileLabels.editor_cics_port_tooltip);
                this.fRegionCombo.setEditable(true);
                this.fEditorHelper.getCICSPorts(this.fRegionCombo, this.fConnectionCombo, this.fRegionLabel, p != null && p.getPort() > 0 ? String.valueOf(p.getPort()) : "");
                this.fValidator.updateMessage(this.fConnectionCombo, c.getErrorMessage(), "warn");
            } else {
                this.fToolkitHelper.determineConnectionError(c, this.fConnectionCombo, this.fValidator);
                if (c.getErrorState() == Connection.ERROR_STATE.NOT_CONNECTED) {
                    this.fRegionState = REGION_STATE.PORT;
                    this.fRegionLabel.setText(ProfileLabels.editor_connect_port);
                    this.fToolkitHelper.updateTooltip((Control)this.fRegionCombo, ProfileLabels.editor_cics_port_tooltip);
                    this.fRegionCombo.setEditable(true);
                }
            }
            this.fMessageHelper.updateCCSessionState(c.getErrorState() == Connection.ERROR_STATE.NONE || c.getErrorState() == Connection.ERROR_STATE.BACK_LEVEL);
        } else {
            this.fValidator.updateMessage(this.fConnectionCombo, ProfileMessages.CRRDG9113, "error");
            this.fMessageHelper.updateCCSessionState(false);
        }
        this.fValidator.validateRegionCombo(this.fRegionCombo, this.fRegionState, c);
        this.fRegionLabel.getParent().layout();
    }

    private void getIMSIsolationConnection(Connection c, final IIMSIsolationComposite imsIsolation, final IIMSIsolationComposite imsStepLib) {
        if (c != null && !c.isConnected()) {
            this.form.setBusy(true);
            this.form.getBody().setEnabled(false);
            final String connectionName = this.fConnectionCombo.getText();
            Job j = new Job("Connecting Editor"){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).DebugProfileEditorPage.this.form.isDisposed()) {
                                (this).DebugProfileEditorPage.this.form.setBusy(true);
                                (this).DebugProfileEditorPage.this.form.getBody().setEnabled(false);
                            }
                        }
                    });
                    ConnectionUtilities.getConnection((String)connectionName, (boolean)true);
                    if (imsIsolation != null) {
                        imsIsolation.connect();
                        imsStepLib.connect();
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).DebugProfileEditorPage.this.form.isDisposed()) {
                                (this).DebugProfileEditorPage.this.form.getBody().setEnabled(true);
                                (this).DebugProfileEditorPage.this.form.setBusy(false);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family.equals(connectionName);
                }
            };
            try {
                Job.getJobManager().join((Object)connectionName, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            j.setSystem(true);
            j.schedule();
        }
    }

    private void getConnectionUpdateRegion(boolean needUpdate, String connectionName, boolean autoLogon) {
        this.fToolkitHelper.getConnectionUpdateRegion(needUpdate, connectionName, autoLogon, this.form, this, true);
    }

    @Override
    public void setRegionComboException(APIServerException exception) {
        this.fToolkitHelper.setRegionComboException(exception, this.fMessageHelper, this.fRegionCombo);
    }

    @Override
    public void updateRegionLocation(final Connection c, final String[] regions) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DebugProfileEditorPage.this.ignoreEvent = true;
                if (DebugProfileEditorPage.this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
                    DebugProfileEditorPage.this.populateCICSRegion(c, regions);
                } else {
                    DebugProfileEditorPage.this.populateNonCICSLocation(c);
                }
                if (DebugProfileEditorPage.this.fIMSIsolationComposite != null) {
                    DebugProfileEditorPage.this.checkForIMSRestAPI(c);
                    DebugProfileEditorPage.this.fIMSIsolationComposite.setConnectionName(c.getConnectionName());
                    DebugProfileEditorPage.this.fIMSIsolationComposite.connect();
                }
                DebugProfileEditorPage.this.ignoreEvent = false;
            }
        });
    }

    private void checkForIMSRestAPI(Connection connection) {
        IIMSIsolationUIProvider provider = IMSIsolationProfileUtils.getIMSIsolationUIProvider();
        boolean connected = connection != null && connection.isConnected();
        boolean enabled = connected && provider.isIMSRestAPIAvailable(connection);
        Validator.validateDPS(connected, enabled, this.fConnectionCombo, this.fMessageHelper);
    }

    protected void initializeControls(ScrolledForm sform) {
        String connectionName = this.fDebugProfile != null ? this.fDebugProfile.getConnectionName() : null;
        Connection c = DebugProfileEditorHelper.initConnection(this.fConnectionCombo, connectionName);
        connectionName = this.fConnectionCombo.getText();
        if (c != null) {
            if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
                this.checkForIMSRestAPI(c);
                this.fIMSIsolationComposite.setConnectionName(this.fConnectionCombo.getText());
                this.fIMSStepLibComposite.setConnectionName(this.fConnectionCombo.getText());
            }
            this.getConnectionUpdateRegion(true, c.getConnectionName(), this.fIMSIsolationComposite == null);
            if (this.fIMSIsolationComposite != null) {
                this.getIMSIsolationConnection(c, this.fIMSIsolationComposite, this.fIMSStepLibComposite);
            }
        }
        this.fEditorHelper.showHideDescription(this.form, this.fHideHintLink, this.profileSection, this.fFilterSection, this.fAdditionalFilterSection, this.fAdvancedFilterSection, this.fDebugOptionSection, this.fAddtionSubSysfilterSection, this.fAdvConnOptionSection, this.fIMSISolationSection, this.fIMSStepLibSection);
        if (this.fDebugProfile instanceof DebugProfileDTCN) {
            this.fEditorHelper.initCICSFilters(this.fTransactionNameText, this.fUserIdText, this.fNetNameText, this.fIpText, this.fSYSIDText, this.fTermIDText, this.fContainerNameText, this.fContainerOffsetText, this.fContainerDatasetText, this.fComAreaOffsetText, this.fComAreaDataText, this.fPlatfromNameText, this.fAppNameText, this.fOperationNameText, this.fAppVersionText, this.fURMCheck);
            this.fEditorHelper.disableCOMMAREAGroup(this.fGroupCOMMAREA, this.fContainerNameText, this.fContainerOffsetText, this.fContainerDatasetText);
            this.fEditorHelper.disableContainerGroup(this.fGroupContainer, this.fComAreaOffsetText, this.fComAreaDataText);
            this.fEditorHelper.expandCollapseSection(this.fAdditionalFilterSection, "EXPAND_ADDITIONAL_CICS_FILTERS");
            this.fEditorHelper.expandCollapseSection(this.fAdvancedFilterSection, "EXPAND_ADVANCED_PROGRAM_INTERRUPTION_FILTERS");
        } else if (this.fDebugProfile instanceof DebugProfileIMS) {
            this.fIMSIsolationComposite.initFromProfile((DebugProfileIMS)this.fDebugProfile);
            this.fIMSStepLibComposite.initFromProfile((DebugProfileIMS)this.fDebugProfile);
        } else if (this.fDebugProfile instanceof DebugProfileDTSP) {
            this.fEditorHelper.initAddSysFilterNonCICS(this.fJobNameText, this.fStepNameText, this.fSubsystemIDText, this.fTransactionIDText);
            this.fEditorHelper.expandCollapseSection(this.fAddtionSubSysfilterSection, "EXPAND_ADD_SUBSYSTEM_FILTER");
        } else if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
            this.checkForIMSRestAPI(c);
        }
        this.fEditorHelper.expandCollapseSection(this.fFilterSection, "EXPAND_FILTERS");
        this.fEditorHelper.expandCollapseSection(this.fDebugOptionSection, "EXPAND_DEBUGGER_OPTIONS");
        this.fEditorHelper.expandCollapseSection(this.fAdvConnOptionSection, "EXPAND_ADVANCED_CONNECTION_OPTIONS");
        this.fEditorHelper.initDebuggerOptions(this.fDebugOptionSection, this.fTestLevelCombo, this.fErrorLevelCombo, this.fPromptLevelCombo, this.fCommandDataSetText, this.fPreferenceDataSetText, this.fEnvOptionsText, this.fEqaOptsText);
        this.fEditorHelper.initAdvanceConnectionOptions(this.fAdvConnOptionSection, connectionName, this.fConnectWithClientInfoButton, this.fCertificateBrowseButton, this.fConnectUserIDText, this.fConnectIPText, this.fConnectPortText, this.fCertificateText, this.fConnectUserIDLabel, this.fConnectIPLabel, this.fConnectPortLabel, this.fCertificateLabel);
        boolean isExistingProfileName = this.fValidator.checkIfEqualExistingProfileName(this.fDebugProfile, this.fProfileNameText);
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
            this.fValidator.validateCICSDebugFormInput(isExistingProfileName, this.fProfileNameText, this.fConnectionCombo, this.fRegionState, this.fRegionCombo, this.fTransactionNameText, this.fUserIdText, this.fNetNameText, this.fIpText, this.fTermIDText, this.fLoadModuleComposite, this.fDTCNForceSettings);
        } else {
            this.fValidator.validateNonCICSDebugFormInput(isExistingProfileName, this.fProfileNameText, this.fConnectionCombo, this.fRegionCombo, this.fLoadModuleComposite, this.fJobNameText, this.fStepNameText, this.fSubsystemIDText, this.fTransactionIDText);
        }
        this.fProfileEditor.setDirty(false);
    }

    public void dispose() {
        super.dispose();
        if (this.fImage != null) {
            this.fImage.dispose();
            this.fImage = null;
        }
        if (this.form != null) {
            this.form.dispose();
        }
        if (this.fToolkit != null) {
            this.fToolkit.dispose();
            this.fToolkit = null;
        }
        DebugProfileRSEUtils.getInstance().removeRSEEventListener(this.fRSEEventListener);
        ConnectionEventManager.getInstance().removeConnectionEventListener(this.fConnectionEventListener);
    }

    public void setFocus() {
        super.setFocus();
        this.fMessageHelper.updateSessionState(this.getFormMessageType());
        Connection c = ConnectionUtilities.getConnection((String)this.fConnectionCombo.getText(), (boolean)false);
        switch (this.fType) {
            case PROFILE_NON_CICS: {
                if (c != null) {
                    this.fMessageHelper.updateCCSessionState(c.getErrorState() == Connection.ERROR_STATE.NONE);
                    break;
                }
                this.fMessageHelper.updateCCSessionState(false);
                break;
            }
            case PROFILE_CICS: {
                if (c != null) {
                    this.fMessageHelper.updateCCSessionState(c.getErrorState() == Connection.ERROR_STATE.NONE || c.getErrorState() == Connection.ERROR_STATE.BACK_LEVEL);
                    break;
                }
                this.fMessageHelper.updateCCSessionState(false);
                break;
            }
        }
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void delayDebugValuesUpdated() {
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
            if (this.fValidator.validateCICSDebugConjunctionFields(this.fTransactionNameText, this.fUserIdText, this.fNetNameText, this.fIpText, this.fTermIDText, this.fLoadModuleComposite, this.fDTCNForceSettings)) {
                this.fValidator.validateGenericCICSFields(this.fTransactionNameText, this.fUserIdText, this.fNetNameText, this.fIpText, this.fTermIDText, this.fLoadModuleComposite, this.fDTCNForceSettings);
            }
        } else if (this.fValidator.validateNonCICSLoadModuleComposite(this.fLoadModuleComposite) && this.fType != IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
            this.fValidator.validateGenericNonCICSFields(this.fLoadModuleComposite, this.fJobNameText, this.fStepNameText, this.fSubsystemIDText, this.fTransactionIDText);
        }
        this.fProfileEditor.setDirty(true);
        this.fMessageHelper.updateSessionState(this.getFormMessageType());
        this.updateContentOutline();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(final SelectionEvent event) {
        DebugProfileEditorPage.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (event.getSource() == DebugProfileEditorPage.this.fConnectionCombo) {
                    DebugProfileEditorPage.this.handleConnectionComboUpdate(true, true);
                } else if (event.widget == DebugProfileEditorPage.this.fConnectionButton) {
                    String newHost = DebugProfileEditorPage.this.fToolkitHelper.addNewConnection(DebugProfileEditorPage.this.form.getShell());
                    if (newHost != null) {
                        DebugProfileEditorPage.this.fConnectionCombo.setText("");
                    }
                } else if (event.widget == DebugProfileEditorPage.this.fHideHintLink) {
                    boolean hint = DebugProfileEditorPage.this.fEditorHelper.getDialogSettings().getBoolean("SHOW_HINTS");
                    DebugProfileEditorPage.this.fEditorHelper.getDialogSettings().put("SHOW_HINTS", !hint);
                    DebugProfileEditorPage.this.fEditorHelper.showHideDescription(DebugProfileEditorPage.this.form, DebugProfileEditorPage.this.fHideHintLink, DebugProfileEditorPage.this.profileSection, DebugProfileEditorPage.this.fFilterSection, DebugProfileEditorPage.this.fAdditionalFilterSection, DebugProfileEditorPage.this.fAdvancedFilterSection, DebugProfileEditorPage.this.fDebugOptionSection, DebugProfileEditorPage.this.fAddtionSubSysfilterSection, DebugProfileEditorPage.this.fAdvConnOptionSection, DebugProfileEditorPage.this.fIMSISolationSection, DebugProfileEditorPage.this.fIMSStepLibSection);
                } else if (event.widget == DebugProfileEditorPage.this.fConnectWithClientInfoButton) {
                    DebugProfileEditorPage.this.fEditorHelper.updateAdvancedConnectionFieldsEnablement(DebugProfileEditorPage.this.fConnectionCombo.getText(), DebugProfileEditorPage.this.fConnectWithClientInfoButton, DebugProfileEditorPage.this.fCertificateBrowseButton, DebugProfileEditorPage.this.fConnectUserIDText, DebugProfileEditorPage.this.fConnectIPText, DebugProfileEditorPage.this.fConnectPortText, DebugProfileEditorPage.this.fCertificateText, DebugProfileEditorPage.this.fConnectUserIDLabel, DebugProfileEditorPage.this.fConnectIPLabel, DebugProfileEditorPage.this.fConnectPortLabel, DebugProfileEditorPage.this.fCertificateLabel);
                    DebugProfileEditorPage.this.fValidator.validateAdvanceConnectionOptions(DebugProfileEditorPage.this.fConnectWithClientInfoButton, DebugProfileEditorPage.this.fConnectIPText, DebugProfileEditorPage.this.fConnectPortText, DebugProfileEditorPage.this.fConnectUserIDText);
                    DebugProfileEditorPage.this.fProfileEditor.setDirty(true);
                    DebugProfileEditorPage.this.fMessageHelper.updateSessionState(DebugProfileEditorPage.this.getFormMessageType());
                } else if (event.widget == DebugProfileEditorPage.this.fEqaoptsDataSetBrowseButton || event.widget == DebugProfileEditorPage.this.fCommandsDataSetBrowseButton || event.widget == DebugProfileEditorPage.this.fPreferenceDataSetBrowseButton) {
                    Object member;
                    RSESelectRemoteFolderDialog d = new RSESelectRemoteFolderDialog(DebugProfileEditorPage.this.form.getShell(), true, false, true, false, false);
                    if (d.open() == 0 && (member = d.getOutputObject()) instanceof MVSFileResource) {
                        String dsn = DebugLaunchUIUtils.convertToDatasetName((String)((MVSFileResource)member).getAbsolutePath());
                        if (event.widget == DebugProfileEditorPage.this.fEqaoptsDataSetBrowseButton) {
                            DebugProfileEditorPage.this.fEqaOptsText.setText(dsn);
                        }
                        if (event.widget == DebugProfileEditorPage.this.fCommandsDataSetBrowseButton) {
                            DebugProfileEditorPage.this.fCommandDataSetText.setText(dsn);
                        }
                        if (event.widget == DebugProfileEditorPage.this.fPreferenceDataSetBrowseButton) {
                            DebugProfileEditorPage.this.fPreferenceDataSetText.setText(dsn);
                        }
                    }
                } else if (event.widget == DebugProfileEditorPage.this.fCertificateBrowseButton) {
                    RSESelectRemoteFolderDialog d = new RSESelectRemoteFolderDialog(DebugProfileEditorPage.this.form.getShell(), true, false, true, false, true);
                    d.addViewerFilter((ViewerFilter)new HostFilter(DebugOptionsComposite.getHost((String)DebugProfileEditorPage.this.fConnectionCombo.getText())));
                    d.addViewerFilter(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElem, Object elem) {
                            return !(elem instanceof MVSFileResource) || !((MVSFileResource)elem).isDirectory();
                        }
                    });
                    if (d.open() == 0) {
                        Object member = d.getOutputObject();
                        String path = member.toString();
                        if (member instanceof MVSFileResource) {
                            path = DebugLaunchUIUtils.convertToDatasetName((String)((MVSFileResource)member).getAbsolutePath());
                        } else if (member instanceof IRemoteFile) {
                            path = ((IRemoteFile)member).getAbsolutePath();
                        }
                        DebugProfileEditorPage.this.fCertificateText.setText(path);
                    }
                } else if (event.widget == DebugProfileEditorPage.this.fURMCheck) {
                    DebugProfileEditorPage.this.fProfileEditor.setDirty(true);
                } else if (event.widget == DebugProfileEditorPage.this.fRegionCombo) {
                    if (DebugProfileEditorPage.this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
                        DebugProfileEditorPage.this.fIMSIsolationComposite.setLocation(DebugProfileEditorPage.this.fRegionCombo.getText());
                    } else if (!DebugProfileEditorPage.this.fRegionCombo.getText().trim().isEmpty()) {
                        Connection c = ConnectionUtilities.getConnection((String)DebugProfileEditorPage.this.fConnectionCombo.getText(), (boolean)true);
                        DebugProfileEditorPage.this.fDTCNForceSettings = c.getDTCNForceSettings(DebugProfileEditorPage.this.fRegionCombo.getText());
                        DebugProfileEditorPage.this.delayDebugValuesUpdated();
                    }
                }
                DebugProfileEditorPage.this.updateContentOutline();
            }
        });
    }

    private void handleRename(Connection connection, String oldName) {
        int index = this.fConnectionCombo.indexOf(oldName);
        int selection = this.fConnectionCombo.getSelectionIndex();
        boolean readonly = this.fConnectionCombo.getEditable();
        this.fConnectionCombo.setEditable(true);
        this.fConnectionCombo.setEnabled(false);
        if (index > -1) {
            this.fConnectionCombo.setItem(index, connection.getConnectionName());
        }
        this.fConnectionCombo.setEnabled(true);
        if (selection > -1) {
            this.fConnectionCombo.select(selection);
            this.fProfileEditor.setDirty(true);
        }
        if (this.fConnectionCombo.getText().equals(oldName)) {
            this.fConnectionCombo.setText(connection.getConnectionName());
            this.fProfileEditor.setDirty(true);
        }
        this.fConnectionCombo.setEditable(readonly);
    }

    private void handleConnectionComboUpdate(boolean updateRegion, boolean autoLogon) {
        if (updateRegion) {
            this.getConnectionUpdateRegion(updateRegion, this.fConnectionCombo.getText(), autoLogon);
        }
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_IMS) {
            this.fIMSIsolationComposite.setConnectionName(this.fConnectionCombo.getText());
            this.fIMSStepLibComposite.setConnectionName(this.fConnectionCombo.getText());
        }
        this.fValidator.validateValueSpecified(this.fConnectionCombo, ProfileMessages.CRRDG9102);
        this.fValidator.validateValueSpecified(this.fRegionCombo, this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS ? ProfileMessages.CRRDG9103 : ProfileMessages.CRRDG9142);
        this.fEditorHelper.updateAdvancedConnectionFieldsEnablement(this.fConnectionCombo.getText(), this.fConnectWithClientInfoButton, this.fCertificateBrowseButton, this.fConnectUserIDText, this.fConnectIPText, this.fConnectPortText, this.fCertificateText, this.fConnectUserIDLabel, this.fConnectIPLabel, this.fConnectPortLabel, this.fCertificateLabel);
    }

    public void showTooltip(boolean error) {
        Control control;
        if (this.fToolkit != null && (control = this.getPartControl().getDisplay().getFocusControl()) != null) {
            if (control.getParent() instanceof CCombo) {
                control = control.getParent();
            }
            if (error) {
                this.fToolkitHelper.showErrorTooltip(control);
            } else {
                this.fToolkitHelper.showTooltip(control);
            }
        }
    }

    public void hideTooltip() {
        if (this.fToolkit != null) {
            this.fToolkitHelper.hideTooltip();
        }
    }

    protected Object getOutlineInput() {
        if (this.fOutlineInput == null) {
            this.fOutlineInput = this.form.getData("outlineChildren");
        }
        return this.fOutlineInput;
    }

    private void setOutlineParentChildRel(Widget parent, Widget child) {
        if (parent.getData("outlineChildren") == null) {
            parent.setData("outlineChildren", new ArrayList());
        }
        ((List)parent.getData("outlineChildren")).add(child);
        child.setData("outlineParent", (Object)parent);
    }

    public void updateContentOutline() {
        DebugProfileOutlinePage contentOutlinePage = this.fProfileEditor.getContentOutlinePage();
        if (contentOutlinePage != null) {
            contentOutlinePage.updateViewer();
        }
    }

    protected void showMainErrorTooltip() {
        if (this.fToolkitHelper != null && this.form != null && this.form.getForm() != null && this.form.getForm().getHead() != null) {
            Control[] control;
            Control[] controlArray = control = this.form.getForm().getHead().getChildren();
            int n = control.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof CLabel && c.getToolTipText() != null && !c.getToolTipText().trim().isEmpty()) {
                    c.setData("tooltip", (Object)c.getToolTipText());
                    this.fToolkitHelper.showTooltip(c);
                    break;
                }
                ++n2;
            }
        }
    }

    protected Section createIMSISolationSection(Composite parent, String label) {
        Widget w;
        Widget[] widgets;
        this.fIMSISolationSection = this.fToolkitHelper.createSection(parent, 258);
        TableWrapData td = new TableWrapData(256);
        this.fIMSISolationSection.setLayoutData((Object)td);
        this.fIMSISolationSection.setText(label);
        this.fIMSISolationSection.setData("outlineWidget", (Object)this.fIMSISolationSection);
        this.fIMSISolationSection.setExpanded(true);
        Composite client = this.fToolkit.createComposite((Composite)this.fIMSISolationSection);
        GridLayoutFactory.swtDefaults().applyTo(client);
        this.fToolkitHelper.createSectionDescription(this.fIMSISolationSection, client, 1);
        IIMSIsolationUIProvider provider = IMSIsolationProfileUtils.getIMSIsolationUIProvider();
        this.fIMSIsolationComposite = provider.getIMSIsolationMainComposite(client, this.fToolkitHelper, this.fMessageHelper, this.form, this);
        Widget[] widgetArray = widgets = this.fIMSIsolationComposite.getOutlineItems();
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            w = widgetArray[n2];
            this.setOutlineParentChildRel((Widget)this.fIMSISolationSection, w);
            ++n2;
        }
        this.fIMSISolationSection.setClient((Control)client);
        this.fIMSStepLibSection = this.fToolkitHelper.createSection(client, 386);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fIMSStepLibSection);
        this.fIMSStepLibSection.setText(STEPLIB);
        this.fIMSStepLibSection.setData("outlineWidget", (Object)this.fIMSStepLibSection);
        client = this.fToolkit.createComposite((Composite)this.fIMSStepLibSection);
        GridLayoutFactory.swtDefaults().applyTo(client);
        this.fToolkitHelper.createSectionDescription(this.fIMSStepLibSection, client, 1);
        this.fIMSStepLibComposite = provider.getIMSSTEPLIBComposite(client, this.fToolkitHelper, this.fMessageHelper, this.fIMSIsolationComposite, this.form, this);
        widgetArray = widgets = this.fIMSStepLibComposite.getOutlineItems();
        n = widgets.length;
        n2 = 0;
        while (n2 < n) {
            w = widgetArray[n2];
            this.setOutlineParentChildRel((Widget)this.fIMSStepLibSection, w);
            ++n2;
        }
        this.fIMSStepLibSection.setClient((Control)client);
        this.setOutlineParentChildRel((Widget)this.fIMSISolationSection, (Widget)this.fIMSStepLibSection);
        return this.fIMSISolationSection;
    }

    public void setDirty(boolean value) {
        this.fProfileEditor.setDirty(value);
    }

    protected void refresh() {
        if (this.fIMSIsolationComposite != null) {
            this.fIMSIsolationComposite.refresh();
        }
    }

    public void activateDTSPForImsIso() throws Exception {
        DebugProfile p = this.fEditorInput.getDebugProfile();
        if (p instanceof DebugProfileIMS) {
            ((DebugProfileIMS)p).activateDTSPDebug();
        }
    }

    public static enum REGION_STATE {
        LOCATION,
        REGION,
        PORT;

    }
}

