/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal;

import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.ui.profile.internal.IDebugProfileViewConstants;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileRSEUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;

public class ConnectionSessionSourceProvider
extends AbstractSourceProvider
implements IDebugProfileViewConstants {
    boolean conn_refresh_state;
    private RSEEventListener fRseEventListener = new RSEEventListener(){

        @Override
        public void handleEvent(Connection source, int eventType, String oldName) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionSessionSourceProvider.this.setRefreshConnEnabled(ConnectionUtilities.hasDisconnectedConnection());
                    ConnectionSessionSourceProvider.this.setProfileManagementEnabled(ConnectionUtilities.hasConnectionAvailable());
                }
            });
        }
    };

    public ConnectionSessionSourceProvider() {
        DebugProfileRSEUtils.getInstance().addRSEEventListener(this.fRseEventListener);
    }

    public void dispose() {
        DebugProfileRSEUtils.getInstance().removeRSEEventListener(this.fRseEventListener);
    }

    public Map<String, String> getCurrentState() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hasDisconnectedConn_sessionState", String.valueOf(this.conn_refresh_state));
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{"hasDisconnectedConn_sessionState"};
    }

    public void setRefreshConnEnabled(boolean state) {
        this.conn_refresh_state = state;
        this.fireSourceChanged(0, "hasDisconnectedConn_sessionState", state);
    }

    public void setProfileManagementEnabled(boolean state) {
        this.conn_refresh_state = state;
        this.fireSourceChanged(0, "hasConnectionAvailable_sessionState", state);
    }
}

