/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile;

import com.ibm.debug.pdt.profile.IAdditionalCICSFilters;
import com.ibm.debug.pdt.profile.ICICSDebugProfile;
import com.ibm.debug.pdt.profile.IDebugProfile;
import com.ibm.debug.pdt.profile.IIMSIsoDebugProfile;
import com.ibm.debug.pdt.profile.IIMSTransaction;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DTCNForceSettings;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.rest.APIServerException;
import com.ibm.debug.pdt.ui.profile.ICICSDebugProfileStatus;
import com.ibm.debug.pdt.ui.profile.IDebugProfileConnectionStatus;
import com.ibm.debug.pdt.ui.profile.IDebugProfileUpdateListener;
import com.ibm.debug.pdt.ui.profile.IIMSISOProfileStatus;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditorHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditorPage;
import com.ibm.debug.pdt.ui.profile.internal.editor.FormToolkitHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.IRegionHandler;
import com.ibm.debug.pdt.ui.profile.internal.editor.MessageManagerHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.Validator;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IIMSIsolationComposite;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IIMSIsolationUIProvider;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IMSIsolationProfileUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileRSEUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileCheckboxFilteredTree;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.tabs.HostFilter;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.debug.ui.util.RemoteUtil;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.ui.rse.utils.RSESelectRemoteFolderDialog;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class DebugProfileUIUtils {
    private static final String STEPLIB = "STEPLIB";
    private static final String TEMP_PROFILE = ".tempISOProfile";
    private static final String API_SETTINGS = "com.ibm.debug.pdt.ui.profile.settings";
    private static final String API_PREV_CONNECTION = "connectionName";

    private DebugProfileUIUtils() {
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData) {
        return DebugProfileUIUtils.createConnectionArea(mode, form, listener, parent, layoutData, null, null);
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, IDebugProfile profile) {
        String connectionName = profile instanceof DebugProfile ? ((DebugProfile)profile).getConnectionName() : null;
        String region = profile instanceof DebugProfileDTCN ? ((DebugProfileDTCN)profile).getRegion() : null;
        return DebugProfileUIUtils.createConnectionArea(mode, form, listener, parent, layoutData, connectionName, region);
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, boolean deferConnection) {
        return DebugProfileUIUtils.createConnectionArea(mode, form, listener, parent, layoutData, null, null, true, true, null, deferConnection);
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String connectionName, String region) {
        return DebugProfileUIUtils.createConnectionArea(mode, form, listener, parent, layoutData, connectionName, region, true);
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String connectionName, String region, boolean enabled) {
        return DebugProfileUIUtils.createConnectionArea(mode, form, listener, parent, layoutData, connectionName, region, enabled, true, null);
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String connectionName, String region, boolean enabled, String dbrm) {
        return DebugProfileUIUtils.createConnectionArea(mode, form, listener, parent, layoutData, connectionName, region, enabled, true, dbrm, false);
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String connectionName, String region, boolean enabled, boolean dbrmVisible, String dbrm) {
        return DebugProfileUIUtils.createConnectionArea(mode, form, listener, parent, layoutData, connectionName, region, enabled, dbrmVisible, dbrm, false);
    }

    public static IDebugProfileConnectionStatus createConnectionArea(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String connectionName, String region, boolean enabled, boolean dbrmVisible, String dbrm, boolean deferConnection) {
        DebugProfileConnectionStatus status = new DebugProfileConnectionStatus(mode, form, listener, connectionName, region, deferConnection);
        FormToolkitHelper toolkitHelper = new FormToolkitHelper(form.getToolkit());
        boolean useParent = parent != null;
        Composite client = parent;
        if (parent == null) {
            parent = form.getForm().getBody();
            client = form.getToolkit().createComposite(parent);
        }
        if (!useParent) {
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(client);
            if (layoutData != null) {
                client.setLayoutData(layoutData);
            }
        }
        CCombo combo = status.fConnectionCombo = toolkitHelper.createConnectionCombo(client, status, false);
        if (useParent) {
            DebugProfileUIUtils.adjustColumns((Control)combo, parent);
        }
        status.fConnectionButton = toolkitHelper.createConnectionButton(client, status);
        if (dbrmVisible) {
            toolkitHelper.createLabel(client, ProfileLabels.DBRM, true, false);
            status.fDBRMText = toolkitHelper.createText(client, ProfileLabels.DBRM_tooltip);
            if (useParent) {
                DebugProfileUIUtils.adjustColumns((Control)status.fDBRMText, parent);
            }
            status.fDBRMText.setTextLimit(44);
            status.fDBRMText.addModifyListener((ModifyListener)status);
            status.fDBRMTextBrowseButton = toolkitHelper.createButton(client, ProfileLabels.editor_browse_button_label, "");
            status.fDBRMTextBrowseButton.addSelectionListener((SelectionListener)status);
            GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)status.fDBRMTextBrowseButton);
            GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)status.fConnectionButton);
            if (dbrm != null && !dbrm.trim().isEmpty()) {
                status.fDBRMText.setText(dbrm);
            }
        }
        if (mode == ConnectionMode.CICS) {
            CCombo regionCombo;
            Label label = toolkitHelper.createLabel(client, ProfileLabels.editor_cics_region, true, false);
            status.fRegionCombo = regionCombo = toolkitHelper.createRegionCombo(client, 2, null);
            if (useParent) {
                DebugProfileUIUtils.adjustColumns((Control)status.fRegionCombo, parent);
            }
            toolkitHelper.createLabel(client, "", true, false);
            regionCombo.setData("outlineWidget", (Object)label);
            regionCombo.addSelectionListener((SelectionListener)status);
            regionCombo.addModifyListener((ModifyListener)status);
        } else if (mode == ConnectionMode.IMS_ISO) {
            Group group = new Group(client, 0);
            form.getToolkit().adapt((Composite)group);
            group.setText(ProfileLabels.IMS_ISO_PROFILE);
            GridLayoutFactory.swtDefaults().applyTo((Composite)group);
            Layout layout = parent.getLayout();
            int columns = 1;
            if (layout instanceof GridLayout) {
                columns = ((GridLayout)layout).numColumns;
            }
            GridDataFactory.fillDefaults().grab(true, true).span(columns, 1).applyTo((Control)group);
            Composite treeParent = toolkitHelper.createComposite((Composite)group, 0);
            GridDataFactory.fillDefaults().grab(true, true).span(columns, 1).indent(4, 0).applyTo((Control)treeParent);
            GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(treeParent);
            status.fProfileTree = new DebugProfileCheckboxFilteredTree(treeParent, combo, false, true);
            status.fProfileTree.addCheckStateListener(status);
            form.getToolkit().adapt(treeParent);
            form.getToolkit().adapt((Composite)status.fProfileTree);
        }
        status.updateConnections();
        status.setEnabled(enabled);
        return status;
    }

    private static void adjustColumns(Control control, Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            int columns = ((GridLayout)layout).numColumns;
            if (columns < 3) {
                ((GridLayout)layout).numColumns = 3;
            } else if (columns > 3) {
                GridDataFactory.fillDefaults().indent(4, 0).align(4, 0x1000000).grab(true, false).span(columns - 2, 1).applyTo(control);
            }
        }
    }

    public static ICICSDebugProfileStatus createCICSFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData) {
        return DebugProfileUIUtils.createCICSFilters(form, listener, parent, layoutData, null, null, null);
    }

    public static ICICSDebugProfileStatus createCICSFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, IDebugProfileConnectionStatus connectionStatus) {
        return DebugProfileUIUtils.createCICSFilters(form, listener, parent, layoutData, null, null, connectionStatus);
    }

    public static ICICSDebugProfileStatus createCICSFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, ICICSDebugProfile profile) {
        return DebugProfileUIUtils.createCICSFilters(form, listener, parent, layoutData, profile, null);
    }

    public static ICICSDebugProfileStatus createCICSFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, ICICSDebugProfile profile, IDebugProfileConnectionStatus connectionStatus) {
        String transaction = profile instanceof DebugProfileDTCN ? ((DebugProfileDTCN)profile).getTransaction() : null;
        DebugProfileDTCN.AdditionalCICSFilters filters = profile instanceof DebugProfileDTCN ? ((DebugProfileDTCN)profile).getAdditionalCICSFilters() : null;
        return DebugProfileUIUtils.createCICSFilters(form, listener, parent, layoutData, transaction, (IAdditionalCICSFilters)filters, connectionStatus);
    }

    public static ICICSDebugProfileStatus createCICSFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String transaction, IAdditionalCICSFilters filters) {
        return DebugProfileUIUtils.createCICSFilters(form, listener, parent, layoutData, transaction, filters, null);
    }

    public static ICICSDebugProfileStatus createCICSFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String transaction, IAdditionalCICSFilters filters, IDebugProfileConnectionStatus connectionStatus) {
        CICSDebugProfileStatus status = new CICSDebugProfileStatus(form, listener, transaction, filters, connectionStatus);
        FormToolkitHelper toolkitHelper = new FormToolkitHelper(form.getToolkit());
        if (parent == null) {
            parent = form.getForm().getBody();
        }
        Section filterSection = toolkitHelper.createFilterSection(parent, ProfileLabels.editor_cics_settings, false);
        if (layoutData != null) {
            filterSection.setLayoutData(layoutData);
        }
        filterSection.setExpanded(true);
        Composite client = (Composite)filterSection.getClient();
        status.fTransaction = toolkitHelper.createTransactionText(client);
        status.initialize((Control)status.fTransaction);
        status.fUserIdText = toolkitHelper.createCICSUserIDText(client);
        status.initialize((Control)status.fUserIdText);
        status.fSYSIDText = toolkitHelper.createCICSSYSIDText(client);
        status.initialize((Control)status.fSYSIDText);
        Section additionalFilterSection = toolkitHelper.createAddtionalCICSFiltersSection((Composite)filterSection.getClient(), false);
        client = (Composite)additionalFilterSection.getClient();
        status.fNetNameText = toolkitHelper.createNetNameText(client);
        status.initialize((Control)status.fNetNameText);
        status.fIpText = toolkitHelper.createCICSIPText(client);
        status.initialize((Control)status.fIpText);
        status.fTermIDText = toolkitHelper.createTerminalIDText(client);
        status.initialize((Control)status.fTermIDText);
        status.setEnabled(false);
        status.updateStatus();
        return status;
    }

    private static DTCNForceSettings getDTCNFORCESettings(IDebugProfileConnectionStatus connectionStatus) {
        Connection connection;
        if (connectionStatus != null && !connectionStatus.getConnectionName().isEmpty() && (connection = ConnectionUtilities.getConnection((String)connectionStatus.getConnectionName(), (boolean)false)) != null && connectionStatus.getRegionName() != null && !connectionStatus.getRegionName().isEmpty()) {
            return connection.getDTCNForceSettings(connectionStatus.getRegionName());
        }
        return null;
    }

    public static IIMSISOProfileStatus createIMSIsoFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, IDebugProfileConnectionStatus connectionStatus) {
        return DebugProfileUIUtils.createIMSIsoFilters(form, listener, parent, layoutData, null, connectionStatus);
    }

    public static IIMSISOProfileStatus createIMSIsoFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, String imsID, String jobname, String jobclass, IIMSTransaction[] transactions, String[] steplib, IDebugProfileConnectionStatus connectionStatus) {
        DebugProfileIMS profile = new DebugProfileIMS(TEMP_PROFILE);
        profile.setIMSID(imsID);
        profile.setIMSJobName(jobname);
        profile.setJobClass(jobclass);
        profile.setSTEPLIB(steplib);
        if (transactions != null) {
            IIMSTransaction[] iIMSTransactionArray = transactions;
            int n = transactions.length;
            int n2 = 0;
            while (n2 < n) {
                IIMSTransaction t = iIMSTransactionArray[n2];
                profile.addTransaction(t);
                ++n2;
            }
        }
        return DebugProfileUIUtils.createIMSIsoFilters(form, listener, parent, layoutData, (IIMSIsoDebugProfile)profile, connectionStatus);
    }

    public static IIMSISOProfileStatus createIMSIsoFilters(IManagedForm form, IDebugProfileUpdateListener listener, Composite parent, Object layoutData, IIMSIsoDebugProfile profile, IDebugProfileConnectionStatus connectionStatus) {
        FormToolkit toolkit = form.getToolkit();
        FormToolkitHelper toolkitHelper = new FormToolkitHelper(toolkit);
        MessageManagerHelper messageHelper = new MessageManagerHelper(form.getMessageManager());
        if (parent == null) {
            parent = form.getForm().getBody();
        }
        Section IMSISolationSection = toolkitHelper.createSection(parent, 258);
        IMSISolationSection.setText(ProfileLabels.ims_isolation_section_title);
        IMSISolationSection.setExpanded(true);
        if (layoutData != null) {
            IMSISolationSection.setLayoutData(layoutData);
        }
        Composite client = toolkit.createComposite((Composite)IMSISolationSection);
        GridLayoutFactory.swtDefaults().applyTo(client);
        toolkitHelper.createSectionDescription(IMSISolationSection, client, 1);
        IIMSIsolationUIProvider provider = IMSIsolationProfileUtils.getIMSIsolationUIProvider();
        IIMSIsolationComposite IMSIsolationComposite = provider.getIMSIsolationMainComposite(client, toolkitHelper, messageHelper, form.getForm());
        IMSISolationSection.setClient((Control)client);
        IMSIsolationComposite.addListener(listener);
        if (profile instanceof DebugProfileIMS) {
            IMSIsolationComposite.initFromProfile((DebugProfileIMS)profile);
        }
        Section IMSStepLibSection = toolkitHelper.createSection(client, 386);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)IMSStepLibSection);
        IMSStepLibSection.setText(STEPLIB);
        client = toolkit.createComposite((Composite)IMSStepLibSection);
        GridLayoutFactory.swtDefaults().applyTo(client);
        toolkitHelper.createSectionDescription(IMSStepLibSection, client, 1);
        IIMSIsolationComposite IMSIsolationSTEPLIBComposite = provider.getIMSSTEPLIBComposite(client, toolkitHelper, messageHelper, IMSIsolationComposite, form.getForm());
        IMSStepLibSection.setClient((Control)client);
        IMSIsolationSTEPLIBComposite.addListener(listener);
        if (profile instanceof DebugProfileIMS) {
            IMSIsolationSTEPLIBComposite.initFromProfile((DebugProfileIMS)profile);
        }
        return new IMSISOProfileStatus(IMSIsolationComposite, IMSIsolationSTEPLIBComposite, connectionStatus);
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(API_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(API_SETTINGS);
        }
        return section;
    }

    public static void setTooltip(Control c, String tooltip, FormToolkit toolkit) {
        FormToolkitHelper helper = new FormToolkitHelper(toolkit);
        helper.setTooltip(c, tooltip);
    }

    private static class CICSDebugProfileStatus
    implements ICICSDebugProfileStatus,
    ModifyListener,
    IDebugProfileUpdateListener {
        private Validator fValidator;
        private MessageManagerHelper fMessageHelper;
        private IDebugProfileConnectionStatus fStatus;
        IDebugProfileUpdateListener fListener;
        Text fTransaction;
        Text fUserIdText;
        Text fSYSIDText;
        Text fNetNameText;
        Text fIpText;
        Text fTermIDText;
        String fTransactionName = null;
        DebugProfileDTCN.AdditionalCICSFilters fFilters = new DebugProfileDTCN.AdditionalCICSFilters(null, null, null, null, null);

        private CICSDebugProfileStatus(IManagedForm form, IDebugProfileUpdateListener listener, String transaction, IAdditionalCICSFilters filters, IDebugProfileConnectionStatus status) {
            this.fListener = listener;
            this.fTransactionName = transaction;
            if (filters instanceof DebugProfileDTCN.AdditionalCICSFilters) {
                this.fFilters = (DebugProfileDTCN.AdditionalCICSFilters)filters;
            }
            this.fMessageHelper = new MessageManagerHelper(form.getMessageManager());
            this.fValidator = new Validator(this.fMessageHelper);
            this.fStatus = status;
            if (this.fStatus instanceof DebugProfileConnectionStatus) {
                ((DebugProfileConnectionStatus)this.fStatus).fListener.add(this);
            }
        }

        private void initialize(Control control) {
            if (control instanceof Text) {
                ((Text)control).addModifyListener((ModifyListener)this);
                if (control == this.fTransaction && this.fTransactionName != null) {
                    this.fTransaction.setText(this.fTransactionName);
                } else if (control == this.fUserIdText && this.fFilters.getUserID() != null) {
                    this.fUserIdText.setText(this.fFilters.getUserID());
                } else if (control == this.fSYSIDText && this.fFilters.getCICSSysID() != null) {
                    this.fSYSIDText.setText(this.fFilters.getCICSSysID());
                } else if (control == this.fNetNameText && this.fFilters.getNetName() != null) {
                    this.fNetNameText.setText(this.fFilters.getNetName());
                } else if (control == this.fIpText && this.fFilters.getIP() != null) {
                    this.fIpText.setText(this.fFilters.getIP());
                } else if (control == this.fTermIDText && this.fFilters.getTerminalID() != null) {
                    this.fTermIDText.setText(this.fFilters.getTerminalID());
                }
            }
        }

        public void modifyText(ModifyEvent arg0) {
            this.updateStatus();
        }

        private void updateStatus() {
            DTCNForceSettings settings;
            this.fTransactionName = this.fTransaction != null ? this.fTransaction.getText().trim() : "";
            String userID = this.fUserIdText != null ? this.fUserIdText.getText().trim() : null;
            String netName = this.fNetNameText != null ? this.fNetNameText.getText().trim() : null;
            String ip = this.fIpText != null ? this.fIpText.getText().trim() : null;
            String cicsSysID = this.fSYSIDText != null ? this.fSYSIDText.getText().trim() : null;
            String terminalID = this.fTermIDText != null ? this.fTermIDText.getText().trim() : null;
            this.fFilters = new DebugProfileDTCN.AdditionalCICSFilters(userID, netName, ip, cicsSysID, terminalID);
            if (this.fStatus != null && (settings = DebugProfileUIUtils.getDTCNFORCESettings(this.fStatus)) != null) {
                this.fValidator.validateDTCNFORCE(this.fTransaction, this.fUserIdText, this.fNetNameText, this.fIpText, this.fTermIDText, null, settings, true);
            }
            if (this.fListener != null) {
                this.fListener.controlsUpdated();
            }
        }

        @Override
        public String getTransaction() {
            return this.fTransactionName;
        }

        @Override
        public IAdditionalCICSFilters getFilters() {
            return this.fFilters;
        }

        @Override
        public boolean isValid() {
            return !(this.fIpText != null && this.fMessageHelper.hasErrorMessage((Control)this.fIpText) || this.fNetNameText != null && this.fMessageHelper.hasErrorMessage((Control)this.fNetNameText) || this.fTransaction != null && this.fMessageHelper.hasErrorMessage((Control)this.fTransaction) || this.fSYSIDText != null && this.fMessageHelper.hasErrorMessage((Control)this.fSYSIDText) || this.fUserIdText != null && this.fMessageHelper.hasErrorMessage((Control)this.fUserIdText) || this.fTermIDText != null && this.fMessageHelper.hasErrorMessage((Control)this.fTermIDText));
        }

        public void setEnabled(Text control, boolean enabled) {
            if (control != null) {
                control.setEnabled(enabled);
                Object label = control.getData("outlineWidget");
                if (label instanceof Label) {
                    ((Label)label).setEnabled(enabled);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.setEnabled(this.fIpText, enabled);
            this.setEnabled(this.fNetNameText, enabled);
            this.setEnabled(this.fTransaction, enabled);
            this.setEnabled(this.fSYSIDText, enabled);
            this.setEnabled(this.fUserIdText, enabled);
            this.setEnabled(this.fTermIDText, enabled);
            this.updateStatus();
        }

        @Override
        public void controlsUpdated() {
            this.setEnabled(this.fStatus != null && this.fStatus.getRegionName() != null && !this.fStatus.getRegionName().isEmpty());
        }
    }

    public static enum ConnectionMode {
        CICS,
        NON_CICS,
        IMS_ISO;

    }

    private static final class DebugProfileConnectionStatus
    implements IDebugProfileConnectionStatus,
    SelectionListener,
    ModifyListener,
    IRegionHandler,
    ICheckStateListener {
        private IManagedForm fForm;
        private CCombo fConnectionCombo;
        private String fConnectionName = null;
        private Button fConnectionButton;
        private CCombo fRegionCombo;
        private Text fDBRMText;
        private String fDBRMvalue = "";
        private Button fDBRMTextBrowseButton;
        private String fRegionName = null;
        private MessageManagerHelper fMessageHelper;
        private FormToolkitHelper fToolkitHelper;
        private Validator fValidator;
        private Set<IDebugProfileUpdateListener> fListener = new HashSet<IDebugProfileUpdateListener>();
        private RSEEventListener fRSEEventListener;
        private String fDefaultConnectionName;
        private String fDefaultRegion;
        private ConnectionMode fMode;
        public DebugProfileCheckboxFilteredTree fProfileTree;
        private DebugProfile fProfile;
        private boolean fDeferValidation;

        DebugProfileConnectionStatus(ConnectionMode mode, IManagedForm form, IDebugProfileUpdateListener listener, String connectionName, String region, boolean deferValidation) {
            this.fMode = mode;
            this.fForm = form;
            this.fDeferValidation = deferValidation;
            if (listener != null) {
                this.fListener.add(listener);
            }
            this.fToolkitHelper = new FormToolkitHelper(form.getToolkit());
            this.fMessageHelper = new MessageManagerHelper(form.getMessageManager());
            this.fValidator = new Validator(this.fMessageHelper);
            this.fDefaultConnectionName = connectionName;
            if (this.fDefaultConnectionName == null) {
                IDialogSettings settings = DebugProfileUIUtils.getDialogSettings();
                this.fDefaultConnectionName = settings.get(DebugProfileUIUtils.API_PREV_CONNECTION);
            }
            this.fDefaultRegion = region;
            this.fRSEEventListener = new RSEEventListener(){

                @Override
                public void handleEvent(final Connection source, int eventType, String oldName) {
                    if (fConnectionCombo != null) {
                        if (fConnectionCombo.isDisposed()) {
                            DebugProfileRSEUtils.getInstance().removeRSEEventListener(fRSEEventListener);
                        } else {
                            switch (eventType) {
                                case 0: {
                                    fConnectionCombo.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            String host = source.getConnectionName();
                                            fConnectionCombo.add(host);
                                            fConnectionCombo.setText(host);
                                            this.validateConnection();
                                            this.updateRegions();
                                            this.updateStatus();
                                        }
                                    });
                                    break;
                                }
                            }
                        }
                    }
                }
            };
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget == this.fConnectionCombo) {
                this.validateConnection();
                this.updateRegions();
                this.updateStatus();
            } else if (event.widget == this.fRegionCombo) {
                this.validateRegion();
                this.updateStatus();
            } else if (event.widget == this.fConnectionButton) {
                this.fToolkitHelper.addNewConnection(this.fForm.getForm().getShell());
                this.updateStatus();
            } else if (event.widget == this.fDBRMTextBrowseButton) {
                Object member;
                RSESelectRemoteFolderDialog d = new RSESelectRemoteFolderDialog(this.fDBRMTextBrowseButton.getShell(), true, false, true, false, false);
                IZOSSystemImage h = DebugLaunchUtils.getConnection((String)this.fConnectionCombo.getText());
                d.addViewerFilter((ViewerFilter)new HostFilter(RemoteUtil.getHost((IZOSSystemImage)h)));
                d.setAllowFolderSelection(true);
                d.setMultipleSelectionMode(false);
                if (d.open() == 0 && (member = d.getOutputObject()) instanceof MVSFileResource) {
                    String dsn;
                    this.fDBRMvalue = dsn = DebugLaunchUIUtils.convertToDatasetName((String)((MVSFileResource)member).getAbsolutePath());
                    this.fDBRMText.setText(dsn);
                }
            }
        }

        private void validateConnection() {
            if (this.fDeferValidation) {
                return;
            }
            if (!this.fConnectionCombo.isEnabled()) {
                return;
            }
            if (this.fConnectionCombo.getText().trim().isEmpty()) {
                this.fValidator.updateMessage(this.fConnectionCombo, ProfileMessages.CRRDG9102, "error");
            } else {
                final String connectionName = this.fConnectionCombo.getText();
                Job j = new Job("Ensure Connection"){

                    protected IStatus run(IProgressMonitor arg0) {
                        this.setFormBusy(true);
                        try {
                            final Connection connection = ConnectionUtilities.getConnection((String)connectionName, (boolean)true);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (fConnectionCombo.isDisposed()) {
                                        return;
                                    }
                                    fValidator.clearMessages(fConnectionCombo);
                                    if (connection == null) {
                                        fValidator.updateMessage(fConnectionCombo, ProfileMessages.CRRDG9113, "error");
                                    } else if (!connection.isConnected()) {
                                        fValidator.updateMessage(fConnectionCombo, NLS.bind((String)ProfileMessages.CRRDG9111, (Object)connection.getConnectionName()), "info");
                                    } else if (!connection.isRecordingPlaybackSupported()) {
                                        fValidator.updateMessage(fConnectionCombo, NLS.bind((String)ProfileMessages.CRRDG9172, (Object[])new Object[]{1.5, connection.getAPIVersion()}), "error");
                                    } else if (fMode == ConnectionMode.IMS_ISO) {
                                        try {
                                            connection.checkIMSIsoConnection();
                                        }
                                        catch (Exception e) {
                                            if (!e.getMessage().startsWith("CRRDG") && !e.getMessage().startsWith("EQA")) {
                                                LogUtils.log((Throwable)e);
                                            }
                                            fValidator.updateMessage(fConnectionCombo, e.getMessage(), "error");
                                        }
                                    }
                                    if (fProfileTree != null) {
                                        fValidator.clearMessages(fProfileTree.getParent());
                                        fProfileTree.setConnection(fConnectionCombo.getText());
                                        this.validateProfileTree();
                                    }
                                    this.updateStatus();
                                }
                            });
                        }
                        catch (Throwable t) {
                            Activator.log(t);
                        }
                        this.setFormBusy(false);
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return family.equals(connectionName);
                    }
                };
                Job[] currentConnectionJobs = Job.getJobManager().find((Object)connectionName);
                if (currentConnectionJobs == null || currentConnectionJobs.length == 0) {
                    j.setSystem(true);
                    j.schedule();
                }
            }
        }

        private void setFormBusy(final boolean busy) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!fForm.getForm().isDisposed()) {
                        fForm.getForm().setBusy(busy);
                        fForm.getForm().setEnabled(!busy);
                    }
                }
            });
        }

        private void updateConnections() {
            if (this.fConnectionCombo != null && !this.fConnectionCombo.isDisposed()) {
                DebugProfileRSEUtils.getInstance().addRSEEventListener(this.fRSEEventListener);
                DebugProfileEditorHelper.initConnection(this.fConnectionCombo, this.fDefaultConnectionName);
                this.fDefaultConnectionName = null;
                this.fConnectionCombo.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent arg0) {
                        DebugProfileRSEUtils.getInstance().removeRSEEventListener(fRSEEventListener);
                    }
                });
                if (this.fProfileTree != null) {
                    this.fProfileTree.setConnection(this.fConnectionCombo.getText());
                    ((CheckboxTreeViewer)this.fProfileTree.getViewer()).addCheckStateListener((ICheckStateListener)this);
                    this.validateProfileTree();
                }
            }
        }

        private void updateRegions() {
            if (this.fRegionCombo != null && this.fRegionCombo.isEnabled() && this.fConnectionCombo != null && this.fConnectionCombo.isEnabled()) {
                this.fToolkitHelper.getConnectionUpdateRegion(true, this.fConnectionCombo.getText(), true, this.fForm.getForm(), this, false);
            }
        }

        private void updateStatus() {
            if (this.fConnectionCombo != null) {
                this.fConnectionName = this.fConnectionCombo.getText().trim().isEmpty() ? null : this.fConnectionCombo.getText();
                IDialogSettings settings = DebugProfileUIUtils.getDialogSettings();
                settings.put(DebugProfileUIUtils.API_PREV_CONNECTION, this.fConnectionName);
            }
            if (this.fRegionCombo != null) {
                this.fRegionName = this.fRegionCombo.getText().trim().isEmpty() ? null : this.fRegionCombo.getText();
            }
            for (IDebugProfileUpdateListener listener : this.fListener) {
                listener.controlsUpdated();
            }
        }

        @Override
        public void setRegionComboException(APIServerException exception) {
            if (!this.fRegionCombo.isDisposed()) {
                this.fToolkitHelper.setRegionComboException(exception, this.fMessageHelper, this.fRegionCombo);
            }
        }

        @Override
        public void updateRegionLocation(final Connection c, final String[] regions) {
            if (this.fRegionCombo != null && !this.fRegionCombo.isDisposed()) {
                this.fRegionCombo.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (fRegionCombo.isDisposed()) {
                            return;
                        }
                        if (fRegionCombo.getItemCount() > 0) {
                            fRegionCombo.removeAll();
                        }
                        if (c != null) {
                            if (c.isRecordingPlaybackSupported()) {
                                fToolkitHelper.getRegionList(c, fDefaultRegion, regions, fRegionCombo);
                                fDefaultRegion = null;
                            }
                        } else {
                            fValidator.updateMessage(fConnectionCombo, ProfileMessages.CRRDG9113, "error");
                        }
                        this.validateRegion();
                        this.updateStatus();
                    }
                });
            }
        }

        @Override
        public String getConnectionName() {
            return this.fConnectionName;
        }

        @Override
        public String getRegionName() {
            return this.fRegionName;
        }

        public DebugProfile getDebugProfile() {
            return this.fProfile;
        }

        @Override
        public boolean isValid() {
            return !(this.fConnectionCombo != null && (this.fMessageHelper.hasErrorMessage((Control)this.fConnectionCombo) || this.fMessageHelper.hasInfoMessage((Control)this.fConnectionCombo)) || this.fRegionCombo != null && this.fMessageHelper.hasErrorMessage((Control)this.fRegionCombo) || this.fDBRMText != null && this.fMessageHelper.hasErrorMessage((Control)this.fDBRMText) || this.fProfileTree != null && this.fProfileTree.getMessage() != null);
        }

        public void modifyText(ModifyEvent event) {
            if (event.widget == this.fRegionCombo) {
                this.validateRegion();
            } else if (event.widget == this.fDBRMText) {
                this.fDBRMvalue = this.fDBRMText.getText();
                this.fValidator.validateDataset(this.fConnectionCombo.getText(), this.fDBRMText);
                for (IDebugProfileUpdateListener listener : this.fListener) {
                    listener.controlsUpdated();
                }
            }
        }

        private void validateRegion() {
            if (this.fRegionCombo != null) {
                Connection c = ConnectionUtilities.getConnection((String)this.fConnectionCombo.getText(), (boolean)false);
                if (this.fValidator.validateValueSpecified(this.fRegionCombo, ProfileMessages.CRRDG9103) && c.isConnected()) {
                    this.fValidator.validateRegionCombo(this.fRegionCombo, DebugProfileEditorPage.REGION_STATE.REGION, c);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            Object label;
            if (this.fConnectionButton != null) {
                this.fConnectionButton.setEnabled(enabled);
            }
            if (this.fConnectionCombo != null) {
                this.fConnectionCombo.setEnabled(enabled);
                label = this.fConnectionCombo.getData("outlineWidget");
                if (label instanceof Label) {
                    ((Label)label).setEnabled(enabled);
                }
            }
            if (this.fRegionCombo != null) {
                this.fRegionCombo.setEnabled(enabled);
                label = this.fRegionCombo.getData("outlineWidget");
                if (label instanceof Label) {
                    ((Label)label).setEnabled(enabled);
                }
            }
            if (!this.fDeferValidation) {
                this.validateConnection();
                this.updateRegions();
                this.validateRegion();
                this.updateStatus();
            }
        }

        @Override
        public String getDBRM() {
            return this.fDBRMvalue;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.validateProfileTree();
            this.updateStatus();
        }

        private void validateProfileTree() {
            if (this.fProfileTree != null) {
                this.fProfile = this.fProfileTree.getProfile();
                if (this.fProfileTree.getMessage() == null) {
                    this.fValidator.clearMessages(this.fProfileTree.getParent());
                } else {
                    this.fValidator.updateMessage(this.fProfileTree.getParent(), this.fProfileTree.getMessage(), "error");
                }
            }
        }

        @Override
        public String getMessage() {
            if (this.fConnectionCombo != null && (this.fMessageHelper.hasErrorMessage((Control)this.fConnectionCombo) || this.fMessageHelper.hasInfoMessage((Control)this.fConnectionCombo))) {
                return null;
            }
            return this.fProfileTree == null ? null : this.fProfileTree.getMessage();
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.fDeferValidation = false;
                this.validateConnection();
                this.updateRegions();
                this.validateRegion();
            } else {
                this.fDeferValidation = true;
            }
        }
    }

    static class IMSISOProfileStatus
    implements IIMSISOProfileStatus,
    SelectionListener {
        private static final String INTERNAL_NAME = ".IMSISOProfileStatus";
        private IIMSIsolationComposite fIMSIsolationSTEPLIBComposite;
        private final DebugProfileIMS profile = new DebugProfileIMS(".IMSISOProfileStatus");
        private DebugProfileConnectionStatus fConnectionStatus;
        private IIMSIsolationComposite fIMSIsolationComposite;

        public IMSISOProfileStatus(IIMSIsolationComposite IMSIsolationComposite, IIMSIsolationComposite IMSIsolationSTEPLIBComposite, IDebugProfileConnectionStatus connectionStatus) {
            this.fIMSIsolationSTEPLIBComposite = IMSIsolationSTEPLIBComposite;
            this.fIMSIsolationComposite = IMSIsolationComposite;
            if (connectionStatus instanceof DebugProfileConnectionStatus) {
                this.fConnectionStatus = (DebugProfileConnectionStatus)connectionStatus;
                this.fConnectionStatus.fConnectionCombo.addSelectionListener((SelectionListener)this);
                this.setConnection();
            }
        }

        @Override
        public boolean isValid() {
            return this.fIMSIsolationComposite.isValid() && this.fIMSIsolationSTEPLIBComposite.isValid();
        }

        @Override
        public String getIMSID() {
            this.fIMSIsolationComposite.updateProfile(this.profile);
            return this.profile.getIMSID();
        }

        @Override
        public String getIMSJobName() {
            this.fIMSIsolationComposite.updateProfile(this.profile);
            return this.profile.getIMSJobName();
        }

        @Override
        public String getJobClass() {
            this.fIMSIsolationComposite.updateProfile(this.profile);
            return this.profile.getJobClass();
        }

        @Override
        public String[] getSTEPLIB() {
            this.fIMSIsolationSTEPLIBComposite.updateProfile(this.profile);
            return this.profile.getSTEPLIB();
        }

        @Override
        public IIMSTransaction[] getTransactions() {
            this.fIMSIsolationComposite.updateProfile(this.profile);
            return this.profile.getTransactions();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget == this.fConnectionStatus.fConnectionCombo) {
                this.setConnection();
            }
        }

        private void setConnection() {
            String connectionName = this.fConnectionStatus.fConnectionCombo.getText();
            this.fIMSIsolationComposite.setConnectionName(connectionName);
            this.fIMSIsolationSTEPLIBComposite.setConnectionName(connectionName);
            this.fIMSIsolationComposite.refresh();
            this.fIMSIsolationSTEPLIBComposite.refresh();
        }
    }
}

