/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.rsecommon;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.rsecommon.DefaultEntityResolver;
import com.ibm.debug.pdt.rsecommon.MapEditorInput;
import com.ibm.debug.pdt.rsecommon.RSECommonPlugin;
import com.ibm.debug.pdt.rsecommon.RSELabels;
import com.ibm.debug.pdt.rsecommon.RSEMessages;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RSEUtils {
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String IS_REMOTE = "is_remote";
    public static String PROFILE = "profile";
    public static String CONNECTION = "connection";
    public static String DIRECTORY = "directory";
    private static HashSet<String> fReadOnlyFiles;

    public static void openFileInEditor(File file, int lineNumber) throws CoreException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile f = workspaceRoot.getFileForLocation((IPath)new Path(file.getAbsolutePath()));
                if (f != null) {
                    IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)f);
                    if (lineNumber > 0 && part != null) {
                        IMarker locationMarker = f.createMarker("lineNumber");
                        locationMarker.setAttribute("lineNumber", lineNumber);
                        IDE.gotoMarker((IEditorPart)part, (IMarker)locationMarker);
                    }
                    return;
                }
                IEditorDescriptor descriptor = window.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                MapEditorInput editorInput = new MapEditorInput(file);
                String editorId = descriptor != null ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
                IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)editorId);
                IResource resource = ResourceUtil.getResource((IEditorInput)editorInput);
                if (resource != null && part != null && lineNumber > 0) {
                    IMarker locationMarker = resource.createMarker("lineNumber");
                    locationMarker.setAttribute("lineNumber", lineNumber);
                    IDE.gotoMarker((IEditorPart)part, (IMarker)locationMarker);
                }
                return;
            }
        } else {
            MessageDialog.openError((Shell)RSECommonPlugin.getShell(), (String)RSELabels.GenericError, (String)NLS.bind((String)RSEMessages.OpenFileError, (Object)file.getName()));
        }
    }

    public static void addRemoteReadOnlyFile(String absolutePath) {
        if (fReadOnlyFiles == null) {
            fReadOnlyFiles = new HashSet(4);
        }
        fReadOnlyFiles.add(absolutePath);
    }

    public static boolean isReadOnly(String absolutePath) {
        return fReadOnlyFiles != null && fReadOnlyFiles.contains(absolutePath);
    }

    public static void removeRemoteReadOnlyFile(String absolutePath) {
        if (fReadOnlyFiles != null) {
            fReadOnlyFiles.remove(absolutePath);
        }
    }

    public static Document parseFile(File mapFile) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = PDTCoreUtils.getSecureDocumentBuilderFactory();
        if (factory == null) {
            return null;
        }
        try {
            factory.setValidating(true);
            factory.setAttribute(SCHEMA_LANGUAGE, W3C_SCHEMA);
            factory.setAttribute(SCHEMA_SOURCE, new InputSource(RSEUtils.getSchema()));
        }
        catch (IllegalArgumentException e) {
            factory.setValidating(false);
        }
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setEntityResolver(new DefaultEntityResolver());
        docBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        Document domLayout = null;
        domLayout = docBuilder.parse(mapFile);
        return domLayout;
    }

    private static StringReader getSchema() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n").append("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n").append("<xsd:element name=\"LAYOUT\">\r\n").append("<xsd:complexType>\r\n").append("<xsd:sequence>\r\n").append("\t\t<xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\" ref=\"GROUP\"/>\r\n").append("   <xsd:element maxOccurs=\"unbounded\" minOccurs=\"1\" ref=\"FIELD\"/>\r\n").append("</xsd:sequence>\r\n").append("<xsd:attribute name=\"Header\" type=\"xsd:string\" use=\"required\"/>\r\n").append("<xsd:attribute name=\"length\" type=\"xsd:string\" use=\"required\"/>\r\n").append("</xsd:complexType>\r\n").append("</xsd:element>\r\n").append("<xsd:element name=\"GROUP\">\r\n").append("<xsd:complexType>\r\n").append("<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\r\n").append("</xsd:complexType>\r\n").append("</xsd:element>\r\n").append("<xsd:element name=\"FIELD\">\r\n").append("<xsd:complexType>\r\n").append("<xsd:sequence>\r\n").append("   <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\" ref=\"FIELD\"/>\r\n").append("</xsd:sequence>\r\n").append("<xsd:attribute name=\"Header\" type=\"xsd:string\" use=\"required\"/>\r\n").append("\r\n").append("<xsd:attribute name=\"Type\" use=\"required\">\r\n").append("   <xsd:simpleType>\r\n").append("<xsd:restriction base=\"xsd:string\">\r\n").append("<xsd:enumeration value=\"16_BIT_INT\"/>\r\n").append("<xsd:enumeration value=\"16_BIT_UINT\"/>\r\n").append("<xsd:enumeration value=\"16_BIT_HINT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_INT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_UINT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_HINT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_FLOAT\"/>\r\n").append("<xsd:enumeration value=\"64_BIT_INT\"/>\r\n").append("<xsd:enumeration value=\"64_BIT_FLOAT\"/>\r\n").append("<xsd:enumeration value=\"CHARACTER\"/>\r\n").append("<xsd:enumeration value=\"HEX\"/>\r\n").append("<xsd:enumeration value=\"ASCII\"/>\r\n").append("<xsd:enumeration value=\"EBCDIC\"/>\r\n").append("<xsd:enumeration value=\"STRUCTURE\"/>\r\n").append("<xsd:enumeration value=\"PADDING\"/>\r\n").append("<xsd:enumeration value=\"BIT\"/>\r\n").append("<xsd:enumeration value=\"BITMASK\"/>\r\n").append("<xsd:enumeration value=\"MAP\"/>\r\n").append("       </xsd:restriction>\r\n").append("   </xsd:simpleType>\r\n").append("</xsd:attribute>\r\n").append("<xsd:attribute name=\"length\" type=\"xsd:nonNegativeInteger\" use=\"required\"/>\r\n").append("<xsd:attribute name=\"layout\" type=\"xsd:string\"  use=\"optional\"/>\r\n").append("<xsd:attribute name=\"filename\"  type=\"xsd:string\" use=\"optional\"/>\r\n").append("<xsd:attribute name=\"Groups\" type=\"xsd:string\" use=\"optional\"/>\r\n").append("</xsd:complexType>\r\n").append("</xsd:element>\r\n").append("</xsd:schema>");
        return new StringReader(buffer.toString());
    }
}

