/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.rest.client;

import com.ibm.debug.pdt.profile.internal.cc.CodeCoverageUtils;
import com.ibm.debug.pdt.profile.internal.cc.ICCStartupKeyGenerator;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTCN_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTSP_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.IDebugProfileRestClientConstants;
import java.util.List;
import java.util.UUID;

public abstract class DebugProfileRestClientV1_JSON
implements IDebugProfileRestClientConstants {
    public static String getValue(String fieldValue) {
        if (fieldValue == null || fieldValue.trim().isEmpty()) {
            return null;
        }
        return fieldValue;
    }

    public static void synchronize(boolean push, DebugProfile profile, DebugProfileRestClientV1_JSON json) throws Exception {
        boolean activate = DebugProfileRestClientV1_JSON.isActivated(json);
        if (activate) {
            int activationMode = DebugProfileRestClientV1_JSON.isCCEnabled(json) ? 2 : 1;
            profile.synchronize(push, activationMode);
        }
    }

    private static boolean isActivated(DebugProfileRestClientV1_JSON json) {
        return json instanceof DebugProfileRestClientV1_DTCN_JSON ? "A".equals(((DebugProfileRestClientV1_DTCN_JSON)json).activation) : true;
    }

    private static boolean isCCEnabled(DebugProfileRestClientV1_JSON json) {
        String startupKey = DebugProfileUtils.getStartupKeyFromENVAR(DebugProfileRestClientV1_JSON.getLEOptions(json));
        ICCStartupKeyGenerator generator = CodeCoverageUtils.getCodeCoverageStartupKeyGenerator();
        return startupKey != null && generator != null && generator.isCCStartupKey(startupKey);
    }

    private static String getLEOptions(DebugProfileRestClientV1_JSON json) {
        return json instanceof DebugProfileRestClientV1_DTCN_JSON ? ((DebugProfileRestClientV1_DTCN_JSON)json).otheropts : ((DebugProfileRestClientV1_DTSP_JSON)json).envar;
    }

    protected static UUID getUUID(String uuid) {
        if (uuid != null && !uuid.isEmpty()) {
            return UUID.fromString(uuid);
        }
        return null;
    }

    protected static DebugProfile.CodeCoverageOptions getCCOptions(String otheropts) {
        String startupKey = DebugProfileUtils.getStartupKeyFromENVAR(otheropts);
        ICCStartupKeyGenerator generator = CodeCoverageUtils.getCodeCoverageStartupKeyGenerator();
        return startupKey != null && generator != null ? generator.getCodeCoverageOptions(startupKey) : null;
    }

    protected static String getDBRMOptions(String leoptions) {
        return DebugProfileUtils.getDBRMFromENVAR(leoptions);
    }

    protected static void setAdvancedConnectionOptions(DebugProfile profile, Connection connection, String sesstype, String sessaddr, String sessport, String sesscert) {
        String userID = null;
        String ip = null;
        String port = null;
        String cert = sesscert;
        Boolean isCertEnabled = false;
        if (connection.isUsingDBM()) {
            if (sesstype == null || !sesstype.equals("DBMDT")) {
                ip = sessaddr;
                port = sessport;
                if (connection.isAuthCertSupported()) {
                    isCertEnabled = true;
                }
            } else if (!connection.getUserId().equals(sessaddr)) {
                userID = sessaddr;
            }
        } else {
            if (sesstype != null && !sesstype.equals("TCP")) {
                userID = sessaddr;
            } else {
                ip = sessaddr;
                port = sessport;
            }
            if (connection.isConnected() && connection.isAuthCertSupported()) {
                isCertEnabled = true;
            }
        }
        if (userID != null || ip != null || port != null) {
            DebugProfile.AdvancedConnectionOptions advancedConnectionOptions = new DebugProfile.AdvancedConnectionOptions(userID, ip, port, cert, isCertEnabled);
            profile.setAdvancedConnectionOptions(advancedConnectionOptions);
        }
    }

    protected static void setZUnitOptions(DebugProfile profile, String bzucfgfile, String bzuplayfile) {
        if (bzucfgfile != null || bzuplayfile != null) {
            profile.configurezUnit(bzuplayfile, bzucfgfile);
        }
    }

    protected static void setCodeCoverageOptions(DebugProfile profile, String otheropts) {
        DebugProfile.CodeCoverageOptions ccOptions = DebugProfileRestClientV1_JSON.getCCOptions(otheropts);
        if (ccOptions != null) {
            profile.setCodeCoverageOptions(ccOptions);
        }
    }

    protected static void setDBRM(DebugProfile profile, String leoptions) {
        String dbrm = DebugProfileRestClientV1_JSON.getDBRMOptions(leoptions);
        if (dbrm != null) {
            profile.setDBRM(dbrm);
        }
    }

    protected static void setDebugOptions(DebugProfile profile, String trigger, String level, String promptlevel, String commandfile, String eqaoptsfile, String otheropts, String preferencefile) {
        DebugProfile.DebuggerOptions debuggerOptions = new DebugProfile.DebuggerOptions(trigger, level, promptlevel);
        if (commandfile != null) {
            debuggerOptions.setCommandDataSet(commandfile);
        }
        if (eqaoptsfile != null) {
            debuggerOptions.setEqaOptsFile(eqaoptsfile);
        }
        if (otheropts != null && (otheropts = DebugProfileUtils.removeStartupKey(otheropts)) != null && !otheropts.isEmpty()) {
            debuggerOptions.setLanguageEnvironmentOptions(otheropts);
        }
        if (preferencefile != null) {
            debuggerOptions.setPreferenceDataSet(preferencefile);
        }
        profile.setDebuggerOptions(debuggerOptions);
    }

    protected static void setLoadModules(DebugProfile profile, List<DebugProfileRestClientV1_DTCN_JSON.LoadModuleJSON> program) {
        if (program != null) {
            for (DebugProfileRestClientV1_DTCN_JSON.LoadModuleJSON lodmod : program) {
                profile.addLoadModulePair(lodmod.loadname, lodmod.pgmname);
            }
        }
    }

    protected static String fixDataset(String dataset) {
        if (dataset == null || dataset.isEmpty() || dataset.startsWith("-")) {
            return dataset;
        }
        if (dataset.equals("*")) {
            return null;
        }
        return "-" + dataset;
    }

    protected static String buildEnvar(String ... envars) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = envars;
        int n = envars.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e != null) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(e);
            }
            ++n2;
        }
        return sb.toString();
    }
}

