/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.rest.client;

import com.ibm.debug.pdt.profile.internal.cc.CodeCoverageUtils;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTCN_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_JSON;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class DebugProfileRestClientV1_DTSP_JSON
extends DebugProfileRestClientV1_JSON
implements IDebugProfileConstants {
    protected String profileid;
    protected List<DebugProfileRestClientV1_DTCN_JSON.LoadModuleJSON> program;
    protected String jobname;
    protected String stepname;
    protected String imssubsystemid;
    protected String[] imstransactionid;
    protected String trigger;
    protected String level;
    protected String sesstype;
    protected String sessaddr;
    protected String sessport;
    protected String sesscert;
    protected String commandfile;
    protected String preferencefile;
    protected String promptlevel;
    protected String otheropts;
    protected String eqaoptsfile;
    protected String envar;
    protected String bzucfgfile;
    protected String bzuplayfile;
    protected String uuid;

    public DebugProfileRestClientV1_DTSP_JSON(DebugProfileDTSP localProfile) {
        this.uuid = localProfile.getUUID().toString();
        List<DebugProfile.LoadModulePair> loadModules = localProfile.getLoadModulePairs();
        if (loadModules != null && !loadModules.isEmpty()) {
            this.program = new ArrayList<DebugProfileRestClientV1_DTCN_JSON.LoadModuleJSON>();
            for (DebugProfile.LoadModulePair l : loadModules) {
                this.program.add(new DebugProfileRestClientV1_DTCN_JSON.LoadModuleJSON(l.getLoadModule(), l.getCompilationUnit()));
            }
        }
        if (localProfile.getJobInfo() != null) {
            this.jobname = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getJobInfo().getJobName());
            this.stepname = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getJobInfo().getStepName());
        }
        if (localProfile.getIMSOptions() != null) {
            this.imssubsystemid = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getIMSOptions().getSubsystemID());
            if (DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getIMSOptions().getTransactionID()) != null) {
                this.imstransactionid = new String[]{DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getIMSOptions().getTransactionID())};
            }
        }
        String zunitEnvar = null;
        if (localProfile.getDebuggerOptions() != null) {
            this.trigger = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getDebuggerOptions().getTestLevel());
            this.level = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getDebuggerOptions().getErrorLevel());
            this.commandfile = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getDebuggerOptions().getCommandDataSet());
            if (this.commandfile != null && !this.commandfile.startsWith("VADSCP")) {
                this.commandfile = DebugProfileRestClientV1_DTSP_JSON.fixDataset(this.commandfile);
            }
            this.preferencefile = DebugProfileRestClientV1_DTSP_JSON.fixDataset(DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getDebuggerOptions().getPreferenceDataSet()));
            this.promptlevel = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getDebuggerOptions().getPromptLevel());
            this.eqaoptsfile = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getDebuggerOptions().getEqaOptsFile());
            String ccEnvar = null;
            if (localProfile.getMode() == 2) {
                ccEnvar = localProfile.getCodeCoverageStartupKey() != null ? localProfile.getCodeCoverageStartupKey() : CodeCoverageUtils.generateStartupKey(localProfile);
            }
            switch (localProfile.getMode()) {
                case 3: 
                case 6: {
                    zunitEnvar = "EQA_DTR_MODE=Y";
                    break;
                }
                case 4: 
                case 7: {
                    zunitEnvar = "EQA_DTR_MODE=C";
                    break;
                }
            }
            Object dbrmEnvar = localProfile.getDBRM();
            if (dbrmEnvar != null && zunitEnvar != null) {
                dbrmEnvar = "EQA_DBG_DBRM=" + (String)dbrmEnvar;
            }
            String recEnvar = null;
            if (localProfile.getCollectorPort() >= 0) {
                recEnvar = "EQA_STARTUP_KEY=REC";
            }
            this.envar = DebugProfileRestClientV1_DTSP_JSON.buildEnvar(DebugProfileUtils.quote(zunitEnvar), DebugProfileUtils.quote((String)dbrmEnvar), DebugProfileUtils.quote(ccEnvar), DebugProfileUtils.quote(recEnvar));
        }
        if (localProfile.getZUnitOptions() != null && zunitEnvar != null) {
            this.bzuplayfile = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getZUnitOptions().getRecordingFile());
            this.bzucfgfile = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getZUnitOptions().getConfigFile());
        }
        if (localProfile.getMode() == 4 || localProfile.getMode() == 3) {
            int collectorPort = localProfile.getCollectorPort();
            if (collectorPort < 0) {
                this.sesstype = "MFI";
                this.sessaddr = null;
                this.sessport = null;
                this.sesscert = null;
            } else {
                this.sesstype = "RECORD";
                this.sessaddr = InetAddress.getLoopbackAddress().getHostAddress();
                this.sessport = Integer.toString(collectorPort);
                this.sesscert = null;
            }
        } else {
            Connection c;
            if (localProfile.getAdvancedConnectionOptions() != null) {
                String userField = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getAdvancedConnectionOptions().getUserID());
                String ipField = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getAdvancedConnectionOptions().getIP());
                String portField = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getAdvancedConnectionOptions().getPort());
                if (userField != null && !userField.isEmpty()) {
                    this.sesstype = "DBMDT";
                    this.sessaddr = userField;
                    this.sessport = null;
                } else if (ipField != null && !ipField.isEmpty() || portField != null && !portField.isEmpty()) {
                    this.sesstype = "TCPIP";
                    this.sessaddr = ipField;
                    this.sessport = portField;
                }
                String certField = DebugProfileRestClientV1_DTSP_JSON.getValue(localProfile.getAdvancedConnectionOptions().getCertificate());
                this.sesscert = certField != null && !certField.isEmpty() && localProfile.getAdvancedConnectionOptions().isCertificateEnabled() != false ? certField : null;
            }
            if (this.sesstype == null && (c = ConnectionUtilities.getConnection(localProfile.getConnectionName(), false)) != null) {
                if (c.isUsingDBM()) {
                    c.getLocalClientPort();
                    this.sesstype = "DBMDT";
                    this.sessaddr = c.getUserId();
                    this.sessport = null;
                } else {
                    this.sesstype = "TCPIP";
                    this.sessaddr = c.getLocalClientIP();
                    this.sessport = c.getLocalClientPort();
                }
            }
        }
    }

    public static DebugProfileDTSP getProfile(DebugProfileRestClientV1_DTSP_JSON json, Connection connection) {
        DebugProfileDTSP profile = new DebugProfileDTSP(DebugProfileRestClientV1_DTSP_JSON.getUUID(json.uuid));
        profile.setConnectionName(connection.getConnectionName());
        if (json.imssubsystemid != null && json.imstransactionid != null) {
            String transaction = json.imstransactionid.length > 0 ? json.imstransactionid[0] : null;
            DebugProfileDTSP.IMSOptions imsOptions = new DebugProfileDTSP.IMSOptions(json.imssubsystemid, transaction);
            profile.setIMSOptions(imsOptions);
        }
        if (json.jobname != null && json.stepname != null) {
            DebugProfileDTSP.JobInfo jobInfo = new DebugProfileDTSP.JobInfo(json.jobname, json.stepname);
            profile.setJobInfo(jobInfo);
        }
        DebugProfileRestClientV1_DTSP_JSON.setLoadModules(profile, json.program);
        DebugProfileRestClientV1_DTSP_JSON.setDebugOptions(profile, json.trigger, json.level, json.promptlevel, json.commandfile, json.eqaoptsfile, json.otheropts, json.preferencefile);
        DebugProfileRestClientV1_DTSP_JSON.setCodeCoverageOptions(profile, json.envar);
        DebugProfileRestClientV1_DTSP_JSON.setDBRM(profile, json.envar);
        DebugProfileRestClientV1_DTSP_JSON.setAdvancedConnectionOptions(profile, connection, json.sesstype, json.sessaddr, json.sessport, json.sesscert);
        return profile;
    }
}

