/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.configuration.ExtendedSupportUtillities;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.persistence.DebugProfilePersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;

public class DebugProfileRoot
implements IDebugProfileConstants {
    private static DebugProfileRoot fInstance = new DebugProfileRoot();
    private HashMap<String, DebugProfile> fDebugProfiles = new HashMap();
    private ArrayList<DebugProfileEventListener> fListeners = new ArrayList();

    static {
        ExtendedSupportUtillities.profileRootStartup();
        JsonArray profileList = DebugProfilePersistence.retrieveProfileList();
        for (JsonElement jsonElement : profileList) {
            DebugProfileUtils.addLogForMigrationForIMSDepracatedFields(jsonElement.getAsJsonObject());
            DebugProfile p = DebugProfileUtils.jsonToDebugProfile(jsonElement.getAsJsonObject());
            if (p == null) continue;
            p.fState = 0;
            p.fMode = 0;
            fInstance.addDebugProfile(p);
        }
        fInstance.addProfileEventListener(new DebugProfileEventListener(){

            @Override
            public void handleEvent(DebugProfile source, int eventType) {
                if (eventType != 3) {
                    return;
                }
                Collection<DebugProfile> allProfiles = fInstance.getDebugProfiles();
                for (DebugProfile p : allProfiles) {
                    Connection c2;
                    if (!(p != source && p.getClass().equals(source.getClass()) || p != source && !p.getClass().equals(DebugProfileDTCN.class) && !source.getClass().equals(DebugProfileDTCN.class))) continue;
                    boolean implicitDeactivate = false;
                    Connection c1 = ConnectionUtilities.getConnection(source.getConnectionName(), false);
                    if (c1 == (c2 = ConnectionUtilities.getConnection(p.getConnectionName(), false))) {
                        implicitDeactivate = true;
                    } else if (c1 != null && c2 != null && c1.getHostName() != null && c1.getHostName().equalsIgnoreCase(c2.getHostName()) && c1.getUserId() != null && c1.getUserId().equals(c2.getUserId())) {
                        implicitDeactivate = true;
                    }
                    if (source instanceof DebugProfileDTCN) {
                        DebugProfileDTCN dtcnSource = (DebugProfileDTCN)source;
                        if (c1.isConnected() && c1.getErrorState() != Connection.ERROR_STATE.NONE && dtcnSource.getPort() != ((DebugProfileDTCN)p).getPort() || dtcnSource.getRegion() != null && !dtcnSource.getRegion().equals(((DebugProfileDTCN)p).getRegion())) continue;
                    }
                    if (source instanceof DebugProfileDTSP && (source.isBackLevelRequired() || source.isBackLevelRequired(c1)) && (p.isBackLevelRequired() || p.isBackLevelRequired(c2)) && !((DebugProfileDTSP)source).getLocation().equals(((DebugProfileDTSP)p).getLocation())) {
                        try {
                            p.deactivate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!implicitDeactivate) continue;
                    p.fState = 2;
                    p.fMode = 0;
                    fInstance.fireProfileEvent(p, 4);
                }
            }
        });
    }

    public static boolean isDeleteProfilesRequired() {
        return Platform.getPreferencesService().getBoolean("com.ibm.debug.pdt.launch.zpicl", "DisableProfilesOnShutdown", true, null);
    }

    public static void deleteProfiles(Collection<DebugProfile> profiles) {
        for (DebugProfile p : profiles) {
            try {
                if (p.getState() != 1) continue;
                Connection c = ConnectionUtilities.getConnection(p.getConnectionName(), false);
                if (c != null && c.isConnected()) {
                    try {
                        p.deleteRemoteProfile(c);
                    }
                    catch (Exception e) {
                        try {
                            p.deleteRemoteProfile(p.getCachedConnection());
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    p.deleteRemoteProfile(p.getCachedConnection());
                }
                p.save();
            }
            catch (Exception e) {
                LogUtils.log(e);
            }
        }
    }

    private DebugProfileRoot() {
    }

    protected final void finalize() {
    }

    public static DebugProfileRoot getInstance() {
        return fInstance;
    }

    public Collection<DebugProfile> getDebugProfiles() {
        return new ArrayList<DebugProfile>(this.fDebugProfiles.values());
    }

    public synchronized void addDebugProfile(DebugProfile p) {
        this.fDebugProfiles.put(p.getName(), p);
        DebugProfilePersistence.saveProfile(p);
        if (p.getState() == 0) {
            Connection c = ConnectionUtilities.getConnection(p.getConnectionName(), false);
            p.fState = c == null || !c.isConnected() ? 3 : 2;
        }
        this.fireProfileEvent(p, 0);
    }

    public synchronized void removeDebugProfile(DebugProfile p) {
        this.fDebugProfiles.remove(p.getName());
        DebugProfilePersistence.deleteProfileByName(p.getName());
        this.fireProfileEvent(p, 1);
    }

    public synchronized void addProfileEventListener(DebugProfileEventListener l) {
        this.fListeners.add(l);
    }

    public synchronized void removeProfileEventListener(DebugProfileEventListener l) {
        this.fListeners.remove(l);
    }

    public synchronized void fireProfileEvent(DebugProfile source, int eventType) {
        Gson gson = new Gson();
        ProfilePlugin.getTrace().trace("/profileEvents", "\nEvent:" + eventType + " Profile:" + gson.toJson((Object)source));
        ProfilePlugin.getTrace().trace("/profileEvents", "\nnumber of listeners: " + this.fListeners.size());
        for (DebugProfileEventListener l : this.fListeners) {
            ProfilePlugin.getTrace().trace("/profileEvents", "\nListener about to be notified: " + String.valueOf(l));
            l.handleEvent(source, eventType);
        }
    }

    boolean isNameInUse(String name) {
        return this.fDebugProfiles.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProfile getProfileByUUID(UUID uuid) {
        if (uuid != null) {
            HashMap<String, DebugProfile> hashMap = this.fDebugProfiles;
            synchronized (hashMap) {
                for (DebugProfile profile : this.fDebugProfiles.values()) {
                    if (!profile.getUUID().equals(uuid)) continue;
                    return profile;
                }
            }
        }
        return null;
    }

    public Collection<DebugProfile> getDebugProfiles(String connectionName, boolean cics, boolean nonCics) {
        ArrayList<DebugProfile> result = new ArrayList<DebugProfile>();
        if (cics || nonCics) {
            for (DebugProfile p : DebugProfileRoot.getInstance().getDebugProfiles()) {
                if ((!nonCics || !(p instanceof DebugProfileDTSP)) && (!cics || !(p instanceof DebugProfileDTCN)) || p.getConnectionName() == null || !p.getConnectionName().equals(connectionName)) continue;
                result.add(p);
            }
        }
        return result;
    }

    public static abstract class DebugProfileEventListener {
        protected static final int CREATION = 0;
        protected static final int DELETION = 1;
        protected static final int UPDATE = 2;
        protected static final int ACTIVATION = 3;
        protected static final int DEACTIVATION = 4;

        public abstract void handleEvent(DebugProfile var1, int var2);
    }
}

