/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;

public class DebugProfileNameUtils {
    public static final String CICS_PROFILE_PREFIX = "CICS-PROFILE-";
    public static final String NON_CICS_PROFILE_PREFIX = "PROFILE-";
    public static final String IMS_PROFILE_PREFIX = "IMS-PROFILE-";
    public static final String REMOTE_PROFILE_PREFIX = "REMOTE-PROFILE-";
    private static int fCICSIndex = 1;
    private static int fNonCICSIndex = 1;
    private static int fRemoteIndex = 1;
    private static int fIMSIndex = 1;

    public static boolean isNameInUse(String name) {
        return DebugProfileRoot.getInstance().isNameInUse(name);
    }

    public static synchronized String generateNewName(String prefix) {
        if (prefix.equals(CICS_PROFILE_PREFIX)) {
            fCICSIndex = DebugProfileNameUtils.generateProfileName(prefix, fCICSIndex);
            return prefix + fCICSIndex++;
        }
        if (prefix.equals(NON_CICS_PROFILE_PREFIX)) {
            fNonCICSIndex = DebugProfileNameUtils.generateProfileName(prefix, fNonCICSIndex);
            return prefix + fNonCICSIndex++;
        }
        if (prefix.equals(REMOTE_PROFILE_PREFIX)) {
            fRemoteIndex = DebugProfileNameUtils.generateProfileName(prefix, fRemoteIndex);
            return prefix + fRemoteIndex++;
        }
        if (prefix.equals(IMS_PROFILE_PREFIX)) {
            fIMSIndex = DebugProfileNameUtils.generateProfileName(prefix, fIMSIndex);
            return prefix + fIMSIndex++;
        }
        int i = 0;
        String newName = null;
        while (DebugProfileNameUtils.isNameInUse(newName = DebugProfileNameUtils.getAdjustedPrefix(prefix + "_", ++i) + i)) {
        }
        return newName;
    }

    private static int generateProfileName(String prefix, int index) {
        while (DebugProfileNameUtils.isNameInUse(DebugProfileNameUtils.getAdjustedPrefix(prefix, index) + index)) {
            ++index;
        }
        return index;
    }

    private static String getAdjustedPrefix(String prefix, int index) {
        int indexLen = Integer.toString(index).length();
        int adjustment = prefix.length() + indexLen - 25;
        if (adjustment > 0) {
            prefix = prefix.substring(0, prefix.length() - adjustment);
        }
        return prefix;
    }
}

