/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.debug.pdt.profile.IDebugProfile;
import com.ibm.debug.pdt.profile.ProfileException;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.compatibility.BackLevelDebugProfileClient;
import com.ibm.debug.pdt.profile.internal.connection.CachedConnection;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.APIServerException;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1;
import com.ibm.debug.pdt.profile.internal.rest.client.IDebugProfileRestReturnCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpHostConnectException;
import org.eclipse.osgi.util.NLS;

public abstract class DebugProfile
implements IDebugProfileConstants,
IDebugProfileRestReturnCodes,
IDebugProfile {
    protected String fType;
    protected String fName;
    protected int fMode;
    protected int fState;
    protected String fConnectionName;
    protected String fDescription;
    protected ArrayList<LoadModulePair> fLoadModulePairs;
    protected CodeCoverageOptions fCCOptions;
    protected DebuggerOptions fDebuggerOptions;
    protected AdvancedConnectionOptions fAdvancedConnectionOptions;
    protected UUID fUUID = null;
    protected ZUnitOptions fzUnitOptions;
    protected String fDBRM = null;
    private transient CachedConnection fCachedConnection;
    private transient boolean fSkipGenericCheck = false;
    private String fCCStartupKey;
    private int fCollectorPort = -1;
    private String fOwnerId = null;

    public DebugProfile(String name) {
        this.fName = name;
        this.fLoadModulePairs = new ArrayList();
    }

    public String getName() {
        return this.fName;
    }

    public int getMode() {
        return this.fMode;
    }

    public int getState() {
        return this.fState;
    }

    public void setConnectionName(String connectionName) {
        if (!connectionName.equals(this.fConnectionName)) {
            this.fState = 0;
            this.fMode = 0;
        }
        this.fConnectionName = connectionName;
    }

    public String getConnectionName() {
        return this.fConnectionName;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void addLoadModulePair(String loadModule, String compilationUnit) {
        this.fLoadModulePairs.add(new LoadModulePair(loadModule, compilationUnit));
    }

    public List<LoadModulePair> getLoadModulePairs() {
        return new ArrayList<LoadModulePair>(this.fLoadModulePairs);
    }

    public void clearLoadModules() {
        this.fLoadModulePairs.clear();
    }

    public void setCodeCoverageOptions(CodeCoverageOptions ccOptions) {
        this.fCCOptions = ccOptions;
    }

    public CodeCoverageOptions getCodeCoverageOptions() {
        return this.fCCOptions;
    }

    public void setDebuggerOptions(DebuggerOptions debuggerOptions) {
        this.fDebuggerOptions = debuggerOptions;
    }

    public DebuggerOptions getDebuggerOptions() {
        return this.fDebuggerOptions;
    }

    public void setAdvancedConnectionOptions(AdvancedConnectionOptions advancedConnectionOptions) {
        this.fAdvancedConnectionOptions = advancedConnectionOptions;
    }

    public AdvancedConnectionOptions getAdvancedConnectionOptions() {
        return this.fAdvancedConnectionOptions;
    }

    public void save() {
        DebugProfileRoot.getInstance().addDebugProfile(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activate(int mode) throws Exception {
        block9: {
            block10: {
                if (!this.isValid()) {
                    throw new DebugProfileException(this.getValidationMessagesAsString());
                }
                if (!this.fSkipGenericCheck && !this.checkForGenericProfile()) {
                    return;
                }
                Connection connection = ConnectionUtilities.getConnection(this.getConnectionName(), true);
                if (connection == null || !connection.isConnected()) break block10;
                this.fMode = mode;
                this.fState = 4;
                this.fCachedConnection = new CachedConnection(connection);
                if (BackLevelDebugProfileClient.isBackLevelSupported() && (this.isBackLevelRequired() || this.isBackLevelRequired(connection))) {
                    this.doBackLevelProfileActivation(connection, mode);
                    break block9;
                } else {
                    HttpMessage[] results = new HttpMessage[2];
                    try {
                        results = this.doProfileActivation(connection);
                        HttpRequestBase request = (HttpRequestBase)results[0];
                        HttpResponse response = (HttpResponse)results[1];
                        String responseMessage = DebugProfileRestClientV1.getReadableResponseString(response);
                        if (response.getStatusLine().getStatusCode() != 201) {
                            this.resetStateUnknown();
                            if (!this.handleActivateResponse(response.getStatusLine().getStatusCode(), responseMessage)) {
                                throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), "http" + response.getStatusLine().getStatusCode() + " " + responseMessage);
                            }
                        }
                        break block9;
                    }
                    catch (HttpHostConnectException hhce) {
                        HttpRequestBase request = (HttpRequestBase)results[0];
                        this.resetStateUnknown();
                        if (request == null) {
                            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
                        }
                        throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), hhce.getMessage());
                    }
                }
            }
            this.resetStateUnknown();
            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
        }
        this.sendActivationEvent();
    }

    protected void sendActivationEvent() {
        this.fState = 1;
        DebugProfileRoot.getInstance().fireProfileEvent(this, 3);
    }

    protected boolean handleActivateResponse(int statusCode, String responseMessage) throws DebugProfileException {
        return false;
    }

    public void resetStateUnknown() {
        this.fMode = 0;
        this.fState = 0;
        DebugProfileRoot.getInstance().fireProfileEvent(this, 2);
    }

    public boolean isBackLevelRequired(Connection connection) {
        return DebugProfile.isBackLevelRequired(connection, this instanceof DebugProfileDTCN);
    }

    public static boolean isBackLevelRequired(Connection connection, boolean cics) {
        return connection.getErrorState().equals((Object)Connection.ERROR_STATE.BACK_LEVEL) || connection.getErrorState().equals((Object)Connection.ERROR_STATE.CLIENT_ERROR) || connection.getErrorState().equals((Object)Connection.ERROR_STATE.HOST_ERROR) || !cics && connection.getErrorState().equals((Object)Connection.ERROR_STATE.CICS_ONLY);
    }

    private String getValidationMessagesAsString() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.getValidationIssues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(NEWLINE);
            }
            sb.append(msg);
            ++n2;
        }
        return sb.toString();
    }

    protected abstract boolean isBackLevelRequired();

    protected abstract HttpMessage[] doProfileActivation(Connection var1) throws Exception;

    protected abstract void doBackLevelProfileActivation(Connection var1, int var2) throws Exception;

    public void deactivate() throws Exception {
        block12: {
            if (!this.isValid()) {
                throw new DebugProfileException(this.getValidationMessagesAsString());
            }
            if (this.fState == 1) {
                try {
                    Connection connection = ConnectionUtilities.getConnection(this.getConnectionName(), true);
                    if (connection != null && connection.isConnected()) {
                        if (this.isBackLevelRequired() || this.isBackLevelRequired(connection)) {
                            this.doBackLevelProfileDelete(connection);
                        } else {
                            HttpMessage[] results = new HttpMessage[2];
                            try {
                                results = this.doProfileDelete(connection);
                                HttpRequestBase request = (HttpRequestBase)results[0];
                                HttpResponse response = (HttpResponse)results[1];
                                if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 404) {
                                    this.resetStateUnknown();
                                    throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), "http" + response.getStatusLine().getStatusCode() + " " + DebugProfileRestClientV1.getReadableResponseString(response));
                                }
                            }
                            catch (HttpHostConnectException hhce) {
                                HttpRequestBase request = (HttpRequestBase)results[0];
                                this.resetStateUnknown();
                                if (request == null) {
                                    throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
                                }
                                throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), hhce.getMessage());
                            }
                        }
                        this.fState = 2;
                        this.fMode = 0;
                        break block12;
                    }
                    this.resetStateUnknown();
                    throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
                }
                finally {
                    DebugProfileRoot.getInstance().fireProfileEvent(this, 4);
                }
            }
        }
    }

    protected abstract void doBackLevelProfileDelete(Connection var1) throws Exception;

    protected abstract HttpMessage[] doProfileDelete(Connection var1) throws Exception;

    public void delete() throws Exception {
        DebugProfileRoot.getInstance().removeDebugProfile(this);
        if (this.getConnectionName() != null && !this.getConnectionName().isEmpty()) {
            if (!this.isValid()) {
                throw new DebugProfileException(this.getValidationMessagesAsString());
            }
            Connection connection = ConnectionUtilities.getConnection(this.fConnectionName, false);
            if (connection != null && connection.isConnected()) {
                if (this.isBackLevelRequired() || this.isBackLevelRequired(connection)) {
                    this.doBackLevelProfileDelete(connection);
                } else {
                    HttpMessage[] results = new HttpMessage[2];
                    try {
                        results = this.doProfileDelete(connection);
                        HttpRequestBase request = (HttpRequestBase)results[0];
                        HttpResponse response = (HttpResponse)results[1];
                        if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 404) {
                            throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), "http" + response.getStatusLine().getStatusCode() + " " + DebugProfileRestClientV1.getReadableResponseString(response));
                        }
                    }
                    catch (HttpHostConnectException hhce) {
                        HttpRequestBase request = (HttpRequestBase)results[0];
                        if (request == null) {
                            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
                        }
                        throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), hhce.getMessage());
                    }
                }
            }
        }
    }

    public void deleteRemoteProfile(Connection connection) throws Exception {
        DebugProfileRoot.getInstance().fireProfileEvent(this, 1);
        if (connection != null) {
            this.resetStateUnknown();
            if (BackLevelDebugProfileClient.isBackLevelSupported() && (this.isBackLevelRequired() || this.isBackLevelRequired(connection))) {
                this.doBackLevelProfileDelete(connection);
            } else {
                HttpMessage[] results = new HttpMessage[2];
                try {
                    results = this.doProfileDelete(connection);
                    HttpRequestBase request = (HttpRequestBase)results[0];
                    HttpResponse response = (HttpResponse)results[1];
                    if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 404) {
                        throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), "http" + response.getStatusLine().getStatusCode() + " " + DebugProfileRestClientV1.getReadableResponseString(response));
                    }
                }
                catch (HttpHostConnectException hhce) {
                    HttpRequestBase request = (HttpRequestBase)results[0];
                    if (request == null) {
                        throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
                    }
                    throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), hhce.getMessage());
                }
            }
        }
    }

    public boolean isValid() {
        return this.fName != null && !this.fName.isEmpty() && this.fConnectionName != null && !this.fConnectionName.isEmpty() && ConnectionUtilities.getConnection(this.fConnectionName, false) != null && this.doValidateProfile();
    }

    protected abstract boolean doValidateProfile();

    public String[] getValidationIssues() {
        ArrayList<String> issues = new ArrayList<String>();
        if (this.fName == null || this.fName.isEmpty()) {
            issues.add(ProfileMessages.CRRDG9101);
        }
        if (this.fConnectionName == null || this.fConnectionName.isEmpty()) {
            issues.add(ProfileMessages.CRRDG9102);
        }
        if (this.fConnectionName != null && !this.fConnectionName.isEmpty() && ConnectionUtilities.getConnection(this.fConnectionName, false) == null) {
            issues.add(NLS.bind((String)ProfileMessages.CRRDG9154, (Object)this.fConnectionName));
        }
        issues.addAll(this.getProfileIssues());
        return issues.toArray(new String[issues.size()]);
    }

    protected abstract List<String> getProfileIssues();

    @Override
    public UUID getUUID() {
        if (this.fUUID == null) {
            this.fUUID = UUID.randomUUID();
        }
        return this.fUUID;
    }

    public void synchronize(boolean push, int mode) throws Exception {
        if (!this.isValid()) {
            throw new DebugProfileException(this.getValidationMessagesAsString());
        }
        Connection connection = ConnectionUtilities.getConnection(this.getConnectionName(), false);
        if (connection != null && connection.isConnected()) {
            this.fCachedConnection = new CachedConnection(connection);
            if (BackLevelDebugProfileClient.isBackLevelSupported() && (this.isBackLevelRequired() || this.isBackLevelRequired(connection))) {
                return;
            }
            HttpMessage[] results = new HttpMessage[2];
            this.fMode = mode;
            this.fState = 1;
            if (push) {
                try {
                    results = this.doProfileSynchronization(connection);
                    HttpRequestBase request = (HttpRequestBase)results[0];
                    HttpResponse response = (HttpResponse)results[1];
                    String responseMessage = DebugProfileRestClientV1.getReadableResponseString(response);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.resetStateUnknown();
                        throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), "http" + response.getStatusLine().getStatusCode() + " " + responseMessage);
                    }
                }
                catch (HttpHostConnectException hhce) {
                    HttpRequestBase request = (HttpRequestBase)results[0];
                    this.resetStateUnknown();
                    if (request == null) {
                        throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
                    }
                    throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), hhce.getMessage());
                }
            }
        } else {
            this.resetStateUnknown();
            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
        }
        DebugProfileRoot.getInstance().fireProfileEvent(this, 3);
    }

    protected abstract HttpMessage[] doProfileSynchronization(Connection var1) throws Exception;

    public JsonObject getAsJsonObject() {
        Gson gson = new GsonBuilder().create();
        JsonElement pJsonElement = gson.toJsonTree((Object)this, this.getClass());
        if (pJsonElement.isJsonObject()) {
            return pJsonElement.getAsJsonObject();
        }
        return null;
    }

    public DebugProfile duplicate() {
        DebugProfile p;
        JsonObject jsonObj = this.getAsJsonObject();
        if (jsonObj != null && (p = DebugProfileUtils.jsonToDebugProfile(jsonObj)) != null) {
            p.fName = DebugProfileNameUtils.generateNewName(this.getName());
            p.fUUID = null;
            p.fState = 2;
            p.fMode = 0;
            p.save();
            return p;
        }
        LogUtils.log(4, "Failed to duplicate profile " + this.getName());
        return null;
    }

    protected abstract boolean checkForGenericProfile();

    protected boolean isGenericLoadModulePairs() {
        if (this.fLoadModulePairs != null) {
            if (this.fLoadModulePairs.size() == 0) {
                return true;
            }
            for (LoadModulePair pair : this.fLoadModulePairs) {
                if (!pair.getLoadModule().equals("*") || !pair.getCompilationUnit().equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void activateProfileForDebugAndRecording(boolean append) throws ProfileException {
        try {
            try {
                this.fSkipGenericCheck = true;
                this.validateZUnitOptions();
                this.activate(append ? 7 : 6);
            }
            catch (Exception e) {
                if (e instanceof DebugProfileException) {
                    throw (DebugProfileException)e;
                }
                throw new DebugProfileException(e);
            }
        }
        finally {
            this.fSkipGenericCheck = false;
        }
    }

    @Override
    public void activateProfileForDebug() throws ProfileException {
        try {
            try {
                this.fSkipGenericCheck = true;
                this.activate(1);
            }
            catch (Exception e) {
                if (e instanceof DebugProfileException) {
                    throw (DebugProfileException)e;
                }
                throw new DebugProfileException(e);
            }
        }
        finally {
            this.fSkipGenericCheck = false;
        }
    }

    @Override
    public void activateProfileForCodeCoverage() throws ProfileException {
        this.activateProfileForCodeCoverage(null);
    }

    @Override
    public void activateProfileForCodeCoverage(String ccstartupkey) throws ProfileException {
        this.fCCStartupKey = ccstartupkey;
        try {
            try {
                this.fSkipGenericCheck = true;
                this.activate(2);
            }
            catch (Exception e) {
                if (e instanceof DebugProfileException) {
                    throw (DebugProfileException)e;
                }
                throw new DebugProfileException(e);
            }
        }
        finally {
            this.fSkipGenericCheck = false;
        }
    }

    public String getCodeCoverageStartupKey() {
        return this.fCCStartupKey;
    }

    @Override
    public void activateProfileForRecording(boolean append) throws ProfileException {
        try {
            try {
                this.fSkipGenericCheck = true;
                if (this.fCollectorPort < 0) {
                    this.validateZUnitOptions();
                }
                this.activate(append ? 4 : 3);
            }
            catch (Exception e) {
                if (e instanceof DebugProfileException) {
                    throw (DebugProfileException)e;
                }
                throw new DebugProfileException(e);
            }
        }
        finally {
            this.fSkipGenericCheck = false;
        }
    }

    protected void validateZUnitOptions() throws ProfileException {
        if (this.fzUnitOptions == null || this.fzUnitOptions.getRecordingFile() == null || this.fzUnitOptions.getRecordingFile().trim().isEmpty()) {
            throw new DebugProfileException(ProfileMessages.CRRDG9173);
        }
    }

    @Override
    public void deactivateProfile() throws ProfileException {
        try {
            this.deactivate();
        }
        catch (Exception e) {
            if (e instanceof DebugProfileException) {
                throw (DebugProfileException)e;
            }
            throw new DebugProfileException(e);
        }
    }

    @Override
    public String toJSON() {
        return this.getAsJsonObject().toString();
    }

    @Override
    public void configurezUnit(String recordingFile, String configurationFile) {
        this.fzUnitOptions = new ZUnitOptions(recordingFile, configurationFile);
    }

    public ZUnitOptions getZUnitOptions() {
        return this.fzUnitOptions;
    }

    @Override
    public void setDBRM(String DBRM) {
        this.fDBRM = DBRM;
    }

    public String getDBRM() {
        return this.fDBRM;
    }

    public CachedConnection getCachedConnection() {
        return this.fCachedConnection;
    }

    public void setName(String newName) {
        this.fName = newName;
    }

    @Override
    public void activateProfileForRecording(boolean append, int collectorPort) throws ProfileException {
        this.fCollectorPort = collectorPort;
        this.activateProfileForRecording(append);
    }

    public int getCollectorPort() {
        return this.fCollectorPort;
    }

    @Override
    public void setOwnerId(String ownerId) {
        this.fOwnerId = ownerId;
    }

    public String getOwnerId() {
        return this.fOwnerId;
    }

    public static class AdvancedConnectionOptions {
        private String fUserID;
        private String fIP;
        private String fPort;
        private String fCertificate;
        private Boolean fCertEnabled;

        public AdvancedConnectionOptions(String userID, String ip, String port) {
            this.fUserID = userID;
            this.fIP = ip;
            this.fPort = port;
            this.fCertificate = null;
            this.fCertEnabled = false;
        }

        public AdvancedConnectionOptions(String userID, String ip, String port, String cert, Boolean certEnabled) {
            this.fUserID = userID;
            this.fIP = ip;
            this.fPort = port;
            this.fCertificate = cert;
            this.fCertEnabled = certEnabled;
        }

        public String getUserID() {
            return this.fUserID;
        }

        public String getIP() {
            return this.fIP;
        }

        public String getPort() {
            return this.fPort;
        }

        public String getCertificate() {
            return this.fCertificate;
        }

        public Boolean isCertificateEnabled() {
            return this.fCertEnabled;
        }
    }

    public static class CodeCoverageOptions {
        private boolean fIsGeneratePDFReport;
        private boolean fIsIgnoreErrors;
        private String fFileFilter;
        private String fTestID;
        private String fTags;

        public CodeCoverageOptions(boolean isGeneratePDFReport, boolean isIgnoreErrors, String fileFilter, String testID, String tags) {
            this.fIsGeneratePDFReport = isGeneratePDFReport;
            this.fIsIgnoreErrors = isIgnoreErrors;
            this.fFileFilter = fileFilter;
            this.fTestID = testID;
            this.fTags = tags;
        }

        public boolean isGeneratePDFReport() {
            return this.fIsGeneratePDFReport;
        }

        public boolean isIgnoreErrors() {
            return this.fIsIgnoreErrors;
        }

        public String getFileFilter() {
            return this.fFileFilter;
        }

        public String getTestID() {
            return this.fTestID;
        }

        public String getTags() {
            return this.fTags;
        }
    }

    public static class DebuggerOptions {
        private String fTestLevel;
        private String fErrorLevel;
        private String fPromptLevel;
        private String fCommandDataSet;
        private String fPreferenceDataSet;
        private String fLanguageEnvironmentOptions;
        private String fEqaOptsFile;

        public DebuggerOptions(String testLevel, String errorLevel, String promptLevel) {
            this.fTestLevel = testLevel;
            this.fErrorLevel = errorLevel;
            this.fPromptLevel = promptLevel;
        }

        public String getTestLevel() {
            return this.fTestLevel;
        }

        public String getErrorLevel() {
            return this.fErrorLevel;
        }

        public String getPromptLevel() {
            return this.fPromptLevel;
        }

        public void setCommandDataSet(String commandDataSet) {
            this.fCommandDataSet = commandDataSet;
        }

        public String getCommandDataSet() {
            if (this.fCommandDataSet != null && this.fCommandDataSet.startsWith("-")) {
                return this.fCommandDataSet.substring(1);
            }
            return this.fCommandDataSet;
        }

        public void setPreferenceDataSet(String preferenceDataSet) {
            this.fPreferenceDataSet = preferenceDataSet;
        }

        public String getPreferenceDataSet() {
            if (this.fPreferenceDataSet != null && this.fPreferenceDataSet.startsWith("-")) {
                return this.fPreferenceDataSet.substring(1);
            }
            return this.fPreferenceDataSet;
        }

        public void setLanguageEnvironmentOptions(String languageEnvironmentOptions) {
            this.fLanguageEnvironmentOptions = languageEnvironmentOptions;
        }

        public String getLanguageEnvironmentOptions() {
            return this.fLanguageEnvironmentOptions;
        }

        public void setEqaOptsFile(String eqaOptsFile) {
            this.fEqaOptsFile = eqaOptsFile;
        }

        public String getEqaOptsFile() {
            return this.fEqaOptsFile;
        }
    }

    public static class LoadModulePair {
        String fLoadModule;
        String fCompilationUnit;

        public LoadModulePair(String loadModule, String compilationUnit) {
            this.fLoadModule = loadModule.trim().isEmpty() ? "*" : loadModule;
            this.fCompilationUnit = compilationUnit.trim().isEmpty() ? "*" : compilationUnit;
        }

        public String getLoadModule() {
            return this.fLoadModule;
        }

        public String getCompilationUnit() {
            return this.fCompilationUnit;
        }
    }

    public static final class ZUnitOptions {
        private String fConfigFile;
        private String fRecordingFile;

        ZUnitOptions(String recordingFile, String configurationFile) {
            this.fRecordingFile = recordingFile;
            this.fConfigFile = configurationFile;
        }

        public String getConfigFile() {
            return this.fConfigFile;
        }

        public String getRecordingFile() {
            return this.fRecordingFile;
        }
    }
}

