/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.connection;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.ibm.debug.daemon.internal.core.DaemonCore;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferences;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.configuration.ExtendedSupportUtillities;
import com.ibm.debug.pdt.profile.internal.connection.IConnectionInfo;
import com.ibm.debug.pdt.profile.internal.ims.IMSIsolationProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.DTCNForceSettings;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.APIServerException;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Connection
implements IDebugProfileConstants {
    private static final RegionPortPair[] EMPTY_REGION_PORT_PAIRS;
    private static final String[] EMPTY_REGION_NAMES;
    int http_port;
    int https_port;
    String http_context_root;
    String fNonCICSDataset;
    boolean fIsSecured = true;
    private APIServerException fNonCICSException;
    private APIServerException fCICSException;
    private boolean fIsSynchronized = false;
    private final Object fAPIVersionLock = new Object();
    private Double fAPIVersion = null;
    private IConnectionInfo fConnectionInfo;
    private Map<String, String> fAuthInvalidCicsRegions = new HashMap<String, String>();
    private String fErrorMessage;
    private ERROR_STATE fState;

    static {
        DebugProfileRoot.getInstance();
        EMPTY_REGION_PORT_PAIRS = new RegionPortPair[0];
        EMPTY_REGION_NAMES = new String[0];
    }

    Connection(IConnectionInfo connectionInfo) {
        this.fConnectionInfo = connectionInfo;
    }

    Connection(IConnectionInfo connectionInfo, int http_port, int https_port, String http_context_root) {
        this.fConnectionInfo = connectionInfo;
        this.http_port = http_port;
        this.https_port = https_port;
        this.http_context_root = http_context_root;
        this.fIsSecured = https_port > 0;
    }

    public boolean hasAuthInvalidCicsRegion() {
        return !this.fAuthInvalidCicsRegions.isEmpty();
    }

    public Set<String> getAuthInvalidCicsRegions() {
        return new HashSet<String>(this.fAuthInvalidCicsRegions.keySet());
    }

    public void clearAuthInvalidCicsRegions() {
        this.fAuthInvalidCicsRegions.clear();
    }

    public void addAuthInvalidCicsRegion(String region, HttpResponse response) throws IOException {
        String responseBody = DebugProfileRestClientV1.getBodyFromResponse(response);
        String errorMessage = JsonParser.parseString((String)responseBody).getAsJsonObject().get("message").getAsString();
        errorMessage = NLS.bind((String)ProfileMessages.CRRDG9186, (Object)region.toUpperCase(), (Object)errorMessage);
        this.fAuthInvalidCicsRegions.put(region.toLowerCase(), errorMessage);
    }

    public String getAuthInvalidCicsRegionErrorMessage(String region) {
        return this.fAuthInvalidCicsRegions.getOrDefault(region.toLowerCase(), "");
    }

    public void setConnectionInfo(int http_port, int https_port, String http_context_root) {
        this.http_port = http_port;
        this.https_port = https_port;
        this.http_context_root = http_context_root;
        this.fNonCICSDataset = null;
        this.fIsSecured = https_port > 0;
    }

    public URI getAPIServerURL() {
        if (this.fErrorMessage != null) {
            return null;
        }
        if (this.fConnectionInfo.getAPIServerURL() != null) {
            return this.fConnectionInfo.getAPIServerURL();
        }
        try {
            String scheme = this.isSecured() ? "https" : "http";
            int port = this.isSecured() ? this.https_port : this.http_port;
            return new URI(scheme, null, this.getHostName(), port, this.http_context_root, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public URL getProfileManagementServerURL() throws DebugProfileException {
        boolean isDarkTheme = ExtendedSupportUtillities.isDarkTheme();
        String themeQueryParm = isDarkTheme ? "theme=dark" : "theme=light";
        String authTypeQueryParm = LaunchzPICLPreferences.getIsTokenAuthenticationEnabled() && this.isTokenAuthSupported() ? "authType=token" : "authType=basic";
        String queryParms = "?" + String.join((CharSequence)"&", themeQueryParm, authTypeQueryParm);
        if (this.fErrorMessage != null) {
            throw new DebugProfileException(this.fErrorMessage);
        }
        try {
            String scheme = this.isSecured() ? "https" : "http";
            int port = this.isSecured() ? this.https_port : this.http_port;
            return new URL(scheme, this.getHostName().toLowerCase(), port, "/profile-management/" + queryParms);
        }
        catch (MalformedURLException e) {
            LogUtils.log(e);
            return null;
        }
    }

    public String getConnectionName() {
        return this.fConnectionInfo.getConnectionName();
    }

    public String getHostName() {
        return this.fConnectionInfo.getHostName();
    }

    public String getUserId() {
        return this.fConnectionInfo.getUserId();
    }

    public char[] getUserPassword() {
        return this.fConnectionInfo.getUserPassword();
    }

    public boolean isSecured() {
        return this.fIsSecured;
    }

    public void setSecured(boolean isSecured) {
        this.fIsSecured = isSecured;
    }

    public int getHttpPort(boolean isSecured) {
        return isSecured ? this.https_port : this.http_port;
    }

    public boolean isConnected() {
        return this.fConnectionInfo.isConnected();
    }

    public boolean isUsingDBM() {
        return this.fConnectionInfo.isUsingDBM();
    }

    public String getLocalClientIP() {
        String localClientIP = this.fConnectionInfo.getLocalClientIP();
        if (localClientIP == null || localClientIP.isEmpty()) {
            try {
                InetAddress[] addrs;
                InetAddress[] inetAddressArray = addrs = DaemonCore.getLocalAddress();
                int n = addrs.length;
                int n2 = 0;
                while (n2 < n) {
                    InetAddress a = inetAddressArray[n2];
                    if (!a.isLoopbackAddress()) {
                        return a.getHostAddress();
                    }
                    ++n2;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return localClientIP;
    }

    public String getLocalClientPort() {
        return Connection.getLocalClientPort(true);
    }

    public static String getLocalClientPort(boolean profileMode) {
        boolean isSecuredListening = DaemonCore.isListeningSecure();
        boolean isListening = DaemonCore.isListening();
        if (!isSecuredListening && !isListening) {
            isSecuredListening = ExtendedSupportUtillities.enableSecuredDebugDaemon();
            isListening = DaemonCore.isListening();
        }
        if (isSecuredListening && !isListening) {
            return Integer.toString(DaemonCore.getCurrentPortSecure());
        }
        if (isSecuredListening && isListening) {
            return Integer.toString(ExtendedSupportUtillities.getDaemonPort(profileMode));
        }
        if (isListening) {
            return Integer.toString(DaemonCore.getCurrentPort());
        }
        return "";
    }

    public IStatus connect() throws Exception {
        if (this.isConnected()) {
            return Status.OK_STATUS;
        }
        return this.fConnectionInfo.connect();
    }

    public String getJwt() {
        return this.fConnectionInfo.getJwt();
    }

    public String toString() {
        String connectedStatus = this.isConnected() ? "+CONNECTED+" : "-CONNECTED-";
        return this.getConnectionName() + ": " + connectedStatus + " " + String.valueOf(this.getAPIServerURL());
    }

    public void setErrorState(ERROR_STATE error) {
        this.fState = error;
    }

    public ERROR_STATE getErrorState() {
        return this.fState;
    }

    public String[] getRegionNames() {
        try {
            List<DebugProfileRestClientV1.DTCN_Region_Response> regions;
            this.fCICSException = null;
            if (this.isConnected() && (regions = DebugProfileRestClientV1.getRegions(this)) != null) {
                ArrayList<String> regionNames = new ArrayList<String>();
                for (DebugProfileRestClientV1.DTCN_Region_Response region : regions) {
                    regionNames.add(region.regionname);
                }
                return regionNames.toArray(new String[0]);
            }
        }
        catch (APIServerException e) {
            this.fCICSException = e;
        }
        return EMPTY_REGION_NAMES;
    }

    public RegionPortPair[] getCICSRegionAndPorts() {
        try {
            this.fCICSException = null;
            List<DebugProfileRestClientV1.DTCN_Region_Response> regions = DebugProfileRestClientV1.getRegions(this);
            if (regions != null) {
                ArrayList<RegionPortPair> result = new ArrayList<RegionPortPair>();
                for (DebugProfileRestClientV1.DTCN_Region_Response region : regions) {
                    try {
                        result.add(new RegionPortPair(region.regionname, Integer.parseInt(region.port)));
                    }
                    catch (NumberFormatException e) {
                        LogUtils.log(e);
                    }
                }
                return result.toArray(new RegionPortPair[result.size()]);
            }
        }
        catch (APIServerException e) {
            this.fCICSException = e;
        }
        return EMPTY_REGION_PORT_PAIRS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNonCICSLocation() {
        if (this.fNonCICSDataset != null) return this.fNonCICSDataset;
        if (!this.isConnected()) return this.fNonCICSDataset;
        if (this.getErrorState() != ERROR_STATE.NONE) return this.fNonCICSDataset;
        this.fNonCICSException = null;
        HttpRequestBase request = null;
        HttpResponse response = null;
        try {
            request = DebugProfileRestClientV1.buildRequest_GetRemoteDTSPProfile(this.getUserId(), this);
            response = DebugProfileRestClientV1.executeRequest(request, this);
            if (response == null) {
                return this.fNonCICSDataset;
            }
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 404) {
                Gson gson = new Gson();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                DebugProfileRestClientV1.DTSP_Profile_Response jsonBody = (DebugProfileRestClientV1.DTSP_Profile_Response)gson.fromJson(body, DebugProfileRestClientV1.DTSP_Profile_Response.class);
                if (jsonBody != null) {
                    this.setAPIVersion(jsonBody.apiversion);
                }
                if (jsonBody == null) return null;
                if (jsonBody.datasetname == null) return null;
                if (jsonBody.datasetname.isEmpty()) {
                    return null;
                }
                this.fNonCICSDataset = jsonBody.datasetname;
                return this.fNonCICSDataset;
            }
            if (response.getStatusLine().getStatusCode() == 204) {
                this.setErrorState(ERROR_STATE.CICS_ONLY);
                this.setErrorMessage(ProfileMessages.CRRDG9113);
                LogUtils.log(4, "HTTP 204 received retrieving non-CICS dataset for connection: " + this.getHostName());
                return this.fNonCICSDataset;
            }
            String responseMessage = DebugProfileRestClientV1.getReadableResponseString(response);
            throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), "http" + response.getStatusLine().getStatusCode() + " " + responseMessage);
        }
        catch (APIServerException e) {
            this.fNonCICSException = e;
            return this.fNonCICSDataset;
        }
        catch (Exception e) {
            LogUtils.log(e);
        }
        return this.fNonCICSDataset;
    }

    public APIServerException getNonCICSException() {
        return this.fNonCICSException;
    }

    public APIServerException getCICSException() {
        return this.fCICSException;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    public boolean isSynchronized() {
        return this.fIsSynchronized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronized() {
        Connection connection = this;
        synchronized (connection) {
            this.fIsSynchronized = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAPIVersion(String apiversion) {
        Object object = this.fAPIVersionLock;
        synchronized (object) {
            try {
                this.fAPIVersion = Double.parseDouble(apiversion);
            }
            catch (NumberFormatException e) {
                LogUtils.log(e);
                this.fAPIVersion = 0.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double getAPIVersion() {
        Object object = this.fAPIVersionLock;
        synchronized (object) {
            return this.fAPIVersion != null ? this.fAPIVersion : 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isApiVersionSupported(double version, boolean isCics) {
        Object object = this.fAPIVersionLock;
        synchronized (object) {
            if (this.fAPIVersion == null) {
                try {
                    if (isCics) {
                        DebugProfileRestClientV1.getRegions(this);
                    } else {
                        this.getNonCICSLocation();
                    }
                }
                catch (APIServerException e) {
                    this.fAPIVersion = 0.0;
                }
            }
            return this.fAPIVersion != null && version <= this.fAPIVersion;
        }
    }

    public boolean isIMSISO1000BytesSupported() {
        return this.isApiVersionSupported(1.4, false);
    }

    public boolean isRecordingPlaybackSupported() {
        return this.isApiVersionSupported(1.5, true);
    }

    public boolean isTokenAuthSupported() {
        return this.isApiVersionSupported(1.6, true);
    }

    public boolean isAuthCertSupported() {
        return this.isApiVersionSupported(1.9, true);
    }

    public boolean isRecordingCollectorSupported() {
        return this.isApiVersionSupported(2.0, false);
    }

    public DTCNForceSettings getDTCNForceSettings(String region) {
        if (this.isConnected() && this.getErrorState() == ERROR_STATE.NONE) {
            this.fNonCICSException = null;
            HttpRequestBase request = null;
            HttpResponse response = null;
            try {
                request = DebugProfileRestClientV1.buildRequest_GetDTCNForceSettings(region, this);
                response = DebugProfileRestClientV1.executeRequest(request, this);
                if (response == null) {
                    return new DTCNForceSettings();
                }
                if (response.getStatusLine().getStatusCode() == 200) {
                    Gson gson = new Gson();
                    String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    DebugProfileRestClientV1.DTCNForceSettings_Response jsonBody = (DebugProfileRestClientV1.DTCNForceSettings_Response)gson.fromJson(body, DebugProfileRestClientV1.DTCNForceSettings_Response.class);
                    if (jsonBody != null) {
                        return new DTCNForceSettings(jsonBody);
                    }
                } else {
                    response.getStatusLine().getStatusCode();
                }
            }
            catch (APIServerException e) {
                this.fNonCICSException = e;
            }
            catch (Exception e) {
                LogUtils.log(e);
            }
        }
        return new DTCNForceSettings();
    }

    public void checkIMSIsoConnection() throws DebugProfileException {
        if (IMSIsolationProfileUtils.getIMSIsolationAPIProvider() == null) {
            throw new DebugProfileException(ProfileMessages.CRRDG9181);
        }
        try {
            if (!IMSIsolationProfileUtils.getIMSIsolationAPIProvider().isIMSRestAPIAvailable(this)) {
                throw new DebugProfileException(ProfileMessages.CRRDG9182);
            }
        }
        catch (Exception e) {
            if (!e.getMessage().startsWith("CRRDG") && !e.getMessage().startsWith("EQA")) {
                LogUtils.log(e);
            }
            throw new DebugProfileException(e.getMessage());
        }
    }

    public SSLContext getSSLContext(X509TrustManager mgr) throws Exception {
        return this.fConnectionInfo.getSSLContext(mgr);
    }

    public IConnectionInfo getConnectionInfo() {
        return this.fConnectionInfo;
    }

    public static enum ERROR_STATE {
        NONE,
        BACK_LEVEL,
        CLIENT_ERROR,
        HOST_ERROR,
        CICS_ONLY,
        NOT_CONNECTED,
        AUTHENTICATION_NOT_VALID;

    }

    public static class RegionPortPair {
        public String regionName;
        public int port;

        RegionPortPair(String region, int port) {
            this.regionName = region;
            this.port = port;
        }
    }
}

