/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.connection;

import com.ibm.debug.pdt.profile.internal.connection.Connection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class CachedConnection
extends Connection {
    private URI cachedURI;
    private String userId;
    private byte[] userPassword;
    private Connection.ERROR_STATE cachedErrorState;

    public CachedConnection(Connection c) {
        super(c.getConnectionInfo(), c.http_port, c.https_port, c.http_context_root);
        this.cachedURI = c.getAPIServerURL();
        this.userId = c.getUserId();
        this.userPassword = Base64.getEncoder().encode(new String(c.getUserPassword()).getBytes(StandardCharsets.UTF_8));
        this.cachedErrorState = c.getErrorState();
    }

    @Override
    public URI getAPIServerURL() {
        return this.cachedURI;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public char[] getUserPassword() {
        return new String(Base64.getDecoder().decode(this.userPassword), StandardCharsets.UTF_8).toCharArray();
    }

    @Override
    public Connection.ERROR_STATE getErrorState() {
        return this.cachedErrorState;
    }
}

