/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.cc;

import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.cc.ICCStartupKeyGenerator;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class CodeCoverageUtils {
    private static final String CC_PLUGIN = "com.ibm.debug.pdt.codecoverage.core";
    private static IExtensionPoint fCCExtensionPoint = null;
    private static IConfigurationElement[] fCCExtensionPointElements = null;

    public static boolean isCodeCoverageClient() {
        Bundle b = Platform.getBundle((String)CC_PLUGIN);
        return b != null;
    }

    public static synchronized ICCStartupKeyGenerator getCodeCoverageStartupKeyGenerator() {
        if (fCCExtensionPoint == null) {
            fCCExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.profile.eclipse.profileCCStartupKeyGenerator");
        }
        if (fCCExtensionPoint != null) {
            if (fCCExtensionPointElements == null) {
                fCCExtensionPointElements = fCCExtensionPoint.getConfigurationElements();
            }
            IConfigurationElement[] iConfigurationElementArray = fCCExtensionPointElements;
            int n = fCCExtensionPointElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    return (ICCStartupKeyGenerator)config.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    LogUtils.log(e);
                }
                catch (ClassCastException e) {
                    LogUtils.log(e);
                }
                ++n2;
            }
        }
        return null;
    }

    public static String generateStartupKey(DebugProfile profile) {
        ICCStartupKeyGenerator generator = CodeCoverageUtils.getCodeCoverageStartupKeyGenerator();
        if (generator != null) {
            if (profile != null && profile.getCodeCoverageOptions() != null) {
                generator.setGenPDF(profile.getCodeCoverageOptions().isGeneratePDFReport());
                generator.setIgnoreError(profile.getCodeCoverageOptions().isIgnoreErrors());
                generator.setFilter(profile.getCodeCoverageOptions().getFileFilter());
                generator.setTestId(profile.getCodeCoverageOptions().getTestID());
                generator.setTestTags(profile.getCodeCoverageOptions().getTags());
            }
            return generator.generateStartupKey();
        }
        return null;
    }
}

