/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.playback.internal.preferences;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepGetPlaybackOptions;
import com.ibm.debug.pdt.playback.internal.PlaybackMessages;
import com.ibm.debug.pdt.playback.internal.PlaybackOptionsUtilities;
import com.ibm.debug.pdt.playback.internal.preferences.EditOptionDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

final class IncludeListFieldEditor
extends FieldEditor
implements ISelectionChangedListener,
SelectionListener {
    private static IContentProvider fContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            if (inputElement instanceof String) {
                Object[] result = new Object[]{inputElement};
                return result;
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private static CellLabelProvider column1LabelProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            if (element instanceof TableOptions) {
                return ((TableOptions)element).fOption.getName().toString();
            }
            return super.getText(element);
        }
    };
    private static CellLabelProvider column2LabelProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            if (element instanceof TableOptions) {
                return ((TableOptions)element).fStringValue;
            }
            if (element instanceof String) {
                return "";
            }
            return super.getText(element);
        }
    };
    private TableViewer fList;
    private Composite fComposite;
    private Button fEditButton;

    public IncludeListFieldEditor(Composite parent) {
        super("com.ibm.debug.pdt.playback.include.", PlaybackMessages.INCLUDE, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.fComposite != null) {
            GridData gd = null;
            if (this.fComposite.getLayoutData() instanceof GridData) {
                gd = (GridData)this.fComposite.getLayoutData();
            } else {
                gd = new GridData(768);
                this.fComposite.setLayoutData((Object)gd);
            }
            gd.horizontalSpan = numColumns;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.fComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fComposite.setLayout((Layout)layout);
        Label label = this.getLabelControl(this.fComposite);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(this.fComposite, 0);
        gd = new GridData(1808);
        gd.verticalSpan = 3;
        tableComposite.setLayoutData((Object)gd);
        this.fList = new TableViewer(tableComposite, 2852);
        this.fList.setContentProvider(fContentProvider);
        TableViewerColumn column1 = new TableViewerColumn(this.fList, 16384);
        column1.setLabelProvider(column1LabelProvider);
        TableViewerColumn column2 = new TableViewerColumn(this.fList, 16384);
        column2.setLabelProvider(column2LabelProvider);
        List<TableOptions> items = this.getListItems();
        boolean isOptions = items != null && items.size() > 0;
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(isOptions ? 50 : 100));
        tableLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(isOptions ? 50 : 0));
        tableComposite.setLayout((Layout)tableLayout);
        this.fList.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fList.setInput(isOptions ? items : PlaybackMessages.NO_OPTIONS);
        this.fList.setItemCount(5);
        gd = new GridData(768);
        gd.heightHint = this.fList.getTable().computeSize((int)-1, (int)-1).y;
        this.fList.getTable().setLayoutData((Object)gd);
        this.fEditButton = new Button(this.fComposite, 8);
        this.fEditButton.setText(PlaybackMessages.EDIT);
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fList.setItemCount(isOptions ? items.size() : 1);
        this.fList.getControl().setEnabled(isOptions);
        label.setEnabled(isOptions);
        this.fEditButton.setEnabled(isOptions);
    }

    protected void doLoad() {
        IAdaptable item = DebugUITools.getDebugContext();
        if (item instanceof PDTDebugElement) {
            ERepGetPlaybackOptions[] options = ((PDTDebugElement)item).getEngineSession().getPlaybackOptions();
            if (this.fList != null) {
                TableItem[] items = this.fList.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof TableOptions) {
                        this.loadOption((TableOptions)data, items[i], options);
                    }
                    ++i;
                }
                this.fList.refresh();
            }
        }
    }

    protected void doLoadDefault() {
        if (this.fList != null) {
            TableItem[] items = this.fList.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(false);
                Object data = items[i].getData();
                if (data instanceof TableOptions) {
                    ((TableOptions)data).fStringValue = null;
                }
                ++i;
            }
        }
    }

    protected void doStore() {
        if (this.fList != null) {
            ArrayList<ERepGetPlaybackOptions> options = new ArrayList<ERepGetPlaybackOptions>();
            TableItem[] items = this.fList.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                Object data = items[i].getData();
                if (data instanceof TableOptions) {
                    this.storeOption((TableOptions)data, items[i].getChecked());
                    options.add(((TableOptions)data).fOption);
                }
                ++i;
            }
            IAdaptable item = DebugUITools.getDebugContext();
            if (item instanceof PDTDebugElement) {
                ((PDTDebugElement)item).getEngineSession().updatePlaybackOptions(options);
                ((PDTDebugElement)item).getDebugEngine().saveDebugObjects();
                if (((PDTDebugElement)item).getDebugTarget() instanceof PDTDebugTarget) {
                    ((PDTDebugTarget)((PDTDebugElement)item).getDebugTarget()).saveToProfile();
                }
            }
        }
    }

    private void editSelection(ISelection selection) {
        Object item;
        if (selection instanceof StructuredSelection && this.fComposite != null && (item = ((StructuredSelection)selection).getFirstElement()) instanceof TableOptions) {
            int type = ((TableOptions)item).fOption.getType();
            EditOptionDialog dialog = null;
            if (ERepGetPlaybackOptions.isListType((int)type)) {
                dialog = new EditOptionDialog(this.fComposite.getShell(), ((TableOptions)item).fOption, PlaybackOptionsUtilities.getListFromString(((TableOptions)item).fStringValue));
            } else if (ERepGetPlaybackOptions.isStringType((int)type)) {
                dialog = new EditOptionDialog(this.fComposite.getShell(), ((TableOptions)item).fOption, ((TableOptions)item).fStringValue);
            }
            if (dialog != null && dialog.open() == 0) {
                ((TableOptions)item).fStringValue = dialog.getReturnedString();
            }
        }
    }

    private List<TableOptions> getListItems() {
        PDTDebugElement debugElement;
        EPDC_EngineSession session;
        ERepGetPlaybackOptions[] options;
        IAdaptable item = DebugUITools.getDebugContext();
        if (item instanceof PDTDebugElement && (options = (session = (debugElement = (PDTDebugElement)item).getEngineSession()).getPlaybackOptions()) != null) {
            ArrayList<TableOptions> list = new ArrayList<TableOptions>();
            int i = 0;
            while (i < options.length) {
                list.add(new TableOptions(options[i]));
                ++i;
            }
            return list;
        }
        return null;
    }

    public int getNumberOfControls() {
        return 1;
    }

    private void loadOption(TableOptions option, TableItem tableItem, ERepGetPlaybackOptions[] options) {
        int i = 0;
        while (i < options.length) {
            if (option.fOption == options[i]) {
                option.fOption.setBooleanValue(options[i].getBooleanValue());
                option.fOption.setStringValue(options[i].getStringValue());
                tableItem.setChecked(options[i].getBooleanValue());
            }
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel;
        if (this.fEditButton != null && (sel = event.getSelection()) instanceof StructuredSelection) {
            Object item = ((StructuredSelection)sel).getFirstElement();
            if (item instanceof TableOptions) {
                int type = ((TableOptions)item).fOption.getType();
                this.fEditButton.setEnabled(ERepGetPlaybackOptions.isLaunchType((int)type) || ERepGetPlaybackOptions.isListType((int)type));
            } else {
                this.fEditButton.setEnabled(false);
            }
        }
    }

    private void storeOption(TableOptions data, boolean checked) {
        data.fOption.setBooleanValue(checked);
        data.fOption.setStringValue(data.fStringValue);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.fEditButton && this.fList != null) {
            this.editSelection(this.fList.getSelection());
        }
    }

    static class TableOptions {
        String fStringValue = null;
        ERepGetPlaybackOptions fOption;

        public TableOptions(ERepGetPlaybackOptions option) {
            this.fOption = option;
        }
    }
}

