/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.playback.internal.handlers;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepPlayback;
import com.ibm.debug.pdt.internal.epdc.EReqPlaybackStart;
import com.ibm.debug.pdt.internal.epdc.EReqPlaybackStop;
import com.ibm.debug.pdt.playback.internal.PlaybackMessages;
import com.ibm.debug.pdt.playback.internal.PlaybackOptionsUtilities;
import com.ibm.debug.pdt.playback.internal.PlaybackStateCache;
import com.ibm.debug.pdt.playback.internal.handlers.AbstractPlaybackControlHandler;
import com.ibm.debug.pdt.playback.internal.preferences.PlaybackPreferenceUtils;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EnablePlaybackHandler
extends AbstractHandler
implements IElementUpdater,
IDebugContextListener {
    private static final ImageDescriptor STOP_ENABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.playback", (String)"/icons/etool16/playback_stop.png");
    private static final ImageDescriptor RECORD_ENABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.playback", (String)"/icons/etool16/playback_record.png");
    private static final ImageDescriptor STOP_DISABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.playback", (String)"/icons/dtool16/playback_stop.png");
    private static final ImageDescriptor RECORD_DISABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.playback", (String)"/icons/dtool16/playback_record.png");
    private boolean fListenerAdded = false;
    private int fMemory = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.fListenerAdded) {
            DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        }
        Command command = event.getCommand();
        boolean isRecording = this.isRecording(command);
        IAdaptable item = DebugUITools.getDebugContext();
        if (item instanceof PDTDebugElement && this.isPlaybackRequestHandled((PDTDebugElement)item, isRecording)) {
            HandlerUtil.toggleCommandState((Command)command);
            if (isRecording) {
                PlaybackStateCache.playbackRecordingStopped(((PDTDebugElement)item).getDebugEngine());
            } else {
                PlaybackStateCache.playbackRecordingStarted(((PDTDebugElement)item).getDebugEngine());
            }
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            commandService.refreshElements("com.ibm.debug.pdt.playback.command.startrecording", null);
        }
        return null;
    }

    private boolean isPlaybackRequestHandled(PDTDebugElement item, boolean isRecording) {
        DebugEngine engine = item.getDebugEngine();
        EPDC_Reply reply = null;
        try {
            reply = isRecording ? engine.processRequest((EPDC_Request)new EReqPlaybackStop(item.getEngineSession())) : engine.processRequest((EPDC_Request)new EReqPlaybackStart(item.getEngineSession(), PlaybackPreferenceUtils.getPlaybackMemory(), PlaybackOptionsUtilities.getPlaybackOptions(engine)));
            if (reply instanceof ERepPlayback) {
                this.fMemory = ((ERepPlayback)reply).getMemory();
                if (!isRecording && this.fMemory != PlaybackPreferenceUtils.getPlaybackMemory()) {
                    PDTCoreUtils.logString((Object)((Object)this), (String)("Memory desired=" + PlaybackPreferenceUtils.getPlaybackMemory() + ",memory allocated:" + this.fMemory), (int)2);
                }
            }
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString((Object)((Object)this), (String)(e.getMessage() != null ? e.getMessage() : e.toString()), (int)4, (Exception)((Object)e));
        }
        if (reply != null && reply.getReturnCode() == 0) {
            return true;
        }
        if (reply != null) {
            PDTCoreUtils.logString((Object)((Object)this), (String)AbstractPlaybackControlHandler.getReplyMessage(reply), (int)2);
        }
        return false;
    }

    public void updateElement(final UIElement element, Map parameters) {
        ICommandService commandService = (ICommandService)element.getServiceLocator().getService(ICommandService.class);
        if (commandService != null) {
            final Command command = commandService.getCommand("com.ibm.debug.pdt.playback.command.startrecording");
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (EnablePlaybackHandler.this.isRecording(command).booleanValue()) {
                        element.setTooltip(PlaybackMessages.STOP_RECORDING);
                        element.setText(PlaybackMessages.STOP_RECORDING);
                        element.setIcon(STOP_ENABLED_ICON);
                        element.setDisabledIcon(STOP_DISABLED_ICON);
                    } else {
                        element.setTooltip(PlaybackMessages.START_RECORDING);
                        element.setText(PlaybackMessages.START_RECORDING);
                        element.setIcon(RECORD_ENABLED_ICON);
                        element.setDisabledIcon(RECORD_DISABLED_ICON);
                    }
                }
            });
        }
    }

    private Boolean isRecording(Command command) {
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        Object stateValue = state.getValue();
        if (stateValue instanceof Boolean) {
            return (Boolean)stateValue;
        }
        return false;
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection selection = event.getContext();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            IDebugTarget dt;
            Object element = ((IStructuredSelection)selection).getFirstElement();
            DebugEngine engine = null;
            if (element instanceof PDTDebugElement) {
                engine = ((PDTDebugElement)element).getDebugEngine();
            } else if (element instanceof ILaunch && ((ILaunch)element).getDebugTarget() != null && (dt = ((ILaunch)element).getDebugTarget()) instanceof PDTDebugElement) {
                engine = ((PDTDebugElement)dt).getDebugEngine();
            }
            if (engine != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
                Command command = commandService.getCommand("com.ibm.debug.pdt.playback.command.startrecording");
                State state = command.getState("org.eclipse.ui.commands.toggleState");
                state.setValue((Object)PlaybackStateCache.isPlaybackActive(engine));
                commandService.refreshElements(command.getId(), null);
            }
        }
    }
}

