/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.internal.pdt.model;

import com.ibm.debug.internal.pdt.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdView;

public class Watchpoint
extends EventBreakpoint {
    private static final long serialVersionUID = 20050525L;

    Watchpoint() {
    }

    @Override
    public boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, (Object)this._workingSetName));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        EStdView esv = null;
        com.ibm.debug.internal.epdc.EStdView[] eStdViewArray = this._epdcBkp.getContexts();
        int n = eStdViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            com.ibm.debug.internal.epdc.EStdView orig = eStdViewArray[n2];
            if (orig != null && orig.isComplete()) {
                esv = new EStdView(orig.getPartID(), orig.getViewNum(), orig.getSrcFileIndex(), orig.getLineNumber());
                break;
            }
            ++n2;
        }
        if (esv == null) {
            esv = new EStdView(0, 0, 0, 0);
        }
        OptionalBreakpointData optData = new OptionalBreakpointData(this.getConditionalExpression(), this.getBreakpointAction(), this.getThreadID(), this.getEveryVal(), this.getFromVal(), this.getToVal(), false);
        try {
            if (targetProcess.getEngineSession().supportsEnhancedWatchpointBreakpoints()) {
                targetProcess.setEnhancedWatchpoint(this.isEnabled(), this._epdcBkp.getEntryName(), null, this._epdcBkp.getByteCount(), null, null, null, null, null, optData, property, esv);
            } else {
                targetProcess.setWatchpoint(true, this.isEnabled(), this._epdcBkp.getEntryName(), this._epdcBkp.getByteCount(), optData, property, esv, this._epdcBkp.getFileName(), this._epdcBkp.getModuleName(), this._epdcBkp.getPartName(), this._epdcBkp.getAddress());
            }
            return true;
        }
        catch (EngineRequestException e) {
            return false;
        }
    }
}

