/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.internal.pdt.model;

import com.ibm.debug.internal.epdc.EStdView;
import com.ibm.debug.internal.pdt.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ModelPackageAccessHelper;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;

public class LineBreakpoint
extends LocationBreakpoint {
    private static final long serialVersionUID = 20050525L;

    LineBreakpoint() {
    }

    @Override
    public boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, (Object)this._workingSetName));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        int lineNumber = -1;
        EStdView originalLocation = this._epdcBkp.getOriginalLocation();
        if (originalLocation != null && originalLocation.getLineNumber() > 0) {
            lineNumber = originalLocation.getLineNumber();
        } else {
            ViewInformation view = null;
            EStdView[] epdcLocations = this._epdcBkp.getContexts();
            ViewInformation[] views = targetProcess.getDebugEngine().getSupportedViews();
            int i = 0;
            while (i < views.length) {
                if (views[i] != null && views[i].isLineBreakpointCapable()) {
                    view = views[i];
                    break;
                }
                ++i;
            }
            if (view == null) {
                return false;
            }
            lineNumber = epdcLocations[ModelPackageAccessHelper.getViewNumber(view) - 1].getLineNumber();
        }
        if (lineNumber < 0) {
            return false;
        }
        String stmtNum = null;
        if (targetProcess.getEngineSession().supportsStatementBreakpoints()) {
            stmtNum = this._epdcBkp.getStatementNumber();
        }
        OptionalBreakpointData optData = new OptionalBreakpointData(this.getConditionalExpression(), this.getBreakpointAction(), this.getThreadID(), this.getEveryVal(), this.getFromVal(), this.getToVal(), false);
        try {
            targetProcess.setDeferredLineBreakpoint(this.isEnabled(), lineNumber, stmtNum, this.getFunctionName(), this.getModuleName(), this.getPartName(), this.getFileName(), optData, property);
            return true;
        }
        catch (EngineRequestException e) {
            return false;
        }
    }
}

