/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.launch.internal.zpicl.preferences;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.launch.internal.zpicl.Activator;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferenceConstants;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.service.prefs.BackingStoreException;

public class LaunchzPICLPreferences
implements LaunchzPICLPreferenceConstants {
    public static final String PREFERENCE_PLUGIN_ID = "com.ibm.debug.pdt.launch.zpicl";
    private static final String SECURE_PREFERENCES_FILE_NAME = "securePreferences.properties";
    private static final String PASSWORD_NODE = "keystore_password";
    private static final String PASSWORD = "password";
    private static final String EMPTY_STRING = "";
    private static final String SECURE_PWD_UPDATED_PREFERENCE = "updateSecure";
    private static Object fPrefLock = new Object();
    private static ISecurePreferences fSecurePreferences;
    private static File fSecurePreferencesDataFile;

    public static int getZPICLPortNumber() {
        return Platform.getPreferencesService().getInt(PREFERENCE_PLUGIN_ID, "zpicl_engine_port", 0, null);
    }

    public static String getZPICLEnginePath() {
        return Platform.getPreferencesService().getString(PREFERENCE_PLUGIN_ID, "zpicl_engine_path", EMPTY_STRING, null);
    }

    public static String getZPICLCmdLineArgs() {
        return Platform.getPreferencesService().getString(PREFERENCE_PLUGIN_ID, "zpicl_cmdline_arguments", EMPTY_STRING, null);
    }

    public static Boolean zPICLSecureChannelEnabled() {
        return LaunchzPICLPreferences.overrideDefaultKeystoreDetails();
    }

    public static Boolean overrideDefaultKeystoreDetails() {
        return Platform.getPreferencesService().getBoolean(PREFERENCE_PLUGIN_ID, "SecureChannelEnabled", false, null);
    }

    public static String getZPICLKeyStoreFile() {
        return Platform.getPreferencesService().getString(PREFERENCE_PLUGIN_ID, "KeyStoreFile", EMPTY_STRING, null);
    }

    public static char[] getZPICLKeyStorePassword() {
        return LaunchzPICLPreferences.getPasswordFromSecureStorage(LaunchzPICLPreferences.getSecurePreferences());
    }

    public static char[] getZPICLKeyStorePassword(String keyStoreFileName) {
        if (keyStoreFileName == null || keyStoreFileName.trim().length() <= 0) {
            return EMPTY_STRING.toCharArray();
        }
        return LaunchzPICLPreferences.getPasswordFromSecureStorage(LaunchzPICLPreferences.getSecurePreferences());
    }

    public static void setZPICLKeyStorePassword(char[] fKeyStorePassword) {
        LaunchzPICLPreferences.addPasswordToSecureStorage(LaunchzPICLPreferences.getSecurePreferences(), fKeyStorePassword);
    }

    private static void addPasswordToSecureStorage(ISecurePreferences securePreferences, char[] keyStorePassword) {
        ISecurePreferences thisNode = null;
        if (securePreferences.nodeExists(PASSWORD_NODE)) {
            thisNode = securePreferences.node(PASSWORD_NODE);
            thisNode.removeNode();
        }
        thisNode = securePreferences.node(PASSWORD_NODE);
        try {
            thisNode.put(PASSWORD, String.valueOf(keyStorePassword), true);
        }
        catch (StorageException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
        }
    }

    private static char[] getPasswordFromSecureStorage(ISecurePreferences securePreferences) {
        if (securePreferences.nodeExists(PASSWORD_NODE)) {
            try {
                ISecurePreferences thisNode = securePreferences.node(PASSWORD_NODE);
                return thisNode.get(PASSWORD, EMPTY_STRING).toCharArray();
            }
            catch (StorageException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
        return EMPTY_STRING.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ISecurePreferences getSecurePreferences() {
        Object object = fPrefLock;
        synchronized (object) {
            if (fSecurePreferences == null) {
                LaunchzPICLPreferences.migratePreferences();
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("org.eclipse.equinox.security.storage.promptUser", true);
                try {
                    fSecurePreferencesDataFile = new File(Activator.getDefault().getStateLocation().toOSString() + File.separator + SECURE_PREFERENCES_FILE_NAME);
                    fSecurePreferences = SecurePreferencesFactory.open((URL)fSecurePreferencesDataFile.toURI().toURL(), options).node(PREFERENCE_PLUGIN_ID);
                }
                catch (IOException e) {
                    PDTCoreUtils.logError((Exception)e);
                }
            }
        }
        return fSecurePreferences;
    }

    private static void migratePreferences() {
        boolean updateToSecurePreference = Platform.getPreferencesService().getBoolean(PREFERENCE_PLUGIN_ID, SECURE_PWD_UPDATED_PREFERENCE, true, null);
        if (updateToSecurePreference) {
            IEclipsePreferences pref = InstanceScope.INSTANCE.getNode(PREFERENCE_PLUGIN_ID);
            pref.putBoolean(SECURE_PWD_UPDATED_PREFERENCE, false);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec("changeit".toCharArray()));
            options.put("org.eclipse.equinox.security.storage.promptUser", true);
            try {
                File prefFile = new File(Activator.getDefault().getStateLocation().toOSString() + File.separator + SECURE_PREFERENCES_FILE_NAME);
                if (prefFile.exists()) {
                    ISecurePreferences preferencesOld = SecurePreferencesFactory.open((URL)prefFile.toURI().toURL(), options).node(PREFERENCE_PLUGIN_ID);
                    String pwd = preferencesOld.get(PASSWORD, null);
                    if (pwd != null) {
                        LaunchzPICLPreferences.setZPICLKeyStorePassword(pwd.toCharArray());
                    }
                    LaunchzPICLPreferences.getSecurePreferences().flush();
                }
            }
            catch (IOException | StorageException e) {
                PDTCoreUtils.logError((Exception)e);
            }
            try {
                pref.flush();
            }
            catch (BackingStoreException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
    }

    @Deprecated
    public static String getDefaultEQAUOPTSPattern() {
        return Platform.getPreferencesService().getString(PREFERENCE_PLUGIN_ID, "EQAUOPTSpattern", "&USERID.DBGTOOL.EQAUOPTS", null);
    }

    @Deprecated
    public static String getDefaultDLYDEBUGPattern() {
        return Platform.getPreferencesService().getString(PREFERENCE_PLUGIN_ID, "DelayDebugPattern", "&USERID.DLAYDBG.EQAUOPTS", null);
    }

    public static boolean getProfilesDisabledOnbWorkbenchShutdown() {
        return Platform.getPreferencesService().getBoolean(PREFERENCE_PLUGIN_ID, "DisableProfilesOnShutdown", false, null);
    }

    public static boolean getIsGenericEditorWarningNeeded() {
        return Platform.getPreferencesService().getBoolean(PREFERENCE_PLUGIN_ID, "ShowWarningInDebugProfileEditor", true, null);
    }

    public static boolean getIsSSLCertErrorIgnored() {
        return Platform.getPreferencesService().getBoolean(PREFERENCE_PLUGIN_ID, "IgnoreSSLCertErrors", true, null);
    }

    public static boolean getisSynchronizeProfiles() {
        return Platform.getPreferencesService().getBoolean(PREFERENCE_PLUGIN_ID, "SynchronizeProfilesOnRseConn", true, null);
    }

    public static boolean getIsTokenAuthenticationEnabled() {
        return Platform.getPreferencesService().getBoolean(PREFERENCE_PLUGIN_ID, "TokenAuthenticationEnabled", true, null);
    }
}

