/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.launch.internal.zpicl.ui.preferences;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLLabels;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLMessages;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferenceConstants;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferences;
import java.io.File;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class LaunchzPICLPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
LaunchzPICLPreferenceConstants {
    private Button fSecureChannelEnableButton;
    private Text fKeyStoreFileNameField;
    private Text fKeyStorePasswordField;
    private Button fKeyStoreFileNameBrowse;
    private boolean fSecureChannelEnabled;
    private String fKeyStoreFileName = LaunchzPICLPreferences.getZPICLKeyStoreFile();
    private char[] fKeyStorePassword = LaunchzPICLPreferences.getZPICLKeyStorePassword((String)this.fKeyStoreFileName);
    private ScopedPreferenceStore fTerminateActionPreferences;
    private Button fTerminate;
    private Button fTerminateAndAbend;
    private boolean fDisableProfiles;
    private Button fDisableProfilesButton;
    private boolean fGenericProfiles;
    private Button fGenericProfilesButton;
    private boolean fIgnoreSSLCertError;
    private Button fIgnoreSSLCertErrorButton;
    private boolean fSynchronizeProfilesOnRseConn;
    private Button fSynchronizeProfilesOnRseConnButton;
    private Button fDisconnect;
    private Button fDisconnectTask;
    private Button fDisconnectPrompt;
    private boolean fTokenAuthEnabled;
    private Button fTokenAuthEnabledButton;

    public LaunchzPICLPreferencePage() {
        super(LaunchzPICLLabels.LaunchzPICLPreferencePage_label);
        this.fSecureChannelEnabled = LaunchzPICLPreferences.zPICLSecureChannelEnabled();
        this.fTerminateActionPreferences = PreferenceUI.getPreferenceStore();
        this.fDisableProfiles = LaunchzPICLPreferences.getProfilesDisabledOnbWorkbenchShutdown();
        this.fGenericProfiles = LaunchzPICLPreferences.getIsGenericEditorWarningNeeded();
        this.fIgnoreSSLCertError = LaunchzPICLPreferences.getIsSSLCertErrorIgnored();
        this.fSynchronizeProfilesOnRseConn = LaunchzPICLPreferences.getisSynchronizeProfiles();
        this.fTokenAuthEnabled = LaunchzPICLPreferences.getIsTokenAuthenticationEnabled();
    }

    public void init(IWorkbench workbench) {
    }

    public Control createContents(Composite parent) {
        Composite compositeForBoth = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compositeForBoth.setLayout((Layout)gl);
        this.createProfilesGroup(compositeForBoth);
        Composite subComposite = new Composite(compositeForBoth, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(subComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subComposite);
        this.createTerminateActionGroup(subComposite);
        this.createDisconnectActionGroup(subComposite);
        this.createContentsLaunchzPICLSecureGroup(compositeForBoth);
        this.createContentsLaunchzPICLMainGroup(compositeForBoth);
        this.setFieldEnablement();
        Dialog.applyDialogFont((Control)compositeForBoth);
        return compositeForBoth;
    }

    private void createProfilesGroup(Composite compositeForBoth) {
        Group profilesGroup = new Group(compositeForBoth, 0);
        profilesGroup.setLayoutData((Object)new GridData(768));
        profilesGroup.setText(LaunchzPICLLabels.PROFILE_MGT_GROUP);
        GridLayoutFactory.swtDefaults().applyTo((Composite)profilesGroup);
        this.fDisableProfilesButton = new Button((Composite)profilesGroup, 32);
        this.fDisableProfilesButton.setText(LaunchzPICLLabels.PROFILE_SHUTDOWN_ACTION);
        this.fDisableProfilesButton.setSelection(this.fDisableProfiles);
        this.fSynchronizeProfilesOnRseConnButton = new Button((Composite)profilesGroup, 32);
        this.fSynchronizeProfilesOnRseConnButton.setText(LaunchzPICLLabels.SYNCHRONIZE_PROFILES_ON_RSE_CONN);
        this.fSynchronizeProfilesOnRseConnButton.setSelection(this.fSynchronizeProfilesOnRseConn);
        this.fGenericProfilesButton = new Button((Composite)profilesGroup, 32);
        this.fGenericProfilesButton.setText(LaunchzPICLLabels.PROFILE_GENERIC);
        this.fGenericProfilesButton.setSelection(this.fGenericProfiles);
        this.fIgnoreSSLCertErrorButton = new Button((Composite)profilesGroup, 32);
        this.fIgnoreSSLCertErrorButton.setText(LaunchzPICLLabels.IGNORE_SSL_CERT_ERRORS);
        this.fIgnoreSSLCertErrorButton.setSelection(this.fIgnoreSSLCertError);
        this.fTokenAuthEnabledButton = new Button((Composite)profilesGroup, 32);
        this.fTokenAuthEnabledButton.setText(LaunchzPICLLabels.ENABLE_TOKEN_AUTH);
        this.fTokenAuthEnabledButton.setSelection(this.fTokenAuthEnabled);
    }

    public void performDefaults() {
        IEclipsePreferences pref = ConfigurationScope.INSTANCE.getNode("com.ibm.debug.pdt.launch.zpicl");
        this.fSecureChannelEnableButton.setSelection(pref.getBoolean("SecureChannelEnabled", false));
        this.setFieldEnablement();
        this.fKeyStoreFileNameField.setText(pref.get("KeyStoreFile", ""));
        this.fKeyStorePasswordField.setText("");
        String terminateAction = this.fTerminateActionPreferences.getDefaultString("preference.terminate");
        this.fTerminate.setSelection(terminateAction.equals("terminate"));
        this.fTerminateAndAbend.setSelection(terminateAction.equals("abend"));
        this.fDisableProfilesButton.setSelection(pref.getBoolean("DisableProfilesOnShutdown", true));
        this.fGenericProfilesButton.setSelection(pref.getBoolean("ShowWarningInDebugProfileEditor", true));
        this.fIgnoreSSLCertErrorButton.setSelection(pref.getBoolean("IgnoreSSLCertErrors", false));
        this.fSynchronizeProfilesOnRseConnButton.setSelection(pref.getBoolean("SynchronizeProfilesOnRseConn", true));
        this.fTokenAuthEnabledButton.setSelection(pref.getBoolean("TokenAuthenticationEnabled", true));
        String disconnectString = PreferenceUI.getPreferenceStore().getDefaultString("preference.disconnect");
        int disconnectType = 0;
        if (disconnectString != null && disconnectString.equals("ProcessKeep")) {
            disconnectType = 1;
        } else if (disconnectString != null && disconnectString.equals("ProcessPrompt")) {
            disconnectType = Integer.MAX_VALUE;
        }
        this.setDisconnectSelection(disconnectType);
        super.performDefaults();
    }

    public boolean performOk() {
        this.fSecureChannelEnabled = this.fSecureChannelEnableButton.getSelection();
        this.fKeyStoreFileName = this.fKeyStoreFileNameField.getText();
        this.fKeyStorePassword = this.fKeyStorePasswordField.getText().toCharArray();
        if (this.fSecureChannelEnabled && this.fKeyStoreFileNameField.getText().trim().length() <= 0) {
            return false;
        }
        this.fDisableProfiles = this.fDisableProfilesButton.getSelection();
        this.fGenericProfiles = this.fGenericProfilesButton.getSelection();
        this.fIgnoreSSLCertError = this.fIgnoreSSLCertErrorButton.getSelection();
        this.fSynchronizeProfilesOnRseConn = this.fSynchronizeProfilesOnRseConnButton.getSelection();
        this.fTokenAuthEnabled = this.fTokenAuthEnabledButton.getSelection();
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.launch.zpicl");
        pref.put("KeyStoreFile", this.fKeyStoreFileName);
        pref.putBoolean("SecureChannelEnabled", this.fSecureChannelEnabled);
        pref.putBoolean("DisableProfilesOnShutdown", this.fDisableProfiles);
        pref.putBoolean("ShowWarningInDebugProfileEditor", this.fGenericProfiles);
        pref.putBoolean("IgnoreSSLCertErrors", this.fIgnoreSSLCertError);
        pref.putBoolean("SynchronizeProfilesOnRseConn", this.fSynchronizeProfilesOnRseConn);
        pref.putBoolean("TokenAuthenticationEnabled", this.fTokenAuthEnabled);
        String terminateAction = "preference.terminate";
        if (this.fTerminate.getSelection()) {
            terminateAction = "terminate";
        } else if (this.fTerminateAndAbend.getSelection()) {
            terminateAction = "abend";
        }
        this.fTerminateActionPreferences.setValue("preference.terminate", terminateAction);
        String disconnectType = "ProcessRelease";
        if (this.fDisconnectPrompt.getSelection()) {
            disconnectType = "ProcessPrompt";
        } else if (this.fDisconnectTask.getSelection()) {
            disconnectType = "ProcessKeep";
        }
        PreferenceUI.getPreferenceStore().setValue("preference.disconnect", disconnectType);
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
        }
        LaunchzPICLPreferences.setZPICLKeyStorePassword((char[])this.fKeyStorePassword);
        return super.performOk();
    }

    public void createContentsLaunchzPICLMainGroup(Composite compositeForBoth) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.debug.pdt.launch.zpicl.ui.zpicl_preference_page");
    }

    private void createContentsLaunchzPICLSecureGroup(Composite compositeForBoth) {
        Group secureGroup = new Group(compositeForBoth, 0);
        GridData secureGridData = new GridData(768);
        secureGroup.setLayoutData((Object)secureGridData);
        secureGroup.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_SecureChannelGroupLabel);
        GridLayout secureGroupGridLayout = new GridLayout();
        secureGroupGridLayout.numColumns = 1;
        secureGroup.setLayout((Layout)secureGroupGridLayout);
        this.createContentsSecureGroupSecureChannel(secureGroup);
        this.installSeparator((Composite)secureGroup, 10);
        this.createContentsSecureGroupKeyStoreFile(secureGroup);
    }

    private void createTerminateActionGroup(Composite compositeForBoth) {
        Group terminateActionGroup = new Group(compositeForBoth, 0);
        GridData terminateActionGridData = new GridData(1808);
        terminateActionGroup.setLayoutData((Object)terminateActionGridData);
        terminateActionGroup.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_TerminateActionGroupLabel);
        GridLayout terminateActionGridLayout = new GridLayout();
        terminateActionGridLayout.numColumns = 1;
        terminateActionGroup.setLayout((Layout)terminateActionGridLayout);
        String terminateAction = this.fTerminateActionPreferences.getString("preference.terminate");
        this.fTerminate = new Button((Composite)terminateActionGroup, 16);
        this.fTerminate.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_TerminateLabel);
        this.fTerminate.setSelection(terminateAction.equals("terminate"));
        this.fTerminateAndAbend = new Button((Composite)terminateActionGroup, 16);
        this.fTerminateAndAbend.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_TerminateAndAbendLabel);
        this.fTerminateAndAbend.setSelection(terminateAction.equals("abend"));
    }

    private void createDisconnectActionGroup(Composite compositeForBoth) {
        Group disconnectActionGroup = new Group(compositeForBoth, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)disconnectActionGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)disconnectActionGroup);
        disconnectActionGroup.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_DISCONNECT_ACTION);
        this.fDisconnect = new Button((Composite)disconnectActionGroup, 16);
        this.fDisconnect.setText("QUIT DEBUG");
        this.fDisconnectTask = new Button((Composite)disconnectActionGroup, 16);
        this.fDisconnectTask.setText("QUIT DEBUG TASK");
        this.fDisconnectPrompt = new Button((Composite)disconnectActionGroup, 16);
        this.fDisconnectPrompt.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_PROMPT);
        this.setDisconnectSelection(PreferenceUI.getDisconnectType());
    }

    private void setDisconnectSelection(int disconnectType) {
        this.fDisconnect.setSelection(disconnectType == 0);
        this.fDisconnectTask.setSelection(disconnectType == 1);
        this.fDisconnectPrompt.setSelection(disconnectType == Integer.MAX_VALUE);
    }

    private void installSeparator(Composite parent, int verticalSpacing) {
        Label separator = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = verticalSpacing;
        separator.setLayoutData((Object)gridData);
    }

    private void setFieldEnablement() {
        this.fSecureChannelEnabled = this.fSecureChannelEnableButton.getSelection();
        this.fKeyStoreFileNameField.setEnabled(this.fSecureChannelEnabled);
        this.fKeyStorePasswordField.setEnabled(this.fSecureChannelEnabled);
        this.fKeyStoreFileNameBrowse.setEnabled(this.fSecureChannelEnabled);
    }

    private void createContentsSecureGroupSecureChannel(Group SecureGroup) {
        Composite securePortEnableComposite = new Composite((Composite)SecureGroup, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        securePortEnableComposite.setLayout((Layout)gl);
        securePortEnableComposite.setLayoutData((Object)new GridData(1808));
        this.fSecureChannelEnableButton = new Button(securePortEnableComposite, 32);
        this.fSecureChannelEnableButton.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_overrideKeystoreLabel);
        this.fSecureChannelEnableButton.setSelection(this.fSecureChannelEnabled);
        this.fSecureChannelEnableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LaunchzPICLPreferencePage.this.setFieldEnablement();
                LaunchzPICLPreferencePage.this.validateFields();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createContentsSecureGroupKeyStoreFile(Group SecureGroup) {
        Composite keystoreFileComposite = new Composite((Composite)SecureGroup, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        keystoreFileComposite.setLayout((Layout)gl);
        keystoreFileComposite.setLayoutData((Object)new GridData(1808));
        Label keyStoreFileLabel = new Label(keystoreFileComposite, 0);
        keyStoreFileLabel.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_KeyStoreFileName);
        GridData keystoreGridData = new GridData(128);
        keyStoreFileLabel.setLayoutData((Object)keystoreGridData);
        this.fKeyStoreFileNameField = new Text(keystoreFileComposite, 2052);
        keystoreGridData = new GridData(768);
        keystoreGridData.horizontalSpan = 1;
        this.fKeyStoreFileNameField.setLayoutData((Object)keystoreGridData);
        this.fKeyStoreFileNameField.setText(this.fKeyStoreFileName);
        this.fKeyStoreFileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchzPICLPreferencePage.this.setValid(true);
                LaunchzPICLPreferencePage.this.setErrorMessage(null);
                LaunchzPICLPreferencePage.this.validateKeystoreFileName();
                LaunchzPICLPreferencePage.this.validateFields();
            }
        });
        this.fKeyStoreFileNameBrowse = new Button(keystoreFileComposite, 8);
        this.fKeyStoreFileNameBrowse.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_KeyStoreChooseFile);
        keystoreGridData = new GridData(32);
        this.fKeyStoreFileNameBrowse.setLayoutData((Object)keystoreGridData);
        this.fKeyStoreFileNameBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(LaunchzPICLPreferencePage.this.getShell());
                fd.setFilterPath(LaunchzPICLPreferencePage.this.fKeyStoreFileName);
                fd.setFilterExtensions(new String[]{"*.kdb", "*.*"});
                String newDir = fd.open();
                if (newDir != null) {
                    LaunchzPICLPreferencePage.this.fKeyStoreFileName = newDir;
                    LaunchzPICLPreferencePage.this.fKeyStoreFileNameField.setText(LaunchzPICLPreferencePage.this.fKeyStoreFileName);
                }
                LaunchzPICLPreferencePage.this.setValid(true);
                LaunchzPICLPreferencePage.this.setErrorMessage(null);
                LaunchzPICLPreferencePage.this.validateKeystoreFileName();
                LaunchzPICLPreferencePage.this.validateFields();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite keystorePasswordComposite = new Composite((Composite)SecureGroup, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        keystorePasswordComposite.setLayout((Layout)gl);
        keystorePasswordComposite.setLayoutData((Object)new GridData(1808));
        Label keyStorePasswordLabel = new Label(keystorePasswordComposite, 0);
        keyStorePasswordLabel.setText(LaunchzPICLLabels.LaunchzPICLPreferencePage_KeyStorePassword);
        keystoreGridData = new GridData(128);
        keyStorePasswordLabel.setLayoutData((Object)keystoreGridData);
        this.fKeyStorePasswordField = new Text(keystorePasswordComposite, 2052);
        GridData passwordGD = new GridData(256);
        passwordGD.grabExcessHorizontalSpace = true;
        this.fKeyStorePasswordField.setLayoutData((Object)passwordGD);
        this.fKeyStorePasswordField.setEchoChar('*');
        this.fKeyStorePasswordField.setText(String.valueOf(this.fKeyStorePassword));
        this.fKeyStorePasswordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchzPICLPreferencePage.this.setValid(true);
                LaunchzPICLPreferencePage.this.setErrorMessage(null);
                LaunchzPICLPreferencePage.this.fKeyStorePassword = LaunchzPICLPreferencePage.this.fKeyStorePasswordField.getText().toCharArray();
                LaunchzPICLPreferencePage.this.validateFields();
            }
        });
    }

    private void validateFields() {
        this.validateKeystoreFileName();
    }

    private void validateKeystoreFileName() {
        if (this.fKeyStoreFileName != null && this.fKeyStoreFileNameField.isEnabled() && this.getErrorMessage() == null) {
            File file = new File(this.fKeyStoreFileNameField.getText());
            if (this.fKeyStoreFileNameField.getText().trim().length() <= 0 || !file.exists() || !file.isFile()) {
                String errorMsg = LaunchzPICLMessages.CRRDG7825;
                this.setValid(false);
                this.setErrorMessage(errorMsg);
            }
        }
    }
}

