/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.Labels;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences.LPEXUtilities;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class JobCardFieldEditor
extends FieldEditor
implements LpexDocumentListener {
    private String fPreferenceKey;
    private Group fMainComposite;
    private LpexView fLpexView;
    private IPreferencePageContainer fContainer;

    public JobCardFieldEditor(Composite parent, String prefKey, IPreferencePageContainer container) {
        this.fPreferenceKey = prefKey;
        this.setPreferenceName(this.fPreferenceKey);
        this.fContainer = container;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridDataFactory.fillDefaults().grab(true, false).span(numColumns, 1).applyTo((Control)this.fMainComposite);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fMainComposite = new Group(parent, 0);
        this.fMainComposite.setText(Labels.JOB_CARD);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)this.fMainComposite);
        this.adjustForNumColumns(numColumns);
        this.fLpexView = LPEXUtilities.createLpexWindowAndView((Composite)this.fMainComposite, this.fContainer, false, this, 5, 1, -1);
    }

    protected void doLoad() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fLpexView != null) {
            LPEXUtilities.resetLPEXContent(this.fLpexView, store.getString(this.fPreferenceKey));
        }
    }

    protected void doLoadDefault() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fLpexView != null) {
            LPEXUtilities.resetLPEXContent(this.fLpexView, store.getDefaultString(this.fPreferenceKey));
        }
    }

    protected void doStore() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fLpexView != null) {
            store.setValue(this.fPreferenceKey, this.fLpexView.text());
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void documentChanged(LpexView arg0, int arg1, int arg2, int arg3, int arg4) {
        String newValue;
        IPreferenceStore store = this.getPreferenceStore();
        String oldValue = store.getString(this.fPreferenceKey);
        if (!oldValue.equals(newValue = this.fLpexView.text())) {
            this.fireValueChanged(this.fPreferenceKey, oldValue, newValue);
        }
        this.setPresentsDefaultValue(newValue.equals(store.getDefaultString(this.fPreferenceKey)));
    }

    public void setFocus() {
        this.fLpexView.window().setFocus();
    }
}

