/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences.IMVSBatchPreferenceConstants;
import com.ibm.ftt.debug.ui.composites.DebugOptionsComposite;
import com.ibm.ftt.debug.ui.composites.IDebugOptionsCompositeListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DebugOptionsFieldEditor
extends FieldEditor
implements IDebugOptionsCompositeListener,
IMVSBatchPreferenceConstants {
    private static final String DEBUG_OPTIONS = "DebugOptions";
    private static final String EMPTY = "";
    DebugOptionsComposite fDebugOptions = null;
    private String fTestKey;
    private String fPromptKey;
    private String fErrorKey;
    private String fCommandsKey;
    private String fPreferencesKey;
    private String fDebugLibKey;
    private boolean fIsValid = true;

    public DebugOptionsFieldEditor(Composite parent, String testKey, String errorKey, String promptKey, String commandsKey, String preferencesKey, String debugLibKey) {
        this.setPreferenceName(DEBUG_OPTIONS);
        this.fTestKey = testKey;
        this.fErrorKey = errorKey;
        this.fPromptKey = promptKey;
        this.fCommandsKey = commandsKey;
        this.fPreferencesKey = preferencesKey;
        this.fDebugLibKey = debugLibKey;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridDataFactory.fillDefaults().grab(true, false).span(numColumns, 1).applyTo((Control)this.fDebugOptions);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fDebugOptions = new DebugOptionsComposite(parent, (IDebugOptionsCompositeListener)this, true, true, true, false, false, true, true, false);
        this.fDebugOptions.setSystemFilter("*");
        this.adjustForNumColumns(numColumns);
    }

    protected void doLoad() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fDebugOptions != null) {
            String test = store.getString(this.fTestKey);
            String error = store.getString(this.fErrorKey);
            String prompt = store.getString(this.fPromptKey);
            String commands = store.getString(this.fCommandsKey);
            String preferences = store.getString(this.fPreferencesKey);
            String debugLib = store.getString(this.fDebugLibKey);
            this.fDebugOptions.setInitialValues(false, test, error, prompt, EMPTY, null, commands, preferences, null, debugLib);
        }
    }

    protected void doLoadDefault() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fDebugOptions != null) {
            String test = store.getDefaultString(this.fTestKey);
            String error = store.getDefaultString(this.fErrorKey);
            String prompt = store.getDefaultString(this.fPromptKey);
            String commands = store.getDefaultString(this.fCommandsKey);
            String preferences = store.getDefaultString(this.fPreferencesKey);
            String debugLib = store.getDefaultString(this.fDebugLibKey);
            this.fDebugOptions.setInitialValues(false, test, error, prompt, EMPTY, null, commands, preferences, null, debugLib);
        }
    }

    protected void doStore() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fDebugOptions != null) {
            store.setValue("com.ibm.debug.pdt.idz.launches.mvs.test", this.fDebugOptions.getTestOption());
            store.setValue("com.ibm.debug.pdt.idz.launches.mvs.error", this.fDebugOptions.getTestLevel());
            store.setValue("com.ibm.debug.pdt.idz.launches.mvs.prompt", this.fDebugOptions.getPrompt());
            store.setValue("com.ibm.debug.pdt.idz.launches.mvs.command", this.fDebugOptions.getCommandsDatasetString());
            store.setValue("com.ibm.debug.pdt.idz.launches.mvs.preference", this.fDebugOptions.getPreferenceDatasetString());
            store.setValue("com.ibm.debug.pdt.idz.launches.mvs.debugLib", this.fDebugOptions.getDebugLibDatasetString());
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.checkValues();
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.checkValues();
    }

    private void checkValues() {
        this.checkValue(this.fTestKey, this.fDebugOptions.getTestOption());
        this.checkValue(this.fErrorKey, this.fDebugOptions.getTestLevel());
        this.checkValue(this.fPromptKey, this.fDebugOptions.getPrompt());
        this.checkValue(this.fCommandsKey, this.fDebugOptions.getCommandsDatasetString());
        this.checkValue(this.fPreferencesKey, this.fDebugOptions.getPreferenceDatasetString());
        this.checkValue(this.fDebugLibKey, this.fDebugOptions.getDebugLibDatasetString());
        this.refreshValidState();
    }

    protected void refreshValidState() {
        if (this.fDebugOptions != null) {
            String error = this.fDebugOptions.getErrorText();
            boolean oldValue = this.fIsValid;
            boolean bl = this.fIsValid = error == null || error.isEmpty();
            if (this.fIsValid != oldValue) {
                this.fireStateChanged("field_editor_is_valid", oldValue, this.fIsValid);
            }
        }
    }

    public boolean isValid() {
        this.refreshValidState();
        return this.fIsValid;
    }

    public void setFocus() {
        this.fDebugOptions.setFocus();
    }

    private void checkValue(String property, String newValue) {
        IPreferenceStore store = this.getPreferenceStore();
        String oldValue = store.getString(property);
        if (!oldValue.equals(newValue)) {
            this.fireValueChanged(property, oldValue, newValue);
        }
        this.setPresentsDefaultValue(false);
    }

    public void modifyText(ModifyEvent arg0) {
        this.checkValues();
    }
}

