/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.Labels;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences.LPEXUtilities;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences.MVSBatchPreferenceUtils;
import com.ibm.debug.pdt.profile.internal.compatibility.DebugCompatibilityMessages;
import com.ibm.ftt.debug.ui.Messages;
import com.ibm.ftt.debug.ui.composites.DebugOptionsComposite;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.composites.ISourceLookupCompositeListener;
import com.ibm.ftt.debug.ui.composites.SourceLookupComposite;
import com.ibm.ftt.debug.ui.tabs.IPropertyGroupProvider;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MVSBatchAdditionalJCLOptionsTab
extends AbstractLaunchConfigurationTab
implements LpexDocumentListener,
IJCLLaunchConstants,
ISourceLookupCompositeListener {
    private LpexView fLpexView = null;
    private SourceLookupComposite fSourceLookupComposite = null;
    private IConnectionProvider fProvider = null;

    public MVSBatchAdditionalJCLOptionsTab(IPropertyGroupProvider maintab) {
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.setControl((Control)parent);
        Group group = new Group(parent, 0);
        group.setText(Labels.JOB_CARD);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)group);
        this.fLpexView = LPEXUtilities.createLpexWindowAndView((Composite)group, this.getShell(), false, this, 5, 1, -1);
        group.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MVSBatchAdditionalJCLOptionsTab.this.fLpexView.dispose();
                MVSBatchAdditionalJCLOptionsTab.this.fLpexView = null;
            }
        });
        new Label(parent, 0);
        this.fSourceLookupComposite = new SourceLookupComposite((ISourceLookupCompositeListener)this, parent, 0, true);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.fSourceLookupComposite);
        this.fSourceLookupComposite.setConnectionProvider(this.fProvider);
        Link preferencesLink = new Link(parent, 0);
        preferencesLink.setText(Messages.MainTab_8);
        GridDataFactory.fillDefaults().align(131072, 1024).grab(true, true).applyTo((Control)preferencesLink);
        preferencesLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String preferencePageId = "com.ibm.debug.pdt.idz.launches.jclGeneration";
                PreferencesUtil.createPreferenceDialogOn((Shell)MVSBatchAdditionalJCLOptionsTab.this.getShell(), (String)preferencePageId, (String[])new String[]{preferencePageId}, null).open();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.debug.pdt.idz.launches.mvsbatch.additional_jcl_options_tab");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("JOB_CARD", MVSBatchPreferenceUtils.getJobCard());
        configuration.setAttribute("SOURCE_LOOKUP", MVSBatchPreferenceUtils.getSourceLookup());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            LPEXUtilities.resetLPEXContent(this.fLpexView, configuration.getAttribute("JOB_CARD", MVSBatchPreferenceUtils.getJobCard()));
            if (this.fSourceLookupComposite != null) {
                this.fSourceLookupComposite.setInitialValues(configuration.getAttribute("SOURCE_LOOKUP", MVSBatchPreferenceUtils.getSourceLookup()));
            }
        }
        catch (CoreException e) {
            MvsBatchLaunchPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fLpexView != null) {
            configuration.setAttribute("JOB_CARD", this.fLpexView.text());
        }
        if (this.fSourceLookupComposite != null) {
            configuration.setAttribute("SOURCE_LOOKUP", this.fSourceLookupComposite.getListString());
        }
    }

    public String getName() {
        return Labels.ADDITIONAL_JCL;
    }

    public void documentChanged(LpexView arg0, int arg1, int arg2, int arg3, int arg4) {
        this.updateLaunchConfigurationDialog();
    }

    public void sourceLookupListChanged() {
        this.updateLaunchConfigurationDialog();
    }

    public boolean validate(Text dataset, boolean isUssAllowed) {
        boolean isValid;
        block10: {
            this.setErrorMessage(null);
            if (this.fProvider == null) {
                return false;
            }
            String path = dataset.getText();
            isValid = false;
            if (path.startsWith("/")) {
                if (!isUssAllowed) {
                    this.setErrorMessage(NLS.bind((String)DebugCompatibilityMessages.CRRDG8039, (Object)path));
                } else {
                    String conn = this.fProvider.getConnection() != null ? this.fProvider.getConnection().getName() : null;
                    IHost host = DebugOptionsComposite.getHost((String)conn);
                    IRemoteFileSubSystem fs = RemoteFileUtility.getFileSubSystem((IHost)host);
                    try {
                        IRemoteFile f = fs.getRemoteFileObject(path, (IProgressMonitor)new NullProgressMonitor());
                        if (!f.exists()) {
                            this.setErrorMessage(NLS.bind((String)DebugCompatibilityMessages.CRRDG8020, (Object)path));
                            break block10;
                        }
                        isValid = true;
                    }
                    catch (SystemMessageException e) {
                        this.setErrorMessage(NLS.bind((String)DebugCompatibilityMessages.CRRDG8020, (Object)path));
                    }
                }
            } else {
                String errMsg = DebugLaunchUIUtils.isDatasetOrMemberNameExist((String)this.fProvider.getConnection().getName(), (String)path);
                if (errMsg != null) {
                    this.setErrorMessage(NLS.bind((String)DebugCompatibilityMessages.CRRDG8020, (Object)path));
                } else {
                    isValid = true;
                }
            }
        }
        this.getLaunchConfigurationDialog().updateMessage();
        return isValid;
    }

    public Image getImage() {
        return MvsBatchLaunchPlugin.getDefault().getImageRegistry().get("icons/JCL.png");
    }

    public void setConnectionProvider(IConnectionProvider provider) {
        this.fProvider = provider;
        if (this.fSourceLookupComposite != null) {
            this.fSourceLookupComposite.setConnectionProvider(this.fProvider);
        }
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }
}

