/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.Messages;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebugEngineCommandLogResponseEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineTerminatedEvent;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.MessageReceivedEvent;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessAddedEvent;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.etools.zos.subsystem.jes.JESSubSystem;
import com.ibm.etools.zos.subsystem.jes.JMConnection;
import com.ibm.etools.zos.subsystem.jes.actions.job.OpenJESJobAction;
import com.ibm.etools.zos.subsystem.jes.model.JESJob;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.zos.PBResourceMvsUtils;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class JobStatusDebugTarget
implements IDebugTarget,
IDebugEngineEventListener {
    private static final String ABEND_RC = "ABEND";
    private static final String JCLERROR_RC = "JCLERROR";
    private boolean fMessageDisplayed = false;
    private ILaunch fLaunch;
    private IZOSSystemImage fConnection;
    private String fStatus = Messages.CRRDG8404;
    private JobThread fJob;
    private String fJobId;
    private boolean fcomplete;

    public JobStatusDebugTarget(ILaunch launch, IZOSSystemImage connection) {
        IDebugTarget target;
        IDebugTarget[] targets;
        assert (launch != null);
        this.fLaunch = launch;
        IDebugTarget[] iDebugTargetArray = targets = this.fLaunch.getDebugTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            target = iDebugTargetArray[n2];
            this.fLaunch.removeDebugTarget(target);
            ++n2;
        }
        this.fLaunch.addDebugTarget((IDebugTarget)this);
        iDebugTargetArray = targets;
        n = targets.length;
        n2 = 0;
        while (n2 < n) {
            target = iDebugTargetArray[n2];
            this.fLaunch.addDebugTarget(target);
            ++n2;
        }
        this.fConnection = connection;
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
    }

    public void setJobId(String jobId) {
        this.fJob = new JobThread(jobId, this.fConnection, this);
        this.fJob.setDaemon(true);
        this.fJob.start();
        this.fJobId = jobId;
    }

    public String getModelIdentifier() {
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean canTerminate() {
        boolean canTerminate = true;
        IDebugTarget[] iDebugTargetArray = this.fLaunch.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget t = iDebugTargetArray[n2];
            if (t != this && !(canTerminate &= t.canTerminate() || t.isTerminated())) break;
            ++n2;
        }
        return canTerminate;
    }

    public boolean isTerminated() {
        if (this.fLaunch.getDebugTargets().length == 1) {
            this.checkLaunchStatus(false);
            return this.fcomplete;
        }
        boolean terminated = true;
        IDebugTarget[] iDebugTargetArray = this.fLaunch.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget t = iDebugTargetArray[n2];
            if (t != this && !(terminated &= t.isTerminated())) break;
            ++n2;
        }
        if (terminated) {
            this.checkLaunchStatus(false);
        }
        return terminated;
    }

    public void terminate() throws DebugException {
        this.terminateJob();
        this.checkLaunchStatus(true);
    }

    private void terminateJob() {
        JESSubSystem jSubSystem;
        if (this.fJobId != null && (jSubSystem = PBResourceMvsUtils.getJMSubSystem((IOSImage)this.fConnection)) != null) {
            try {
                JESJob[] jobs = jSubSystem.getJobs(NLS.bind((String)"*;*;*;*;*;{0}", (Object)this.fJobId));
                if (jobs != null && jobs.length == 1) {
                    JESJob j = jobs[0];
                    JMConnection jm = jSubSystem.getJMConnection();
                    if (!j.getJobCompleted()) {
                        jm.cancel(this.fJobId);
                    }
                }
            }
            catch (Exception e) {
                MvsBatchLaunchPlugin.log(e);
            }
        }
    }

    private void checkLaunchStatus(boolean waitForEndOfJob) {
        JESSubSystem jSubSystem;
        if (!this.fcomplete && this.fJobId != null && (jSubSystem = PBResourceMvsUtils.getJMSubSystem((IOSImage)this.fConnection)).isConnected()) {
            try {
                JESJob[] jobs = jSubSystem.getJobs(NLS.bind((String)"*;*;*;*;*;{0}", (Object)this.fJobId));
                if (jobs != null && jobs.length == 1) {
                    JESJob j = jobs[0];
                    if (j.getJobCompleted()) {
                        this.fStatus = NLS.bind((String)Messages.CRRDG8403, (Object[])new String[]{this.fJobId, j.getReturnInfo() + " " + j.getReturnCode()});
                        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
                        this.fcomplete = true;
                        boolean isRunMode = this.getLaunch().getLaunchMode().equals("run");
                        if (j.getReturnInfo().equals(JCLERROR_RC) || j.getReturnStatus().equals(ABEND_RC) && (isRunMode || !this.isDebugOrCodeCoverageSession())) {
                            this.showJobMessage(j);
                        }
                        if (isRunMode) {
                            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
                        }
                    } else {
                        jSubSystem.updateJobStatus(j);
                        this.fcomplete = false;
                        if (waitForEndOfJob) {
                            this.checkLaunchStatus(waitForEndOfJob);
                        }
                    }
                } else {
                    this.fStatus = NLS.bind((String)Messages.CRRDG8400, (Object[])new String[]{this.fJobId});
                    this.fcomplete = waitForEndOfJob;
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private boolean isDebugOrCodeCoverageSession() {
        IDebugTarget[] targets;
        if (this.getLaunch() != null && (targets = this.getLaunch().getDebugTargets()).length > 1) {
            if (targets[1] instanceof PDTDebugElement) {
                return ((PDTDebugElement)targets[1]).getEngineSession() != null;
            }
            if (targets[1] instanceof IPDTDebugTarget) {
                return ((IPDTDebugTarget)targets[1]).getDebugEngine() != null && ((IPDTDebugTarget)targets[1]).getDebugEngine().getEngineSession() != null;
            }
        }
        return false;
    }

    private synchronized void showJobMessage(final JESJob j) {
        if (!this.fMessageDisplayed && PICLDebugPlugin.showQuestionDialog((String)PICLLabels.MessageDialog_title_Warning, (String)NLS.bind((String)Messages.CRRDG8413, (Object[])new Object[]{this.fJobId, j.getReturnCode()}))) {
            final Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    OpenJESJobAction action = new OpenJESJobAction(display.getActiveShell());
                    action.setSelection((ISelection)new StructuredSelection(new Object[]{j}));
                    action.run();
                }
            });
        }
        this.fMessageDisplayed = true;
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
    }

    public void suspend() throws DebugException {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] EMPTY_THREADS = new IThread[]{};
        return EMPTY_THREADS;
    }

    public boolean hasThreads() throws DebugException {
        return false;
    }

    public String getName() throws DebugException {
        return this.fStatus;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public void commandLogResponse(DebugEngineCommandLogResponseEvent event) {
    }

    public void debugEngineTerminated(DebugEngineTerminatedEvent event) {
        this.checkLaunchStatus(false);
    }

    public void processAdded(ProcessAddedEvent event) {
    }

    public void errorOccurred(ErrorOccurredEvent event) {
    }

    public void messageReceived(MessageReceivedEvent event) {
    }

    public void modelStateChanged(ModelStateReadyEvent event) {
    }

    void setMessage(String message) {
        this.fStatus = message;
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
    }

    public JESJob getJob() {
        if (this.fJobId != null) {
            JESSubSystem jSubSystem = PBResourceMvsUtils.getJMSubSystem((IOSImage)this.fConnection);
            try {
                JESJob[] jobs = jSubSystem.getJobs(NLS.bind((String)"*;*;*;*;*;{0}", (Object)this.fJobId));
                if (jobs != null && jobs.length == 1) {
                    return jobs[0];
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getJobID() {
        return this.fJobId;
    }

    static class JobThread
    extends Thread {
        private String fJobId;
        private IZOSSystemImage fConnection;
        private JobStatusDebugTarget fDebugTarget;

        public JobThread(String jobId, IZOSSystemImage connection, JobStatusDebugTarget debugTarget) {
            this.setName("Tracking job status:" + jobId);
            this.fJobId = jobId;
            this.fConnection = connection;
            this.fDebugTarget = debugTarget;
        }

        @Override
        public void run() {
            JESSubSystem jSubSystem = PBResourceMvsUtils.getJMSubSystem((IOSImage)this.fConnection);
            boolean jobStartedOk = false;
            boolean jobCompleted = false;
            boolean isRunMode = this.fDebugTarget.getLaunch().getLaunchMode().equals("run");
            int jobCounter = 10;
            boolean oneMore = false;
            boolean added = false;
            while (this.fConnection.isConnected() && !this.fDebugTarget.getLaunch().isTerminated()) {
                IProcess[] processes = this.fDebugTarget.getLaunch().getProcesses();
                jobStartedOk = !isRunMode && this.isProcessesTerminated(processes);
                IDebugTarget pdtTarget = this.fDebugTarget.getLaunch().getDebugTarget();
                if (!added && pdtTarget instanceof IPDTDebugTarget && ((IPDTDebugTarget)pdtTarget).getDebugEngine() != null) {
                    ((IPDTDebugTarget)pdtTarget).getDebugEngine().addEventListener((IDebugEngineEventListener)this.fDebugTarget);
                    added = true;
                }
                try {
                    JESJob[] jobs = jSubSystem.getJobs(NLS.bind((String)"*;*;*;*;*;{0}", (Object)this.fJobId));
                    if (jobs != null && jobs.length == 1) {
                        JESJob j = jobs[0];
                        jSubSystem.updateJobStatus(j);
                        if (j.getJobCompleted()) {
                            if (!this.fDebugTarget.fcomplete) {
                                this.fDebugTarget.fStatus = NLS.bind((String)Messages.CRRDG8403, (Object[])new String[]{this.fJobId, j.getReturnInfo() + " " + j.getReturnCode()});
                                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this.fDebugTarget, 16, 512)});
                            }
                            jobCompleted = true;
                            break;
                        }
                        this.fDebugTarget.fStatus = NLS.bind((String)Messages.CRRDG8402, (Object[])new String[]{this.fJobId, j.getJobPhase()});
                        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this.fDebugTarget, 16, 512)});
                        if (oneMore) break;
                        Thread.sleep(5000L);
                        continue;
                    }
                    if (jobCounter-- < 0 && this.fDebugTarget.isTerminated()) break;
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    if (oneMore) break;
                    oneMore = true;
                }
                catch (InvocationTargetException e) {
                    break;
                }
            }
            if (jobCompleted || !jobStartedOk || isRunMode) {
                try {
                    this.fDebugTarget.checkLaunchStatus(false);
                    this.fDebugTarget.fcomplete = true;
                    this.fDebugTarget.getLaunch().terminate();
                }
                catch (DebugException e) {
                    MvsBatchLaunchPlugin.log(e);
                }
            }
        }

        private boolean isProcessesTerminated(IProcess[] processes) {
            if (this.fDebugTarget.getLaunch().getDebugTargets().length == 1) {
                return false;
            }
            if (this.fDebugTarget.getLaunch().getDebugTargets().length != processes.length) {
                return false;
            }
            boolean result = true;
            IProcess[] iProcessArray = processes;
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess p = iProcessArray[n2];
                result |= !p.isTerminated();
                ++n2;
            }
            return result;
        }
    }
}

