/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.migration.internal;

import com.ibm.debug.pdt.idz.launches.migration.internal.AbstractApplicationLaunchMigrationDelegate;
import com.ibm.debug.pdt.profile.IAdditionalCICSFilters;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.ftt.cics.debug.launcher.CICSApplicationLaunchConstants;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class RemoteCICSApplicationLaunchMigrationDelegate
extends AbstractApplicationLaunchMigrationDelegate
implements CICSApplicationLaunchConstants {
    static final String CICS_LAUNCH_TYPE = "com.ibm.ftt.cics.debug.configuration";

    @Override
    protected String getLaunchTypeId() {
        return CICS_LAUNCH_TYPE;
    }

    @Override
    protected DebugProfile createProfile(String name) {
        return new DebugProfileDTCN(name);
    }

    @Override
    protected void addLaunchTypeOptions(DebugProfile profile, ILaunchConfiguration candidate) throws CoreException {
        if (profile instanceof DebugProfileDTCN) {
            String port;
            DebugProfileDTCN dtcnProfile = (DebugProfileDTCN)profile;
            if (candidate.hasAttribute("com.ibm.ftt.cics.debug.dtcnport") && !(port = candidate.getAttribute("com.ibm.ftt.cics.debug.dtcnport", "")).isEmpty()) {
                int portNum = Integer.parseInt(port);
                boolean isRegionNameFound = false;
                Connection c = ConnectionUtilities.getConnection((String)dtcnProfile.getConnectionName(), (boolean)true);
                if (c != null) {
                    Connection.RegionPortPair[] regionInfo;
                    Connection.RegionPortPair[] regionPortPairArray = regionInfo = c.getCICSRegionAndPorts();
                    int n = regionInfo.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Connection.RegionPortPair r = regionPortPairArray[n2];
                        if (r.port == portNum) {
                            dtcnProfile.setRegion(r.regionName);
                            isRegionNameFound = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!isRegionNameFound) {
                    dtcnProfile.setPort(portNum);
                }
            }
            if (candidate.hasAttribute("com.ibm.ftt.cics.debug.transactionname")) {
                dtcnProfile.setTransaction(candidate.getAttribute("com.ibm.ftt.cics.debug.transactionname", ""));
            }
            if (candidate.hasAttribute("com.ibm.ftt.cics.debug.cicsuserid") || candidate.hasAttribute("com.ibm.ftt.cics.debug.netname") || candidate.hasAttribute("com.ibm.ftt.cics.debug.ip") || candidate.hasAttribute("com.ibm.ftt.cics.debug.cicssysid") || candidate.hasAttribute("com.ibm.ftt.cics.debug.terminalid")) {
                String userID = candidate.getAttribute("com.ibm.ftt.cics.debug.cicsuserid", "");
                String netName = candidate.getAttribute("com.ibm.ftt.cics.debug.netname", "");
                String ip = candidate.getAttribute("com.ibm.ftt.cics.debug.ip", "");
                String cicsSysID = candidate.getAttribute("com.ibm.ftt.cics.debug.cicssysid", "");
                String terminalID = candidate.getAttribute("com.ibm.ftt.cics.debug.terminalid", "");
                DebugProfileDTCN.AdditionalCICSFilters additionalCICSFilters = new DebugProfileDTCN.AdditionalCICSFilters(userID, netName, ip, cicsSysID, terminalID);
                dtcnProfile.setAdditionalCICSFilters((IAdditionalCICSFilters)additionalCICSFilters);
            }
            DebugProfileDTCN.ContainerInfo containerInfo = null;
            if (candidate.hasAttribute("com.ibm.ftt.cics.debug.containername") || candidate.hasAttribute("com.ibm.ftt.cics.debug.containeroffset") || candidate.hasAttribute("com.ibm.ftt.cics.debug.containerdata")) {
                String name = candidate.getAttribute("com.ibm.ftt.cics.debug.containername", "");
                String offset = candidate.getAttribute("com.ibm.ftt.cics.debug.containeroffset", "");
                String data = candidate.getAttribute("com.ibm.ftt.cics.debug.containerdata", "");
                if (!name.isEmpty() || !offset.isEmpty() && !offset.equals("0") || !data.isEmpty()) {
                    containerInfo = new DebugProfileDTCN.ContainerInfo(name, offset, data);
                }
            }
            DebugProfileDTCN.ApplicationInfo applicationInfo = null;
            if (candidate.hasAttribute("com.ibm.ftt.cics.debug.platformname") && (candidate.hasAttribute("com.ibm.ftt.cics.debug.applicationname") || candidate.hasAttribute("com.ibm.ftt.cics.debug.operationname") || candidate.hasAttribute("com.ibm.ftt.cics.debug.applicationversionmajor"))) {
                String applicationVersion;
                String platformName = candidate.getAttribute("com.ibm.ftt.cics.debug.platformname", "");
                String applicationName = candidate.getAttribute("com.ibm.ftt.cics.debug.applicationname", "");
                String operationName = candidate.getAttribute("com.ibm.ftt.cics.debug.operationname", "");
                String string = applicationVersion = candidate.getAttribute("com.ibm.ftt.cics.debug.applicationversionmajor", "").isEmpty() ? "" : candidate.getAttribute("com.ibm.ftt.cics.debug.applicationversionmajor", "") + "." + candidate.getAttribute("com.ibm.ftt.cics.debug.applicationversionminor", "") + "." + candidate.getAttribute("com.ibm.ftt.cics.debug.applicationversionmicro", "");
                if (!(platformName.isEmpty() && applicationName.isEmpty() && operationName.isEmpty() && applicationVersion.isEmpty())) {
                    applicationInfo = new DebugProfileDTCN.ApplicationInfo(platformName, applicationName, operationName, applicationVersion);
                }
            }
            DebugProfileDTCN.CommAreaInfo commAreaInfo = null;
            if (candidate.hasAttribute("com.ibm.ftt.cics.debug.commareaoffset") || candidate.hasAttribute("com.ibm.ftt.cics.debug.commareadata")) {
                String offset = candidate.getAttribute("com.ibm.ftt.cics.debug.commareaoffset", "");
                String data = candidate.getAttribute("com.ibm.ftt.cics.debug.commareadata", "");
                if (!offset.isEmpty() && !offset.equals("0") || !data.isEmpty()) {
                    commAreaInfo = new DebugProfileDTCN.CommAreaInfo(offset, data);
                }
            }
            if (containerInfo != null || applicationInfo != null || commAreaInfo != null || candidate.hasAttribute("com.ibm.ftt.cics.debug.urmdebugging")) {
                boolean isURM = candidate.getAttribute("com.ibm.ftt.cics.debug.urmdebugging", "N").equals("Y");
                DebugProfileDTCN.AdvancedProgramInterruptionCriteria advancedCriteria = new DebugProfileDTCN.AdvancedProgramInterruptionCriteria(containerInfo, applicationInfo, commAreaInfo, isURM);
                dtcnProfile.setAdvancedProgramInterruptionCriteria(advancedCriteria);
            }
        }
    }

    @Override
    protected void addModules(DebugProfile profile, ILaunchConfiguration candidate) throws CoreException {
        List list = candidate.getAttribute("com.ibm.ftt.cics.debug.loadmoduleprogramname", new ArrayList());
        if (!list.isEmpty()) {
            for (String value : list) {
                String lm = null;
                String cu = null;
                int dotIndex = value.indexOf(46);
                if (dotIndex > -1) {
                    lm = value.substring(0, dotIndex);
                    cu = value.substring(dotIndex + 1);
                } else {
                    lm = "*";
                    cu = value;
                }
                profile.addLoadModulePair(lm, cu);
            }
        }
    }
}

