/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.migration.internal;

import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.ui.profile.internal.migration.IDebugProfileMigrator;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.CCLaunchUtils;
import com.ibm.ftt.debug.ui.ICCInfoProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

abstract class AbstractApplicationLaunchMigrationDelegate
implements ILaunchConfigurationMigrationDelegate,
IDebugProfileMigrator,
ApplicationLaunchConstants {
    protected static final String PLUGIN_ID = "com.ibm.debug.pdt.idz.launches.migration";
    protected static final String WILDCARD = "*";
    private static final String IMPORT_DIR = "DebugProfilesTemp";
    private List<ILaunchConfiguration> fProfiles = null;
    private int fMigratedProfiles = 0;
    protected String fImportDirectory;

    AbstractApplicationLaunchMigrationDelegate() {
    }

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        return candidate.getType() != null && candidate.getType().getIdentifier().equals(this.getLaunchTypeId()) && candidate.exists() && !candidate.getAttribute("MIGRATED_ZPROFILES", false);
    }

    protected abstract String getLaunchTypeId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = candidate;
        synchronized (iLaunchConfiguration) {
            try {
                boolean isImport;
                boolean bl = isImport = this.fImportDirectory != null;
                if (!candidate.exists() && !isImport) {
                    return;
                }
                DebugProfile profile = this.createProfile(this.ensureUniqueName(candidate.getName()));
                if (candidate.hasAttribute("com.ibm.ftt.debug.remotemvsconnectionname")) {
                    profile.setConnectionName(candidate.getAttribute("com.ibm.ftt.debug.remotemvsconnectionname", ""));
                }
                this.addModules(profile, candidate);
                ICCInfoProvider provider = CCLaunchUtils.getCCInfoProvider();
                DebugProfile.CodeCoverageOptions ccOptions = provider.getCodeCoverageOptions(candidate);
                if (ccOptions != null) {
                    profile.setCodeCoverageOptions(ccOptions);
                }
                DebugProfile.DebuggerOptions debuggerOptions = null;
                if (candidate.hasAttribute("com.ibm.ftt.debug.testoption") || candidate.hasAttribute("com.ibm.ftt.debug.testlevel") || candidate.hasAttribute("com.ibm.ftt.debug.promptlevel") || candidate.hasAttribute("com.ibm.ftt.debug.trace") || candidate.hasAttribute("com.ibm.ftt.debug.commandsfile") || candidate.hasAttribute("com.ibm.ftt.debug.eqaoptsfile") || candidate.hasAttribute("com.ibm.ftt.debug.langenvoptions") || candidate.hasAttribute("com.ibm.ftt.debug.preferencefile")) {
                    String testLevel = candidate.getAttribute("com.ibm.ftt.debug.testoption", "TEST");
                    String errorLevel = candidate.getAttribute("com.ibm.ftt.debug.testlevel", "ALL");
                    String promptLevel = candidate.getAttribute("com.ibm.ftt.debug.promptlevel", "PROMPT");
                    debuggerOptions = new DebugProfile.DebuggerOptions(testLevel, errorLevel, promptLevel);
                    debuggerOptions.setCommandDataSet(candidate.getAttribute("com.ibm.ftt.debug.commandsfile", ""));
                    debuggerOptions.setEqaOptsFile(candidate.getAttribute("com.ibm.ftt.debug.eqaoptsfile", ""));
                    debuggerOptions.setLanguageEnvironmentOptions(candidate.getAttribute("com.ibm.ftt.debug.langenvoptions", ""));
                    debuggerOptions.setPreferenceDataSet(candidate.getAttribute("com.ibm.ftt.debug.preferencefile", ""));
                    profile.setDebuggerOptions(debuggerOptions);
                }
                if (candidate.hasAttribute("com.ibm.ftt.debug.advanceduserid") || candidate.hasAttribute("com.ibm.ftt.debug.workstationip") || candidate.hasAttribute("com.ibm.ftt.debug.port")) {
                    String userID = candidate.getAttribute("com.ibm.ftt.debug.advanceduserid", "");
                    String ip = candidate.getAttribute("com.ibm.ftt.debug.workstationip", "");
                    String port = candidate.getAttribute("com.ibm.ftt.debug.port", "");
                    DebugProfile.AdvancedConnectionOptions advancedConnectionOptions = new DebugProfile.AdvancedConnectionOptions(userID, ip, port);
                    profile.setAdvancedConnectionOptions(advancedConnectionOptions);
                }
                this.addLaunchTypeOptions(profile, candidate);
                if (!isImport) {
                    ILaunchConfigurationWorkingCopy copy = candidate.getWorkingCopy();
                    copy.setAttribute("MIGRATED_ZPROFILES", true);
                    copy.doSave();
                } else {
                    candidate.delete();
                }
                profile.save();
                ++this.fMigratedProfiles;
                if (profile.isValid()) {
                    LogUtil.log((int)1, (String)String.format("Debug launch configuration '%s' of type '%s' is successfully migrated to a z/OS Debugger profile(%s).", candidate.getName(), this.getLaunchTypeId(), profile.getName()), (String)PLUGIN_ID);
                } else {
                    LogUtil.log((int)1, (String)String.format("Debug launch configuration '%s' of type '%s' is migrated to a z/OS Debugger profile(%s) with missing information.", candidate.getName(), this.getLaunchTypeId(), profile.getName()), (String)PLUGIN_ID);
                }
            }
            catch (CoreException e) {
                LogUtil.log((int)4, (String)String.format("Debug launch configuration '%s' of type '%s' failed to be migrated to a z/OS Debugger profile.", candidate.getName(), this.getLaunchTypeId()), (String)PLUGIN_ID);
                throw e;
            }
        }
    }

    private String ensureUniqueName(String name) {
        if (name.length() > 25) {
            name = name.substring(0, 25);
        }
        return DebugProfileNameUtils.isNameInUse((String)name) ? DebugProfileNameUtils.generateNewName((String)name) : name;
    }

    protected abstract DebugProfile createProfile(String var1);

    protected abstract void addLaunchTypeOptions(DebugProfile var1, ILaunchConfiguration var2) throws CoreException;

    protected abstract void addModules(DebugProfile var1, ILaunchConfiguration var2) throws CoreException;

    public int getNumberOfProfilesToMigrate() {
        if (this.fProfiles == null) {
            this.fProfiles = new ArrayList<ILaunchConfiguration>();
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.getLaunchTypeId());
            try {
                ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                int n = iLaunchConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration candidate = iLaunchConfigurationArray[n2];
                    try {
                        if (this.isCandidate(candidate)) {
                            this.fProfiles.add(candidate);
                        }
                    }
                    catch (CoreException e) {
                        LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
            }
        }
        return this.fProfiles.size();
    }

    public void migrateProfiles(IProgressMonitor monitor) {
        try {
            this.migrateProfile(monitor, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void migrateProfile(IProgressMonitor monitor, boolean catchException) throws Exception {
        if (this.fProfiles == null) {
            this.getNumberOfProfilesToMigrate();
        }
        for (ILaunchConfiguration profile : this.fProfiles) {
            try {
                this.migrate(profile);
            }
            catch (CoreException e) {
                if (catchException) {
                    LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
                }
                throw e;
            }
            monitor.worked(1);
        }
    }

    public int getNumberOfProfilesSuccessfullyMigrated() {
        return this.fMigratedProfiles;
    }

    public void setImportDirectory(String dir) {
        this.fImportDirectory = dir;
        this.fProfiles = null;
    }

    public int getNumberOfProfilesToImport() throws Exception {
        if (this.fProfiles == null) {
            this.fProfiles = new ArrayList<ILaunchConfiguration>();
            File launchConfigDir = new File(this.fImportDirectory + File.separator + ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.debug.core" + File.separator + ".launches");
            if (launchConfigDir.exists() && launchConfigDir.isDirectory()) {
                File[] launchConfigs = launchConfigDir.listFiles();
                if (launchConfigDir != null) {
                    IProject parentImportDir = ResourcesPlugin.getWorkspace().getRoot().getProject(IMPORT_DIR);
                    if (!parentImportDir.exists()) {
                        parentImportDir.create((IProgressMonitor)new NullProgressMonitor());
                        parentImportDir.setHidden(true);
                    }
                    parentImportDir.open((IProgressMonitor)new NullProgressMonitor());
                    File[] fileArray = launchConfigs;
                    int n = launchConfigs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File configFile = fileArray[n2];
                        IFile wsFile = ResourcesPlugin.getWorkspace().getRoot().getProject(IMPORT_DIR).getFile((IPath)new Path(configFile.getName()));
                        if (wsFile != null) {
                            this.copyFile(configFile, wsFile);
                            ILaunchConfiguration config = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(wsFile);
                            if (config.getType().getIdentifier().equals(this.getLaunchTypeId())) {
                                this.fProfiles.add(config);
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
        return this.fProfiles.size();
    }

    private void copyFile(File configFile, IFile newFile) throws IOException, CoreException {
        FileInputStream input = null;
        try {
            if (newFile.exists()) {
                newFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            input = new FileInputStream(configFile);
            newFile.create((InputStream)input, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void importProfiles(IProgressMonitor monitor) throws Exception {
        this.migrateProfiles(monitor);
    }

    public int getNumberOfProfilesSuccessfullyImported() {
        return this.getNumberOfProfilesSuccessfullyMigrated();
    }
}

