/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui;

import com.ibm.ftt.debug.internal.DebugProducCheckUtils;
import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.IIDzInfoProvider;
import com.ibm.ftt.debug.ui.util.RemoteUtil;
import com.ibm.ftt.resource.utils.PBResourceUtils;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.rse.debug.DebugSubSystemUtil;
import com.ibm.ftt.rse.debug.subsystems.DebugSubSystem;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;

public class DebugLaunchUtils
extends DebugProducCheckUtils {
    private static final String DBMDT = "DBMDT";
    private static final String TEST = "TEST";
    private static final String TCPIP = "TCPIP";
    private static final String EMPTY = "";
    private static final String VADSCP_FORMAT = "(?i)^VADSCP\\d+";
    private static final String DS_PREFIX = "'-";
    private static final String DS_SUFFIX = "'";
    private static final Object fIDzInfoProvidersLock = new Object();
    private static IIDzInfoProvider fIDzInfoProvider = null;
    private static boolean fLicenceLoggedIDz = false;

    public static boolean isDBMVersionGreaterThan111(IZOSSystemImage image) {
        return DebugLaunchUtils.isDBMVersionGreaterThan111(DebugLaunchUtils.getHostFromSystemName(image.getName()));
    }

    public static boolean isDBMVersionGreaterThan111(IHost host) {
        String dbmVersion = DebugSubSystemUtil.getDBMVersion((IHost)host);
        if (dbmVersion != null) {
            StringTokenizer tk = new StringTokenizer(dbmVersion, ".");
            int versionCheck = 0;
            while (tk.hasMoreTokens()) {
                int i = Integer.parseInt(tk.nextToken());
                if (i == 1) {
                    ++versionCheck;
                    continue;
                }
                if (i <= 1) continue;
                return true;
            }
            return versionCheck == 3;
        }
        return false;
    }

    public static String getTestParm(boolean dbmActive, IZOSSystemImage systemImage, boolean debugUseIntegratedDebugger, String hostCodePageEntry, String debugTestLevel, String debugTestPrompt, String debugConnection, String prefFile, String testOverride) {
        return DebugLaunchUtils.getTestParm(dbmActive, systemImage, debugUseIntegratedDebugger, false, false, false, hostCodePageEntry, debugTestLevel, debugTestPrompt, debugConnection, prefFile, testOverride);
    }

    public static String getTestParm(boolean dbmActive, IZOSSystemImage systemImage, boolean debugUseIntegratedDebugger, boolean debugUseOldInfo, boolean runInIntegratedDebug, boolean codeIntegratedCoverage, String hostCodePageEntry, String debugTestLevel, String debugTestPrompt, String debugConnection, String prefFile, String testOverride) {
        Object effectiveHostCodePageEntry;
        String localMachineIPAddress = null;
        if (systemImage != null) {
            try {
                localMachineIPAddress = PBResourceUtils.getClientIPAddress((IOSImage)systemImage);
            }
            catch (Exception e) {
                try {
                    localMachineIPAddress = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        boolean useID = debugUseIntegratedDebugger || debugUseOldInfo && (runInIntegratedDebug || codeIntegratedCoverage);
        boolean useDTDBM = systemImage == null ? false : DebugLaunchUtils.isDBMVersionGreaterThan111(systemImage);
        String dbmString = DBMDT;
        boolean isDBMRequested = debugConnection != null && debugConnection.startsWith(dbmString);
        String test = testOverride != null ? testOverride : TEST;
        Object testParmPattern = test + "({0},{1},{2},{3})";
        Object connection = null;
        if (debugConnection != null && (!isDBMRequested && debugConnection.contains("&") || isDBMRequested && dbmActive && (useID || useDTDBM) && !debugConnection.equals(dbmString))) {
            connection = debugConnection;
        }
        if (connection == null || ((String)connection).isEmpty()) {
            if (dbmActive && (useID || useDTDBM)) {
                IHost h = DebugLaunchUtils.getHostFromSystemName(systemImage.getName());
                String uid = h.getConnectorServices().length > 0 ? h.getConnectorServices()[0].getUserId() : null;
                connection = dbmString + (String)(uid == null ? EMPTY : "%" + uid);
            } else {
                String prefix = TCPIP;
                connection = prefix + "&" + localMachineIPAddress + "%" + RemoteUtil.getLocalClientPort();
            }
        }
        connection = (String)connection + ":";
        if (prefFile == null || prefFile.isEmpty()) {
            connection = (String)connection + "*";
        } else {
            Object effectivePrefFile = prefFile.trim();
            effectivePrefFile = ((String)effectivePrefFile).startsWith(DS_PREFIX) ? effectivePrefFile : "-" + (String)effectivePrefFile;
            connection = (String)connection + (String)effectivePrefFile;
            connection = DS_SUFFIX + (String)connection + DS_SUFFIX;
        }
        Object object = effectiveHostCodePageEntry = hostCodePageEntry == null ? EMPTY : hostCodePageEntry.trim();
        if (!(((String)effectiveHostCodePageEntry).isEmpty() || ((String)effectiveHostCodePageEntry).startsWith(DS_PREFIX) || ((String)effectiveHostCodePageEntry).matches(VADSCP_FORMAT))) {
            effectiveHostCodePageEntry = DS_PREFIX + (String)effectiveHostCodePageEntry + DS_SUFFIX;
        }
        debugTestPrompt = debugTestPrompt == null ? EMPTY : debugTestPrompt;
        debugTestLevel = debugTestLevel == null ? EMPTY : debugTestLevel;
        testParmPattern = NLS.bind((String)testParmPattern, (Object[])new String[]{debugTestLevel.trim(), ((String)effectiveHostCodePageEntry).trim(), debugTestPrompt.trim(), ((String)connection).trim()});
        return testParmPattern;
    }

    protected static IHost getHostFromSystemName(String systemName) {
        IHost[] conns = RSECorePlugin.getDefault().getSystemRegistry().getHosts();
        int i = 0;
        while (i < conns.length) {
            if (conns[i].getAliasName().equals(systemName)) {
                return conns[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isDebugManagerReady(String systemName) {
        IHost host = null;
        if (DebugLaunchUtils.getHostFromSystemName(systemName) != null) {
            host = DebugLaunchUtils.getHostFromSystemName(systemName);
            DebugSubSystem subsystem = DebugSubSystemUtil.getDebugSubSystem((IHost)host);
            return subsystem.readyToDebug();
        }
        return false;
    }

    public static IZOSSystemImage getConnection(String name) {
        if (name != null && !name.trim().isEmpty()) {
            Object[] systems;
            Object[] objectArray = systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
            int n = systems.length;
            int n2 = 0;
            while (n2 < n) {
                Object system = objectArray[n2];
                if (system instanceof IZOSSystemImage && ((IZOSSystemImage)system).getName().equals(name)) {
                    return (IZOSSystemImage)system;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IZOSSystemImage getFirstConnection() {
        Object[] systems;
        IZOSSystemImage firstConnection = null;
        Object[] objectArray = systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            Object system = objectArray[n2];
            if (system instanceof IZOSSystemImage) {
                if (((IZOSSystemImage)system).isConnected()) {
                    return (IZOSSystemImage)system;
                }
                firstConnection = firstConnection != null ? firstConnection : (IZOSSystemImage)system;
            }
            ++n2;
        }
        return firstConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IIDzInfoProvider getIDzInfoProvider() {
        Object object = fIDzInfoProvidersLock;
        synchronized (object) {
            IExtensionPoint ep;
            if (fIDzInfoProvider == null && !fLicenceLoggedIDz && (ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.idz.launches.common.IDzInfoProvider")) != null) {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = ep.getConfigurationElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block10: {
                        IConfigurationElement config = iConfigurationElementArray[n2];
                        try {
                            String id = config.getAttribute("id");
                            if (fIDzInfoProvider != null) {
                                Activator.log(new Exception("Multiple registrations for IDz Info Provider. Ignoring: " + id));
                                break block10;
                            }
                            if (DebugLaunchUtils.isDebugIDzLicense(true)) {
                                fIDzInfoProvider = (IIDzInfoProvider)config.createExecutableExtension("class");
                                break block10;
                            }
                            if (fLicenceLoggedIDz) break;
                            fLicenceLoggedIDz = true;
                            Activator.logInfo("Valid license not found. Ignoring: " + id);
                            break;
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                        catch (ClassCastException e) {
                            Activator.log(e);
                        }
                    }
                    ++n2;
                }
            }
            return fIDzInfoProvider;
        }
    }
}

