/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.common;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CommonDebugPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "com.ibm.debug.pdt.common";
    private static boolean retrievedAdvancedEnvVars = false;
    private static IConfigurationElement[] advancedEnvironmentVariables;
    public static final String IADVANCEDENVVAREXTENSION = "advancedEnvVarExtension";
    private static final Object fLock;
    private static CommonDebugPlugin fInstance;
    static boolean logging;
    static boolean events;
    private static final Object fLogLock;
    public static ILog logFile;

    static {
        fLock = new Object();
        logging = false;
        events = false;
        fLogLock = new Object();
        logFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonDebugPlugin() {
        Object object = fLock;
        synchronized (object) {
            fInstance = this;
        }
        if (this.isDebugging()) {
            object = fLogLock;
            synchronized (object) {
                logFile = this.getLog();
            }
            String id = CommonDebugPlugin.getPluginID();
            String test = Platform.getDebugOption((String)(id + "/debug/events"));
            if (test != null) {
                events = test.equals("true");
            }
            if ((test = Platform.getDebugOption((String)(id + "/debug/logging"))) != null) {
                logging = test.equals("true");
            }
        }
        CommonUtils.logText("CommonDebuggerPlugin loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonDebugPlugin getInstance() {
        Object object = fLock;
        synchronized (object) {
            return fInstance;
        }
    }

    public static String getPluginID() {
        return PLUGIN_ID;
    }

    public void start(BundleContext context) throws Exception {
        CommonUtils.logText("In CommonDebuggerPlugin startup()");
        super.start(context);
    }

    protected static IConfigurationElement[] getExtensions(String extensionName) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CommonDebugPlugin.getPluginID(), extensionName);
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        return configElements;
    }

    public void setDialogSetting(String name, String value) {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(name, value);
    }

    public String getDialogSetting(String setting) {
        IDialogSettings settings = this.getDialogSettings();
        return settings.get(setting);
    }

    public static IConfigurationElement[] getAdvancedEnvironmentVariablePlugins() {
        if (!retrievedAdvancedEnvVars) {
            advancedEnvironmentVariables = CommonDebugPlugin.getExtensions(IADVANCEDENVVAREXTENSION);
            retrievedAdvancedEnvVars = true;
        }
        return advancedEnvironmentVariables;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = CommonDebugPlugin.getPluginBundle();
        if (bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static Bundle getPluginBundle() {
        return Platform.getBundle((String)PLUGIN_ID);
    }
}

