/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.common;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSourceEntryBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSourceLineBreakpoint;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class CommonDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public String getText(Object item) {
        if (item instanceof GenericLineBreakpoint) {
            return ((GenericLineBreakpoint)item).getLabel();
        }
        if (item instanceof PICLSourceEntryBreakpoint) {
            return ((PICLSourceEntryBreakpoint)item).getLabel();
        }
        return null;
    }

    public Image getImage(Object item) {
        if (item instanceof IMarker) {
            item = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)item);
        }
        if (!(item instanceof GenericLineBreakpoint || item instanceof PICLSourceLineBreakpoint || item instanceof PICLSourceEntryBreakpoint)) {
            return null;
        }
        int status = 0;
        try {
            status |= ((Breakpoint)item).isEnabled() ? 2 : 0;
        }
        catch (CoreException e) {
            CommonUtils.logError((Exception)((Object)e));
        }
        if (item instanceof GenericLineBreakpoint) {
            status |= ((GenericLineBreakpoint)item).isInstalled() ? 1 : 0;
        }
        if (item instanceof PICLSourceLineBreakpoint) {
            status |= ((PICLSourceLineBreakpoint)item).isInstalled() ? 1 : 0;
            status |= ((PICLSourceLineBreakpoint)item).isConditional() ? 4 : 0;
        }
        if (item instanceof PICLSourceEntryBreakpoint) {
            status |= ((PICLSourceEntryBreakpoint)item).isInstalled() ? 1 : 0;
            status |= ((PICLSourceEntryBreakpoint)item).isConditional() ? 4 : 0;
        }
        Image bpImage = null;
        if (item instanceof PICLSourceLineBreakpoint || item instanceof PICLSourceEntryBreakpoint) {
            switch (status) {
                case 2: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_ENABLED");
                    break;
                }
                case 1: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_DISABLED_INSTALLED");
                    break;
                }
                case 4: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_DISABLED_CONDITIONAL");
                    break;
                }
                case 3: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_ENABLED_INSTALLED");
                    break;
                }
                case 6: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_ENABLED_CONDITIONAL");
                    break;
                }
                case 5: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_DISABLED_INSTALLED_CONDITIONAL");
                    break;
                }
                case 7: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_ENABLED_INSTALLED_CONDITIONAL");
                    break;
                }
                default: {
                    bpImage = CommonUtils.getImage("ICON_REALEDITOR_BREAKPOINT_DISABLED");
                    break;
                }
            }
        } else if (item instanceof GenericLineBreakpoint) {
            switch (status) {
                case 2: {
                    bpImage = DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
                    break;
                }
                case 1: {
                    bpImage = CommonUtils.getImage("COMMON_ICON_BREAKPOINT_DISABLED_INSTALLED");
                    break;
                }
                case 3: {
                    bpImage = CommonUtils.getImage("COMMON_ICON_BREAKPOINT_ENABLED_INSTALLED");
                    break;
                }
                default: {
                    bpImage = DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
                }
            }
        }
        return bpImage;
    }

    public IEditorInput getEditorInput(Object item) {
        if (item instanceof IBreakpoint) {
            IMarker marker = ((IBreakpoint)item).getMarker();
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            return null;
        }
        if (item instanceof IFile) {
            return new FileEditorInput((IFile)item);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        if (input instanceof IFileEditorInput) {
            IResource resource;
            IEditorDescriptor desc = null;
            if (inputObject instanceof IFile) {
                IFile file = (IFile)inputObject;
                desc = IDE.getDefaultEditor((IFile)file);
                if (desc != null) {
                    return desc.getId();
                }
                return "org.eclipse.ui.DefaultTextEditor";
            }
            if (inputObject instanceof IBreakpoint && (resource = ((IBreakpoint)inputObject).getMarker().getResource()) instanceof IFile) {
                IFile file = (IFile)resource;
                desc = IDE.getDefaultEditor((IFile)file);
                if (desc != null) {
                    return desc.getId();
                }
                return "org.eclipse.ui.DefaultTextEditor";
            }
        }
        return null;
    }

    public void setAttribute(String id, Object value) {
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }
}

