/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultsView;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.CCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.security.CCSSecurityUtils;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.handlers.ShowCCHistoryViewHandler;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCZipResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IJavaResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.JavaDeprecatedLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.LocalResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;

public class ResultsViewUtilities {
    private static final String DEFAULT_PROVIDER_CLASS = "com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProvider";
    private static final String MEMENTO_TYPE_ROOT = "root";
    private static final String MEMENTO_TYPE_RESULT_LOCATION = "resultLocation";
    private static final String MEMENTO_IS_REMOTE = "isRemote";
    private static final String MEMENTO_REMOTE_PROVIDER = "remoteProvider";
    private static final String MEMENTO_PATH = "path";
    private static final String MEMENTO_NAME = "name";
    private static final String MEMENTO_IS_CCAAS = "isCCaaS";
    private static final String MEMENTO_CCAAS_HOST = "host";
    private static final String MEMENTO_CCAAS_PORT = "port";
    private static final String MEMENTO_CCAAS_SECURED = "secure";
    private static final String MEMENTO_IS_JAVA = "isJava";
    public static final String CC_UI_FOLDER = "codecoverage";
    public static final String CC_UNZIP_FOLDER = "CC_unzips";
    private static IProject fProject = null;
    private static final IResultAdapter[] EMPTY = new IResultAdapter[0];

    public static void showCodeCoverageResultsView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ShowCCHistoryViewHandler.showLaunchHistoryView(window);
    }

    public static IResultAdapter[] getAdapters(IServiceLocator servicelocator) {
        ISelectionService selectionService = (ISelectionService)servicelocator.getService(ISelectionService.class);
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object[] items = sel.toArray();
            ArrayList<IResultAdapter> result = new ArrayList<IResultAdapter>();
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (!(item instanceof IResultAdapter)) {
                    return EMPTY;
                }
                result.add((IResultAdapter)item);
                ++n2;
            }
            return result.toArray(new IResultAdapter[result.size()]);
        }
        return EMPTY;
    }

    public static IResultAdapter getResult(String localPath) {
        return ResultsViewUtilities.getResult(localPath, true);
    }

    public static IResultAdapter getResult(String localPath, boolean createNewResult) {
        ICCResultsView view = ResultsViewUtilities.getResultsView();
        IResultLocation[] locations = view.getResultLocations();
        Object[] objectArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IResultLocation location = objectArray[n2];
            IResultAdapter result = location.findResult(localPath);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        if (createNewResult) {
            objectArray = ResultsViewContentProviders.getContentProviders();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object provider = objectArray[n2];
                if (provider.isResultHandled(localPath)) {
                    return provider.getResultAdapter(localPath);
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getEditorId(String file, String engineKey) {
        IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
        int n = iResultContentProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultContentProvider provider = iResultContentProviderArray[n2];
            if (provider.isEngineHandled(engineKey)) {
                return provider.getEditorId(file, engineKey);
            }
            ++n2;
        }
        return null;
    }

    public static void displayHTMLReport(final URI report, final String resultName, final String tabName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    browserSupport.createBrowser(32, resultName, tabName, resultName).openURL(report.toURL());
                }
                catch (PartInitException e) {
                    ResultsViewPlugin.log(e);
                }
                catch (MalformedURLException e) {
                    ResultsViewPlugin.log(e);
                }
            }
        });
    }

    public static void refreshCoverageView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        CCResultsView view = ShowCCHistoryViewHandler.showLaunchHistoryView(window);
        view.refresh();
    }

    public static ICCResultsView getResultsView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewPart part = page.findView("com.ibm.debug.pdt.codecoverage.ui.results.views.statistics.history");
            if (part != null) {
                return (CCResultsView)part;
            }
            ++n2;
        }
        return null;
    }

    public static boolean copyFiles(File resultsFile, File destination) {
        if (resultsFile.isDirectory()) {
            File newDir = new File(destination.getPath() + File.separator + resultsFile.getName());
            if (!newDir.exists() && !newDir.mkdirs()) {
                ResultsViewPlugin.log("Unable to create result directory:" + newDir.getAbsolutePath());
                return false;
            }
            File[] results = resultsFile.listFiles();
            if (results != null) {
                File[] fileArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!ResultsViewUtilities.copyFiles(f, newDir)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        File newFile = new File(destination.getPath() + File.separator + resultsFile.getName());
        try {
            boolean result;
            java.nio.file.Path p = Files.copy(resultsFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean bl = result = p != null && p.toFile().exists();
            if (!result) {
                ResultsViewPlugin.log("Unable to copy file:" + newFile.getAbsolutePath());
            }
            return result;
        }
        catch (IOException e) {
            ResultsViewPlugin.log(e);
            return false;
        }
    }

    public static String getSaveLocationsString(List<IResultLocation> locations, boolean ignoreDefaultLocations) {
        XMLMemento root = XMLMemento.createWriteRoot((String)MEMENTO_TYPE_ROOT);
        for (IResultLocation location : locations) {
            if (ignoreDefaultLocations && location.isDefaultLocation() && !(location instanceof IJavaResultLocation) || !location.isSaveRestoreable()) continue;
            location.addSaveMemento(root);
        }
        StringWriter writer = new StringWriter();
        try {
            root.save((Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static List<IResultLocation> restoreLocationsFromString(String resultLocationStr) {
        ArrayList<IResultLocation> results = new ArrayList<IResultLocation>();
        try {
            IMemento[] children;
            XMLMemento root = XMLMemento.createReadRoot((Reader)new StringReader(resultLocationStr));
            IMemento[] iMementoArray = children = root.getChildren(MEMENTO_TYPE_RESULT_LOCATION);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                boolean isJava = child.getBoolean(MEMENTO_IS_JAVA) == null ? false : child.getBoolean(MEMENTO_IS_JAVA);
                boolean isRemote = child.getBoolean(MEMENTO_IS_REMOTE) == null ? false : child.getBoolean(MEMENTO_IS_REMOTE);
                boolean isCCaaS = child.getBoolean(MEMENTO_IS_CCAAS) == null ? false : child.getBoolean(MEMENTO_IS_CCAAS);
                String path = child.getString(MEMENTO_PATH);
                String name = child.getString(MEMENTO_NAME);
                IResultLocation location = null;
                if (isCCaaS) {
                    String host = child.getString(MEMENTO_CCAAS_HOST);
                    String port = child.getString(MEMENTO_CCAAS_PORT);
                    boolean isSecured = false;
                    if (child.getBoolean(MEMENTO_CCAAS_SECURED) != null) {
                        isSecured = child.getBoolean(MEMENTO_CCAAS_SECURED);
                    }
                    HttpClient client = new HttpClient(host, port, isSecured, CCSSecurityUtils.getSocketFactory(), CCSSecurityUtils.getHostNameVerifier());
                    location = new CCaasResultLocation(name, client);
                } else if (isRemote) {
                    String className = child.getString(MEMENTO_REMOTE_PROVIDER);
                    className = className == null ? DEFAULT_PROVIDER_CLASS : className;
                    location = ResultsViewUtilities.getRemoteResultLocation(path, name, className);
                } else {
                    location = isJava ? new JavaDeprecatedLocation(path, true, null) : new LocalResultLocation(path, name, false, null);
                }
                if (location != null) {
                    results.add(location);
                }
                ++n2;
            }
        }
        catch (WorkbenchException ex) {
            ResultsViewPlugin.log(ex);
        }
        return results;
    }

    private static IResultLocation getRemoteResultLocation(String path, String name, String className) {
        IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
        int n = iResultContentProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultContentProvider provider = iResultContentProviderArray[n2];
            if (provider instanceof IRemoteResultContentProvider && provider.getClass().getName().equals(className)) {
                IRemoteResultContentProvider rProvider = (IRemoteResultContentProvider)provider;
                try {
                    IRemoteResultLocation location = rProvider.resolveRemotePath(path, name, true, false);
                    if (location != null) {
                        return location;
                    }
                }
                catch (ResultException e) {
                    ResultsViewPlugin.log(e);
                }
            }
            ++n2;
        }
        return null;
    }

    public static IResultLocation getDefaultLocation() {
        IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
        int n = iResultContentProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultContentProvider provider = iResultContentProviderArray[n2];
            IResultLocation[] locations = provider.getDefaultLocations();
            if (locations != null) {
                IResultLocation[] iResultLocationArray = locations;
                if (locations.length != 0) {
                    IResultLocation location = iResultLocationArray[0];
                    return location;
                }
            }
            ++n2;
        }
        return null;
    }

    public static boolean isISeriesEngine(String engineKey) {
        if (engineKey != null && !engineKey.isEmpty()) {
            char c = engineKey.charAt(0);
            return c == 'a';
        }
        return false;
    }

    public static IFolder getProjectLinkedFolder(String resultName) throws CoreException {
        IPath results = ResultsViewUtilities.getDefaultResultsPath(resultName);
        if (!results.toFile().exists() && !results.toFile().mkdir()) {
            ResultsViewPlugin.log("Failed to create result directory " + String.valueOf(results));
        }
        return ResultsViewUtilities.getProjectLinkedFolder(resultName, results);
    }

    public static IPath getDefaultResultsPath(String resultName) {
        Bundle bundle = Platform.getBundle((String)"com.ibm.debug.pdt.codecoverage.core");
        return Platform.getStateLocation((Bundle)bundle).append(resultName);
    }

    public static IFolder getProjectUnzipFolder(String resultname) throws CoreException {
        IFolder unzipFolder = ResultsViewUtilities.getProjectFolder(MODE.UNZIP);
        if (!(unzipFolder = unzipFolder.getFolder(resultname)).exists()) {
            unzipFolder.create(true, true, null);
        }
        return unzipFolder;
    }

    private static IFolder getProjectLinkedFolder(String linkFolder, IPath pathToFolder) throws CoreException {
        IFolder folder = ResultsViewUtilities.getProjectFolder(MODE.LINK);
        if (!(folder = folder.getFolder(linkFolder)).exists()) {
            folder.create(true, true, null);
        }
        if (pathToFolder != null) {
            folder.createLink(pathToFolder, 256, null);
        }
        return folder;
    }

    public static IFile getProjectLinkedFile(String linkFolder, String fileName, IPath pathToFile) throws CoreException {
        IFolder folder = ResultsViewUtilities.getProjectLinkedFolder(linkFolder, null);
        Path filePath = new Path(fileName);
        int i = 0;
        while (i < filePath.segmentCount() - 1) {
            if (!(folder = folder.getFolder(filePath.segment(i))).exists()) {
                folder.create(true, true, null);
            }
            ++i;
        }
        IFile linkFile = folder.getFile(filePath.lastSegment());
        linkFile.createLink(pathToFile, 256, null);
        return linkFile;
    }

    private static IFolder getProjectFolder(MODE mode) throws CoreException {
        IFolder folder;
        IProject project = ResultsViewUtilities.getProject();
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!(folder = project.getFolder(mode == MODE.LINK ? CC_UI_FOLDER : CC_UNZIP_FOLDER)).exists()) {
            folder.create(true, true, null);
        }
        return folder;
    }

    public static IFile[] findFileInProject(IFileStore fileStore) {
        IWorkspace wrkSpc = ResourcesPlugin.getWorkspace();
        return wrkSpc.getRoot().findFilesForLocationURI(fileStore.toURI());
    }

    public static IProject getProject() {
        try {
            IWorkspaceRoot workspaceRoot;
            if (fProject == null && (fProject = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getProject("CCTempFiles")) != null && !fProject.exists()) {
                fProject.create((IProgressMonitor)new NullProgressMonitor());
            }
            if (fProject != null) {
                fProject.open((IProgressMonitor)new NullProgressMonitor());
                fProject.setHidden(true);
            }
        }
        catch (CoreException e) {
            ResultsViewPlugin.log(e);
        }
        return fProject;
    }

    public static IResultAdapter addCCZipResult(String resultPath, boolean createLocation) {
        String parentDir = new File(resultPath).getParent();
        IResultLocation location = ResultsViewUtilities.getLocation(parentDir, createLocation);
        CCZipResultAdapter adapter = new CCZipResultAdapter(resultPath);
        if (location != null) {
            adapter.setResultLocation(location);
            location.addResult(adapter);
        }
        CCResultEventManager.getDefault().fireResultEvent(new CCResultEvent(adapter, 5));
        return adapter;
    }

    private static IResultLocation getLocation(String location, boolean createLocation) {
        ICCResultsView view = ResultsViewUtilities.getResultsView();
        IResultLocation[] iResultLocationArray = view.getResultLocations();
        int n = iResultLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultLocation rLoc = iResultLocationArray[n2];
            if (rLoc.getPath().equals(location)) {
                return rLoc;
            }
            ++n2;
        }
        if (createLocation) {
            File f = new File(location);
            if (f.exists() && f.isDirectory()) {
                LocalResultLocation resultLocation = new LocalResultLocation(location, location, false, null);
                CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(resultLocation, 1));
                return resultLocation;
            }
            if (!f.exists()) {
                ResultsViewPlugin.log("Unable to add local location, it does not exist:" + location);
            } else {
                ResultsViewPlugin.log("Unable to add local location, it is not a directory:" + location);
            }
        }
        return null;
    }

    public static enum MODE {
        LINK,
        UNZIP;

    }
}

