/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractResultAdapter;
import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CCAPIResultAdapter
extends AbstractResultAdapter {
    private int fElapsedTime = -1;

    public CCAPIResultAdapter(String path) {
        super(path);
        this.doAnalysis(true);
        this.fLocalInitTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        if (this.isResultAvailable()) {
            Path path = new Path(this.getResult().getName());
            return path.removeFileExtension().toOSString();
        }
        String resultPath = this.getResultPath();
        int idx = resultPath.lastIndexOf(this.getSeparator());
        String result = idx > 0 ? resultPath.substring(idx + 1) : resultPath;
        idx = result.lastIndexOf(".");
        return idx > -1 ? result.substring(0, idx) : result;
    }

    @Override
    public String getTestcaseID() {
        return null;
    }

    @Override
    public long getElapsedTime() {
        ICCResult result;
        if (this.fElapsedTime < 0 && (result = this.getResult()) != null) {
            this.fElapsedTime = 0;
            ICCTestcase[] iCCTestcaseArray = result.getTestcases();
            int n = iCCTestcaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICCTestcase t = iCCTestcaseArray[n2];
                this.fElapsedTime = (int)((long)this.fElapsedTime + t.getElapsedTime());
                ++n2;
            }
        }
        return this.fElapsedTime;
    }

    @Override
    public boolean isAnalyzed() {
        return true;
    }

    @Override
    public Image getImage() {
        return ResultsViewPlugin.getDefault().getImageRegistry().get("icons/elcl16/threshold_filter.png");
    }

    @Override
    public String getBaselineFileName() {
        return null;
    }

    @Override
    public void open(String mode, Shell activeShell) {
    }

    @Override
    public boolean copyTo(File directory, boolean unpack) {
        return false;
    }

    @Override
    protected void doAnalysis(boolean useResultAPI) {
        String localPath = this.getLocalPath();
        if (localPath != null) {
            this.setResult(localPath);
        }
    }

    @Override
    protected boolean exists() {
        File f = new File(this.getResultPath());
        return f.exists();
    }
}

