/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.core.results.CCMessageUtilities;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.ccresults.CCResultExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.CCImportUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRenamableResultsAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractResultAdapter
implements IAdaptable,
IResultAdapter,
IRenamableResultsAdapter {
    public static final String RESULTVIEW_THRESHOLD_PREF = "com.ibm.debug.pdt.tatt.threshold";
    public static final String RESULTVIEW_PLUGIN_ID = "com.ibm.debug.pdt.codecoverage.ui.view";
    protected static final String EMPTY = "";
    private String fMode = "default";
    private IResultLocation fResultLocation;
    private String fPath;
    private ICCResult fResult;
    private Object fResultLock = new Object();
    protected long fLocalInitTime = 0L;
    private Properties fCCProperties = new Properties();
    private boolean fPropsAreSet = false;
    private Object fPropertiesLock = new Object();
    private java.nio.file.Path fPropFilePath = null;

    protected AbstractResultAdapter(String path) {
        this.fPath = path;
    }

    protected boolean supportsProperties() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeProperties() {
        Object object = this.fPropertiesLock;
        synchronized (object) {
            if (this.fPropsAreSet || !this.supportsProperties() || this.fPath == null) {
                return;
            }
            File fPropertiesFile = this.generatePropertiesFile(this.fPath);
            if (fPropertiesFile != null) {
                if (!fPropertiesFile.exists() || !this.fCCProperties.containsKey("tags")) {
                    ICCResult result = this.getResult();
                    if (result == null) {
                        return;
                    }
                    StringBuilder tags = new StringBuilder();
                    ICCTestcase[] iCCTestcaseArray = this.getResult().getTestcases();
                    int n = iCCTestcaseArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICCTestcase t = iCCTestcaseArray[n2];
                        if (tags.length() > 0) {
                            tags.append(',');
                        }
                        if (t.getTag() != null) {
                            tags.append(t.getTag());
                        }
                        ++n2;
                    }
                    this.fCCProperties.setProperty("tags", tags.toString());
                    this.fCCProperties.setProperty("percentCovered", String.valueOf(result.getPercentCoverage()));
                    this.fCCProperties.setProperty("dateAnalyzed", String.valueOf(result.getInfo().getCreatedTime()));
                    ICCTestcase[] tests = result.getTestcases();
                    if (tests.length > 0) {
                        this.fCCProperties.setProperty("cclevel", this.getLevelLabel(result.getLevel().toString(), tests[0].getEngineKey()));
                    }
                    try {
                        Throwable throwable = null;
                        Object var7_12 = null;
                        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fPropertiesFile), StandardCharsets.UTF_8);){
                            this.fCCProperties.store(writer, "CC Properties");
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        fPropertiesFile = null;
                        ResultsViewPlugin.log(e);
                    }
                } else {
                    try {
                        Throwable result = null;
                        Object var4_8 = null;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fPropertiesFile), StandardCharsets.UTF_8);){
                            this.fCCProperties.load(reader);
                        }
                        catch (Throwable throwable) {
                            if (result == null) {
                                result = throwable;
                            } else if (result != throwable) {
                                result.addSuppressed(throwable);
                            }
                            throw result;
                        }
                    }
                    catch (Exception e) {
                        ResultsViewPlugin.log(e);
                    }
                }
                this.fPropsAreSet = true;
            }
        }
    }

    protected File generatePropertiesFile(String filePath) {
        if (filePath != null) {
            java.nio.file.Path propertiesFileName = this.removeExtension(Paths.get(this.scrubPath(filePath), new String[0]).getFileName());
            java.nio.file.Path propFileDir = this.getResultLocation().getPropFileDir();
            if (propertiesFileName != null && propFileDir != null) {
                this.setPropFilePath(propFileDir.resolve(propertiesFileName.toString() + ".properties"));
            }
            return this.getPropFilePath().toFile();
        }
        return null;
    }

    protected java.nio.file.Path removeExtension(java.nio.file.Path fileName) {
        if (fileName != null) {
            return Paths.get(fileName.toString().replaceAll("[.]cczip|[.]zip", EMPTY), new String[0]);
        }
        return fileName;
    }

    protected String scrubPath(String path) {
        int colonIndex = path.lastIndexOf(58);
        if (colonIndex == -1) {
            return path;
        }
        return path.substring(colonIndex + 1);
    }

    @Override
    public IResultLocation getResultLocation() {
        return this.fResultLocation;
    }

    @Override
    public String getResultError() {
        String errorMsg = this.getProperty("resultError", null);
        return errorMsg == null ? EMPTY : errorMsg;
    }

    @Override
    public String getResultPath() {
        return this.fPath;
    }

    @Override
    public String getResultPath(boolean isLocal) {
        return this.getResultPath();
    }

    protected void setResultPath(String path) {
        this.fPath = path;
    }

    @Override
    public String getLevel() {
        return this.getProperty("cclevel", EMPTY);
    }

    protected String getLevelLabel(String level, String engineKey) {
        String levelStr = null;
        switch (level) {
            case "MODULE": {
                levelStr = ResultsViewUtilities.isISeriesEngine(engineKey) ? Labels.MODULE_ISERIES : Labels.MODULE;
                break;
            }
            case "FUNCTION": {
                levelStr = ResultsViewUtilities.isISeriesEngine(engineKey) ? Labels.FUNCTION_ISERIES : Labels.FUNCTION;
                break;
            }
            default: {
                levelStr = Labels.LINE;
            }
        }
        return levelStr;
    }

    @Override
    public void setResultLocation(IResultLocation resultLocation) {
        this.fResultLocation = resultLocation;
    }

    @Override
    public ICCResult getResult() {
        if (!this.isResultAvailable()) {
            this.analyze(true);
        }
        return this.fResult;
    }

    @Override
    public boolean isResultAvailable() {
        return this.fResult != null;
    }

    /*
     * Unable to fully structure code
     */
    protected void setResult(String localPath) {
        if (localPath == null) {
            this.fResult = null;
        } else {
            block11: {
                result = null;
                errorMsg = new StringBuilder();
                if (!this.isResultAvailable()) {
                    try {
                        result = CCResultsFactory.getInstance().createResult(localPath);
                        if (result != null) {
                            resultPath = new Path(localPath);
                            resultName = resultPath.removeFileExtension().lastSegment();
                            result.setName(resultName);
                        }
                        this.fResult = result;
                        break block11;
                    }
                    catch (CCResultException e) {
                        if (e.getExceptions().length > 0) {
                            errorMsg.append(e.getExceptions()[0].getMessage());
                        }
                        var8_8 = e.getExceptions();
                        var7_9 = var8_8.length;
                        var6_11 = 0;
                        ** while (var6_11 < var7_9)
                    }
lbl-1000:
                    // 1 sources

                    {
                        exception = var8_8[var6_11];
                        ResultsViewPlugin.log(exception.getMessage());
                        ++var6_11;
                        continue;
                    }
                }
            }
            if (result != null) {
                var7_10 = result.getMessages();
                var6_11 = var7_10.length;
                var5_7 = 0;
                while (var5_7 < var6_11) {
                    encodedMsg = var7_10[var5_7];
                    if (errorMsg.length() > 0) {
                        errorMsg.append(" ");
                    }
                    errorMsg.append(CCMessageUtilities.getMessage((String)encodedMsg));
                    ++var5_7;
                }
            }
            this.setResultError(errorMsg.toString());
        }
    }

    protected void setResult(ICCResult result) {
        this.fResult = result;
    }

    protected void setResultError(String error) {
        if (error == null || error.isEmpty()) {
            this.fCCProperties.remove("resultError");
        } else {
            this.fCCProperties.put("resultError", error);
        }
    }

    public int getPercentCoverage() {
        return Integer.parseInt(this.getProperty("percentCovered", "-1"));
    }

    private String getProperty(String key, String defaultValue) {
        this.initializeProperties();
        return this.fCCProperties.getProperty(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(boolean useResultAPI) {
        if (!this.exists()) {
            if (this.getResultLocation() != null && !this.getResultLocation().exists()) {
                CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(this.getResultLocation(), 3));
            } else {
                this.setResultError(CCResultViewMessages.CRRDG9308);
                ResultsViewPlugin.log(NLS.bind((String)CCResultViewMessages.CRRDG9309, (Object)this.getResultPath()));
            }
            return;
        }
        if (!this.isAnalyzed()) {
            Object object = this.fResultLock;
            synchronized (object) {
                if (!this.isAnalyzed()) {
                    this.doAnalysis(useResultAPI);
                    CCResultEventManager.getDefault().fireResultEvent(new CCResultEvent(this, 7));
                }
            }
        }
    }

    @Override
    public boolean isAnalyzed() {
        return this.isResultAvailable() || this.fCCProperties.containsKey("resultError");
    }

    protected abstract void doAnalysis(boolean var1);

    protected abstract boolean exists();

    @Override
    public String getLocalPath() {
        return this.getResultPath();
    }

    @Override
    public String getDefaultOpenMode() {
        return this.fMode;
    }

    @Override
    public void setDefaultOpenMode(String mode) {
        this.fMode = mode;
    }

    @Override
    public void setTestCaseId(String name) {
        try {
            CCImportUtilities.setTestId((String)this.getDataFileName(), (String)name, (boolean)true);
        }
        catch (Throwable e) {
            ResultsViewPlugin.log(e);
        }
        this.analyze(true);
        CCResultEventManager.getDefault().fireResultEvent(new CCResultEvent(this, 7));
    }

    @Override
    public void setTags(String tags) {
        try {
            CCImportUtilities.setTags((String)this.getDataFileName(), (String)tags, (boolean)true);
        }
        catch (Throwable e) {
            ResultsViewPlugin.log(e);
        }
        this.analyze(true);
        CCResultEventManager.getDefault().fireResultEvent(new CCResultEvent(this, 7));
    }

    public String toString() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (AbstractResultAdapter.class.isAssignableFrom(adapter)) {
            return this;
        }
        return null;
    }

    protected String getSeparator() {
        return File.separator;
    }

    @Override
    public boolean isBaselineUsed() {
        return false;
    }

    @Override
    public long getLocalResultAnalyzeTime() {
        return this.fLocalInitTime;
    }

    @Override
    public boolean isAdapterExpired() {
        return new File(this.getLocalPath()).lastModified() > this.getLocalResultAnalyzeTime();
    }

    protected int checkThreshold(int coverage, int threshold) {
        if (coverage >= threshold) {
            return 1;
        }
        return 2;
    }

    @Override
    public IEditorPart getOpenEditor() {
        IEditorReference[] editorRefs;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = editorRefs = window.getActivePage().getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor;
            IEditorInput editorInput;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            if (editorRef.getId().equals("com.ibm.debug.pdt.codecoverage.ui.view.web.browserviewer") && (editorInput = (editor = editorRef.getEditor(true)).getEditorInput()).getToolTipText() != null && this.isResultAvailable() && editorInput.getToolTipText().contains(String.valueOf(this.getResult().getUUID()))) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String rename(String newResultName) {
        String newPropFileName = (String)newResultName + ".properties";
        if (new File(this.getResultPath()).exists()) {
            if (!CCResultExporter.isValidExtension((String)newResultName)) {
                newResultName = (String)newResultName + CCResultExporter.getExtension();
            }
            java.nio.file.Path oldFile = Paths.get(this.getResultPath(), new String[0]);
            java.nio.file.Path newFile = Paths.get(String.valueOf(oldFile.getParent()) + File.separator + (String)newResultName, new String[0]);
            try {
                Files.move(oldFile, newFile, new CopyOption[0]);
                this.setResultPath(newFile.toFile().toString());
                this.setResult(newFile.toFile().toString());
                java.nio.file.Path oldPropFile = this.getPropFilePath();
                java.nio.file.Path newPropFile = oldPropFile.resolveSibling(newPropFileName);
                Files.move(oldPropFile, newPropFile, new CopyOption[0]);
                this.setPropFilePath(newPropFile);
                return null;
            }
            catch (Exception e) {
                ResultsViewPlugin.log(e);
                return newFile.toFile().exists() ? NLS.bind((String)CCResultViewMessages.CRRDG9307, (Object)newResultName) : NLS.bind((String)CCResultViewMessages.CRRDG9310, (Object)newResultName);
            }
        }
        return NLS.bind((String)CCResultViewMessages.CRRDG9311, (Object)this.getName());
    }

    @Override
    public void cleanup(boolean deleteDataFiles) {
        File f;
        if (this.getPropFilePath() != null) {
            try {
                Files.deleteIfExists(this.getPropFilePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (deleteDataFiles && (f = new File(this.getResultPath())).exists() && !f.delete()) {
            ResultsViewPlugin.log("Unable to delete: " + String.valueOf(f));
        }
        this.setResult((String)null);
    }

    @Override
    public String getDataFileName() {
        return this.getResultPath();
    }

    public int hashCode() {
        return (this.getResultLocation().getPath() + this.getName()).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IResultAdapter) {
            IResultAdapter item = (IResultAdapter)o;
            if (this.getName().equals(item.getName())) {
                return this.getResultLocation().getPath().equals(item.getResultLocation().getPath());
            }
        }
        return false;
    }

    @Override
    public int compareTo(IResultAdapter o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public void closeOpenedReportViewer() {
        final AbstractResultAdapter resultAdapter = this;
        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart editor = resultAdapter.getOpenEditor();
                if (editor != null) {
                    editor.getSite().getPage().closeEditor(editor, false);
                }
            }
        });
    }

    @Override
    public Date getAnalyzedDate() {
        try {
            return new Date(Long.parseLong(this.getProperty("dateAnalyzed", String.valueOf(new Date()))));
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public java.nio.file.Path getPropFilePath() {
        return this.fPropFilePath;
    }

    protected void setPropFilePath(java.nio.file.Path propFilePath) {
        this.fPropFilePath = propFilePath;
    }

    @Override
    public String getTags() {
        return this.getProperty("tags", EMPTY);
    }
}

