/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public abstract class AbstractRemoteResultLocation
extends AbstractResultLocation
implements IRemoteResultLocation {
    private CONNECTION fConnectionStatus = CONNECTION.DISCONNECTED;

    public AbstractRemoteResultLocation(String path, String name, boolean isDefault, IResultContentProvider provider) {
        super(path, name, isDefault, provider);
    }

    @Override
    public boolean exists() {
        return this.isConnected();
    }

    @Override
    public boolean expandLocationOnRestart() {
        return false;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.fConnectionStatus == CONNECTION.CONNECTED;
    }

    @Override
    public String getColumnText(int column) {
        if (column == 1) {
            switch (this.getConnectionStatus()) {
                case CONNECTED: {
                    return Labels.CONNECTED;
                }
                case DISCONNECTED: {
                    return Labels.DISCONNECTED;
                }
                case CONNECTING: {
                    return Labels.CONNECTING;
                }
                case CONNECTION_ERROR: {
                    return Labels.CONNECTION_ERROR;
                }
            }
            return "";
        }
        return "";
    }

    public CONNECTION getConnectionStatus() {
        return this.fConnectionStatus;
    }

    public void setConnectionStatus(CONNECTION connectionStatus) {
        this.fConnectionStatus = connectionStatus;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    protected void addSaveProperties(IMemento child) {
        if (this.getProvider() != null) {
            child.putString("remoteProvider", this.getProvider().getClass().getName());
        }
        child.putBoolean("isRemote", this.isRemote());
    }

    public static enum CONNECTION {
        DISCONNECTED,
        CONNECTED,
        CONNECTING,
        CONNECTION_ERROR;

    }
}

