/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.percentPainter;

import com.ibm.debug.pdt.codecoverage.core.results.ICCPercentItem;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.ui.percentPainter.AbstractTattColorFontItem;
import com.ibm.debug.pdt.codecoverage.ui.percentPainter.DefaultPainter;
import com.ibm.debug.pdt.codecoverage.ui.percentPainter.LinuxPainter;
import java.text.NumberFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

class CCCellPainter
extends AbstractTattColorFontItem {
    private static final NumberFormat fCachedFormat = NumberFormat.getPercentInstance();
    private int fColumnIndex;
    private Viewer fViewer;
    private Widget fText;
    private boolean fIsReverseColors;

    CCCellPainter(int columnIndex, Viewer viewer) {
        Assert.isNotNull((Object)viewer.getControl());
        Assert.isTrue((viewer instanceof TreeViewer || viewer instanceof TableViewer ? 1 : 0) != 0);
        this.fColumnIndex = columnIndex;
        this.fViewer = viewer;
    }

    CCCellPainter(Widget widget, boolean isReverseColors) {
        Assert.isTrue((widget instanceof Text || widget instanceof Label ? 1 : 0) != 0);
        this.fText = widget;
        this.fIsReverseColors = isReverseColors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Event event, Object element) {
        int progressBoxOffsetLeft = 0;
        int progressBoxOffsetRight = 1;
        int textStringOffset = 20;
        int progressBarLeftOffset = 0;
        int progressBarRightOffset = 0;
        int percentage = 0;
        String text = null;
        int yOffset = 0;
        int yHeight = 1;
        int left = event.x;
        int width = 0;
        GC gc = event.gc;
        Rectangle clippingRect = gc.getClipping();
        gc.setAdvanced(true);
        gc.setClipping(clippingRect);
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        Point extent = null;
        if (this.fText != null) {
            if (element instanceof String) {
                text = (String)element;
            }
            percentage = this.getPercentage(text);
            extent = gc.textExtent(text);
            width = Math.max(this.getWidth(event.widget), extent.x);
        } else {
            int index = event.index;
            if (index == this.fColumnIndex && index != 0) {
                percentage = 0;
                if (element instanceof ICCPercentItem) {
                    percentage = ((ICCPercentItem)element).getPercentCoverage();
                    if (percentage > -1) {
                        NumberFormat numberFormat = fCachedFormat;
                        synchronized (numberFormat) {
                            text = fCachedFormat.format((double)percentage / 100.0).intern();
                        }
                    } else {
                        text = Labels.NOT_APPLICABLE;
                    }
                } else {
                    return;
                }
                yOffset = 2;
                yHeight = 4;
                progressBoxOffsetLeft = 2;
                progressBoxOffsetRight = 5;
                progressBarLeftOffset = 0;
                progressBarRightOffset = 0;
                left += 6;
                extent = gc.textExtent(text);
                width = Math.max(this.getWidth(event.widget, index) - 12, extent.x + 12);
            }
        }
        if (width > 0) {
            if (text == null) {
                text = Labels.NOT_APPLICABLE;
            }
            Display display = event.widget.getDisplay();
            gc.setForeground(display.getSystemColor(1));
            gc.fillRectangle(left + progressBoxOffsetLeft, event.y + yOffset, width - progressBoxOffsetRight, event.height - yHeight);
            gc.setForeground(display.getSystemColor(16));
            gc.drawRectangle(left + progressBoxOffsetLeft, event.y + yOffset, width - progressBoxOffsetRight, event.height - yHeight);
            int alpha = gc.getAlpha();
            gc.setAlpha(120);
            int y = event.y + yOffset;
            int height = event.height - yHeight;
            DefaultPainter painter = "linux".equals(Platform.getOS()) ? new LinuxPainter(this.fIsReverseColors ? this.getCoveredForegroundColor() : this.getCoveredBackgroundColor(), this.fIsReverseColors ? this.getCoveredBackgroundColor() : this.getCoveredForegroundColor(), this.fIsReverseColors ? this.getUncoveredForegroundColor() : this.getUncoveredBackgroundColor(), this.fIsReverseColors ? this.getUncoveredBackgroundColor() : this.getUncoveredForegroundColor()) : new DefaultPainter(this.fIsReverseColors ? this.getUncoveredBackgroundColor() : this.getCoveredBackgroundColor(), this.fIsReverseColors ? this.getUncoveredForegroundColor() : this.getCoveredForegroundColor(), this.fIsReverseColors ? this.getCoveredBackgroundColor() : this.getUncoveredBackgroundColor(), this.fIsReverseColors ? this.getCoveredForegroundColor() : this.getUncoveredForegroundColor());
            painter.paintProgress(gc, left + progressBarLeftOffset, y, width - progressBarRightOffset, height, percentage, progressBoxOffsetLeft, progressBoxOffsetRight);
            gc.setAlpha(alpha);
            gc.setForeground(foreground);
            gc.setBackground(background);
            textStringOffset = (width - gc.textExtent((String)text).x) / 2;
            gc.drawString(text, left + textStringOffset, event.y + (event.height - extent.y + 1) / 2 + 1, true);
        }
    }

    private int getWidth(Widget w, int index) {
        if (w instanceof Tree) {
            return ((Tree)w).getColumn(index).getWidth();
        }
        if (w instanceof Table) {
            return ((Table)w).getColumn(index).getWidth();
        }
        return 0;
    }

    @Override
    protected void doRedraw() {
        this.fViewer.getControl().redraw();
    }

    public void paint(Event event) {
        String text = null;
        if (this.fText instanceof Label) {
            text = ((Label)this.fText).getText();
        } else if (this.fText instanceof Text) {
            text = ((Text)this.fText).getText();
        }
        this.paint(event, text);
    }

    private int getPercentage(String text) {
        if (text != null) {
            if ((text = text.trim()).endsWith("%")) {
                text = text.substring(0, text.length() - 1);
            }
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private int getWidth(Widget widget) {
        if (widget instanceof Text) {
            return ((Text)widget).getSize().x;
        }
        if (widget instanceof Label) {
            return ((Label)widget).getSize().x;
        }
        return 0;
    }
}

