/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.debug.pdt.codecoverage.internal.core.results.XMLUtils;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.CCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.security.CCSSecurityUtils;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ConnectLocationFields;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.CcsNetAuthenticator;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocationDialogContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.LocalResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultException;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ResultViewImportExportUtils {
    private static IUtilitiesContentProvider fProvider = ResultViewImportExportUtils.getContentProvider();

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static boolean addNewLocation(final ConnectLocationFields connectLocation, final Shell shell, final String name) {
        final boolean[] addOK = new boolean[1];
        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IResultLocation resultLocation = null;
                if (connectLocation.isCCaaS()) {
                    String host = connectLocation.getCCaaSHost();
                    String port = connectLocation.getCCaaSPort();
                    String ResultlocationName = name == null || name.isEmpty() ? connectLocation.getLocation() : name;
                    HttpClient httpClient = new HttpClient(host, port, connectLocation.isSecured(), CCSSecurityUtils.getSocketFactory(), CCSSecurityUtils.getHostNameVerifier());
                    if (ResultViewImportExportUtils.pingCCaaSOK(httpClient, shell)) {
                        resultLocation = new CCaasResultLocation(ResultlocationName, httpClient);
                    }
                } else {
                    String location = connectLocation.getLocation();
                    String connection = connectLocation.getConnection();
                    if (fProvider != null && fProvider.isValidRemoteLocation(connection, location)) {
                        String remotePath = fProvider.populateRemotePath(connection, location);
                        IRemoteResultContentProvider provider = null;
                        IRemoteResultLocationDialogContentProvider[] iRemoteResultLocationDialogContentProviderArray = ResultsViewContentProviders.getRemoteDialogContentProviders();
                        int n = iRemoteResultLocationDialogContentProviderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRemoteResultLocationDialogContentProvider dcProvider = iRemoteResultLocationDialogContentProviderArray[n2];
                            provider = dcProvider.getRemoteFileProvider();
                            ++n2;
                        }
                        if (provider == null || remotePath == null) {
                            return;
                        }
                        try {
                            resultLocation = provider.resolveRemotePath(remotePath, name, true, false);
                        }
                        catch (ResultException ex) {
                            ResultsViewPlugin.log(ex);
                            return;
                        }
                    } else {
                        resultLocation = new LocalResultLocation(location, name, false, null);
                    }
                }
                if (resultLocation != null) {
                    CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(resultLocation, 1));
                    addOK[0] = true;
                }
            }
        });
        return addOK[0];
    }

    public static boolean pingCCaaSOK(final HttpClient httpClient, final Shell shell) {
        final boolean[] pingCCaaSOK = new boolean[]{true};
        BusyIndicator.showWhile((Display)ResultViewImportExportUtils.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Authenticator.setDefault(new CcsNetAuthenticator(httpClient));
                    httpClient.ping();
                }
                catch (SSLException e) {
                    if (CCSSecurityUtils.importCertificates(httpClient.getHost())) {
                        try {
                            httpClient.setSSLSocketFactory(CCSSecurityUtils.getSocketFactory());
                            httpClient.ping();
                        }
                        catch (Exception e2) {
                            ResultsViewPlugin.log(e2);
                            pingCCaaSOK[0] = false;
                            MessageDialog.openError((Shell)shell, (String)CCResultViewMessages.CRRDG9305, (String)CCResultViewMessages.CRRDG9306);
                        }
                    } else {
                        pingCCaaSOK[0] = false;
                    }
                }
                catch (Exception e) {
                    ResultsViewPlugin.log(e);
                    pingCCaaSOK[0] = false;
                    MessageDialog.openError((Shell)shell, (String)CCResultViewMessages.CRRDG9305, (String)CCResultViewMessages.CRRDG9306);
                }
            }
        });
        return pingCCaaSOK[0];
    }

    public static boolean isFileExtensionValid(String fileName, boolean isDefaultLocation) {
        return isDefaultLocation ? fileName.endsWith(".clcoveragedata") || fileName.endsWith(".cczip") || fileName.endsWith(".zip") : fileName.endsWith(".cczip");
    }

    public static IUtilitiesContentProvider getContentProvider() {
        IUtilitiesContentProvider[] iUtilitiesContentProviderArray = ResultsViewContentProviders.getUtilContentProviders();
        if (iUtilitiesContentProviderArray.length != 0) {
            IUtilitiesContentProvider provider = iUtilitiesContentProviderArray[0];
            return provider;
        }
        return null;
    }

    public static void deleteDir(String directory) throws IOException {
        Files.walkFileTree(Paths.get(directory, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void resetViewFileFolder(File dataFile, String newValue, boolean prepend) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        DocumentBuilder docBuilder = XMLUtils.getSecureDocumentBuilderFactory().newDocumentBuilder();
        Document doc = docBuilder.parse(dataFile);
        Element rootElement = doc.getDocumentElement();
        if (rootElement.getNodeName().equals("LLC")) {
            if (prepend) {
                Object viewFileFolder = rootElement.getAttribute("viewFileFolder");
                viewFileFolder = newValue + (String)viewFileFolder;
                rootElement.setAttribute("viewFileFolder", (String)viewFileFolder);
            } else if (newValue == null) {
                rootElement.removeAttribute("viewFileFolder");
            } else {
                rootElement.setAttribute("viewFileFolder", newValue);
            }
        }
        Transformer xformer = XMLUtils.getSecureTransformerFactory().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        FileOutputStream fos = new FileOutputStream(dataFile);
        StreamResult result = new StreamResult(fos);
        DOMSource source = new DOMSource(doc);
        xformer.transform(source, result);
        fos.close();
    }

    public static void importCoverageDataFile(File dataFile, IResultLocation location) {
        ResultViewImportExportUtils.importCoverageDataFile(dataFile, false, location);
    }

    public static void importCoverageDataFile(File dataFile, boolean generatedFromZip, IResultLocation location) {
        ResultViewImportExportUtils.importCoverageDataFile(dataFile, generatedFromZip, (IProgressMonitor)new NullProgressMonitor(), location);
    }

    public static void importCoverageDataFile(final File dataFile, boolean generatedFromZip, final IProgressMonitor monitor, final IResultLocation ResultLocation) {
        monitor.beginTask("", 40);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IResultLocation location = ResultLocation;
                IResultAdapter adapter = ResultsViewUtilities.getResult(dataFile.getAbsolutePath());
                adapter.setResultLocation(location);
                location.addResult(adapter);
                monitor.worked(10);
                CCResultEventManager.getDefault().fireResultEvent(new CCResultEvent(adapter, 5));
                ResultsViewUtilities.showCodeCoverageResultsView();
                monitor.worked(10);
                adapter.analyze(true);
                monitor.worked(10);
            }
        });
        monitor.worked(10);
        monitor.done();
    }

    public static void copyLocalFile(File file, File targetFolder) throws IOException {
        File destination = new File(targetFolder.getAbsolutePath() + File.separator + file.getName());
        if (file.isDirectory()) {
            File[] children;
            if (!destination.exists() && !destination.mkdirs()) {
                ResultsViewPlugin.log(4, "Unable to create dir: " + String.valueOf(file));
            }
            if ((children = file.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    ResultViewImportExportUtils.copyLocalFile(f, destination);
                    ++n2;
                }
            }
        } else {
            Files.copy(file.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

