/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler;

import com.ibm.debug.pdt.codecoverage.core.results.CCLabelUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.CumulativeAnnotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class HoverInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private static final int ANNOTATION = 0;
    private static final int LINERANGE = 1;
    private Composite fTableComposite;
    private Label fTitleLabel;
    private boolean fHasContents = false;

    public HoverInformationControl(Shell parentShell, boolean isResizable) {
        super(parentShell, isResizable);
        this.create();
    }

    public boolean hasContents() {
        return this.fHasContents;
    }

    protected void createContent(Composite parent) {
        this.fTableComposite = new Composite(parent, 0);
        this.fTableComposite.setBackground(parent.getBackground());
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(this.fTableComposite);
        this.fTitleLabel = new Label(this.fTableComposite, 65);
        this.fTitleLabel.setBackground(parent.getBackground());
        String titleText = NLS.bind((String)Labels.LINE_COVERED_MESSAGE2, (Object)0);
        this.fTitleLabel.setText(titleText);
    }

    public void setInput(Object input) {
        this.fHasContents = false;
        if (input instanceof Object[]) {
            ILineRange lineRange = null;
            Object[] inputList = (Object[])input;
            CumulativeAnnotation annotation = null;
            if (!(inputList[0] instanceof CumulativeAnnotation)) {
                return;
            }
            annotation = (CumulativeAnnotation)((Object)inputList[0]);
            if (inputList[1] instanceof ILineRange && annotation.getFile() != null) {
                lineRange = (ILineRange)inputList[1];
                StringBuilder titleText = new StringBuilder();
                boolean covered = annotation.isCovered(lineRange.getStartLine());
                if (lineRange.getNumberOfLines() == 1) {
                    titleText.append(NLS.bind((String)(covered ? Labels.LINE_COVERED_MESSAGE2 : Labels.LINE_MISSED_MESSAGE), (Object)(lineRange.getStartLine() + 1)));
                } else {
                    titleText.append(NLS.bind((String)(covered ? Labels.LINES_COVERED_MESSAGE2 : Labels.LINES_MISSED_MESSAGE), (Object[])new Object[]{lineRange.getStartLine() + 1, lineRange.getStartLine() + lineRange.getNumberOfLines()}));
                }
                for (String details : annotation.getIncludeFileDetails()) {
                    StringTokenizer st = new StringTokenizer(details, ",");
                    ArrayList<String> labelParms = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        int numOfParameters = 0;
                        labelParms.clear();
                        try {
                            numOfParameters = Integer.parseInt(st.nextToken());
                        }
                        catch (Exception e) {
                            continue;
                        }
                        int x = 0;
                        while (x < numOfParameters) {
                            labelParms.add(st.nextToken());
                            ++x;
                        }
                        titleText.append("\n");
                        Collections.rotate(labelParms, -1);
                        titleText.append(CCLabelUtilities.getLabel((String)"includeFileDetails", (String[])labelParms.toArray(new String[labelParms.size()])));
                    }
                }
                this.fTitleLabel.setText(titleText.toString());
                this.fTitleLabel.getParent().layout(true);
                this.fHasContents = true;
            }
            this.fTableComposite.layout(true);
            Point size = this.getShell().computeSize(-1, -1, true);
            this.setSizeConstraints(size.x, size.y);
        }
    }
}

