/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler;

import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.source.Annotation;

public class CumulativeAnnotation
extends Annotation {
    private static final String COVERED_TYPE = "com.ibm.debug.pdt.tatt.ui.cumulative.covered";
    private static final String NOT_COVERED_TYPE = "com.ibm.debug.pdt.tatt.ui.cumulative.notcovered";
    private boolean fCovered;
    private ICCFile fFile;
    private int fStartLine;
    private int fEndLine;
    private Set<String> fIncludeFileDetails;

    public CumulativeAnnotation(boolean covered, ICCTestcase[] tests, ICCFile file, int startLine, int endLine, Map<Integer, String> includeFileDetails) {
        super(covered ? COVERED_TYPE : NOT_COVERED_TYPE, false, "");
        this.fCovered = covered;
        this.fFile = file;
        this.fStartLine = startLine;
        this.fEndLine = endLine;
        this.fIncludeFileDetails = new HashSet<String>();
        int i = this.fStartLine;
        while (i <= this.fEndLine) {
            if (includeFileDetails.containsKey(i)) {
                this.fIncludeFileDetails.add(includeFileDetails.get(i));
            }
            ++i;
        }
    }

    public boolean isCovered(int line) {
        return this.fCovered;
    }

    public Integer[] getCoveredLines(ICCFile file) {
        return file.getLines(true);
    }

    public ICCFile getFile() {
        return this.fFile;
    }

    public int getStartLine(int lineNumber, int minValue) {
        boolean covered = this.isCovered(lineNumber);
        Object[] executableLines = this.fFile.getLines(false);
        int index = Arrays.binarySearch(executableLines, (Object)lineNumber);
        if (index > -1) {
            while (--index > -1 && (Integer)executableLines[index] >= minValue) {
                boolean newLineCovered = this.isCovered((Integer)executableLines[index]);
                if (newLineCovered != covered) break;
            }
            return (Integer)executableLines[index + 1];
        }
        return lineNumber;
    }

    public int getEndLine(int lineNumber, int maxValue) {
        boolean covered = this.isCovered(lineNumber);
        Object[] executableLines = this.fFile.getLines(false);
        int index = Arrays.binarySearch(executableLines, (Object)lineNumber);
        if (index > -1) {
            while (++index < executableLines.length && (Integer)executableLines[index] <= maxValue) {
                boolean newLineCovered = this.isCovered((Integer)executableLines[index]);
                if (newLineCovered != covered) break;
            }
            return (Integer)executableLines[index - 1];
        }
        return lineNumber;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public Set<String> getIncludeFileDetails() {
        return this.fIncludeFileDetails;
    }
}

