/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.preferences;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.preferences.ThresholdPreferenceInitializer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ThresholdPreferencePage
extends FieldEditorPreferencePage {
    public static final String ID = "com.ibm.debug.pdt.codecoverage.ui.resultsview.preferences.ThresholdPreferencePage";
    public static final String THRESHOLD_DEFAULT_PREF = "com.ibm.debug.pdt.tatt.threshold";
    public static final String THRESHOLD_DEFAULT_PREF_WARNING = "com.ibm.debug.pdt.tatt.threshold.warning";
    private static final int MIN_VALID_THRESHOLD = 0;
    private static final int MAX_VALID_THRESHOLD = 100;
    private IntegerFieldEditor fThresholdFail;
    private IntegerFieldEditor fThresholdWarning;

    public ThresholdPreferencePage() {
        this.setTitle(Labels.TOA_VIEWER);
    }

    protected void createFieldEditors() {
        final Composite parent = this.getFieldEditorParent();
        this.fThresholdFail = new IntegerFieldEditor(THRESHOLD_DEFAULT_PREF, Labels.THRESHOLD_P, parent, 3){

            protected boolean checkState() {
                int warningThreshold;
                this.setValidRange(0, 100);
                Text failText = this.getTextControl();
                if (!ThresholdPreferencePage.this.checkTextState(failText)) {
                    this.showErrorMessage();
                    return false;
                }
                Text warningText = ThresholdPreferencePage.this.fThresholdWarning.getTextControl(parent);
                if (!ThresholdPreferencePage.this.checkTextState(warningText)) {
                    ThresholdPreferencePage.this.fThresholdWarning.showErrorMessage();
                    return false;
                }
                int failThreshold = Integer.parseInt(failText.getText());
                if (failThreshold > (warningThreshold = Integer.parseInt(warningText.getText()))) {
                    this.setErrorMessage(CCResultViewMessages.CRRDG9330);
                    this.showErrorMessage();
                    return false;
                }
                this.clearErrorMessage();
                return true;
            }
        };
        this.fThresholdFail.setValidRange(0, 100);
        this.addField((FieldEditor)this.fThresholdFail);
        this.fThresholdWarning = new IntegerFieldEditor(THRESHOLD_DEFAULT_PREF_WARNING, Labels.THRESHOLD_P_WARNING, parent, 3){

            protected boolean checkState() {
                int warningThreshold;
                this.setValidRange(0, 100);
                Text warningText = this.getTextControl();
                if (!ThresholdPreferencePage.this.checkTextState(warningText)) {
                    this.showErrorMessage();
                    return false;
                }
                Text failText = ThresholdPreferencePage.this.fThresholdFail.getTextControl(parent);
                if (!ThresholdPreferencePage.this.checkTextState(failText)) {
                    ThresholdPreferencePage.this.fThresholdFail.showErrorMessage();
                    return false;
                }
                int failThreshold = Integer.parseInt(failText.getText());
                if (failThreshold > (warningThreshold = Integer.parseInt(warningText.getText()))) {
                    this.setErrorMessage(CCResultViewMessages.CRRDG9330);
                    this.showErrorMessage();
                    return false;
                }
                this.clearErrorMessage();
                return true;
            }
        };
        this.fThresholdWarning.setValidRange(0, 100);
        this.addField((FieldEditor)this.fThresholdWarning);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.pdt.codecoverage.ui.view.file_analysis_preference_page");
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ThresholdPreferenceInitializer.getPreStore();
    }

    public static int getThreshold() {
        return ThresholdPreferenceInitializer.getPreStore().getInt(THRESHOLD_DEFAULT_PREF);
    }

    public static int getWarningThreshold() {
        return ThresholdPreferenceInitializer.getPreStore().getInt(THRESHOLD_DEFAULT_PREF_WARNING);
    }

    private boolean checkTextState(Text text) {
        if (text == null) {
            return false;
        }
        String numberString = text.getText();
        try {
            int number = Integer.parseInt(numberString);
            if (number >= 0 && number <= 100) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }
}

