/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.migration;

import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.compiled.ICCResultConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.JavaDeprecatedLocation;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class JavaCCResultsMigration
implements IResultViewConstants,
ICCResultConstants {
    private IPath fResultViewDir = null;
    private File fSourceJavaCCDir = null;
    private File[] EMPTYFILES = new File[0];
    private FileFilter fJavaDataFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".coveragedata") || pathname.isDirectory();
        }
    };
    private FileFilter fCCzipFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".cczip");
        }
    };

    public JavaCCResultsMigration() {
        Job j = new Job("Waiting for migrate old java data files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String coverageRoot = ".coverage";
                    String junitCoverageRoot = ".junitcoverage";
                    if (JavaCCResultsMigration.this.getOriginalJCCDir(coverageRoot) == null && JavaCCResultsMigration.this.getOriginalJCCDir(junitCoverageRoot) == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (JavaCCResultsMigration.this.getOriginalJCCDir(coverageRoot) != null) {
                        JavaCCResultsMigration.this.convertToCCzip(coverageRoot);
                        JavaCCResultsMigration.this.fSourceJavaCCDir = null;
                    }
                    if (JavaCCResultsMigration.this.getOriginalJCCDir(junitCoverageRoot) != null) {
                        JavaCCResultsMigration.this.convertToCCzip(junitCoverageRoot);
                    }
                    if (JavaCCResultsMigration.this.hasMigrationDone()) {
                        JavaCCResultsMigration.this.addJavaDeprecatedLocation();
                    }
                }
                catch (CCResultException | CCExportException | IOException e) {
                    ResultsViewPlugin.log(e);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return new Status(4, "com.ibm.debug.pdt.codecoverage.ui.view", e.getMessage());
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }

    public boolean hasMigrationDone() {
        File[] files;
        return this.getTargetCCzipDir().toFile().exists() && (files = this.getAllDataFiles(this.getTargetCCzipDir().toFile(), this.fCCzipFileFilter)) != null && files.length > 0;
    }

    private IPath getResultViewDir() {
        if (this.fResultViewDir == null) {
            Bundle bundle = Platform.getBundle((String)"com.ibm.debug.pdt.codecoverage.ui.view");
            this.fResultViewDir = Platform.getStateLocation((Bundle)bundle);
        }
        return this.fResultViewDir;
    }

    private File getOriginalJCCDir(String root) {
        File[] allDirectories;
        if (this.fSourceJavaCCDir == null && (allDirectories = this.getResultViewDir().toFile().getParentFile().listFiles(File::isDirectory)) != null) {
            File[] fileArray = allDirectories;
            int n = allDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File[] allFiles;
                File dir = fileArray[n2];
                if (dir.getName().matches("com.ibm.rational.llc.ide.core") && (allFiles = dir.listFiles(File::isDirectory)) != null) {
                    File[] fileArray2 = allFiles;
                    int n3 = allFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file = fileArray2[n4];
                        if (file.getName().matches(root)) {
                            this.fSourceJavaCCDir = file;
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return this.fSourceJavaCCDir;
    }

    private void convertToCCzip(String root) throws IOException, CCResultException, CCExportException {
        File javaLocationRoot = new File(this.getOriginalJCCDir(root).getPath());
        File[] dataFiles = this.getAllDataFiles(javaLocationRoot, this.fJavaDataFileFilter);
        if (dataFiles == this.EMPTYFILES) {
            return;
        }
        if (!this.getTargetCCzipDir().toFile().exists() && !this.getTargetCCzipDir().toFile().mkdirs()) {
            ResultsViewPlugin.log("JavaCCResultsMigration: Unable to create: " + String.valueOf(this.getTargetCCzipDir().toFile()));
        }
        File[] fileArray = dataFiles;
        int n = dataFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File dataFile = fileArray[n2];
            ICCResult jResult = null;
            if (dataFile.isDirectory()) {
                File[] files = this.getAllDataFiles(dataFile, this.fJavaDataFileFilter);
                if (files == this.EMPTYFILES) break;
                File[] fileArray2 = files;
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    if (file.getName().endsWith(".coveragedata")) {
                        jResult = CCResultsFactory.getInstance().createResult(file.getPath());
                    }
                    ++n4;
                }
            } else {
                jResult = CCResultsFactory.getInstance().createResult(dataFile.getPath());
            }
            if (jResult != null) {
                ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
                File cczip = new File(String.valueOf(this.getTargetCCzipDir().toFile()) + File.separator + this.getResultName(dataFile.getName()));
                exporter.exportResult(jResult, null, cczip.getAbsolutePath(), true);
            }
            ++n2;
        }
        this.renameOriginalJCCDir(root);
    }

    private String getResultName(String fullName) {
        int lastIndex = fullName.lastIndexOf("-");
        return fullName.substring(0, lastIndex);
    }

    private File[] getAllDataFiles(File file, FileFilter filter) {
        File[] dataFiles;
        if (file.exists() && (dataFiles = file.listFiles(filter)) != null && dataFiles.length > 0) {
            return dataFiles;
        }
        return this.EMPTYFILES;
    }

    public IPath getTargetCCzipDir() {
        IPath targeCCzipDir = this.getResultViewDir().append("JCCResult");
        return targeCCzipDir;
    }

    private void renameOriginalJCCDir(String root) {
        Path dir = new Path(this.getOriginalJCCDir(root).getParent());
        dir = dir.append("migrated_" + root.replace(".", ""));
        File originalDir = this.getOriginalJCCDir(root);
        if (!originalDir.renameTo(dir.toFile())) {
            ResultsViewPlugin.log("JavaCCResultsMigration: Unable to rename: " + String.valueOf(originalDir));
        }
    }

    private void addJavaDeprecatedLocation() {
        final JavaDeprecatedLocation javaLoc = new JavaDeprecatedLocation(this.getTargetCCzipDir().toString(), true, null);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (javaLoc != null) {
                    CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(javaLoc, 1));
                }
            }
        });
    }
}

