/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.IImportResultWizardContribution;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ImportWizardUtilities {
    static boolean fInitialized = false;
    static Map<String, IImportResultWizardContribution> fContributions = new HashMap<String, IImportResultWizardContribution>();

    private static void initializeContributions() {
        if (!fInitialized) {
            fInitialized = true;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.codecoverage.ui.view.importResult");
            if (ep != null) {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = ep.getConfigurationElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement config = iConfigurationElementArray[n2];
                    try {
                        IImportResultWizardContribution contribution = (IImportResultWizardContribution)config.createExecutableExtension("class");
                        String id = config.getAttribute("id");
                        if (fContributions.containsKey(id)) {
                            ResultsViewPlugin.log(1, "ID already contributed: " + id + " class->" + contribution.getClass().getName());
                        } else {
                            fContributions.put(id, contribution);
                        }
                    }
                    catch (CoreException e) {
                        ResultsViewPlugin.log(e);
                    }
                    catch (ClassCastException e) {
                        ResultsViewPlugin.log(e);
                    }
                    ++n2;
                }
            }
        }
    }

    public static Map<String, IImportResultWizardContribution> getWizardPageContributions() {
        ImportWizardUtilities.initializeContributions();
        HashMap<String, IImportResultWizardContribution> result = new HashMap<String, IImportResultWizardContribution>();
        result.putAll(fContributions);
        return result;
    }

    protected static void openError(final String title, final String message, final Throwable[] exception) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Status> statusList = new ArrayList<Status>();
                    Throwable[] throwableArray = exception;
                    int n = exception.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Throwable t = throwableArray[n2];
                        statusList.add(new Status(4, "com.ibm.debug.pdt.codecoverage.ui.view", t.getMessage(), null));
                        ++n2;
                    }
                    MultiStatus status = new MultiStatus("com.ibm.debug.pdt.codecoverage.ui.view", 4, (IStatus[])statusList.toArray(new Status[statusList.size()]), message, null);
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)title, null, (IStatus)status);
                }
            });
        }
    }

    protected static void openError(final String title, final String message, final Throwable exception) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Status status = new Status(4, "com.ibm.debug.pdt.codecoverage.ui.view", message, exception);
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)title, null, (IStatus)status);
                }
            });
        }
    }

    protected static void showMessage(final Shell shell, final String messageTitle, final String message) {
        ResultViewImportExportUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)messageTitle, (String)message);
            }
        });
    }
}

