/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.commoncomponents.codecoverage.core.exporters.events.FopEventListener;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsModifierFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResultModifier;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporterSettings;
import com.ibm.debug.pdt.codecoverage.core.results.filters.CCFilterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.filters.ICCFilter;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCFileMismatchException;
import com.ibm.debug.pdt.codecoverage.internal.core.exporter.cobertura.CCCoberturaExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.exporter.pdf.CCPdfExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.exporter.pdf.CCPdfExporterSettings;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.ccresults.CCResultExporterSettings;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.sonar.CCSonarQubeExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.sonar.CCSonarQubeExporterSettings;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultsView;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.CCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.ICCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.security.CCSSecurityUtils;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ConnectLocationFields;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ExportEncodingDialog;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.PdfPropertiesDialog;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.FontReflowUtil;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.fop.events.EventListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ExportCCZipWizardPage
extends WizardPage
implements IResultViewConstants {
    public static final int TYPE_COLUMN_INDEX = 0;
    public static final int NAME_COLUMN_INDEX = 1;
    private static final int ncol = 3;
    private Combo fFormatCombo;
    private Text fFileNameText;
    private Text fRootText;
    private Label fRootLabel;
    private Label fSuffixLabel;
    private String fExporterType = "CCRESULT";
    private ArrayList<IResultAdapter> fResultAdapters = null;
    private Button fSettingButton;
    private Button fOpenPDFCheckButton;
    private File fPDfPropertyFile = null;
    private Text fFilterText;
    private Button fRegExButton;
    private Button fAddLocationButton;
    private IDialogSettings fDialogSettings;
    private ConnectLocationFields fConnectLocationObject;
    private HttpClient fHttpClient;
    private boolean fConfirmOverWrite = true;
    private boolean isOpenPDFCheck = false;
    private boolean isComparisonPDFReport = false;
    private boolean fIsRegex = false;
    private boolean fAddLocation = false;
    private String fTempResultPath = null;
    private IUtilitiesContentProvider fProvider = CCResultsView.getProvider();

    public ExportCCZipWizardPage(ArrayList<IResultAdapter> resultAdapters, boolean isCompare) {
        super(Labels.ExportCCZipWizard, Labels.ExportCCZipWizard, null);
        this.setDescription(Labels.ExportCCZipAction_Description);
        this.isComparisonPDFReport = isCompare;
        this.fResultAdapters = resultAdapters;
    }

    public void createControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fDialogSettings = this.getWizard().getDialogSettings();
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        GridLayoutFactory.swtDefaults().applyTo((Composite)sc);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite composite = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createFields(composite);
        this.initializeControls();
        sc.setContent((Control)composite);
        sc.setMinSize(composite.computeSize(-1, -1));
        FontReflowUtil.installListeners(sc);
        this.setControl((Control)sc);
        if (ResultsViewContentProviders.getRemoteDialogContentProviders().length == 0) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.debug.pdt.codecoverage.ui.view.export_cc_wizard_no_rse");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.debug.pdt.codecoverage.ui.view.export_cc_wizard");
        }
    }

    private void createFields(Composite composite) {
        this.createFormatType(composite);
        this.fConnectLocationObject = new ConnectLocationFields(composite, this.getShell(), this.fDialogSettings, Labels.ExportCCZipWizardPage_Connection, Labels.COVERAGEIMPORTWIZARDPAGE_LOCATION_LABEL, false, false);
        this.fConnectLocationObject.addConnectLocationListener(new ConnectLocationFields.IConnectLocationListener(){

            @Override
            public void modifyText() {
                ExportCCZipWizardPage.this.validateFields();
            }
        });
        this.createResultFile(composite);
        this.createFilter(composite);
        this.createRootPath(composite);
        this.createLine(composite, 3);
        this.createCheckOptions(composite);
    }

    private void createFormatType(Composite composite) {
        new Label(composite, 0).setText(Labels.ExportCCZipWizardPage_ExporterTypes);
        this.fFormatCombo = new Combo(composite, 2056);
        this.fFormatCombo.add(Labels.ExportCCZipWizardPage_CCZipOption);
        this.fFormatCombo.add(Labels.ExportCCZipWizardPage_SonarQubeOption);
        this.fFormatCombo.add(Labels.ExportCCZipWizardPage_CoberturaOption);
        this.fFormatCombo.add(Labels.ExportCCZipWizardPage_PDFOption);
        if (this.fResultAdapters.size() == 2) {
            this.fFormatCombo.add(Labels.ExportCCZipWizardPage_PDFCompareOption);
        }
        this.fFormatCombo.select(0);
        this.fFormatCombo.setLayoutData((Object)new GridData(768));
        this.fFormatCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExportCCZipWizardPage.this.updateControls();
            }
        });
        this.fSettingButton = new Button(composite, 8);
        this.fSettingButton.setText(Labels.OPEN_PDF_PROPERTIES_BUTTON);
        GridData data = new GridData();
        data.widthHint = 120;
        this.fSettingButton.setLayoutData((Object)data);
        this.fSettingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ExportCCZipWizardPage.this.isFormatType(FORMAT_TYPE.SONARQUBE)) {
                            new ExportEncodingDialog(ExportCCZipWizardPage.this.getShell(), (this).ExportCCZipWizardPage.this.fDialogSettings).open();
                        } else if (ExportCCZipWizardPage.this.isFormatType(FORMAT_TYPE.PDF) || ExportCCZipWizardPage.this.isFormatType(FORMAT_TYPE.PDFCOMPARE)) {
                            block18: {
                                if ((this).ExportCCZipWizardPage.this.fPDfPropertyFile == null) {
                                    FileOutputStream out = null;
                                    Properties prop = new Properties();
                                    try {
                                        try {
                                            (this).ExportCCZipWizardPage.this.fPDfPropertyFile = File.createTempFile("user", ".properties");
                                            out = new FileOutputStream((this).ExportCCZipWizardPage.this.fPDfPropertyFile);
                                            prop.store(out, Labels.PDF_PROPERTIES_DIALOG_TITLE);
                                            out.close();
                                            (this).ExportCCZipWizardPage.this.fPDfPropertyFile.deleteOnExit();
                                        }
                                        catch (Exception e) {
                                            ResultsViewPlugin.log(e);
                                            try {
                                                if (out != null) {
                                                    out.close();
                                                }
                                                break block18;
                                            }
                                            catch (IOException e2) {
                                                ResultsViewPlugin.log(e2);
                                            }
                                            break block18;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            if (out != null) {
                                                out.close();
                                            }
                                        }
                                        catch (IOException e) {
                                            ResultsViewPlugin.log(e);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        if (out != null) {
                                            out.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        ResultsViewPlugin.log(e);
                                    }
                                }
                            }
                            PdfPropertiesDialog dialog = new PdfPropertiesDialog(ExportCCZipWizardPage.this.getShell(), (this).ExportCCZipWizardPage.this.fPDfPropertyFile, (this).ExportCCZipWizardPage.this.isComparisonPDFReport);
                            dialog.open();
                        }
                    }
                });
            }
        });
    }

    private void createCheckOptions(Composite composite) {
        this.fAddLocationButton = new Button(composite, 32);
        this.fAddLocationButton.setText(Labels.ExportCCZipWizardPage_Add_Location_Label);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fAddLocationButton.setLayoutData((Object)gd);
        this.fAddLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportCCZipWizardPage.this.fAddLocationButton = (Button)event.getSource();
                ExportCCZipWizardPage.this.fAddLocation = ExportCCZipWizardPage.this.fAddLocationButton.getSelection();
                ExportCCZipWizardPage.this.validateFields();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.fOpenPDFCheckButton = new Button(composite, 32);
        this.fOpenPDFCheckButton.setText(Labels.OPEN_PDF_UPON_COMPLETION_CHECKBOX);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 3;
        this.fOpenPDFCheckButton.setLayoutData((Object)gd2);
        this.fOpenPDFCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportCCZipWizardPage.this.fOpenPDFCheckButton = (Button)event.getSource();
                ExportCCZipWizardPage.this.isOpenPDFCheck = ExportCCZipWizardPage.this.fOpenPDFCheckButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void createFilter(Composite composite) {
        new Label(composite, 0).setText(Labels.ExportCCZipWizardPage_Filter_Label);
        this.fFilterText = new Text(composite, 2048);
        this.fFilterText.setLayoutData((Object)new GridData(768));
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportCCZipWizardPage.this.validateFields();
            }
        });
        this.fRegExButton = new Button(composite, 32);
        this.fRegExButton.setText(Labels.ExportCCZipWizardPage_Filter_REG_EX);
        this.fRegExButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportCCZipWizardPage.this.fRegExButton = (Button)event.getSource();
                ExportCCZipWizardPage.this.fIsRegex = ExportCCZipWizardPage.this.fRegExButton.getSelection();
                ExportCCZipWizardPage.this.validateFields();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void createResultFile(Composite composite) {
        new Label(composite, 0).setText(Labels.ExportCCZipWizardPage_ResultFileName);
        this.fFileNameText = new Text(composite, 2048);
        this.fFileNameText.setText(this.getDefaultResultName());
        this.fFileNameText.setLayoutData((Object)new GridData(768));
        this.fFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportCCZipWizardPage.this.validateFields();
            }
        });
        this.fFileNameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ExportCCZipWizardPage.this.fFileNameText.selectAll();
            }

            public void focusLost(FocusEvent e) {
                if (ExportCCZipWizardPage.this.fFileNameText.getText().isEmpty()) {
                    ExportCCZipWizardPage.this.fFileNameText.setText(ExportCCZipWizardPage.this.getDefaultResultName());
                }
            }
        });
        this.fSuffixLabel = new Label(composite, 16384);
    }

    private void createRootPath(Composite composite) {
        this.fRootLabel = new Label(composite, 0);
        this.fRootLabel.setText(Labels.ExportCCZipWizardPage_Root);
        this.fRootText = new Text(composite, 2048);
        this.fRootText.setLayoutData((Object)new GridData(768));
        this.fRootText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportCCZipWizardPage.this.validateFields();
            }
        });
        this.fRootText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ExportCCZipWizardPage.this.fRootText.selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    protected void initializeControls() {
        String exportType = this.fDialogSettings.get("exportType");
        if (exportType != null) {
            this.fFormatCombo.setText(exportType);
        } else {
            this.fFormatCombo.select(0);
        }
        this.updateControls();
    }

    private void updateControls() {
        this.fFilterText.setEnabled(true);
        this.fRegExButton.setEnabled(true);
        this.fOpenPDFCheckButton.setEnabled(false);
        this.fOpenPDFCheckButton.setSelection(false);
        this.fAddLocationButton.setEnabled(false);
        this.fAddLocationButton.setSelection(false);
        this.fSettingButton.setEnabled(false);
        this.isComparisonPDFReport = false;
        if (this.fDialogSettings.get("rootText") != null) {
            this.fRootText.setText(this.fDialogSettings.get("rootText"));
        }
        if (this.isFormatType(FORMAT_TYPE.PDF) || this.isFormatType(FORMAT_TYPE.PDFCOMPARE)) {
            this.fExporterType = "CCPDF";
            this.fSettingButton.setEnabled(true);
            this.fOpenPDFCheckButton.setEnabled(true);
            if (this.fDialogSettings.get("openPDF") != null) {
                this.fOpenPDFCheckButton.setSelection(Boolean.valueOf(this.fDialogSettings.get("openPDF")).booleanValue());
            }
            if (this.fDialogSettings.get("regEx") != null) {
                this.fRegExButton.setSelection(Boolean.valueOf(this.fDialogSettings.get("regEx")).booleanValue());
            }
            if (this.fDialogSettings.get("filterText") != null) {
                this.fFilterText.setText(this.fDialogSettings.get("filterText"));
            }
            if (this.isFormatType(FORMAT_TYPE.PDFCOMPARE)) {
                this.fExporterType = "CCPDF";
                this.isComparisonPDFReport = true;
                this.fFilterText.setText("");
                this.fFilterText.setEnabled(false);
                this.fRegExButton.setEnabled(false);
                this.fRegExButton.setSelection(false);
            }
        } else if (this.isFormatType(FORMAT_TYPE.CCZIP)) {
            this.fExporterType = "CCRESULT";
            this.fAddLocationButton.setEnabled(true);
            if (this.fDialogSettings.get("addResultLocation") != null) {
                this.fAddLocationButton.setSelection(Boolean.valueOf(this.fDialogSettings.get("addResultLocation")).booleanValue());
            }
            if (this.fDialogSettings.get("regEx") != null) {
                this.fRegExButton.setSelection(Boolean.valueOf(this.fDialogSettings.get("regEx")).booleanValue());
            }
            if (this.fDialogSettings.get("filterText") != null) {
                this.fFilterText.setText(this.fDialogSettings.get("filterText"));
            }
        } else if (this.isFormatType(FORMAT_TYPE.SONARQUBE)) {
            this.fExporterType = "CCSONARQUBE";
            this.fFilterText.setText("");
            this.fFilterText.setEnabled(false);
            this.fRegExButton.setEnabled(false);
            this.fRegExButton.setSelection(false);
            this.fSettingButton.setEnabled(true);
        } else if (this.isFormatType(FORMAT_TYPE.COBERTURA)) {
            this.fExporterType = "CCCOBERTURA";
            this.fFilterText.setText("");
            this.fFilterText.setEnabled(false);
            this.fRegExButton.setEnabled(false);
            this.fRegExButton.setSelection(false);
        }
        this.isOpenPDFCheck = this.fOpenPDFCheckButton.getSelection();
        this.fIsRegex = this.fRegExButton.getSelection();
        this.fAddLocation = this.fAddLocationButton.getSelection();
        this.changeSuffixLabel();
        this.validateFields();
    }

    public boolean performFinish() {
        String root;
        String suffix;
        String filterString;
        String fileName;
        String connection;
        String outputDir;
        boolean[] finishWizard;
        boolean isCCaaS;
        IWizardContainer container;
        block14: {
            block13: {
                container = this.getContainer();
                isCCaaS = this.fConnectLocationObject.isCCaaS();
                if (!isCCaaS) break block13;
                this.fHttpClient = new HttpClient(this.fConnectLocationObject.getCCaaSHost(), this.fConnectLocationObject.getCCaaSPort(), this.fConnectLocationObject.isSecured(), CCSSecurityUtils.getSocketFactory(), CCSSecurityUtils.getHostNameVerifier());
                if (ResultViewImportExportUtils.pingCCaaSOK(this.fHttpClient, this.getShell())) break block13;
                return false;
            }
            finishWizard = new boolean[]{true};
            outputDir = this.fConnectLocationObject.getLocation();
            connection = this.fConnectLocationObject.getConnection();
            fileName = this.fFileNameText.getText().trim();
            filterString = this.fFilterText.getText();
            suffix = this.fSuffixLabel.getText();
            root = this.fRootText.getText();
            if (!this.isFormatType(FORMAT_TYPE.COBERTURA) && !this.isFormatType(FORMAT_TYPE.SONARQUBE) || this.fConnectLocationObject.isLocationEmpty()) break block14;
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Labels.ExportCCZipWizard, (String)CCResultViewMessages.CRRDG9323);
            return false;
        }
        try {
            boolean resultFileExists;
            boolean createTempFile = false;
            createTempFile = isCCaaS ? true : (this.fProvider == null ? false : this.fProvider.isValidRemoteLocation(connection, outputDir));
            final String outputPath = this.getOutputPath(createTempFile, outputDir, fileName.concat(suffix));
            if (!root.isEmpty() && !filterString.isEmpty()) {
                this.fTempResultPath = this.getOutputPath(true, null, fileName);
            }
            String f = outputDir + File.separator + fileName.concat(suffix);
            boolean bl = isCCaaS ? false : (resultFileExists = this.fProvider == null ? new File(f).exists() : this.fProvider.isFileExists(connection, f));
            if (resultFileExists) {
                MessageDialog d = new MessageDialog(this.getShell(), Labels.ExportCCZipWizard_ConfirmOverwrite_Title, null, CCResultViewMessages.CRRDG9313, 5, new String[]{Labels.ExportCCZipWizard_ConfirmOverwrite_Yes, Labels.ExportCCZipWizard_ConfirmOverwrite_No}, 0);
                int openResult = d.open();
                if (openResult == 0) {
                    this.fConfirmOverWrite = true;
                } else {
                    this.fConfirmOverWrite = false;
                    finishWizard[0] = false;
                }
            }
            if (!resultFileExists || this.fConfirmOverWrite) {
                container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                ICCResultModifier modifier = null;
                                if (!filterString.isEmpty()) {
                                    ICCFilter filter = ExportCCZipWizardPage.this.fIsRegex ? CCFilterFactory.createRegexLineContentFilter((String)filterString) : CCFilterFactory.createLineContentFilter((String)filterString);
                                    modifier = CCResultsModifierFactory.createFilterModifier((ICCFilter)filter);
                                }
                                ICCResultModifier rootModifier = null;
                                if (!root.isEmpty()) {
                                    rootModifier = CCResultsModifierFactory.createRootRelativePathModifier((String)root);
                                }
                                ExportCCZipWizardPage.this.CCResultExport(outputPath, modifier, rootModifier, filterString, isCCaaS, connection, outputDir);
                                finishWizard[0] = true;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                            if (ExportCCZipWizardPage.this.fTempResultPath != null) {
                                ExportCCZipWizardPage.delete(Paths.get(ExportCCZipWizardPage.this.fTempResultPath, new String[0]).getParent());
                            }
                        }
                    }
                });
            }
            if (!finishWizard[0]) {
                return false;
            }
        }
        catch (InvocationTargetException exception) {
            Throwable t;
            ResultsViewPlugin.log(exception);
            String msg = exception.getMessage();
            if ((msg == null || msg.isEmpty()) && (t = exception.getTargetException()) != null) {
                msg = t.getMessage();
            }
            if (msg == null || msg.isEmpty()) {
                msg = NLS.bind((String)CCResultViewMessages.CRRDG9314, (Object)this.fFormatCombo.getText());
            }
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Labels.ExportCCZipWizardPage_Error, (String)msg);
            return false;
        }
        catch (InterruptedException exception) {
            return false;
        }
        this.saveSettings();
        return true;
    }

    protected void saveSettings() {
        this.fConnectLocationObject.saveDialogSettings(this.fDialogSettings);
        this.saveFormatCombo(this.fDialogSettings, "exportType", this.fFormatCombo);
        this.saveCheckBox(this.fDialogSettings, "openPDF", this.fOpenPDFCheckButton);
        this.saveCheckBox(this.fDialogSettings, "regEx", this.fRegExButton);
        this.saveCheckBox(this.fDialogSettings, "addResultLocation", this.fAddLocationButton);
        if (this.fFilterText.getText().trim().isEmpty()) {
            if (this.fDialogSettings.get("filterText") != null) {
                this.fDialogSettings.put("filterText", "");
            }
        } else {
            this.fDialogSettings.put("filterText", this.fFilterText.getText());
        }
        if (this.fRootText.getText().trim().isEmpty()) {
            if (this.fDialogSettings.get("rootText") != null) {
                this.fDialogSettings.put("rootText", "");
            }
        } else {
            this.fDialogSettings.put("rootText", this.fRootText.getText());
        }
    }

    protected void saveCheckBox(IDialogSettings settings, String key, Button checkBox) {
        settings.put(key, checkBox.getSelection());
    }

    protected void saveFormatCombo(IDialogSettings settings, String key, Combo combo) {
        String comboString = combo.getText().trim();
        if (!comboString.isEmpty()) {
            settings.put(key, comboString);
        }
    }

    protected void saveCombo(IDialogSettings settings, String key, Combo combo) {
        String comboString = combo.getText().trim();
        if (!comboString.isEmpty()) {
            settings.put(key + String.valueOf(0), comboString);
            String[] items = combo.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(key + String.valueOf(i + 1), items[i].trim());
                ++i;
            }
        }
    }

    protected void showErrorMessage(final String msg) {
        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public final void run() {
                new MessageDialog(ExportCCZipWizardPage.this.getShell(), CCResultViewMessages.CRRDG9314, null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 1).open();
            }
        });
    }

    private void validateFields() {
        if (!this.validateConnectLocation()) {
            this.setPageComplete(false);
            return;
        }
        if (this.fIsRegex && !this.validateRegEx()) {
            return;
        }
        if (!this.validateResultFile()) {
            return;
        }
        if (!this.isValidRoot(this.fRootText.getText().trim())) {
            this.setErrorMessage(NLS.bind((String)CCResultViewMessages.CRRDG9336, (Object)this.fRootText.getText()));
            this.setPageComplete(false);
            return;
        }
        if (this.fConnectLocationObject.isCCaaS() && !this.isFormatType(FORMAT_TYPE.CCZIP)) {
            this.setErrorMessage(NLS.bind((String)CCResultViewMessages.CRRDG9322, (Object)this.fFormatCombo.getText(), (Object)this.fConnectLocationObject.getConnection()));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private boolean validateConnectLocation() {
        switch (this.fConnectLocationObject.validate()) {
            case OK: {
                break;
            }
            case INVALID_LOCATION: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9303);
                this.setPageComplete(false);
                return false;
            }
            case HOST_NOT_CONNECTED: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9300);
                this.setPageComplete(false);
                return false;
            }
            case EXISTS_LOCATION: {
                break;
            }
            case INVALID_CCAAS_URL: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9301);
                return false;
            }
            case INVALID_CCAAS_HOST_PORT: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9302);
                return false;
            }
        }
        return true;
    }

    private boolean validateResultFile() {
        String fileName = this.fFileNameText.getText();
        if (!this.isValidFileName(fileName)) {
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    private boolean validateRegEx() {
        if (this.fRegExButton.getSelection()) {
            try {
                Pattern.compile(this.fFilterText.getText());
            }
            catch (PatternSyntaxException ex) {
                this.setErrorMessage(ex.getMessage());
                this.setPageComplete(false);
                return false;
            }
        }
        return true;
    }

    private boolean isValidFileName(String fileName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus fileNameStatus = workspace.validateName(fileName, 1);
        if (!fileNameStatus.isOK()) {
            this.setErrorMessage(fileNameStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidRoot(String root) {
        String SLASH = "/";
        String PATH_TRAVERSAL = "..";
        if (!root.startsWith("/") && root.contains("/")) {
            return false;
        }
        return !root.startsWith("..") && !root.contains("/..");
    }

    private ICCResult[] generatePDFCompareResult(ArrayList<IResultAdapter> adapters, ICCResultModifier rootModifier, CCResultsFactory rf) throws CCResultException {
        ICCResult[] results = new ICCResult[]{this.generateCCResult(adapters.get(0), rootModifier, rf)[0], this.generateCCResult(adapters.get(1), rootModifier, rf)[0]};
        return results;
    }

    private void CCResultExport(String outputPath, ICCResultModifier modifier, ICCResultModifier rootModifier, String fFilterString, boolean isCCaaS, String connection, String location) throws CCResultException, CCExportException, DirectoryNotEmptyException, ResultException {
        ICCResult[] results = null;
        CCPdfExporterSettings settings = null;
        CCResultsFactory rf = CCResultsFactory.getInstance();
        CCExporterFactory ef = CCExporterFactory.getInstance();
        ICCExporter exporter = ef.getExporter(this.fExporterType);
        if (this.fExporterType == "CCPDF") {
            ef.registerExporter((ICCExporter)new CCPdfExporter(), this.fExporterType);
            exporter = ef.getExporter(this.fExporterType);
            settings = new CCPdfExporterSettings();
            FopEventListener fopEventListener = new FopEventListener();
            settings.setListener((EventListener)fopEventListener);
            if (this.fPDfPropertyFile != null) {
                settings.setUserOptionFile(this.fPDfPropertyFile);
            }
            settings.setReportOption(Labels.ExportCCZipWizardPage_PDFOption);
            settings.setFilterString(fFilterString);
        } else if (this.fExporterType == "CCSONARQUBE") {
            ef.registerExporter((ICCExporter)new CCSonarQubeExporter(), this.fExporterType);
            exporter = ef.getExporter(this.fExporterType);
            String encoding = this.fDialogSettings.get("exportencoding");
            if (encoding != null) {
                settings = new CCSonarQubeExporterSettings();
                ((CCSonarQubeExporterSettings)settings).setExportEncoding(encoding);
            }
        } else if (this.fExporterType == "CCCOBERTURA") {
            ef.registerExporter((ICCExporter)new CCCoberturaExporter(), this.fExporterType);
            exporter = ef.getExporter(this.fExporterType);
        }
        if (this.fResultAdapters.size() == 1) {
            results = modifier == null ? this.generateCCResult(this.fResultAdapters.get(0), rootModifier, rf) : this.generateMergedOrFilteredResult(this.fResultAdapters, modifier, rootModifier, rf);
        } else if (this.fResultAdapters.size() == 2 && this.isComparisonPDFReport) {
            settings.setReportOption(Labels.ExportCCZipWizardPage_PDFCompareOption);
            results = this.generatePDFCompareResult(this.fResultAdapters, rootModifier, rf);
        } else if (this.fResultAdapters.size() > 1) {
            results = this.generateMergedOrFilteredResult(this.fResultAdapters, modifier, rootModifier, rf);
        }
        if (results != null) {
            if (rootModifier != null && this.fExporterType == "CCRESULT") {
                settings = new CCResultExporterSettings();
                ((CCResultExporterSettings)settings).addFile(rootModifier.getLogInputStream(), "log/rootLog.txt");
            }
            exporter.exportResults(results, (ICCExporterSettings)settings, outputPath, true);
            boolean isExistingLocation = this.fConnectLocationObject.validate().equals((Object)ConnectLocationFields.VALIDATE_STATE.EXISTS_LOCATION);
            if (isCCaaS) {
                this.uploadResultToCCaas(outputPath, isExistingLocation);
            } else if (this.fProvider != null && this.fProvider.isValidRemoteLocation(connection, location)) {
                if (this.fExporterType == "CCCOBERTURA" || this.fExporterType == "CCSONARQUBE") {
                    this.fProvider.uploadFolderToRemoteSystem(new File(outputPath).getParent(), location, connection);
                } else {
                    this.fProvider.uploadFileToRemoteSystem(outputPath, location, connection);
                }
            }
            if (this.isOpenPDFCheck) {
                this.openPDFReport(outputPath);
            }
            if (this.fAddLocation && !isExistingLocation) {
                ResultViewImportExportUtils.addNewLocation(this.fConnectLocationObject, this.getShell(), "");
            } else if (isExistingLocation) {
                CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(this.fConnectLocationObject.getExistingLocation(), 3));
            }
        }
    }

    private void uploadResultToCCaas(String outputPath, boolean isExistingLocation) {
        IResultLocation tempLocation = null;
        tempLocation = !isExistingLocation ? new CCaasResultLocation("", this.fHttpClient) : this.fConnectLocationObject.getExistingLocation();
        try {
            ((ICCaasResultLocation)tempLocation).importResultToLocation(new File(outputPath));
        }
        catch (CLCoverageZipException e) {
            ResultsViewPlugin.log(e);
        }
    }

    private ICCResult[] generateCCResult(IResultAdapter adapter, ICCResultModifier rootModifier, CCResultsFactory rf) throws CCResultException {
        ICCResult[] result = new ICCResult[1];
        if (!adapter.isAnalyzed()) {
            adapter.analyze(true);
        }
        if (rootModifier != null) {
            String resultPath = adapter.getResultPath(true);
            if (adapter.isBaselineUsed()) {
                resultPath = adapter.getBaselineFileName();
            }
            result[0] = rf.createResult(new String[]{resultPath}, rootModifier);
        } else {
            result[0] = adapter.getResult();
        }
        return result;
    }

    private ICCResult[] generateMergedOrFilteredResult(ArrayList<IResultAdapter> adapters, ICCResultModifier modifier, ICCResultModifier rootModifier, CCResultsFactory rf) throws CCResultException, CCExportException {
        HashSet<String> resultPaths = new HashSet<String>();
        ICCResult[] result = new ICCResult[1];
        for (IResultAdapter adapter : adapters) {
            if (!adapter.isResultAvailable()) {
                adapter.getResult();
            }
            resultPaths.add(adapter.getResultPath(true));
            if (!adapter.isBaselineUsed()) continue;
            resultPaths.add(adapter.getBaselineFileName());
        }
        return this.createCCResult(result, resultPaths, modifier, rootModifier, rf);
    }

    /*
     * Unable to fully structure code
     */
    private ICCResult[] createCCResult(ICCResult[] result, Set<String> resultPaths, ICCResultModifier modifier, ICCResultModifier rootModifier, CCResultsFactory rf) throws CCResultException, CCExportException {
        block12: {
            isOtherException = false;
            isCreateSuccess = false;
            isUserInteract = false;
            confirmExport = new boolean[1];
            try {
                if (rootModifier != null && this.fTempResultPath != null) {
                    if (modifier != null) {
                        modifiedResult = rf.createResult(resultPaths.toArray(new String[resultPaths.size()]), rootModifier);
                        exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
                        info = exporter.exportResult(modifiedResult, null, this.fTempResultPath, false);
                        result[0] = rf.createResult(new String[]{info.getDestination()}, modifier);
                    } else {
                        result[0] = rf.createResult(resultPaths.toArray(new String[resultPaths.size()]), rootModifier);
                    }
                } else {
                    result[0] = rf.createResult(resultPaths.toArray(new String[resultPaths.size()]), modifier);
                }
                isCreateSuccess = true;
                break block12;
            }
            catch (CCResultException e) {
                var14_16 = e.getExceptions();
                var13_17 = var14_16.length;
                var12_15 = 0;
                ** while (var12_15 < var13_17)
            }
lbl-1000:
            // 1 sources

            {
                exception = var14_16[var12_15];
                if (exception instanceof CCFileMismatchException) {
                    if (!isUserInteract) {
                        result[0] = e.getResult();
                        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

                            @Override
                            public final void run() {
                                MessageDialog d = new MessageDialog(ResultViewImportExportUtils.getDisplay().getActiveShell(), Labels.ExportCCZipWizard_SrcFileInConflict_Title, null, CCResultViewMessages.CRRDG9316, 4, new String[]{Labels.ExportCCZipWizard_SrcFileInConflict_OK, Labels.ExportCCZipWizard_SrcFileInConflict_Cancel}, 0);
                                int openResult = d.open();
                                if (openResult == 0) {
                                    confirmExport[0] = true;
                                }
                            }
                        });
                        isUserInteract = true;
                    }
                } else {
                    isOtherException = true;
                }
                ++var12_15;
                continue;
            }
lbl33:
            // 1 sources

            if (isOtherException) {
                throw e;
            }
        }
        if (isCreateSuccess || confirmExport[0]) {
            isCreateSuccess = false;
            confirmExport[0] = false;
            return result;
        }
        return null;
    }

    private void openPDFReport(final String destPath) {
        ResultViewImportExportUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    File file = new File(destPath);
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)"org.eclipse.ui.systemExternalEditor", (boolean)true);
                    }
                    catch (PartInitException e) {
                        ResultsViewPlugin.log(e);
                    }
                }
            }
        });
    }

    private void changeSuffixLabel() {
        switch (this.fExporterType) {
            case "CCRESULT": {
                this.fSuffixLabel.setText(".cczip");
                break;
            }
            case "CCSONARQUBE": {
                this.fSuffixLabel.setText(".xml");
                break;
            }
            case "CCPDF": {
                this.fSuffixLabel.setText(".pdf");
                break;
            }
            case "CCCOBERTURA": {
                this.fSuffixLabel.setText(".xml");
                break;
            }
        }
        this.fSuffixLabel.getParent().layout(true);
    }

    private String getDefaultResultName() {
        String dataTimeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String defaultFileName = String.format("ccresult_%s", dataTimeStamp);
        return defaultFileName;
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.heightHint = 30;
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private String getOutputPath(boolean createTempFile, String outputDir, String fileNameWithSuffix) {
        String outputPath = null;
        try {
            if (createTempFile) {
                Path tempPath = Files.createTempDirectory("temp", new FileAttribute[0]);
                File tempDir = tempPath.toFile();
                tempDir.deleteOnExit();
                outputPath = tempDir.getAbsolutePath() + File.separator + fileNameWithSuffix;
            } else {
                outputPath = outputDir + File.separator + fileNameWithSuffix;
            }
        }
        catch (IOException e) {
            ResultsViewPlugin.log(e);
        }
        return outputPath;
    }

    private boolean isFormatType(FORMAT_TYPE type) {
        String formatType = this.fFormatCombo.getText();
        switch (type) {
            case CCZIP: {
                return formatType.equals(Labels.ExportCCZipWizardPage_CCZipOption);
            }
            case SONARQUBE: {
                return formatType.equals(Labels.ExportCCZipWizardPage_SonarQubeOption);
            }
            case PDF: {
                return formatType.equals(Labels.ExportCCZipWizardPage_PDFOption);
            }
            case PDFCOMPARE: {
                return formatType.equals(Labels.ExportCCZipWizardPage_PDFCompareOption);
            }
            case COBERTURA: {
                return formatType.equals(Labels.ExportCCZipWizardPage_CoberturaOption);
            }
        }
        return false;
    }

    private static boolean delete(Path path) {
        if (path == null || !path.toFile().exists()) {
            return true;
        }
        try {
            Files.walkFileTree(path, new Visitor());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static enum FORMAT_TYPE {
        CCZIP,
        SONARQUBE,
        PDF,
        PDFCOMPARE,
        COBERTURA;

    }

    private static class Visitor
    extends SimpleFileVisitor<Path> {
        private Visitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().exists()) {
                file.toFile().setWritable(true);
            }
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

