/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultsView;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.ICCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConnectLocationFields
implements IResultViewConstants {
    private Combo fConnectionCombo;
    protected Combo fDestCombo;
    private IDialogSettings fDialogSettings;
    private VALIDATE_STATE fValidateState;
    protected boolean fSelectFile;
    private Button btnBrowse;
    private Label lblLocation;
    protected Shell fShell;
    private String fCCaaSHost;
    private int fCCaaSPort;
    private boolean fIsDefaultLocation;
    private IResultLocation fExistingLocation;
    protected ViewerFilter fWorkspaceFilter = this.getViewerFilter();
    protected IUtilitiesContentProvider fProvider = null;
    private boolean fIsSecured = false;
    private Set<IConnectLocationListener> fListeners = new HashSet<IConnectLocationListener>();
    protected String fLocation;
    private String fConnection;
    private boolean fHideCCAAS;
    private String flblLocation;
    private boolean fhideLocal;

    public void addConnectLocationListener(IConnectLocationListener listener) {
        if (listener != null) {
            this.fListeners.add(listener);
        }
    }

    public ConnectLocationFields(Composite composite, Shell shell, IDialogSettings settings, String lblConnect, String lblLocation, boolean selectFile, boolean isDefaultLocation) {
        this(composite, shell, settings, lblConnect, lblLocation, selectFile, isDefaultLocation, false, false);
    }

    public ConnectLocationFields(Composite composite, Shell shell, IDialogSettings settings, String lblConnect, String lblLocation, boolean selectFile, boolean isDefaultLocation, boolean hideCCAAS, boolean hideLocal) {
        this.fDialogSettings = settings;
        this.fSelectFile = selectFile;
        this.fShell = shell;
        this.fIsDefaultLocation = isDefaultLocation;
        this.fHideCCAAS = hideCCAAS;
        this.fProvider = CCResultsView.getProvider();
        this.flblLocation = lblLocation;
        this.fhideLocal = hideLocal;
        this.createConnectionField(composite, lblConnect);
        this.createLocationField(composite);
        this.updateFields(true);
        this.updateValidateState();
        this.fireListener();
    }

    private void createConnectionField(Composite composite, String labelName) {
        Label label = new Label(composite, 0);
        label.setText(labelName);
        this.fConnectionCombo = new Combo(composite, 2056);
        GridData data = new GridData(768);
        data.widthHint = 500;
        this.fConnectionCombo.setLayoutData((Object)data);
        List<String> connectionList = this.getConnections();
        String selectedSetting = this.fDialogSettings.get("connections");
        int selectedIndex = selectedSetting == null ? 0 : connectionList.indexOf(selectedSetting);
        for (String aliasName : connectionList) {
            this.fConnectionCombo.add(aliasName);
        }
        this.fConnectionCombo.select(selectedIndex);
        this.fConnectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectLocationFields.this.updateFields(true);
                ConnectLocationFields.this.updateValidateState();
                ConnectLocationFields.this.fireListener();
            }
        });
        Button btnNew = new Button(composite, 8);
        btnNew.setText(Labels.ExportCCZipWizardPage_New_Btn);
        data = new GridData();
        data.widthHint = 120;
        btnNew.setLayoutData((Object)data);
        if (this.fProvider != null) {
            btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BusyIndicator.showWhile((Display)ResultViewImportExportUtils.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            List<String> currentList = ConnectLocationFields.this.getConnections();
                            (this).ConnectLocationFields.this.fProvider.openNewConnectionDialog((this).ConnectLocationFields.this.fShell);
                            ConnectLocationFields.this.updateConnectionList(currentList);
                        }
                    });
                }
            });
        }
        btnNew.setVisible(this.fProvider != null);
    }

    private void updateConnectionList(List<String> oldList) {
        List<String> newList = this.getConnections();
        ArrayList<String> differences = new ArrayList<String>(newList);
        differences.removeAll(oldList);
        if (differences.isEmpty()) {
            return;
        }
        this.fConnectionCombo.removeAll();
        for (String aliasName : newList) {
            this.fConnectionCombo.add(aliasName);
        }
        this.fConnectionCombo.select(newList.indexOf(differences.get(0)));
    }

    private void createLocationField(Composite composite) {
        this.lblLocation = new Label(composite, 0);
        this.lblLocation.setText(this.flblLocation);
        this.fDestCombo = new Combo(composite, 4);
        this.loadLocationList();
        GridData data = new GridData(768);
        data.widthHint = 500;
        this.fDestCombo.setLayoutData((Object)data);
        this.fDestCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectLocationFields.this.updateValidateState();
                ConnectLocationFields.this.fireListener();
            }
        });
        this.btnBrowse = new Button(composite, 8);
        this.btnBrowse.setText(Labels.ImportCCZipWizardPage2_3);
        data = new GridData();
        data.widthHint = 120;
        this.btnBrowse.setLayoutData((Object)data);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectLocationFields.this.isWorkspace()) {
                    ConnectLocationFields.this.handleWorkspaceSelected();
                } else {
                    ConnectLocationFields.this.handleBrowseFileSelected();
                }
            }
        });
    }

    private void fireListener() {
        for (IConnectLocationListener listener : this.fListeners) {
            listener.modifyText();
        }
    }

    protected void handleBrowseFileSelected() {
        String locationPath = null;
        if (this.fProvider != null) {
            try {
                locationPath = this.fProvider.getLocationPath(this.fShell, this.getConnection(), this.fSelectFile, this.fIsDefaultLocation, this.getLocation());
            }
            catch (Exception exception) {}
        } else {
            locationPath = this.handleLocalFileSystemButtonSelected(this.fSelectFile);
        }
        if (locationPath != null) {
            this.fDialogSettings.put(this.getConnection(), locationPath);
            this.fDestCombo.setText(locationPath);
        }
    }

    private String handleLocalFileSystemButtonSelected(boolean fSelectFile) {
        String selectedFile = null;
        if (fSelectFile) {
            FileDialog dialog = new FileDialog(this.fShell, 4096);
            String dataFileExtension = "*.clcoveragedata";
            String zipFileExtension = "*.zip";
            String cczipFileExtension = "*.cczip";
            String filterName = Labels.COVERAGE_IMPORT_DATAFILE_FILTER + "(" + dataFileExtension + ", " + zipFileExtension + ", " + cczipFileExtension + ")";
            String extension = dataFileExtension + ";" + zipFileExtension + ";" + cczipFileExtension;
            dialog.setFilterNames(new String[]{filterName});
            dialog.setFilterExtensions(new String[]{extension});
            selectedFile = dialog.open();
        } else {
            DirectoryDialog dialog = new DirectoryDialog(this.fShell, 4096);
            if (this.getLocation() != null && this.getLocation().length() > 0) {
                dialog.setFilterPath(this.getLocation());
            }
            selectedFile = dialog.open();
        }
        return selectedFile;
    }

    protected List<String> getConnections() {
        ArrayList<String> hostList = new ArrayList<String>();
        List<Object> connectionList = Collections.emptyList();
        if (this.fProvider != null) {
            connectionList = this.fProvider.getConnectionList();
            if (!connectionList.isEmpty() && !this.fhideLocal) {
                hostList.add((String)connectionList.remove(0));
            } else if (this.fhideLocal) {
                connectionList.remove(0);
            }
        } else if (!this.fhideLocal) {
            hostList.add("localhost");
        }
        if (!this.fHideCCAAS) {
            hostList.add(Labels.ExportCCZipWizardPage_CCaaS);
        }
        if (this.fSelectFile) {
            hostList.add(Labels.ExportCCZipWizardPage_Workspace);
        }
        hostList.addAll(connectionList);
        return hostList;
    }

    private void updateFields(boolean retrieveSetting) {
        if (retrieveSetting) {
            this.loadLocationList();
        }
        this.lblLocation.setText(this.isCCaaS() ? Labels.ExportCCZipWizardPage_CCaaS_URL : this.flblLocation);
        this.lblLocation.getParent().layout();
        this.btnBrowse.setEnabled(!this.isCCaaS());
    }

    protected boolean isValidLocation() {
        String location = this.getLocation();
        if (location == null || location.isEmpty()) {
            return false;
        }
        String connection = this.getConnection();
        File f = new File(location);
        if (this.fSelectFile && !ResultViewImportExportUtils.isFileExtensionValid(f.getAbsolutePath(), this.fIsDefaultLocation)) {
            return false;
        }
        return this.fProvider == null || this.isWorkspace() ? f.exists() : this.fProvider.isValidLocation(location, connection);
    }

    protected boolean isExistingLocation() {
        if (this.isWorkspace()) {
            return true;
        }
        ICCResultsView resultsView = ResultsViewUtilities.getResultsView();
        this.fExistingLocation = null;
        String location = this.getLocation();
        IResultLocation[] iResultLocationArray = resultsView.getResultLocations();
        int n = iResultLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultLocation rLocation = iResultLocationArray[n2];
            if (this.isCCaaS()) {
                if (rLocation instanceof ICCaasResultLocation) {
                    String host = ((ICCaasResultLocation)rLocation).getHttpClient().getHost();
                    String port = ((ICCaasResultLocation)rLocation).getHttpClient().getPort();
                    boolean secured = ((ICCaasResultLocation)rLocation).getHttpClient().isSecured();
                    if (host.equalsIgnoreCase(this.getCCaaSHost()) && port.equalsIgnoreCase(this.getCCaaSPort()) && secured == this.isSecured()) {
                        this.fExistingLocation = rLocation;
                    }
                }
            } else {
                String finalLocation;
                String string = finalLocation = this.fProvider == null ? location : this.fProvider.determineLocationPath(this.getConnection(), location);
                if (new Path(rLocation.getPath()).equals((Object)new Path(finalLocation))) {
                    this.fExistingLocation = rLocation;
                }
            }
            ++n2;
        }
        return this.fExistingLocation != null;
    }

    private void updateValidateState() {
        if (this.isCCaaS()) {
            if (!this.isValidCCaaSURL()) {
                return;
            }
        } else {
            if (!this.isHostConnected()) {
                this.fValidateState = VALIDATE_STATE.HOST_NOT_CONNECTED;
                return;
            }
            if (!this.isValidLocation()) {
                this.fValidateState = VALIDATE_STATE.INVALID_LOCATION;
                return;
            }
        }
        if (!this.fSelectFile && this.isExistingLocation()) {
            this.fValidateState = VALIDATE_STATE.EXISTS_LOCATION;
            return;
        }
        this.fValidateState = VALIDATE_STATE.OK;
    }

    private boolean isValidCCaaSURL() {
        String inputUrl = this.getLocation();
        try {
            new URL(inputUrl);
            URI uri = new URI(inputUrl);
            this.fCCaaSHost = uri.getHost();
            this.fCCaaSPort = uri.getPort();
            this.fIsSecured = uri.getScheme().equals("https");
            if (this.fCCaaSHost == null || this.fCCaaSPort == -1) {
                this.fValidateState = VALIDATE_STATE.INVALID_CCAAS_HOST_PORT;
                return false;
            }
        }
        catch (MalformedURLException | URISyntaxException ex) {
            this.fValidateState = VALIDATE_STATE.INVALID_CCAAS_URL;
            return false;
        }
        return true;
    }

    private boolean isHostConnected() {
        if (this.isWorkspace() || this.isCCaaS()) {
            return true;
        }
        return this.fProvider == null ? true : this.fProvider.isHostConnected(this.getConnection());
    }

    protected void handleWorkspaceSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fShell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.addFilter(this.fWorkspaceFilter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setTitle(Labels.COVERAGE_IMPORT_WORKSPACE_TITLE);
        dialog.setMessage(Labels.COVERAGE_IMPORT_WORKSPACE_MESSAGE);
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            String fileName = file.getLocation().toOSString();
            this.fDestCombo.setText(fileName);
        }
    }

    protected ViewerFilter getViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return ResultViewImportExportUtils.isFileExtensionValid(file.getName(), ConnectLocationFields.this.fIsDefaultLocation);
                }
                return true;
            }
        };
    }

    protected void loadLocationList() {
        this.fDestCombo.removeAll();
        String[] list = this.fDialogSettings.getArray(this.getConnection());
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                this.fDestCombo.add(item);
                ++n2;
            }
            this.fDestCombo.setText(list[0]);
        }
    }

    private void updateArrayList(String newItem, String Key2, IDialogSettings setting) {
        LinkedList<String> list = new LinkedList<String>();
        if (setting.getArray(Key2) != null) {
            list.addAll(Arrays.asList(setting.getArray(Key2)));
        }
        if (list.contains(newItem)) {
            list.remove(newItem);
        }
        if (list.size() >= 10) {
            list.removeLast();
        }
        list.addFirst(newItem);
        setting.put(Key2, list.toArray(new String[list.size()]));
    }

    public boolean isWorkspace() {
        return this.getConnection().equalsIgnoreCase(Labels.ExportCCZipWizardPage_Workspace);
    }

    public boolean isLocalhost() {
        return this.getConnection().equalsIgnoreCase(Labels.ExportCCZipWizardPage_Workspace) || this.getConnection().equalsIgnoreCase("localhost") || this.getConnection().equalsIgnoreCase("Local");
    }

    public boolean isCCaaS() {
        return this.getConnection().equalsIgnoreCase(Labels.ExportCCZipWizardPage_CCaaS);
    }

    public String getCCaaSHost() {
        return this.fCCaaSHost;
    }

    public String getCCaaSPort() {
        return String.valueOf(this.fCCaaSPort);
    }

    public boolean isSecured() {
        return this.fIsSecured;
    }

    public String getLocation() {
        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectLocationFields.this.fLocation = ConnectLocationFields.this.fDestCombo.getText().trim();
            }
        });
        return this.fLocation;
    }

    public String getConnection() {
        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectLocationFields.this.fConnection = ConnectLocationFields.this.fConnectionCombo.getText();
            }
        });
        return this.fConnection;
    }

    public IResultLocation getExistingLocation() {
        return this.fExistingLocation;
    }

    public void saveDialogSettings(IDialogSettings setting) {
        setting.put("connections", this.getConnection());
        setting.put(this.getConnection(), this.getLocation());
        this.updateArrayList(this.getLocation(), this.getConnection(), setting);
    }

    public VALIDATE_STATE validate() {
        return this.fValidateState;
    }

    public boolean isLocationEmpty() {
        if (this.fProvider != null) {
            return this.fProvider.isLocationEmpty(this.getConnection(), this.getLocation());
        }
        File f = new File(this.getLocation());
        if (f.isDirectory()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DirectoryStream<java.nio.file.Path> directory = Files.newDirectoryStream(f.toPath());){
                    boolean bl = !directory.iterator().hasNext();
                    return bl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void forceFocus() {
        if (this.fConnectionCombo != null) {
            this.fConnectionCombo.forceFocus();
        }
    }

    public static interface IConnectLocationListener {
        public void modifyText();
    }

    public static enum VALIDATE_STATE {
        OK,
        INVALID_LOCATION,
        HOST_NOT_CONNECTED,
        EXISTS_LOCATION,
        INVALID_CCAAS_URL,
        INVALID_CCAAS_HOST_PORT,
        INVALID_CCAAS_IMPORT_FILE;

    }
}

