/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.commoncomponents.ccaas.core.json.CCResultEntrySerializable;
import com.ibm.commoncomponents.ccaas.core.repo.ICCResultEntry;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.compiled.CompiledCCImporter;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultsView;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZip;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.CCaasHostPort;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.ICCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ConnectLocationFields;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ImportWizardUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.CcsNetAuthenticator;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.FontReflowUtil;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class CommonImportWizardPage
extends WizardPage
implements IResultViewConstants {
    private Combo fImportResultCombo;
    private Label fImportResultlabel;
    private static final int ncol = 3;
    private ConnectLocationFields fConnectLocationObject;
    private IDialogSettings fDialogSettings;
    private IResultLocation fResultLocation;
    private Map<String, String> fMap = new HashMap<String, String>();
    private CCaasHostPort fPreviousHostPort = null;
    private HttpClient fHttpClient;
    private IUtilitiesContentProvider fProvider = CCResultsView.getProvider();
    private FocusListener fFocusListener = new FocusListener(){

        public void focusGained(final FocusEvent event) {
            BusyIndicator.showWhile((Display)ResultViewImportExportUtils.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if ((this).CommonImportWizardPage.this.fImportResultCombo == (Combo)event.getSource() && CommonImportWizardPage.this.validateConnectLocation()) {
                        CommonImportWizardPage.this.loadCCaasResultToCombo();
                    }
                }
            });
        }

        public void focusLost(FocusEvent event) {
        }
    };
    private boolean fIsCCaaS;
    private String fResultName;
    private boolean fPingResult;
    private String fLastHost;
    private String fLastPort;

    public CommonImportWizardPage(IStructuredSelection selection, IResultLocation resultLocation) {
        super(Labels.COVERAGEIMPORTWIZARDPAGE_TITLE);
        this.setTitle(Labels.COVERAGEIMPORTWIZARDPAGE_TITLE);
        this.setDescription(Labels.COVERAGEIMPORTWIZARDPAGE_DESCRIPTION);
        this.fResultLocation = resultLocation == null ? ResultsViewUtilities.getDefaultLocation() : resultLocation;
    }

    public void createControl(Composite parent) {
        this.fDialogSettings = this.getWizard().getDialogSettings();
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        GridLayoutFactory.swtDefaults().applyTo((Composite)sc);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite composite = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createSelectFileArea(composite);
        this.showHideResultName(this.fConnectLocationObject.isCCaaS());
        this.setPageComplete(false);
        sc.setContent((Control)composite);
        sc.setMinSize(composite.computeSize(-1, -1));
        this.setControl((Control)sc);
        FontReflowUtil.installListeners(sc);
        if (ResultsViewContentProviders.getRemoteDialogContentProviders().length == 0) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sc, "com.ibm.debug.pdt.codecoverage.ui.view.import_wizard_no_rse");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sc, "com.ibm.debug.pdt.codecoverage.ui.view.import_wizard");
        }
    }

    private void createSelectFileArea(Composite container) {
        this.fConnectLocationObject = this.createConnectionLocationFields(container, this.fDialogSettings, this.fResultLocation);
        this.fImportResultlabel = new Label(container, 0);
        this.fImportResultlabel.setText(Labels.IMPORT_CCAAS_RESULT_LABEL);
        this.fImportResultCombo = new Combo(container, 4);
        GridData data = new GridData(768);
        data.widthHint = 500;
        this.fImportResultCombo.setLayoutData((Object)data);
        this.fImportResultCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Combo combo = (Combo)keyEvent.getSource();
                if (combo.getItems().length > 0) {
                    CommonImportWizardPage.this.findMatchItem(combo);
                }
                CommonImportWizardPage.this.validateFields();
            }
        });
        this.fImportResultCombo.addFocusListener(this.fFocusListener);
        this.fImportResultCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)ResultViewImportExportUtils.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CommonImportWizardPage.this.validateFields();
                    }
                });
            }
        });
    }

    protected ConnectLocationFields createConnectionLocationFields(Composite parentContainer, IDialogSettings dialogSettings, IResultLocation resultLocation) {
        ConnectLocationFields clf = new ConnectLocationFields(parentContainer, this.getShell(), dialogSettings, Labels.COVERAGEIMPORTWIZARDPAGE_CONNECTION_LABEL, Labels.COVERAGEIMPORTWIZARDPAGE_LOCATION_LABEL, true, resultLocation.isDefaultLocation());
        clf.addConnectLocationListener(new ConnectLocationFields.IConnectLocationListener(){

            @Override
            public void modifyText() {
                CommonImportWizardPage.this.validateFields();
            }
        });
        return clf;
    }

    private void findMatchItem(Combo combo) {
        String text = combo.getText();
        String[] items = combo.getItems();
        int index = -1;
        int i = 0;
        while (i < items.length) {
            if (items[i].toLowerCase().startsWith(text.toLowerCase())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            Point pt = combo.getSelection();
            combo.select(index);
            combo.setText(items[index]);
            combo.setSelection(new Point(pt.x, items[index].length()));
        }
    }

    private void loadCCaasResultToCombo() {
        if (this.fConnectLocationObject.getCCaaSHost().equals(this.fLastHost) && this.fConnectLocationObject.getCCaaSPort().equals(this.fLastPort)) {
            return;
        }
        this.fLastHost = this.fConnectLocationObject.getCCaaSHost();
        this.fLastPort = this.fConnectLocationObject.getCCaaSPort();
        CCaasHostPort newHostPort = new CCaasHostPort(this.fConnectLocationObject.getCCaaSHost(), this.fConnectLocationObject.getCCaaSPort());
        HttpClient httpClient = new HttpClient(newHostPort.getHost(), newHostPort.getPort());
        if (this.fPreviousHostPort != null) {
            if (this.fPreviousHostPort.getHost().equalsIgnoreCase(newHostPort.getHost()) && this.fPreviousHostPort.getPort().equalsIgnoreCase(newHostPort.getPort())) {
                return;
            }
            this.fPreviousHostPort = newHostPort;
        }
        if (this.fImportResultCombo.getItems().length > 0) {
            this.fImportResultCombo.removeAll();
            this.fMap.clear();
        }
        List ccResults = Collections.emptyList();
        try {
            ccResults = httpClient.getResults();
        }
        catch (IOException e) {
            this.setErrorMessage(CCResultViewMessages.CRRDG9317);
            this.setPageComplete(false);
            return;
        }
        if (ccResults.isEmpty()) {
            this.setErrorMessage(CCResultViewMessages.CRRDG9321);
            this.setPageComplete(false);
        } else {
            for (ICCResultEntry entry : ccResults) {
                String name = entry.getName();
                this.fMap.put(name, entry.getId());
                this.fImportResultCombo.add(name);
            }
            if (this.fImportResultCombo.getSelectionIndex() == -1 && this.fImportResultCombo.getItemCount() > 0) {
                this.fImportResultCombo.select(0);
            }
        }
    }

    private String getResultId(String name) {
        for (Map.Entry<String, String> entry : this.fMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected void showHideResultName(boolean showOrHide) {
        this.fImportResultlabel.setVisible(showOrHide);
        this.fImportResultCombo.setVisible(showOrHide);
    }

    protected boolean validateFields() {
        this.showHideResultName(this.fConnectLocationObject.isCCaaS());
        if (!this.validateConnectLocation()) {
            return false;
        }
        if (!this.hasCCaasImportResult()) {
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
        return true;
    }

    private boolean hasCCaasImportResult() {
        String fileName;
        if (this.fConnectLocationObject.isCCaaS() && ((fileName = this.fImportResultCombo.getText()) == null || fileName.isEmpty())) {
            this.setErrorMessage(CCResultViewMessages.CRRDG9318);
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    private boolean isValidImportResult(String resultId) {
        if (this.fConnectLocationObject.isCCaaS()) {
            Authenticator.setDefault(new CcsNetAuthenticator(this.fHttpClient));
            this.fHttpClient = new HttpClient(this.fConnectLocationObject.getCCaaSHost(), this.fConnectLocationObject.getCCaaSPort());
            this.fPingResult = false;
            ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CommonImportWizardPage.this.fPingResult = ResultViewImportExportUtils.pingCCaaSOK(CommonImportWizardPage.this.fHttpClient, CommonImportWizardPage.this.getShell());
                }
            });
            if (!this.fPingResult) {
                return false;
            }
            try {
                CCResultEntrySerializable entry = this.fHttpClient.getResult(resultId);
                if (entry == null) {
                    ImportWizardUtilities.showMessage(this.getShell(), CCResultViewMessages.CRRDG9315, CCResultViewMessages.CRRDG9319);
                    return false;
                }
            }
            catch (Exception e) {
                ImportWizardUtilities.showMessage(this.getShell(), CCResultViewMessages.CRRDG9315, CCResultViewMessages.CRRDG9319);
                return false;
            }
        }
        return true;
    }

    private boolean validateConnectLocation() {
        switch (this.fConnectLocationObject.validate()) {
            case OK: {
                break;
            }
            case INVALID_LOCATION: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9320);
                this.setPageComplete(false);
                return false;
            }
            case HOST_NOT_CONNECTED: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9300);
                this.setPageComplete(false);
                return false;
            }
            case EXISTS_LOCATION: {
                break;
            }
            case INVALID_CCAAS_URL: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9301);
                this.setPageComplete(false);
                return false;
            }
            case INVALID_CCAAS_HOST_PORT: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9302);
                this.setPageComplete(false);
                return false;
            }
        }
        return true;
    }

    public boolean performFinish(IProgressMonitor monitor) {
        boolean[] importOK = new boolean[]{true};
        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CommonImportWizardPage.this.fResultName = CommonImportWizardPage.this.fImportResultCombo.getText();
            }
        });
        if (this.isValidImportResult(this.getResultId(this.fResultName))) {
            importOK[0] = this.importCoverageFile(monitor);
            if (importOK[0]) {
                this.fConnectLocationObject.saveDialogSettings(this.fDialogSettings);
            }
        } else {
            importOK[0] = false;
        }
        monitor.done();
        return importOK[0];
    }

    private boolean importCoverageFile(IProgressMonitor monitor) {
        boolean importOK = true;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)100);
        this.fIsCCaaS = false;
        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CommonImportWizardPage.this.fIsCCaaS = CommonImportWizardPage.this.fConnectLocationObject.isCCaaS();
            }
        });
        importOK = this.fIsCCaaS ? this.importResultFromCCaas(sub) : this.importResultFromLocalOrRemote(sub);
        monitor.done();
        return importOK;
    }

    private boolean importResultFromCCaas(SubMonitor sub) {
        String fileName = this.fResultName;
        boolean importResultOK = false;
        if (!this.isOkToWrite(fileName, this.fResultLocation)) {
            return false;
        }
        File downloadedFile = null;
        try {
            java.nio.file.Path tempDir = Files.createTempDirectory("ccs", new FileAttribute[0]);
            String resultId = this.getResultId(fileName);
            downloadedFile = this.fHttpClient.downloadResult(resultId, tempDir.toAbsolutePath().toString() + File.separator + fileName + ".cczip");
            if (downloadedFile != null) {
                importResultOK = this.importResultToResultLocation(downloadedFile, sub, this.fResultLocation);
                ResultViewImportExportUtils.deleteDir(tempDir.toString());
            }
        }
        catch (IOException e) {
            String msg = e.getMessage();
            ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, msg, e);
            return false;
        }
        sub.worked(50);
        return importResultOK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean importResultFromLocalOrRemote(SubMonitor sub) {
        String location = this.fConnectLocationObject.getLocation();
        String connection = this.fConnectLocationObject.getConnection();
        boolean importResultOK = true;
        if (this.fProvider != null && !this.fConnectLocationObject.isWorkspace() && this.fProvider.isValidRemoteLocation(connection, location)) {
            File remoteTempFile = this.fProvider.handleRemoteFile(connection, location).getLocation().toFile();
            if (remoteTempFile == null) return false;
            location = remoteTempFile.getAbsolutePath();
        }
        sub.worked(20);
        Path path = new Path(location);
        String resultName = path.removeFileExtension().lastSegment();
        if (location.endsWith("zip")) {
            if (!this.isOkToWrite(resultName, this.fResultLocation)) return false;
            importResultOK = this.importResultToResultLocation(new File(location), sub, this.fResultLocation);
        } else {
            String resultPath = String.valueOf(ResultsViewUtilities.getDefaultLocation()) + File.separator + resultName + ".cczip";
            if (!this.isOkToWrite(resultName, this.fResultLocation)) return false;
            importResultOK = this.exportToCCZip(location, resultPath);
        }
        sub.worked(50);
        return importResultOK;
    }

    protected boolean importResultToResultLocation(File ccFile, SubMonitor sub, IResultLocation location) {
        if (CompiledCCImporter.isValidExtension((String)ccFile.getName())) {
            try {
                CLCoverageZip ccZip = new CLCoverageZip(ccFile, true);
                ccZip.importFromZip((IProgressMonitor)sub, location);
                sub.worked(30);
            }
            catch (CLCoverageZipException ex) {
                String msg = ex.getMessage();
                ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, msg, ex);
                return false;
            }
        }
        return true;
    }

    protected boolean exportToCCZip(String inputPath, String resultPath) {
        try {
            CCResultsFactory rf = CCResultsFactory.getInstance();
            CCExporterFactory ef = CCExporterFactory.getInstance();
            ICCExporter exporter = ef.getExporter("CCRESULT");
            ICCResult result = rf.createResult(inputPath);
            exporter.exportResult(result, null, new File(resultPath).getPath(), true);
        }
        catch (CCResultException | CCExportException e) {
            String msg = e.getMessage();
            ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, msg, e);
            return false;
        }
        return true;
    }

    private boolean isOkToWrite(String sourceFileName, IResultLocation targetLocation) {
        if (targetLocation.isRemote()) {
            if (targetLocation instanceof ICCaasResultLocation && targetLocation.findResultWithName(sourceFileName) != null) {
                ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, NLS.bind((String)CCResultViewMessages.CRRDG9307, (Object)sourceFileName), null);
                return false;
            }
            return true;
        }
        IResultAdapter existingAdapter = targetLocation.findResultWithName(sourceFileName);
        if (existingAdapter == null) {
            return true;
        }
        if (this.confirmOverwriting()) {
            targetLocation.removeResult(existingAdapter);
            return true;
        }
        return false;
    }

    private boolean confirmOverwriting() {
        final boolean[] overwriting = new boolean[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    overwriting[0] = MessageDialog.openConfirm((Shell)CommonImportWizardPage.this.getShell(), (String)Labels.ExportCCZipWizard_ConfirmOverwrite_Title, (String)CCResultViewMessages.CRRDG9313);
                }
            });
        }
        return overwriting[0];
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fConnectLocationObject != null) {
            this.fConnectLocationObject.forceFocus();
        }
    }
}

