/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.security;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.security.CCSCertificateWizard;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.CCWizardDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;

public class CCSSecurityUtils {
    private static final char[] KEYSTORE_PWD = "bwqZLx3U]@u!qsT".toCharArray();
    private static final String KEYSTORE_TYPE_PKIX = "PKIX";
    private static final String KEYSTORE_TYPE_JKS = "JKS";
    private static final String CCS_KEYSTORE_FILENAME = "CCSkeystore.dat";
    private static CCSTrustManager fTrustManager = null;

    private static char[] getKeyStorePassword() {
        return KEYSTORE_PWD;
    }

    private static File getKeyStoreFile() {
        return ResultsViewPlugin.getDefault().getStateLocation().append(CCS_KEYSTORE_FILENAME).toFile();
    }

    protected static KeyStore getKeyStore() {
        KeyStore keyStore;
        block21: {
            File keyStoreFile = CCSSecurityUtils.getKeyStoreFile();
            keyStore = null;
            try {
                keyStore = KeyStore.getInstance(KEYSTORE_TYPE_JKS);
                if (keyStoreFile.exists() && keyStoreFile.length() > 0L) {
                    Throwable throwable = null;
                    Object var3_7 = null;
                    try (FileInputStream stream = new FileInputStream(keyStoreFile);){
                        keyStore.load(stream, CCSSecurityUtils.getKeyStorePassword());
                        break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Throwable throwable = null;
                Object var3_9 = null;
                try (FileOutputStream stream = new FileOutputStream(CCSSecurityUtils.getKeyStoreFile());){
                    keyStore.load(null, CCSSecurityUtils.getKeyStorePassword());
                    keyStore.store(stream, CCSSecurityUtils.getKeyStorePassword());
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                ResultsViewPlugin.log(e);
            }
        }
        return keyStore;
    }

    private static CCSTrustManager getTrustManager() {
        if (fTrustManager == null) {
            fTrustManager = new CCSTrustManager();
        }
        return fTrustManager;
    }

    public static SSLSocketFactory getSocketFactory() {
        try {
            KeyStore keyStore = CCSSecurityUtils.getKeyStore();
            if (keyStore == null) {
            }
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            TrustManagerFactory factory = TrustManagerFactory.getInstance(KEYSTORE_TYPE_PKIX);
            factory.init(keyStore);
            CCSSecurityUtils.getTrustManager().setKeystore(String.valueOf(CCSSecurityUtils.getKeyStorePassword()), CCSSecurityUtils.getKeyStorePassword());
            sslcontext.init(null, new TrustManager[]{CCSSecurityUtils.getTrustManager()}, new SecureRandom());
            return sslcontext.getSocketFactory();
        }
        finally {
            return null;
        }
    }

    public static void deleteKeyStore() {
        File keyStoreFile = CCSSecurityUtils.getKeyStoreFile();
        if (keyStoreFile.exists() && !keyStoreFile.delete()) {
            MessageDialog.openError(null, (String)Labels.ExportCCZipWizardPage_Error, (String)CCResultViewMessages.CRRDG9315);
        }
    }

    public static boolean importCertificates(String host) {
        List<Certificate> certificates = CCSSecurityUtils.getTrustManager().getUntrustedCerts();
        if (certificates != null && certificates.size() > 0) {
            CCSCertificateWizard importWizard = new CCSCertificateWizard(host, certificates);
            CCWizardDialog dialog = new CCWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)importWizard);
            return dialog.open() == 0;
        }
        return true;
    }

    private static String getAlias(String host) {
        Object alias = host;
        try {
            int count = 0;
            KeyStore keyStore = CCSSecurityUtils.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String existingalias = aliases.nextElement();
                if (!existingalias.toLowerCase().startsWith(host.toLowerCase())) continue;
                ++count;
            }
            alias = host + ++count;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alias;
    }

    protected static boolean importCertificates(List<Certificate> certificates, String host) {
        block24: {
            block25: {
                Serializable file2;
                String alias = CCSSecurityUtils.getAlias(host);
                KeyStore keyStore = CCSSecurityUtils.getKeyStore();
                for (Certificate cert : certificates) {
                    try {
                        keyStore.setCertificateEntry(alias, cert);
                    }
                    catch (KeyStoreException e) {
                        ResultsViewPlugin.log(e);
                        return false;
                    }
                }
                if (keyStore.size() == 0) {
                    file2 = CCSSecurityUtils.getKeyStoreFile();
                    if (!((File)file2).delete()) {
                        ResultsViewPlugin.log("CCSSecurityUtils: unable to delete: " + String.valueOf(file2));
                    }
                    break block24;
                }
                file2 = null;
                Iterator<Certificate> iterator = null;
                FileOutputStream os = new FileOutputStream(CCSSecurityUtils.getKeyStoreFile());
                try {
                    keyStore.store(os, CCSSecurityUtils.getKeyStorePassword());
                    if (os == null) break block25;
                }
                catch (NoSuchAlgorithmException | CertificateException e) {
                    try {
                        try {
                            try {
                                try {
                                    ResultsViewPlugin.log(e);
                                }
                                catch (Throwable file2) {
                                    throw file2;
                                }
                                finally {
                                    if (os != null) {
                                        os.close();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (file2 == null) {
                                    file2 = throwable;
                                } else if (file2 != throwable) {
                                    ((Throwable)file2).addSuppressed(throwable);
                                }
                                throw file2;
                            }
                        }
                        catch (FileNotFoundException e2) {
                            ResultsViewPlugin.log(e2);
                        }
                        catch (IOException e3) {
                            ResultsViewPlugin.log(e3);
                        }
                    }
                    catch (KeyStoreException e4) {
                        ResultsViewPlugin.log(e4);
                    }
                }
                os.close();
            }
            return true;
        }
        return false;
    }

    public static HostnameVerifier getHostNameVerifier() {
        return null;
    }

    private static class CCSTrustManager
    extends X509ExtendedTrustManager {
        private X509ExtendedTrustManager fPKIXTrustManager;
        private KeyStore fKeyStore;
        private List<Certificate> fUntrustedCertificates = new ArrayList<Certificate>();

        public void setKeystore(String filePath, char[] password) {
            try {
                this.fKeyStore = CCSSecurityUtils.getKeyStore();
                if (this.fKeyStore != null) {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(CCSSecurityUtils.KEYSTORE_TYPE_PKIX);
                    tmf.init(this.fKeyStore);
                    TrustManager[] tms = tmf.getTrustManagers();
                    int i = 0;
                    while (i < tms.length) {
                        if (tms[i] instanceof X509ExtendedTrustManager) {
                            this.fPKIXTrustManager = (X509ExtendedTrustManager)tms[i];
                            break;
                        }
                        ++i;
                    }
                }
                if (this.fPKIXTrustManager == null) {
                    ResultsViewPlugin.log(4, "Cannot find a PKIX trust manager");
                }
            }
            catch (Exception ex) {
                ResultsViewPlugin.log(ex);
            }
        }

        public List<Certificate> getUntrustedCerts() {
            return this.fUntrustedCertificates;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.fPKIXTrustManager != null) {
                try {
                    this.fPKIXTrustManager.checkClientTrusted(chain, authType);
                }
                catch (Exception ex) {
                    this.computeUntrustedCertificates(chain);
                    throw ex;
                }
            } else {
                throw new CertificateException();
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.fPKIXTrustManager != null) {
                try {
                    this.fPKIXTrustManager.checkServerTrusted(chain, authType);
                }
                catch (Exception ex) {
                    this.computeUntrustedCertificates(chain);
                    throw ex;
                }
            } else {
                throw new CertificateException();
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            if (this.fPKIXTrustManager != null) {
                try {
                    this.fPKIXTrustManager.checkClientTrusted(chain, authType, socket);
                }
                catch (Exception ex) {
                    this.computeUntrustedCertificates(chain);
                    throw ex;
                }
            } else {
                throw new CertificateException();
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            if (this.fPKIXTrustManager != null) {
                try {
                    this.fPKIXTrustManager.checkClientTrusted(chain, authType, engine);
                }
                catch (Exception ex) {
                    this.computeUntrustedCertificates(chain);
                    throw ex;
                }
            } else {
                throw new CertificateException();
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            if (this.fPKIXTrustManager != null) {
                try {
                    this.fPKIXTrustManager.checkServerTrusted(chain, authType, socket);
                }
                catch (Exception ex) {
                    this.computeUntrustedCertificates(chain);
                    throw ex;
                }
            } else {
                throw new CertificateException();
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            if (this.fPKIXTrustManager != null) {
                try {
                    this.fPKIXTrustManager.checkServerTrusted(chain, authType, engine);
                }
                catch (Exception ex) {
                    this.computeUntrustedCertificates(chain);
                    throw ex;
                }
            } else {
                throw new CertificateException();
            }
        }

        private void computeUntrustedCertificates(X509Certificate[] certs) {
            this.fUntrustedCertificates.clear();
            ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
            try {
                Enumeration<String> aliases = this.fKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate aCert = this.fKeyStore.getCertificate(alias);
                    if (!(aCert instanceof X509Certificate)) continue;
                    trustedCerts.add((X509Certificate)aCert);
                }
            }
            catch (KeyStoreException ex) {
                ResultsViewPlugin.log(ex);
            }
            int i = 0;
            while (i < certs.length) {
                boolean foundMatch = false;
                X509Certificate cert = certs[i];
                int j = 0;
                while (j < trustedCerts.size() && !foundMatch) {
                    X509Certificate tCert = (X509Certificate)trustedCerts.get(j);
                    if (cert == tCert) {
                        foundMatch = true;
                    } else {
                        try {
                            PublicKey pk = tCert.getPublicKey();
                            cert.verify(pk);
                            int inLength = cert.getEncoded().length;
                            int exLength = tCert.getEncoded().length;
                            foundMatch = inLength == exLength;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                if (!foundMatch) {
                    this.fUntrustedCertificates.add(cert);
                }
                ++i;
            }
        }
    }
}

