/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultsView;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultListener;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;

class ResultsViewListener
implements ICCResultListener,
IResultViewConstants {
    private final CCResultsView fView;

    public ResultsViewListener(CCResultsView view) {
        this.fView = view;
    }

    @Override
    public void resultLocationNotification(CCResultEvent event) {
        IResultLocation location = this.getLocation(event);
        if (location != null) {
            switch (event.getType()) {
                case 1: {
                    location.refreshResults();
                    this.fView.addResultLocation(location, true);
                    break;
                }
                case 2: {
                    this.fView.removeResultLocation(location);
                    this.fView.refresh();
                    break;
                }
                case 3: {
                    try {
                        Job.getJobManager().join((Object)"DeleteResultJob", null);
                    }
                    catch (InterruptedException | OperationCanceledException e) {
                        ResultsViewPlugin.log(e);
                    }
                    location.refreshResults();
                    this.fView.refreshResultLocation(location);
                    break;
                }
                case 4: {
                    this.fView.refreshResultLocation(location);
                    break;
                }
                case 8: {
                    this.fView.updatePreferenceNode();
                    break;
                }
            }
        }
    }

    private IResultLocation getLocation(CCResultEvent event) {
        if (event.getSource() instanceof IResultLocation) {
            return (IResultLocation)event.getSource();
        }
        if (event.getSource() instanceof String) {
            IResultLocation[] iResultLocationArray = this.fView.getResultLocations();
            int n = iResultLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResultLocation location = iResultLocationArray[n2];
                if (location.getPath().equals(event.getSource())) {
                    return location;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void resultNotification(CCResultEvent event) {
        Object source = event.getSource();
        IResultAdapter result = source instanceof IResultAdapter ? (IResultAdapter)source : null;
        switch (event.getType()) {
            case 5: {
                if (result != null) {
                    this.fView.refreshResultLocation(result.getResultLocation(), result);
                    break;
                }
                if (!(source instanceof IResultAdapter[])) break;
                IResultAdapter[] iResultAdapterArray = (IResultAdapter[])source;
                int n = iResultAdapterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResultAdapter r = iResultAdapterArray[n2];
                    this.fView.refreshResultLocation(r.getResultLocation(), r);
                    ++n2;
                }
                break;
            }
            case 6: {
                if (result == null) break;
                result.cleanup(true);
                break;
            }
            case 7: {
                this.fView.update(source);
                break;
            }
        }
    }
}

