/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.ccresults.CCResultImporter;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCAPIResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCZipResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultCCZipContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.ui.IWorkbenchPart;

public class DefaultContentProvider
implements IResultContentProvider {
    private static final IResultLocation[] EMPTY = new IResultLocation[0];

    @Override
    public boolean isResultHandled(String locationPath) {
        return this.isSupportedFileName(locationPath);
    }

    @Override
    public boolean isSupportedFileName(String fileName) {
        return CCResultImporter.isValidExtension((String)fileName);
    }

    @Override
    public IResultAdapter getResultAdapter(String locationPath) {
        Path p = new Path(locationPath);
        String extension = p.getFileExtension();
        if (extension.equalsIgnoreCase("ccresult")) {
            return new CCAPIResultAdapter(locationPath);
        }
        if (extension.equalsIgnoreCase("cczip")) {
            IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
            int n = iResultContentProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResultContentProvider provider = iResultContentProviderArray[n2];
                if (provider instanceof IResultCCZipContentProvider && ((IResultCCZipContentProvider)provider).isCCZipResultHandled(locationPath)) {
                    return ((IResultCCZipContentProvider)provider).getCCZipResult(locationPath);
                }
                ++n2;
            }
            return new CCZipResultAdapter(locationPath);
        }
        return null;
    }

    @Override
    public IResultLocation[] getDefaultLocations() {
        return EMPTY;
    }

    @Override
    public IResultAdapter getResultAdapter(IWorkbenchPart part) {
        String path;
        if (part.getSite().getId().equals("com.ibm.debug.pdt.tatt.ui.mergeViewer") && (path = part.getTitleToolTip()) != null) {
            return ResultsViewUtilities.getResult(path, false);
        }
        return null;
    }

    @Override
    public void initialize(ICCResultsView view) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public Map<String, IPreferencePage> getPreferencePages() {
        return null;
    }

    @Override
    public IHandler getImportHandler(IResultLocation resultLocation) {
        return null;
    }

    @Override
    public boolean isEngineHandled(String engineKey) {
        return false;
    }

    @Override
    public String getEditorId(String file, String engineKey) {
        return null;
    }

    @Override
    public void setDefaultOpenMode(String commandId, String mode) {
    }

    @Override
    public String getPluginId() {
        return null;
    }
}

