/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsLabelProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import java.util.Date;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class CCResultsViewSorter
extends ViewerComparator {
    private int fSortColumn = -1;
    private int fDirection;
    private DecoratingStyledCellLabelProvider fLabelProvider;
    private static final int DIRECTION_DESC = 1;

    public int compare(Viewer viewer, Object first, Object second) {
        int ret = 0;
        if (first instanceof IResultLocation && second instanceof IResultLocation) {
            int priority2;
            int priority1 = ((IResultLocation)first).getPriority();
            if (priority1 != (priority2 = ((IResultLocation)second).getPriority())) {
                return priority1 - priority2;
            }
            if (priority1 == priority2 && this.fSortColumn == 0) {
                return ((IResultLocation)first).getName().compareTo(((IResultLocation)second).getName());
            }
        }
        if (first instanceof IResultAdapter && second instanceof IResultAdapter) {
            IResultAdapter result1 = (IResultAdapter)first;
            IResultAdapter result2 = (IResultAdapter)second;
            switch (this.fSortColumn) {
                case 0: {
                    ret = -1 * this.getDecoratedName(result1).compareTo(this.getDecoratedName(result2));
                    break;
                }
                case 2: {
                    ret = Integer.compare(result1.getPercentCoverage(), result2.getPercentCoverage());
                    break;
                }
                case 1: {
                    ret = ResultsLabelProvider.getStatus(result1) - ResultsLabelProvider.getStatus(result2);
                    break;
                }
                case 3: {
                    ret = this.compareLevels(result1, result2);
                    break;
                }
                case 4: {
                    ret = this.compareDates(result1, result2);
                    break;
                }
                case 5: {
                    ret = this.compareErrors(result1, result2);
                    break;
                }
            }
            if (this.fDirection == 1) {
                ret *= -1;
            }
        }
        return ret;
    }

    private String getDecoratedName(IResultAdapter result) {
        return this.fLabelProvider.getLabelDecorator() == null ? result.getName() : this.fLabelProvider.getLabelDecorator().decorateText(result.getName(), (Object)result);
    }

    private int compareLevels(IResultAdapter result1, IResultAdapter result2) {
        String level1 = result1.getLevel();
        String level2 = result2.getLevel();
        if (level1 != null) {
            return level2 != null ? level1.compareTo(level2) : -1;
        }
        return level2 != null ? 1 : 0;
    }

    private int compareDates(IResultAdapter result1, IResultAdapter result2) {
        Date date1 = result1.getAnalyzedDate();
        Date date2 = result2.getAnalyzedDate();
        if (date1 != null) {
            return date2 != null ? date1.compareTo(date2) : 1;
        }
        return date2 != null ? -1 : 0;
    }

    private int compareErrors(IResultAdapter result1, IResultAdapter result2) {
        String error1 = result1.getResultError();
        String error2 = result2.getResultError();
        if (error1 != null) {
            return error2 != null ? error1.compareTo(error2) : -1;
        }
        return error2 != null ? 1 : 0;
    }

    public void setSortColumn(int i) {
        if (i < 0) {
            this.fSortColumn = 0;
            return;
        }
        if (i == this.fSortColumn) {
            this.fDirection = 1 - this.fDirection;
        } else {
            this.fSortColumn = i;
            this.fDirection = 1;
        }
    }

    public void setNameLabelProvider(DecoratingStyledCellLabelProvider dLabelProvider) {
        this.fLabelProvider = dLabelProvider;
    }
}

