/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote;

import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.CLRemoteUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.RemoteResultUtilities;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ZipResultAdapter;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class RemoteZipResultAdapter
extends ZipResultAdapter
implements IRemoteResultAdapter {
    private IRemoteFile fRemotePath;
    private String fLocalZipPath = null;

    public RemoteZipResultAdapter(IRemoteFile remotePath) {
        super(remotePath.getAbsolutePathPlusConnection());
        this.fRemotePath = remotePath;
    }

    public void analyze(boolean useResultAPI) {
        if (this.fLocalZipPath != null) {
            super.analyze(useResultAPI);
        }
    }

    public String getSeparator() {
        return this.fRemotePath.getSeparator();
    }

    protected String getLocalZipPath() {
        return this.fLocalZipPath;
    }

    public boolean exists() {
        return this.fRemotePath.exists();
    }

    protected void doAnalysis(boolean useResultAPI) {
        if (this.fLocalZipPath == null) {
            return;
        }
        super.doAnalysis(useResultAPI);
    }

    public String getName() {
        Path path = new Path(this.fRemotePath.getName());
        return path.removeFileExtension().lastSegment();
    }

    public void cleanup(boolean deleteDataFiles) {
        super.cleanup(deleteDataFiles);
        if (deleteDataFiles) {
            RemoteResultUtilities.deleteRemoteFile(this.fRemotePath);
        }
    }

    public String rename(String newResultName) {
        String extension = "." + new Path(this.fRemotePath.getAbsolutePath()).getFileExtension();
        String result = RemoteResultUtilities.renameFile(this.fRemotePath, newResultName + extension);
        if (result == null) {
            if (this.fLocalZipPath != null) {
                result = super.rename(newResultName);
            }
            this.fLocalZipPath = null;
        }
        return result;
    }

    public IRemoteResultLocation getResultLocation() {
        return (IRemoteResultLocation)super.getResultLocation();
    }

    private void refreshLocalPath() {
        if (this.fLocalZipPath == null) {
            IFile localZipFile = CLRemoteUtilities.downloadRemoteFile(this.fRemotePath);
            if (localZipFile != null) {
                this.fLocalZipPath = localZipFile.getLocation().toOSString();
            } else {
                return;
            }
        }
    }

    public String getResultPath(boolean isLocal) {
        if (isLocal) {
            return this.fLocalZipPath;
        }
        if (this.fRemotePath != null) {
            return this.fRemotePath.getAbsolutePathPlusConnection();
        }
        return this.getResultPath();
    }

    public Date getAnalyzedDate() {
        if (this.fLocalZipPath == null) {
            return null;
        }
        return super.getAnalyzedDate();
    }

    public ICCResult getResult() {
        this.refreshLocalPath();
        return super.getResult();
    }

    protected void initializeProperties() {
        if (this.fLocalZipPath != null) {
            super.initializeProperties();
        }
    }
}

