/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZip;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.CLRemoteUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RSECoveragePlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RemoteException;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.UtilitiesContentProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.AlternateRemoteResults;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.RSERemoteResultLocationDialogContentProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.RemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocationDialogContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultCCZipContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProviderWithStatusConfig;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultSource;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultException;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ZipResultAdapter;
import com.ibm.debug.pdt.internal.ui.EditorMapping;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class RemoteResultsViewContentProvider
implements IUtilContentProvider,
IResultCCZipContentProvider,
IRemoteResultContentProvider,
IResultContentProviderWithStatusConfig,
IResultSource,
IAdaptable {
    private static final String COMPONENT_ID = "CCResultSource.componentfile";
    private static final IPropertyDescriptor[] EMPTY_PROPERTIES = new IPropertyDescriptor[0];
    private static final IResultLocation[] EMPTY = new IResultLocation[0];

    public boolean isResultHandled(String locationPath) {
        if (locationPath.endsWith(".zip")) {
            return this.checkZip(locationPath);
        }
        return this.isSupportedFileName(locationPath);
    }

    private boolean checkZip(String locationPath) {
        File file = new File(locationPath);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zFile = new ZipFile(file);){
                return CLCoverageZip.isValidCoverageZip((ZipFile)zFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            RSECoveragePlugin.log(e);
            return false;
        }
    }

    public boolean isSupportedFileName(String fileName) {
        Path p = new Path(fileName);
        String extension = p.getFileExtension();
        return extension != null && (extension.equalsIgnoreCase("clcoveragedata") || extension.equalsIgnoreCase("zip") || AlternateRemoteResults.isSupportedExtension(extension));
    }

    public IResultAdapter getResultAdapter(String locationPath) {
        Path path = new Path(locationPath);
        String extension = path.getFileExtension();
        if (extension.equalsIgnoreCase("clcoveragedata")) {
            return new ResultAdapter(this.getLocationPath(locationPath));
        }
        if (extension.equalsIgnoreCase("zip")) {
            return new ZipResultAdapter(locationPath);
        }
        return AlternateRemoteResults.getResultAdapter(locationPath);
    }

    private String getLocationPath(String resultFilePath) {
        if (resultFilePath != null) {
            File result = new File(resultFilePath);
            String parentName = result.getParentFile().getName();
            String resultName = result.getName();
            if (resultName.toLowerCase().endsWith("clcoveragedata".toLowerCase())) {
                resultName = resultName.substring(0, resultName.length() - ".clcoveragedata".length());
            }
            if (resultName.equalsIgnoreCase(parentName)) {
                return result.getParent();
            }
        }
        return resultFilePath;
    }

    public IPropertyDescriptor[] getPropertyDescriptors(IResultAdapter fAdapter) {
        return EMPTY_PROPERTIES;
    }

    public Object getPropertyValue(IResultAdapter adapter, Object id) {
        if (adapter instanceof ResultAdapter) {
            ResultAdapter rAdapter = (ResultAdapter)adapter;
            if (id.equals(COMPONENT_ID)) {
                return rAdapter.getComponentMapFileName();
            }
        }
        return null;
    }

    public void initialize(ICCResultsView view) {
    }

    public void dispose() {
    }

    public Map<String, IPreferencePage> getPreferencePages() {
        return null;
    }

    public IRemoteResultLocation resolveRemotePath(String location, String name, boolean onlyResolveWhenConnected, boolean retry) throws ResultException {
        if (RSECorePlugin.isInitComplete((int)0)) {
            try {
                IRemoteFile file = CLRemoteUtilities.resolveRemotePath(location, onlyResolveWhenConnected, retry);
                if (file != null) {
                    return new RemoteResultLocation(file, name != null ? name : file.toString(), (IResultContentProvider)this);
                }
                if (this.isRemote(location)) {
                    return new RemoteResultLocation(location, name, (IResultContentProvider)this);
                }
            }
            catch (RemoteException e) {
                RSECoveragePlugin.log((Throwable)((Object)e));
            }
        } else {
            this.waitForRseAndAddRemotePath(location, name, onlyResolveWhenConnected, retry);
        }
        return null;
    }

    private void waitForRseAndAddRemotePath(final String locationString, final String name, final boolean onlyResolveWhenConnected, final boolean retry) {
        Job j = new Job("Waiting for RSE to initialize"){

            protected IStatus run(IProgressMonitor arg0) {
                try {
                    RSECorePlugin.waitForInitCompletion();
                    RemoteResultLocation location = null;
                    IRemoteFile file = CLRemoteUtilities.resolveRemotePath(locationString, onlyResolveWhenConnected, retry);
                    if (file != null) {
                        location = new RemoteResultLocation(file, name != null ? name : file.toString(), (IResultContentProvider)RemoteResultsViewContentProvider.this);
                    } else if (RemoteResultsViewContentProvider.this.isRemote(locationString)) {
                        location = new RemoteResultLocation(locationString, name, (IResultContentProvider)RemoteResultsViewContentProvider.this);
                    }
                    if (location != null) {
                        CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)location, 1));
                    }
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (RemoteException e) {
                    RSECoveragePlugin.log((Throwable)((Object)e));
                    return new Status(4, "com.ibm.debug.pdt.codecoverage.ui.view.rse", e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }

    private boolean isRemote(String location) {
        if (location == null || location.trim().length() == 0) {
            return false;
        }
        int dotIndex = location.indexOf(46);
        if (dotIndex > 0) {
            int colonIndex = location.indexOf(58, dotIndex + 1);
            return colonIndex > 0;
        }
        return false;
    }

    public IRemoteResultLocationDialogContentProvider getDialogContentProvider() {
        return new RSERemoteResultLocationDialogContentProvider(this);
    }

    public IHandler getImportHandler(IResultLocation resultLocation) {
        return null;
    }

    public boolean isEngineHandled(String engineKey) {
        return engineKey != null && engineKey.length() == 3;
    }

    public String getEditorId(String file, String engineKey) {
        String editorId = null;
        try {
            editorId = IDE.getEditorDescriptor((String)file, (boolean)true, (boolean)false).getId();
            if (engineKey != null) {
                editorId = EditorMapping.getMappedEditorId((String)editorId, (String)engineKey);
            }
        }
        catch (PartInitException e) {
            RSECoveragePlugin.log(e);
        }
        return editorId;
    }

    public void setDefaultOpenMode(String commandId, String mode) {
    }

    public String getPluginId() {
        return "com.ibm.debug.pdt.codecoverage.ui.view.rse";
    }

    public boolean isStatusColumnSupported() {
        return true;
    }

    public Object getAdapter(Class classObj) {
        Object result = Platform.getAdapterManager().getAdapter((Object)this, classObj);
        if (result == null) {
            result = Platform.getAdapterManager().loadAdapter((Object)this, classObj.getName());
        }
        return result;
    }

    public boolean isCCZipResultHandled(String locationPath) {
        return this.checkZip(locationPath);
    }

    public IResultAdapter getCCZipResult(String locationPath) {
        return new ZipResultAdapter(locationPath);
    }

    public IResultLocation[] getDefaultLocations() {
        return EMPTY;
    }

    public IResultAdapter getResultAdapter(IWorkbenchPart part) {
        return null;
    }

    public IUtilitiesContentProvider getUtilContentProvider() {
        return new UtilitiesContentProvider();
    }
}

