/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.CLRemoteUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RSECoveragePlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RemoteException;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.AlternateRemoteResults;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.RemoteResultAdapter;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.RemoteZipResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.model.Host;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.graphics.Image;

public class RemoteResultLocation
extends AbstractRemoteResultLocation
implements ICommunicationsListener,
ISystemModelChangeListener {
    private IRemoteFile fRemotePath;
    private IRemoteFileSubSystem fRemoteFileSubSystem;
    private boolean fIsWorkbenchStartup;
    private Image fConnectedImage;
    private Image fDisconnectedImage;

    public void waitForConnectJobAndUpdateStatus() {
        Job waitForConnectAndUpdateStatusJob = new Job("Waiting to connect..."){

            protected IStatus run(IProgressMonitor monitor) {
                Job connectJob = CLRemoteUtilities.getRSEViewConnectJob();
                if (connectJob != null) {
                    try {
                        connectJob.join();
                        IStatus status = connectJob.getResult();
                        if (!status.isOK()) {
                            RemoteResultLocation.this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.DISCONNECTED);
                            CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)RemoteResultLocation.this, 4));
                            return Status.CANCEL_STATUS;
                        }
                    }
                    catch (InterruptedException e) {
                        ResultsViewPlugin.log((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        waitForConnectAndUpdateStatusJob.setSystem(true);
        waitForConnectAndUpdateStatusJob.schedule();
    }

    public RemoteResultLocation(IRemoteFile remotePath, String name, IResultContentProvider provider) {
        super(remotePath.getAbsolutePathPlusConnection(), name, false, provider);
        this.fRemotePath = remotePath;
        this.fRemoteFileSubSystem = this.fRemotePath.getParentRemoteFileSubSystem();
        this.fIsWorkbenchStartup = false;
        this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTED);
        CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this, 4));
        this.registerRSEListener();
    }

    public RemoteResultLocation(String remotePath, String name, IResultContentProvider provider) {
        super(remotePath, name, false, provider);
        this.fPath = remotePath;
        this.fIsWorkbenchStartup = true;
        this.resolveRemoteFileSystemFromPath(remotePath);
        this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.DISCONNECTED);
        CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this, 4));
        this.registerRSEListener();
    }

    private void registerRSEListener() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.addSystemModelChangeListener((ISystemModelChangeListener)this);
        if (this.fRemoteFileSubSystem != null) {
            this.fRemoteFileSubSystem.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
        }
    }

    public void removeRSEListener() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.removeSystemModelChangeListener((ISystemModelChangeListener)this);
        if (this.fRemoteFileSubSystem != null) {
            this.fRemoteFileSubSystem.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
        }
    }

    private void resolveRemoteFileSystemFromPath(String remotePath) {
        String profileName = CLRemoteUtilities.getProfileFromPath(remotePath);
        String connectionName = CLRemoteUtilities.getConnectionFromPath(remotePath);
        ISystemRegistry registry = RSECorePlugin.getDefault().getSystemRegistry();
        ISystemProfile profile = registry.getSystemProfile(profileName);
        IHost[] hosts = registry.getHostsByProfile(profile);
        IHost host = null;
        IHost[] iHostArray = hosts;
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            IHost h = iHostArray[n2];
            if (h.getAliasName().equalsIgnoreCase(connectionName)) {
                host = h;
            }
            ++n2;
        }
        if (host != null) {
            this.fRemoteFileSubSystem = this.getRemoteFileSubSystemFromHost(host);
        }
    }

    private IRemoteFileSubSystem getRemoteFileSubSystemFromHost(IHost host) {
        ISubSystem[] iSubSystemArray = host.getSubSystems();
        int n = iSubSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof IRemoteFileSubSystem) {
                return (IRemoteFileSubSystem)subsystem;
            }
            ++n2;
        }
        return null;
    }

    public String getPath() {
        return this.fRemotePath != null ? this.fRemotePath.getAbsolutePathPlusConnection() : super.getPath();
    }

    public boolean exists() {
        if (this.isConnected() && this.fRemotePath != null) {
            return this.fRemotePath.exists();
        }
        return true;
    }

    public void resolveRemotePathInAJob(final String remotePath) {
        Job resolveRemotePathJob = new Job(NLS.bind((String)Labels.RESOLVE_REMOTE_PATH, (Object)remotePath)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RemoteResultLocation.this.fRemotePath = CLRemoteUtilities.resolveRemotePath(remotePath, true, true);
                    if (RemoteResultLocation.this.fRemotePath == null) {
                        RemoteResultLocation.this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.DISCONNECTED);
                    }
                }
                catch (RemoteException ex) {
                    RemoteResultLocation.this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTION_ERROR);
                    RemoteResultLocation.this.removeAllResults();
                    RemoteResultLocation.this.setErrorMessage(ex.getMessage());
                    CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)RemoteResultLocation.this, 4));
                    return Status.CANCEL_STATUS;
                }
                if (RemoteResultLocation.this.isConnected() || RemoteResultLocation.this.getErrorMessage() != null && RemoteResultLocation.this.getNumberOfResults() > 0) {
                    CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)RemoteResultLocation.this, 3));
                } else {
                    CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)RemoteResultLocation.this, 4));
                }
                return Status.OK_STATUS;
            }
        };
        resolveRemotePathJob.schedule();
    }

    public IRemoteFile getRemoteFile() {
        return this.fRemotePath;
    }

    public boolean isRemote() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasResultsToImport(IRemoteFile remoteFile) {
        IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
        if (!remoteFile.isDirectory()) {
            if (!remoteFile.isFile()) return AlternateRemoteResults.hasResultsToImport(remoteFile);
            if (!remoteFile.getName().toLowerCase().endsWith(".zip")) return AlternateRemoteResults.hasResultsToImport(remoteFile);
            return true;
        }
        try {
            IRemoteFile[] subFiles;
            IRemoteFile[] iRemoteFileArray = subFiles = subsystem.list(remoteFile, 1, null);
            int n = subFiles.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IRemoteFile subFile = iRemoteFileArray[n2];
                if (subFile.getName().toLowerCase().endsWith(".clcoveragedata")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (SystemMessageException systemMessageException) {
            return false;
        }
    }

    public void refreshResults() {
        if (!this.exists() || this.getErrorMessage() != null) {
            if (this.getErrorMessage() == null) {
                this.setErrorMessage(Labels.INVALID_RESULT_LOCATION_TITLE);
            }
            this.removeAllResults();
            this.fRemotePath = null;
            return;
        }
        if (!this.isConnected()) {
            if (this.fIsWorkbenchStartup) {
                this.fIsWorkbenchStartup = false;
                return;
            }
            this.connect();
            return;
        }
        IRemoteFileSubSystem subsystem = this.fRemotePath.getParentRemoteFileSubSystem();
        IRemoteFile[] remoteFiles = null;
        try {
            remoteFiles = subsystem.list(this.fRemotePath, 0, null);
        }
        catch (SystemMessageException ex) {
            RSECoveragePlugin.log(ex);
        }
        ArrayList currentList = new ArrayList();
        currentList.addAll(this.getResults());
        if (remoteFiles == null) {
            remoteFiles = new IRemoteFile[]{};
        }
        IRemoteFile[] iRemoteFileArray = remoteFiles;
        int n = remoteFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFile remoteFile = iRemoteFileArray[n2];
            if (remoteFile.isDirectory() || remoteFile.isFile() && remoteFile.getName().toLowerCase().endsWith(".zip") || AlternateRemoteResults.isValidRemoteResult(remoteFile)) {
                String remoteFilePath = remoteFile.getAbsolutePathPlusConnection();
                IResultAdapter existingResult = this.findResult(remoteFilePath);
                if (existingResult != null) {
                    currentList.remove(existingResult);
                } else if (this.hasResultsToImport(remoteFile)) {
                    IRemoteResultAdapter adapter = null;
                    adapter = remoteFile.isDirectory() ? new RemoteResultAdapter(remoteFile) : (remoteFile.getName().toLowerCase().endsWith(".zip") ? new RemoteZipResultAdapter(remoteFile) : (remoteFile.getName().toLowerCase().endsWith(".cczip") ? new RemoteZipResultAdapter(remoteFile) : (remoteFile.getName().toLowerCase().endsWith(".ccresult") ? new RemoteZipResultAdapter(remoteFile) : AlternateRemoteResults.getResultAdapter(remoteFile))));
                    if (adapter != null) {
                        this.addResult((IResultAdapter)adapter);
                    }
                }
            }
            ++n2;
        }
        for (IResultAdapter result : currentList) {
            this.removeResult(result);
        }
    }

    private void connect() {
        String connectionName = CLRemoteUtilities.getConnectionFromPath(this.getPath());
        ConnectJob connectJob = new ConnectJob(connectionName, this);
        connectJob.schedule();
    }

    public Image getImage() {
        if (this.isConnected()) {
            return this.getConnectedImage();
        }
        return this.getDisconnectedImage();
    }

    private Image getConnectedImage() {
        if (this.fConnectedImage == null) {
            this.fConnectedImage = this.getImageInternal();
        }
        return this.fConnectedImage;
    }

    private Image getDisconnectedImage() {
        if (this.fDisconnectedImage == null) {
            this.fDisconnectedImage = this.getImageInternal();
        }
        return this.fDisconnectedImage;
    }

    private Image getImageInternal() {
        ISystemViewElementAdapter adapter;
        IHost host = null;
        if (this.fRemoteFileSubSystem != null) {
            host = this.fRemoteFileSubSystem.getHost();
        } else {
            String remotePath = this.getPath();
            int dotIndex = remotePath.indexOf(46);
            if (dotIndex > 0) {
                String profileName = remotePath.substring(0, dotIndex);
                int colonIndex = remotePath.indexOf(58, dotIndex + 1);
                if (colonIndex > 0) {
                    String connectionName = remotePath.substring(dotIndex + 1, colonIndex);
                    ISystemRegistry registry = RSECorePlugin.getDefault().getSystemRegistry();
                    ISystemProfile profile = registry.getSystemProfile(profileName);
                    if (profile != null) {
                        host = registry.getHost(profile, connectionName);
                    }
                }
            }
        }
        if (host != null && (adapter = (ISystemViewElementAdapter)host.getAdapter(ISystemViewElementAdapter.class)) != null) {
            return adapter.getImageDescriptor((Object)host).createImage();
        }
        return null;
    }

    public IResultAdapter findResult(String resultPath) {
        List results = this.getResults();
        for (IResultAdapter adapter : results) {
            String adapterResultPath = adapter instanceof RemoteZipResultAdapter ? ((RemoteZipResultAdapter)adapter).getResultPath(false) : adapter.getResultPath();
            if (adapterResultPath != null && adapterResultPath.equals(resultPath)) {
                return adapter;
            }
            if (adapter.getLocalPath() == null) continue;
            String localPath = adapter.getLocalPath();
            if (!resultPath.endsWith(".clcoveragedata")) continue;
            int idx = resultPath.lastIndexOf(File.separator);
            String string = resultPath = idx > -1 ? resultPath.substring(0, idx) : resultPath;
            if (!resultPath.equals(localPath)) continue;
            return adapter;
        }
        return null;
    }

    public void importResultToLocation(File dataFile) throws CLCoverageZipException {
        if (this.isConnected()) {
            try {
                IRemoteFile remoteDir = this.getRemoteFile();
                IRemoteFileSubSystem subsystem = remoteDir.getParentRemoteFileSubSystem();
                CLRemoteUtilities.uploadFileRemote(dataFile.getAbsolutePath(), remoteDir, subsystem.getHost());
            }
            catch (Exception e) {
                throw new CLCoverageZipException((Throwable)e);
            }
        }
    }

    public boolean isSaveRestoreable() {
        return true;
    }

    public boolean isConnected() {
        return this.fRemotePath == null ? false : super.isConnected();
    }

    public String getConnectionName() {
        return CLRemoteUtilities.getConnectionFromPath(this.getPath());
    }

    public String getHostName() {
        if (this.fRemoteFileSubSystem != null) {
            return this.fRemoteFileSubSystem.getConnectorService().getHostName();
        }
        return null;
    }

    public void systemModelResourceChanged(ISystemModelChangeEvent event) {
        if (event.getResource() instanceof Host) {
            String connectionName = ((Host)event.getResource()).getName();
            String hostName = ((Host)event.getResource()).getHostName();
            if (event.getEventType() == 2) {
                if (connectionName.equalsIgnoreCase(this.getConnectionName())) {
                    this.removeRSEListener();
                    CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this, 2));
                }
            } else if (event.getEventType() == 8 && hostName.equalsIgnoreCase(this.getHostName())) {
                String newName = ((Host)event.getResource()).getName();
                String remotePath = this.getPath();
                String oldName = event.getOldName();
                if (CLRemoteUtilities.getConnectionFromPath(remotePath).equalsIgnoreCase(oldName)) {
                    remotePath = remotePath.replace(oldName, newName);
                }
                this.fPath = remotePath;
                CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this, 8));
            }
        }
    }

    public void communicationsStateChange(CommunicationsEvent event) {
        String connectionName = event.getSystem().getHost().getAliasName();
        if (event.getState() == 2) {
            if (connectionName.equalsIgnoreCase(this.getConnectionName())) {
                this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTED);
                CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this, 4));
                this.resolveRemotePathInAJob(this.getPath());
            }
        } else if (event.getState() == 4) {
            if (connectionName.equalsIgnoreCase(this.getConnectionName())) {
                this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.DISCONNECTED);
                this.setErrorMessage(null);
                this.removeAllResults();
            }
        } else if (event.getState() == 1) {
            this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTING);
            CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this, 4));
            this.waitForConnectJobAndUpdateStatus();
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    private class ConnectJob
    extends Job {
        RemoteResultLocation fSourceLocation;
        private String fConnectionName;
        private long fTimestamp;

        private ConnectJob(String connectionName, RemoteResultLocation sourceLocation) {
            super("Connecting to " + connectionName);
            this.fConnectionName = connectionName;
            this.fSourceLocation = sourceLocation;
            this.fTimestamp = System.nanoTime();
        }

        protected IStatus run(IProgressMonitor monitor) {
            ConnectJob firstConnectJob;
            Job[] connectJobs = Job.getJobManager().find((Object)this.fConnectionName);
            if (connectJobs.length > 1 && (firstConnectJob = (ConnectJob)this.getFirstConnectJob(connectJobs)) != this) {
                try {
                    firstConnectJob.join();
                    if (!firstConnectJob.getResult().isOK()) {
                        this.fSourceLocation.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.DISCONNECTED);
                        CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this.fSourceLocation, 4));
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                if (RemoteResultLocation.this.fRemoteFileSubSystem != null) {
                    RemoteResultLocation.this.fRemoteFileSubSystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
            catch (Exception e) {
                this.fSourceLocation.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.DISCONNECTED);
                CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent((Object)this.fSourceLocation, 4));
                return Status.CANCEL_STATUS;
            }
        }

        private Job getFirstConnectJob(Job[] connectJobs) {
            if (connectJobs.length == 1) {
                return connectJobs[0];
            }
            if (connectJobs.length > 1) {
                Job firstJob = connectJobs[0];
                int i = 1;
                while (i < connectJobs.length) {
                    if (connectJobs[i] instanceof ConnectJob && ((ConnectJob)connectJobs[i]).getTimeStamp() < ((ConnectJob)firstJob).getTimeStamp()) {
                        firstJob = connectJobs[i];
                    }
                    ++i;
                }
                return firstJob;
            }
            return null;
        }

        public boolean belongsTo(Object family) {
            return family.equals(this.fConnectionName);
        }

        public long getTimeStamp() {
            return this.fTimestamp;
        }
    }
}

