/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.CLRemoteUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RemoteException;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemActionViewerFilter;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.widgets.Shell;

public class UtilitiesContentProvider
implements IUtilitiesContentProvider {
    public List<String> getConnectionList() {
        ISystemRegistry reg = SystemStartHere.getSystemRegistry();
        if (reg == null) {
            return Collections.emptyList();
        }
        String localhostName = null;
        boolean isLocalFound = false;
        ArrayList<String> hostList = new ArrayList<String>();
        IHost[] iHostArray = reg.getHosts();
        int n = iHostArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHost host = iHostArray[n2];
            if (!isLocalFound && host.getSystemType().isLocal()) {
                localhostName = host.getAliasName();
                isLocalFound = true;
            } else {
                hostList.add(host.getAliasName());
            }
            ++n2;
        }
        Collections.sort(hostList);
        if (localhostName != null) {
            hostList.add(0, localhostName);
        }
        return hostList;
    }

    public void openNewConnectionDialog(Shell shell) {
        SystemNewConnectionAction action = new SystemNewConnectionAction(shell, true, null);
        action.run();
    }

    public boolean isHostConnected(String connection) {
        IHost host = this.getHost(connection);
        if (host == null) {
            return false;
        }
        IConnectorService[] services = host.getConnectorServices();
        if (services != null) {
            IConnectorService[] iConnectorServiceArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorService s = iConnectorServiceArray[n2];
                if (s.isConnected()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String getLocationPath(Shell shell, String connection, boolean selectFile, boolean isDefaultLocation, String initialPath) throws Exception {
        Object selected;
        IRemoteFile remoteFile;
        IRemoteFileSubSystem sys;
        SystemRemoteFileDialog dialog;
        IHost host = this.getHost(connection);
        if (host == null) {
            return null;
        }
        if (selectFile) {
            dialog = new SystemRemoteFileDialog(shell);
            SystemActionViewerFilter viewFilter = this.getSystemActionViewerFilter(isDefaultLocation);
            dialog.setCustomViewerFilter(viewFilter);
        } else {
            dialog = new SystemRemoteFolderDialog(shell);
        }
        if (initialPath != null && initialPath.length() != 0 && (sys = RemoteFileUtility.getFileSubSystem((IHost)host)) != null && (remoteFile = sys.getRemoteFileObject(initialPath, (IProgressMonitor)new NullProgressMonitor())) != null && remoteFile.exists()) {
            dialog.setPreSelection((Object)remoteFile);
        }
        dialog.setDefaultSystemConnection(host, true);
        if (dialog.open() == 0 && (selected = dialog.getSelectedObject()) instanceof IRemoteFile) {
            return ((IRemoteFile)selected).getAbsolutePath();
        }
        return null;
    }

    private IHost getHost(String hostAliasName) {
        IHost host_ = null;
        ISystemRegistry reg = SystemStartHere.getSystemRegistry();
        if (reg == null) {
            return null;
        }
        IHost[] iHostArray = reg.getHosts();
        int n = iHostArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHost host = iHostArray[n2];
            if (host.getAliasName().equalsIgnoreCase(hostAliasName)) {
                host_ = host;
                break;
            }
            ++n2;
        }
        return host_;
    }

    private SystemActionViewerFilter getSystemActionViewerFilter(final boolean isDefaultLocation) {
        return new SystemActionViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return UtilitiesContentProvider.this.showElement(element, isDefaultLocation);
            }
        };
    }

    private boolean showElement(Object element, boolean isDefaultLocation) {
        IRemoteFile remoteFile;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return ResultViewImportExportUtils.isFileExtensionValid((String)file.getName(), (boolean)isDefaultLocation);
        }
        if (element instanceof IRemoteFile && (remoteFile = (IRemoteFile)element).isFile()) {
            return ResultViewImportExportUtils.isFileExtensionValid((String)remoteFile.getName(), (boolean)isDefaultLocation);
        }
        return true;
    }

    public boolean isValidLocation(String location, String Connection) {
        IHost host = this.getHost(Connection);
        if (host == null) {
            return false;
        }
        if (host.getSystemType().isLocal()) {
            return new File(location).exists();
        }
        try {
            IRemoteFile file = this.remoteDir(host, location);
            return file == null ? false : file.exists();
        }
        catch (SystemMessageException e) {
            return false;
        }
    }

    public String determineLocationPath(String connection, String location) {
        String finalLocation = location;
        if (this.isValidRemoteLocation(connection, location)) {
            finalLocation = this.populateRemotePath(connection, location);
        }
        return finalLocation;
    }

    public boolean isValidRemoteLocation(String connection, String location) {
        IHost host = this.getHost(connection);
        if (host == null || host.getSystemType().isLocal()) {
            return false;
        }
        try {
            return this.remoteDir(host, location).exists();
        }
        catch (SystemMessageException e) {
            return false;
        }
    }

    public String populateRemotePath(String connection, String location) {
        IRemoteFile remoteDir;
        IHost host = this.getHost(connection);
        ISystemRegistry reg = SystemStartHere.getSystemRegistry();
        if (host == null || reg == null) {
            return null;
        }
        try {
            remoteDir = this.remoteDir(host, location);
        }
        catch (SystemMessageException e) {
            return null;
        }
        return reg.getLocalHost().getHostPool().getName() + "." + String.valueOf(remoteDir.getHost()) + ":" + remoteDir.getAbsolutePath();
    }

    public IFile handleRemoteFile(String connection, String location) {
        IRemoteFile remoteFile;
        IHost host = this.getHost(connection);
        if (host == null) {
            return null;
        }
        try {
            remoteFile = this.remoteDir(host, location);
        }
        catch (SystemMessageException e) {
            return null;
        }
        IFile remoteTempFile = CLRemoteUtilities.downloadRemoteFile(remoteFile);
        if (remoteFile.getExtension().equalsIgnoreCase("clcoveragedata")) {
            CLRemoteUtilities.downloadOtherDataFiles(remoteFile);
            CLRemoteUtilities.downloadSource(remoteFile.getParentRemoteFile());
        }
        return remoteTempFile;
    }

    public IFolder getRemoteSourceFolder() {
        return null;
    }

    public IFile[] getRemoteDataFiles() {
        return null;
    }

    public void uploadFileToRemoteSystem(String localFilePath, String targetPath, String hostAliasName) throws RemoteException {
        IHost host = this.getHost(hostAliasName);
        if (host == null) {
            throw new RemoteException(CCResultViewMessages.CRRDG9324);
        }
        try {
            IRemoteFile remoteDir = this.remoteDir(host, targetPath);
            CLRemoteUtilities.uploadFileRemote(localFilePath, remoteDir, host);
        }
        catch (SystemMessageException e) {
            throw new RemoteException(e);
        }
    }

    public void uploadFolderToRemoteSystem(String localFolder, String targetFolder, String hostAliasName) throws RemoteException, DirectoryNotEmptyException {
        IHost host = this.getHost(hostAliasName);
        if (host == null) {
            throw new RemoteException(CCResultViewMessages.CRRDG9324);
        }
        IRemoteFileSubSystem rfs = RemoteFileUtility.getFileSubSystem((IHost)host);
        if (rfs == null) {
            throw new RemoteException(CCResultViewMessages.CRRDG9324);
        }
        if (!this.isLocationEmpty(host.getAliasName(), targetFolder)) {
            throw new DirectoryNotEmptyException(CCResultViewMessages.CRRDG9323);
        }
        this.uploadFolder(Paths.get(localFolder, new String[0]), targetFolder, host, rfs);
    }

    private void uploadFolder(Path localFolder, String targetFolder, IHost host, IRemoteFileSubSystem rfs) throws RemoteException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(localFolder);){
                IRemoteFile remoteSrcDir = this.remoteDir(host, targetFolder);
                if (!remoteSrcDir.exists()) {
                    remoteSrcDir = rfs.createFolder(remoteSrcDir, null);
                }
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        String destination = remoteSrcDir.getAbsolutePath() + "/" + entry.toFile().getName();
                        this.uploadFolder(entry, destination, host, rfs);
                        continue;
                    }
                    CLRemoteUtilities.uploadFileRemote(entry.toFile().getAbsolutePath(), remoteSrcDir, host);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SystemMessageException e) {
            throw new RemoteException(e);
        }
    }

    public boolean isFileExists(String connection, String file) {
        IHost host = this.getHost(connection);
        if (host == null) {
            return false;
        }
        if (host.getSystemType().isLocal()) {
            return new File(file).exists();
        }
        try {
            IRemoteFile remoteFile = this.remoteDir(host, file);
            return remoteFile == null ? false : remoteFile.exists();
        }
        catch (SystemMessageException e) {
            return false;
        }
    }

    private IRemoteFile remoteDir(IHost host, String path) throws SystemMessageException {
        IRemoteFileSubSystem fs = RemoteFileUtility.getFileSubSystem((IHost)host);
        return fs.getRemoteFileObject(path, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isLocationEmpty(String connection, String outputFile) {
        if (this.isValidLocation(outputFile, connection)) {
            IHost host = this.getHost(connection);
            if (host == null) {
                return false;
            }
            if (host.getSystemType().isLocal()) {
                File f = new File(outputFile);
                if (f.isDirectory()) {
                    try {
                        Throwable throwable = null;
                        Object var6_11 = null;
                        try (DirectoryStream<Path> directory = Files.newDirectoryStream(f.toPath());){
                            boolean bl = !directory.iterator().hasNext();
                            return bl;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                try {
                    IRemoteFile remoteFile = this.remoteDir(host, outputFile);
                    if (remoteFile.isDirectory()) {
                        NullProgressMonitor monitor;
                        IRemoteFileSubSystem fs = RemoteFileUtility.getFileSubSystem((IHost)host);
                        IRemoteFile[] contents = fs.list(remoteFile, (IProgressMonitor)(monitor = new NullProgressMonitor()));
                        return contents == null || contents.length == 0;
                    }
                }
                catch (SystemMessageException systemMessageException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

